/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.RemoteTableName;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MongoOutputTableHandle
implements ConnectorOutputTableHandle {
    private final RemoteTableName remoteTableName;
    private final List<MongoColumnHandle> columns;
    private final Optional<String> temporaryTableName;
    private final Optional<String> pageSinkIdColumnName;

    @JsonCreator
    public MongoOutputTableHandle(@JsonProperty(value="remoteTableName") RemoteTableName remoteTableName, @JsonProperty(value="columns") List<MongoColumnHandle> columns, @JsonProperty(value="temporaryTableName") Optional<String> temporaryTableName, @JsonProperty(value="pageSinkIdColumnName") Optional<String> pageSinkIdColumnName) {
        this.remoteTableName = Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.temporaryTableName = Objects.requireNonNull(temporaryTableName, "temporaryTableName is null");
        this.pageSinkIdColumnName = Objects.requireNonNull(pageSinkIdColumnName, "pageSinkIdColumnName is null");
        Preconditions.checkArgument((temporaryTableName.isPresent() == pageSinkIdColumnName.isPresent() ? 1 : 0) != 0, (Object)"temporaryTableName.isPresent is not equal to pageSinkIdColumnName.isPresent");
    }

    @JsonProperty
    public RemoteTableName getRemoteTableName() {
        return this.remoteTableName;
    }

    @JsonProperty
    public List<MongoColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getTemporaryTableName() {
        return this.temporaryTableName;
    }

    public Optional<RemoteTableName> getTemporaryRemoteTableName() {
        return this.temporaryTableName.map(tableName -> new RemoteTableName(this.remoteTableName.getDatabaseName(), (String)tableName));
    }

    @JsonProperty
    public Optional<String> getPageSinkIdColumnName() {
        return this.pageSinkIdColumnName;
    }
}

