/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgniteBiTuple<V1, V2>
implements Map<V1, V2>,
Map.Entry<V1, V2>,
Iterable<Object>,
Externalizable,
Cloneable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private V1 val1;
    @GridToStringInclude
    private V2 val2;

    public IgniteBiTuple() {
    }

    public IgniteBiTuple(@Nullable V1 val1, @Nullable V2 val2) {
        this.val1 = val1;
        this.val2 = val2;
    }

    public IgniteBiTuple<V2, V1> swap() {
        return F.t(this.val2, this.val1);
    }

    public V1 get1() {
        return this.val1;
    }

    public V2 get2() {
        return this.val2;
    }

    public void set1(@Nullable V1 val1) {
        this.val1 = val1;
    }

    public void set2(@Nullable V2 val2) {
        this.val2 = val2;
    }

    public void set(@Nullable V1 val1, @Nullable V2 val2) {
        this.set1(val1);
        this.set2(val2);
    }

    @Override
    @Nullable
    public V1 getKey() {
        return this.val1;
    }

    @Override
    @Nullable
    public V2 getValue() {
        return this.val2;
    }

    @Override
    public V2 setValue(@Nullable V2 val) {
        V2 old = this.val2;
        this.set2(val);
        return old;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int nextIdx = 1;

            @Override
            public boolean hasNext() {
                return this.nextIdx < 3;
            }

            @Override
            @Nullable
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object res = null;
                if (this.nextIdx == 1) {
                    res = IgniteBiTuple.this.get1();
                } else if (this.nextIdx == 2) {
                    res = IgniteBiTuple.this.get2();
                }
                ++this.nextIdx;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.val1 == null && this.val2 == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return F.eq(this.val1, key);
    }

    @Override
    public boolean containsValue(Object val) {
        return F.eq(this.val2, val);
    }

    @Override
    @Nullable
    public V2 get(Object key) {
        return this.containsKey(key) ? (V2)this.val2 : null;
    }

    @Override
    @Nullable
    public V2 put(V1 key, V2 val) {
        V2 old = this.containsKey(key) ? (V2)this.val2 : null;
        this.set(key, val);
        return old;
    }

    @Override
    @Nullable
    public V2 remove(Object key) {
        if (this.containsKey(key)) {
            V2 v2 = this.val2;
            this.val1 = null;
            this.val2 = null;
            return v2;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends V1, ? extends V2> m4) {
        A.notNull(m4, "m");
        A.ensure(m4.size() <= 1, "m.size() <= 1");
        for (Map.Entry<V1, V2> e : m4.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.val1 = null;
        this.val2 = null;
    }

    @Override
    public Set<V1> keySet() {
        return Collections.singleton(this.val1);
    }

    @Override
    public Collection<V2> values() {
        return Collections.singleton(this.val2);
    }

    @Override
    public Set<Map.Entry<V1, V2>> entrySet() {
        return this.isEmpty() ? Collections.emptySet() : Collections.singleton(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ignore) {
            throw new InternalError();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.val1);
        out.writeObject(this.val2);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.val1 = in.readObject();
        this.val2 = in.readObject();
    }

    @Override
    public int hashCode() {
        return this.val1 == null ? 0 : this.val1.hashCode() * 31 + (this.val2 == null ? 0 : this.val2.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IgniteBiTuple)) {
            return false;
        }
        IgniteBiTuple t2 = (IgniteBiTuple)o;
        return F.eq(this.val1, t2.val1) && F.eq(this.val2, t2.val2);
    }

    public String toString() {
        return S.toString(IgniteBiTuple.class, this);
    }
}

