/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.snapshot;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T5;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotJob;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotTaskResult;
import org.apache.ignite.spi.metric.IntMetric;
import org.apache.ignite.spi.metric.LongMetric;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorSnapshotStatusTask
extends VisorMultiNodeTask<Void, VisorSnapshotTaskResult, SnapshotStatus> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<Void, SnapshotStatus> job(Void arg) {
        return new VisorSnapshotStatusJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<Void> arg) {
        return F.nodeIds(this.ignite.cluster().forServers().nodes());
    }

    @Override
    @Nullable
    protected VisorSnapshotTaskResult reduce0(List<ComputeJobResult> results) {
        if (results.isEmpty()) {
            return new VisorSnapshotTaskResult(null, new IgniteException("Failed to get the snapshot status. Topology is empty."));
        }
        IgniteException error = F.find(F.viewReadOnly(results, ComputeJobResult::getException, r -> r.getException() != null), null, F.notNull());
        if (error != null) {
            return new VisorSnapshotTaskResult(null, new IgniteException("Failed to get the snapshot status.", error));
        }
        Collection<SnapshotStatus> res = F.viewReadOnly(results, ComputeJobResult::getData, r -> r.getData() != null);
        if (res.isEmpty()) {
            return new VisorSnapshotTaskResult(null, null);
        }
        SnapshotStatus s0 = F.first(res);
        res = F.view(res, s2 -> ((SnapshotStatus)s2).requestId.equals(s0.requestId));
        HashMap<UUID, T5<Long, Long, Long, Long, Long>> progress = new HashMap<UUID, T5<Long, Long, Long, Long, Long>>();
        res.forEach(s2 -> progress.putAll(((SnapshotStatus)s2).progress));
        return new VisorSnapshotTaskResult(new SnapshotStatus(s0.op, s0.name, s0.incIdx, s0.requestId, s0.startTime, progress), null);
    }

    public static enum SnapshotOperation {
        CREATE,
        RESTORE;

    }

    public static class SnapshotStatus
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final SnapshotOperation op;
        private final String name;
        private final int incIdx;
        private final String requestId;
        private final long startTime;
        private final Map<UUID, T5<Long, Long, Long, Long, Long>> progress;

        public SnapshotStatus(SnapshotOperation op, String name, int incIdx, String requestId, long startTime, Map<UUID, T5<Long, Long, Long, Long, Long>> progress) {
            this.op = op;
            this.name = name;
            this.incIdx = incIdx;
            this.requestId = requestId;
            this.startTime = startTime;
            this.progress = Collections.unmodifiableMap(progress);
        }

        public SnapshotOperation operation() {
            return this.op;
        }

        public String name() {
            return this.name;
        }

        public int incrementIndex() {
            return this.incIdx;
        }

        public String requestId() {
            return this.requestId;
        }

        public long startTime() {
            return this.startTime;
        }

        public Map<UUID, T5<Long, Long, Long, Long, Long>> progress() {
            return this.progress;
        }
    }

    private static class VisorSnapshotStatusJob
    extends VisorSnapshotJob<Void, SnapshotStatus> {
        private static final long serialVersionUID = 0L;

        protected VisorSnapshotStatusJob(@Nullable Void arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected SnapshotStatus run(@Nullable Void arg) throws IgniteException {
            if (!CU.isPersistenceEnabled(this.ignite.context().config())) {
                return null;
            }
            IgniteSnapshotManager snpMgr = this.ignite.context().cache().context().snapshotMgr();
            SnapshotOperationRequest req = snpMgr.currentCreateRequest();
            if (req != null) {
                T5<Long, Long, Long, Long, Long> metrics;
                if (req.incremental()) {
                    metrics = new T5<Long, Long, Long, Long, Long>(-1L, -1L, -1L, -1L, -1L);
                } else {
                    MetricRegistry mreg = this.ignite.context().metric().registry("snapshot");
                    metrics = new T5<Long, Long, Long, Long, Long>(((LongMetric)mreg.findMetric("CurrentSnapshotProcessedSize")).value(), ((LongMetric)mreg.findMetric("CurrentSnapshotTotalSize")).value(), -1L, -1L, -1L);
                }
                return new SnapshotStatus(SnapshotOperation.CREATE, req.snapshotName(), req.incrementIndex(), req.requestId().toString(), req.startTime(), F.asMap(this.ignite.localNode().id(), metrics));
            }
            MetricRegistry mreg = this.ignite.context().metric().registry("snapshot-restore");
            long startTime = ((LongMetric)mreg.findMetric("startTime")).value();
            if (startTime > ((LongMetric)mreg.findMetric("endTime")).value()) {
                return new SnapshotStatus(SnapshotOperation.RESTORE, mreg.findMetric("snapshotName").getAsString(), ((IntMetric)mreg.findMetric("incrementIndex")).value(), mreg.findMetric("requestId").getAsString(), ((LongMetric)mreg.findMetric("startTime")).value(), F.asMap(this.ignite.localNode().id(), new T5<Long, Long, Long, Long, Long>(Long.valueOf(((IntMetric)mreg.findMetric("processedPartitions")).value()), Long.valueOf(((IntMetric)mreg.findMetric("totalPartitions")).value()), Long.valueOf(((IntMetric)mreg.findMetric("processedWalSegments")).value()), Long.valueOf(((IntMetric)mreg.findMetric("totalWalSegments")).value()), ((LongMetric)mreg.findMetric("processedWalEntries")).value())));
            }
            return null;
        }
    }
}

