/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTaskArg;
import org.apache.ignite.internal.visor.cache.index.IndexForceRebuildTaskRes;
import org.apache.ignite.internal.visor.cache.index.IndexRebuildStatusInfoContainer;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class IndexForceRebuildTask
extends VisorOneNodeTask<IndexForceRebuildTaskArg, IndexForceRebuildTaskRes> {
    private static final long serialVersionUID = 0L;

    protected IndexForceRebuildJob job(IndexForceRebuildTaskArg arg) {
        return new IndexForceRebuildJob(arg, this.debug);
    }

    private static class IndexForceRebuildJob
    extends VisorJob<IndexForceRebuildTaskArg, IndexForceRebuildTaskRes> {
        private static final long serialVersionUID = 0L;

        protected IndexForceRebuildJob(@Nullable IndexForceRebuildTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IndexForceRebuildTaskRes run(@Nullable IndexForceRebuildTaskArg arg) throws IgniteException {
            assert (arg.cacheNames() == null ^ arg.cacheGrps() == null) : "Either cacheNames or cacheGroups must be specified.";
            HashSet<GridCacheContext> cachesToRebuild = new HashSet<GridCacheContext>();
            HashSet<String> notFound = new HashSet<String>();
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            if (arg.cacheNames() != null) {
                for (String cacheName : arg.cacheNames()) {
                    IgniteInternalCache cache = cacheProcessor.cache(cacheName);
                    if (cache != null) {
                        cachesToRebuild.add(cache.context());
                        continue;
                    }
                    notFound.add(cacheName);
                }
            } else {
                for (String cacheGrpName : arg.cacheGrps()) {
                    CacheGroupContext grpCtx = cacheProcessor.cacheGroup(CU.cacheId(cacheGrpName));
                    if (grpCtx != null) {
                        cachesToRebuild.addAll(grpCtx.caches());
                        continue;
                    }
                    notFound.add(cacheGrpName);
                }
            }
            Collection<GridCacheContext> cachesCtxWithRebuildingInProgress = this.ignite.context().cache().context().database().forceRebuildIndexes(cachesToRebuild);
            Set<IndexRebuildStatusInfoContainer> cachesWithRebuildingInProgress = cachesCtxWithRebuildingInProgress.stream().map(c -> new IndexRebuildStatusInfoContainer(c.config())).collect(Collectors.toSet());
            Set<IndexRebuildStatusInfoContainer> cachesWithStartedRebuild = cachesToRebuild.stream().map(c -> new IndexRebuildStatusInfoContainer(c.config())).filter(c -> !cachesWithRebuildingInProgress.contains(c)).collect(Collectors.toSet());
            return new IndexForceRebuildTaskRes(cachesWithStartedRebuild, cachesWithRebuildingInProgress, notFound);
        }
    }
}

