/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.offheap.unsafe;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.GridOffHeapEvent;
import org.apache.ignite.internal.util.offheap.GridOffHeapEventListener;
import org.apache.ignite.internal.util.offheap.GridOffHeapEvictListener;
import org.apache.ignite.internal.util.offheap.GridOffHeapMap;
import org.apache.ignite.internal.util.offheap.GridOffHeapOutOfMemoryException;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeLru;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeLruPoller;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridUnsafeMap
implements GridOffHeapMap {
    private static final int HEADER_SIZE = 28;
    private static final long HEADER_QUEUE_ADDR_OFF = 0L;
    private static final long HEADER_NEXT_ADDR_OFF = 8L;
    private static final long HEADER_HASH_OFF = 16L;
    private static final long HEADER_KEY_SIZE_OFF = 20L;
    private static final long HEADER_VALUE_SIZE = 24L;
    private static final boolean DEBUG = false;
    private static final int MAX_CONCURRENCY = 512;
    private static final int MIN_SIZE = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int part;
    private final int concurrency;
    private final float load;
    private final Segment[] segs;
    private final GridUnsafeMemory mem;
    private final int segmentMask;
    private final int segmentShift;
    private GridOffHeapEvictListener evictLsnr;
    private final GridUnsafeLru lru;
    private final LongAdder totalCnt;
    private GridOffHeapEventListener evtLsnr;
    private final boolean lruRelease;
    private final GridUnsafeLruPoller lruPoller;
    private final boolean rmvEvicted;

    public GridUnsafeMap(int concurrency, float load, long initCap, long totalMem, short lruStripes, @Nullable GridOffHeapEvictListener evictLsnr) {
        int size;
        this.concurrency = concurrency;
        this.load = load;
        this.part = 0;
        this.mem = new GridUnsafeMemory(totalMem);
        this.lru = totalMem > 0L ? new GridUnsafeLru(lruStripes, this.mem) : null;
        this.lruRelease = true;
        if (this.lru != null) {
            this.evictLsnr = evictLsnr;
        }
        this.totalCnt = new LongAdder();
        int shift = 0;
        for (size = 1; size < concurrency; size <<= 1) {
            ++shift;
        }
        this.segmentShift = 32 - shift;
        this.segmentMask = size - 1;
        this.segs = new Segment[size];
        this.init(initCap, size);
        this.lruPoller = new GridUnsafeLruPoller(){

            @Override
            public void lruPoll(int size) {
                int released;
                if (GridUnsafeMap.this.lru == null) {
                    return;
                }
                for (int left = size; left > 0; left -= released) {
                    long qAddr = GridUnsafeMap.this.lru.prePoll();
                    if (qAddr == 0L) {
                        return;
                    }
                    short order = GridUnsafeMap.this.lru.order(qAddr);
                    released = GridUnsafeMap.this.freeSpace(order, qAddr);
                    if (released != 0) continue;
                    return;
                }
            }
        };
        this.rmvEvicted = evictLsnr == null || evictLsnr.removeEvicted();
    }

    GridUnsafeMap(int part, int concurrency, float load, long initCap, LongAdder totalCnt, GridUnsafeMemory mem, GridUnsafeLru lru, @Nullable GridOffHeapEvictListener evictLsnr, GridUnsafeLruPoller lruPoller) {
        int size;
        this.part = part;
        this.concurrency = concurrency > 512 ? 512 : concurrency;
        this.load = load;
        this.totalCnt = totalCnt;
        this.mem = mem;
        this.lru = lru;
        this.lruPoller = lruPoller;
        if (lru != null) {
            this.evictLsnr = evictLsnr;
        }
        this.lruRelease = false;
        int shift = 0;
        for (size = 1; size < this.concurrency; size <<= 1) {
            ++shift;
        }
        this.segmentShift = 32 - shift;
        this.segmentMask = size - 1;
        this.segs = new Segment[size];
        this.init(initCap, size);
        this.rmvEvicted = evictLsnr == null || evictLsnr.removeEvicted();
    }

    private void init(long initCap, int size) {
        long c = initCap / (long)size;
        if (c < 16L) {
            c = 16L;
        }
        if (c * (long)size < initCap) {
            ++c;
        }
        int cap = 1;
        while ((long)cap < c) {
            cap <<= 1;
        }
        for (int i = 0; i < size; ++i) {
            try {
                this.segs[i] = new Segment(i, cap);
                continue;
            }
            catch (GridOffHeapOutOfMemoryException e) {
                this.destruct();
                throw e;
            }
        }
    }

    @Override
    public boolean eventListener(GridOffHeapEventListener evtLsnr) {
        if (this.evtLsnr != null) {
            return false;
        }
        this.evtLsnr = evtLsnr;
        this.mem.listen(evtLsnr);
        return true;
    }

    @Override
    public boolean evictListener(GridOffHeapEvictListener evictLsnr) {
        if (this.evictLsnr != null || this.lru == null) {
            return false;
        }
        this.evictLsnr = evictLsnr;
        return true;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public float loadFactor() {
        return this.load;
    }

    @Override
    public int concurrency() {
        return this.concurrency;
    }

    @Override
    public boolean contains(int hash, byte[] keyBytes) {
        return this.segmentFor(hash).contains(hash, keyBytes);
    }

    @Override
    public byte[] get(int hash, byte[] keyBytes) {
        return this.segmentFor(hash).get(hash, keyBytes);
    }

    @Override
    @Nullable
    public IgniteBiTuple<Long, Integer> valuePointer(int hash, byte[] keyBytes) {
        return this.segmentFor(hash).valuePointer(hash, keyBytes);
    }

    @Override
    public void enableEviction(int hash, byte[] keyBytes) {
        assert (this.lru != null);
        this.segmentFor(hash).enableEviction(hash, keyBytes);
    }

    @Override
    public byte[] remove(int hash, byte[] keyBytes) {
        return this.segmentFor(hash).remove(hash, keyBytes);
    }

    @Override
    public boolean removex(int hash, byte[] keyBytes) {
        return this.segmentFor(hash).removex(hash, keyBytes);
    }

    @Override
    public boolean removex(int hash, byte[] keyBytes, IgniteBiPredicate<Long, Integer> p) {
        return this.segmentFor(hash).removex(hash, keyBytes, p);
    }

    @Override
    public boolean put(int hash, byte[] keyBytes, byte[] valBytes) {
        return this.segmentFor(hash).put(hash, keyBytes, valBytes);
    }

    @Override
    public void insert(int hash, byte[] keyBytes, byte[] valBytes) {
        this.segmentFor(hash).insert(hash, keyBytes, valBytes);
    }

    @Override
    public long totalSize() {
        return this.totalCnt.sum();
    }

    @Override
    public long size() {
        long size = 0L;
        for (int i = 0; i < this.segs.length; ++i) {
            size += this.segs[i].count();
        }
        return size;
    }

    @Override
    public long memorySize() {
        return this.mem.totalSize();
    }

    @Override
    public long allocatedSize() {
        return this.mem.allocatedSize();
    }

    @Override
    public long systemAllocatedSize() {
        return this.mem.systemAllocatedSize();
    }

    @Override
    public long freeSize() {
        return this.mem.freeSize();
    }

    @Override
    public void destruct() {
        for (Segment seg : this.segs) {
            if (seg == null) continue;
            seg.destruct();
        }
        if (this.lru != null && this.lruRelease) {
            this.lru.destruct();
        }
    }

    @Override
    public GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> iterator() {
        return new GridCloseableIteratorAdapter<IgniteBiTuple<byte[], byte[]>>(){
            private GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> curIt;
            private int idx;
            {
                try {
                    this.advance();
                }
                catch (IgniteCheckedException e) {
                    e.printStackTrace();
                }
            }

            private void advance() throws IgniteCheckedException {
                this.curIt = null;
                while (this.idx < GridUnsafeMap.this.segs.length) {
                    this.curIt = GridUnsafeMap.this.segs[this.idx++].iterator();
                    if (this.curIt.hasNext()) {
                        return;
                    }
                    this.curIt.close();
                }
                this.curIt = null;
            }

            @Override
            protected IgniteBiTuple<byte[], byte[]> onNext() throws IgniteCheckedException {
                if (this.curIt == null) {
                    throw new NoSuchElementException();
                }
                IgniteBiTuple t2 = (IgniteBiTuple)this.curIt.next();
                if (!this.curIt.hasNext()) {
                    this.curIt.close();
                    this.advance();
                }
                return t2;
            }

            @Override
            protected boolean onHasNext() {
                return this.curIt != null;
            }

            @Override
            protected void onRemove() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.curIt != null) {
                    this.curIt.close();
                }
            }
        };
    }

    @Override
    public <T> GridCloseableIterator<T> iterator(final CX2<T2<Long, Integer>, T2<Long, Integer>, T> c) {
        return new GridCloseableIteratorAdapter<T>(){
            private GridCloseableIterator<T> curIt;
            private int idx;
            {
                try {
                    this.advance();
                }
                catch (IgniteCheckedException e) {
                    e.printStackTrace();
                }
            }

            private void advance() throws IgniteCheckedException {
                this.curIt = null;
                while (this.idx < GridUnsafeMap.this.segs.length) {
                    this.curIt = GridUnsafeMap.this.segs[this.idx++].iterator(c);
                    if (this.curIt.hasNext()) {
                        return;
                    }
                    this.curIt.close();
                }
                this.curIt = null;
            }

            @Override
            protected T onNext() throws IgniteCheckedException {
                if (this.curIt == null) {
                    throw new NoSuchElementException();
                }
                Object t2 = this.curIt.next();
                if (!this.curIt.hasNext()) {
                    this.curIt.close();
                    this.advance();
                }
                return t2;
            }

            @Override
            protected boolean onHasNext() {
                return this.curIt != null;
            }

            @Override
            protected void onRemove() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.curIt != null) {
                    this.curIt.close();
                }
            }
        };
    }

    public short lruStripes() {
        return this.lru.concurrency();
    }

    public long lruMemorySize() {
        return this.lru.memorySize();
    }

    public long lruSize() {
        return this.lru.size();
    }

    private Segment segmentFor(int hash) {
        return this.segs[hash >>> this.segmentShift & this.segmentMask];
    }

    int freeSpace(short order, long qAddr) {
        if (this.lru == null) {
            return 0;
        }
        int hash = this.lru.hash(order, qAddr);
        return this.segmentFor(hash).freeSpace(hash, order, qAddr);
    }

    private static class Entry {
        private Entry() {
        }

        static int size(byte[] keyBytes, byte[] valBytes) {
            return 28 + keyBytes.length + valBytes.length;
        }

        static int size(long addr, GridUnsafeMemory mem) {
            return 28 + Entry.readKeyLength(addr, mem) + Entry.readValueLength(addr, mem);
        }

        static int hash(long ptr, GridUnsafeMemory mem) {
            return mem.readInt(ptr + 16L);
        }

        static void hash(long ptr, int hash, GridUnsafeMemory mem) {
            mem.writeInt(ptr + 16L, hash);
        }

        static int readKeyLength(long ptr, GridUnsafeMemory mem) {
            int len = mem.readInt(ptr + 20L);
            assert (len >= 0) : "Invalid key length [addr=" + String.format("0x%08x", ptr) + ", len=" + Long.toHexString(len) + ']';
            return len;
        }

        static void writeKeyLength(long ptr, int len, GridUnsafeMemory mem) {
            mem.writeInt(ptr + 20L, len);
        }

        static int readValueLength(long ptr, GridUnsafeMemory mem) {
            int len = mem.readInt(ptr + 24L);
            assert (len >= 0) : "Invalid value length [addr=" + String.format("0x%08x", ptr) + ", len=" + Integer.toHexString(len) + ']';
            return len;
        }

        static void writeValueLength(long ptr, int len, GridUnsafeMemory mem) {
            mem.writeInt(ptr + 24L, len);
        }

        static long queueAddress(long ptr, GridUnsafeMemory mem) {
            return mem.readLong(ptr + 0L);
        }

        static void queueAddress(long ptr, long qAddr, GridUnsafeMemory mem) {
            mem.writeLong(ptr + 0L, qAddr);
        }

        static boolean clearQueueAddress(long ptr, long qAddr, GridUnsafeMemory mem) {
            return mem.casLong(ptr + 0L, qAddr, 0L);
        }

        static long nextAddress(long ptr, GridUnsafeMemory mem) {
            return mem.readLong(ptr + 8L);
        }

        static void nextAddress(long ptr, long addr, GridUnsafeMemory mem) {
            mem.writeLong(ptr + 8L, addr);
        }

        static byte[] readKeyBytes(long ptr, GridUnsafeMemory mem) {
            int keyLen = Entry.readKeyLength(ptr, mem);
            return mem.readBytes(ptr + 28L, keyLen);
        }

        static void writeKeyBytes(long ptr, byte[] keyBytes, GridUnsafeMemory mem) {
            mem.writeBytes(ptr + 28L, keyBytes);
        }

        static byte[] readValueBytes(long ptr, GridUnsafeMemory mem) {
            int keyLen = Entry.readKeyLength(ptr, mem);
            int valLen = Entry.readValueLength(ptr, mem);
            return mem.readBytes(ptr + 28L + (long)keyLen, valLen);
        }

        static void writeValueBytes(long ptr, byte[] valBytes, GridUnsafeMemory mem) {
            Entry.writeValueBytes(ptr, Entry.readKeyLength(ptr, mem), valBytes, mem);
        }

        static void writeValueBytes(long ptr, int keyLen, byte[] valBytes, GridUnsafeMemory mem) {
            mem.writeBytes(ptr + 28L + (long)keyLen, valBytes);
        }

        static void write(long ptr, int hash, byte[] keyBytes, byte[] valBytes, GridUnsafeMemory mem) {
            Entry.hash(ptr, hash, mem);
            Entry.writeKeyLength(ptr, keyBytes.length, mem);
            Entry.writeValueLength(ptr, valBytes.length, mem);
            Entry.writeKeyBytes(ptr, keyBytes, mem);
            Entry.writeValueBytes(ptr, keyBytes.length, valBytes, mem);
        }

        static void write(long ptr, int hash, byte[] keyBytes, byte[] valBytes, long queueAddr, long next, GridUnsafeMemory mem) {
            Entry.hash(ptr, hash, mem);
            Entry.writeKeyLength(ptr, keyBytes.length, mem);
            Entry.writeValueLength(ptr, valBytes.length, mem);
            Entry.queueAddress(ptr, queueAddr, mem);
            Entry.nextAddress(ptr, next, mem);
            Entry.writeKeyBytes(ptr, keyBytes, mem);
            Entry.writeValueBytes(ptr, keyBytes.length, valBytes, mem);
        }

        static boolean keyEquals(long ptr, byte[] keyBytes, GridUnsafeMemory mem) {
            long len = Entry.readKeyLength(ptr, mem);
            return len == (long)keyBytes.length && GridUnsafeMemory.compare(ptr + 28L, keyBytes);
        }
    }

    private static class Bin {
        private Bin() {
        }

        static void clear(long binAddr, GridUnsafeMemory mem) {
            mem.writeLong(binAddr, 0L);
        }

        static void first(long binAddr, long entryAddr, GridUnsafeMemory mem) {
            mem.writeLong(binAddr, entryAddr);
        }

        static long first(long binAddr, GridUnsafeMemory mem) {
            return mem.readLong(binAddr);
        }
    }

    private class Segment {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final int idx;
        private volatile long cap;
        private volatile long memCap;
        private volatile long cnt;
        private volatile long tblAddr;
        private long threshold;

        private Segment(int idx, long cap) {
            this.idx = idx;
            this.cap = cap;
            this.threshold = (long)((float)cap * GridUnsafeMap.this.load);
            this.memCap = cap * 8L;
            this.tblAddr = GridUnsafeMap.this.mem.allocateSystem(this.memCap, true);
        }

        int id() {
            return this.idx;
        }

        long tableAddress() {
            return this.tblAddr;
        }

        long capacity() {
            return this.cap;
        }

        float loadFactor() {
            return GridUnsafeMap.this.load;
        }

        long count() {
            return this.cnt;
        }

        long binIndex(int hash, long cap) {
            assert (Long.bitCount(cap) == 1);
            return (long)hash & cap - 1L;
        }

        long binAddress(int hash) {
            return this.binAddress(hash, this.tblAddr, this.cap);
        }

        long binAddress(int hash, long tblPtr, long cap) {
            return tblPtr + this.binIndex(hash, cap) * 8L;
        }

        private long writeLock(int hash) {
            this.lock.writeLock().lock();
            return this.binAddress(hash);
        }

        private void writeUnlock() {
            this.lock.writeLock().unlock();
        }

        private long readLock(int hash) {
            this.lock.readLock().lock();
            return this.binAddress(hash);
        }

        private void readUnlock() {
            this.lock.readLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destruct() {
            this.lock.writeLock().lock();
            try {
                if (this.tblAddr == 0L) {
                    return;
                }
                long tblEnd = this.tblAddr + this.memCap;
                block4: for (long binAddr = this.tblAddr; binAddr < tblEnd; binAddr += 8L) {
                    long entryAddr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                    if (entryAddr == 0L) continue;
                    while (true) {
                        long next = Entry.nextAddress(entryAddr, GridUnsafeMap.this.mem);
                        GridUnsafeMap.this.mem.release(entryAddr, Entry.size(entryAddr, GridUnsafeMap.this.mem));
                        if (next == 0L) continue block4;
                        entryAddr = next;
                    }
                }
                GridUnsafeMap.this.mem.releaseSystem(this.tblAddr, this.memCap);
            }
            finally {
                this.tblAddr = 0L;
                this.lock.writeLock().unlock();
            }
        }

        GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> iterator() {
            return new GridCloseableIteratorAdapter<IgniteBiTuple<byte[], byte[]>>(){
                private final Queue<IgniteBiTuple<byte[], byte[]>> bin = new LinkedList<IgniteBiTuple<byte[], byte[]>>();
                {
                    Segment.this.lock.readLock().lock();
                    try {
                        this.advance();
                    }
                    finally {
                        Segment.this.lock.readLock().unlock();
                    }
                }

                private void advance() {
                    assert (this.bin.isEmpty());
                    long tblEnd = Segment.this.tblAddr + Segment.this.memCap;
                    for (long binAddr = Segment.this.tblAddr; binAddr < tblEnd; binAddr += 8L) {
                        long entryAddr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                        if (entryAddr == 0L) continue;
                        while (entryAddr != 0L) {
                            int keyLen = Entry.readKeyLength(entryAddr, GridUnsafeMap.this.mem);
                            int valLen = Entry.readValueLength(entryAddr, GridUnsafeMap.this.mem);
                            byte[] valBytes = GridUnsafeMap.this.mem.readBytes(entryAddr + 28L + (long)keyLen, valLen);
                            this.bin.add(F.t(Entry.readKeyBytes(entryAddr, GridUnsafeMap.this.mem), valBytes));
                            entryAddr = Entry.nextAddress(entryAddr, GridUnsafeMap.this.mem);
                        }
                    }
                }

                @Override
                protected boolean onHasNext() {
                    return !this.bin.isEmpty();
                }

                @Override
                protected IgniteBiTuple<byte[], byte[]> onNext() {
                    IgniteBiTuple<byte[], byte[]> t2 = this.bin.poll();
                    if (t2 == null) {
                        throw new NoSuchElementException();
                    }
                    return t2;
                }

                @Override
                protected void onRemove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void onClose() {
                }
            };
        }

        <T> GridCloseableIterator<T> iterator(final CX2<T2<Long, Integer>, T2<Long, Integer>, T> c) {
            return new GridCloseableIteratorAdapter<T>(){
                private final Queue<T> bin = new LinkedList();
                {
                    Segment.this.lock.readLock().lock();
                    try {
                        this.advance();
                    }
                    finally {
                        Segment.this.lock.readLock().unlock();
                    }
                }

                private void advance() {
                    assert (this.bin.isEmpty());
                    long tblEnd = Segment.this.tblAddr + Segment.this.memCap;
                    for (long binAddr = Segment.this.tblAddr; binAddr < tblEnd; binAddr += 8L) {
                        long entryAddr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                        if (entryAddr == 0L) continue;
                        while (entryAddr != 0L) {
                            T2<Long, Integer> valPtr;
                            int keyLen = Entry.readKeyLength(entryAddr, GridUnsafeMap.this.mem);
                            int valLen = Entry.readValueLength(entryAddr, GridUnsafeMap.this.mem);
                            T2<Long, Integer> keyPtr = new T2<Long, Integer>(entryAddr + 28L, keyLen);
                            Object res = c.apply(keyPtr, valPtr = new T2<Long, Integer>(entryAddr + 28L + (long)keyLen, valLen));
                            if (res != null) {
                                this.bin.add(res);
                            }
                            entryAddr = Entry.nextAddress(entryAddr, GridUnsafeMap.this.mem);
                        }
                    }
                }

                @Override
                protected boolean onHasNext() {
                    return !this.bin.isEmpty();
                }

                @Override
                protected T onNext() {
                    Object t2 = this.bin.poll();
                    if (t2 == null) {
                        throw new NoSuchElementException();
                    }
                    return t2;
                }

                @Override
                protected void onRemove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void onClose() {
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rehash() {
            if (this.cnt >= 0x40000000L || this.cnt <= this.threshold) {
                return;
            }
            boolean release = false;
            long oldTblAddr = -1L;
            long oldMemCap = -1L;
            this.lock.writeLock().lock();
            try {
                long oldCap = this.cap;
                oldMemCap = this.memCap;
                oldTblAddr = this.tblAddr;
                if (this.cnt >= 0x40000000L || this.cnt <= this.threshold) {
                    return;
                }
                long newCap = oldCap << 1;
                long newMemCap = newCap * 8L;
                long newTblAddr = GridUnsafeMap.this.mem.allocateSystem(newMemCap, true);
                long oldTblEnd = oldTblAddr + this.memCap;
                block4: for (long oldBinAddr = oldTblAddr; oldBinAddr < oldTblEnd; oldBinAddr += 8L) {
                    long entryAddr = Bin.first(oldBinAddr, GridUnsafeMap.this.mem);
                    if (entryAddr == 0L) continue;
                    while (true) {
                        int hash = Entry.hash(entryAddr, GridUnsafeMap.this.mem);
                        long next = Entry.nextAddress(entryAddr, GridUnsafeMap.this.mem);
                        long newBinAddr = this.binAddress(hash, newTblAddr, newCap);
                        long newFirst = Bin.first(newBinAddr, GridUnsafeMap.this.mem);
                        Bin.first(newBinAddr, entryAddr, GridUnsafeMap.this.mem);
                        Entry.nextAddress(entryAddr, newFirst, GridUnsafeMap.this.mem);
                        if (next == 0L) continue block4;
                        entryAddr = next;
                    }
                }
                this.tblAddr = newTblAddr;
                this.memCap = newMemCap;
                this.cap = newCap;
                this.threshold = (long)((float)newCap * GridUnsafeMap.this.load);
                release = true;
                if (GridUnsafeMap.this.evtLsnr != null) {
                    GridUnsafeMap.this.evtLsnr.onEvent(GridOffHeapEvent.REHASH);
                }
            }
            finally {
                this.lock.writeLock().unlock();
                if (release) {
                    assert (oldTblAddr != this.tblAddr);
                    assert (oldTblAddr != -1L);
                    assert (oldMemCap != -1L);
                    GridUnsafeMap.this.mem.releaseSystem(oldTblAddr, oldMemCap);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int freeSpace(int hash, short order, long qAddr) {
            assert (GridUnsafeMap.this.lru != null);
            byte[] keyBytes = null;
            byte[] valBytes = null;
            int relSize = 0;
            long relAddr = 0L;
            long binAddr = this.writeLock(hash);
            try {
                long first;
                long addr = GridUnsafeMap.this.lru.entry(order, qAddr);
                if (addr != 0L && (first = Bin.first(binAddr, GridUnsafeMap.this.mem)) != 0L) {
                    long prev = 0L;
                    long cur = first;
                    while (cur != addr && cur != 0L) {
                        prev = cur;
                        cur = Entry.nextAddress(cur, GridUnsafeMap.this.mem);
                    }
                    if (cur != 0L) {
                        long qAddr0 = Entry.queueAddress(cur, GridUnsafeMap.this.mem);
                        assert (qAddr == qAddr0) : "Queue node address mismatch [qAddr=" + qAddr + ", entryQueueAddr=" + qAddr + ']';
                        if (GridUnsafeMap.this.evictLsnr != null) {
                            keyBytes = Entry.readKeyBytes(cur, GridUnsafeMap.this.mem);
                            int keyLen = Entry.readKeyLength(cur, GridUnsafeMap.this.mem);
                            int valLen = Entry.readValueLength(cur, GridUnsafeMap.this.mem);
                            valBytes = GridUnsafeMap.this.mem.readBytes(cur + 28L + (long)keyLen, valLen);
                        }
                        if (GridUnsafeMap.this.rmvEvicted) {
                            long a;
                            assert (qAddr == (a = Entry.queueAddress(cur, GridUnsafeMap.this.mem))) : "Queue node address mismatch [qAddr=" + qAddr + ", entryQueueAddr=" + a + ']';
                            long next = Entry.nextAddress(cur, GridUnsafeMap.this.mem);
                            if (prev != 0L) {
                                Entry.nextAddress(prev, next, GridUnsafeMap.this.mem);
                            } else if (next == 0L) {
                                Bin.clear(binAddr, GridUnsafeMap.this.mem);
                            } else {
                                Bin.first(binAddr, next, GridUnsafeMap.this.mem);
                            }
                            relSize = Entry.size(cur, GridUnsafeMap.this.mem);
                            relAddr = cur;
                            --this.cnt;
                            GridUnsafeMap.this.totalCnt.decrement();
                        } else {
                            boolean clear = Entry.clearQueueAddress(cur, qAddr, GridUnsafeMap.this.mem);
                            assert (clear);
                            relSize = Entry.size(cur, GridUnsafeMap.this.mem);
                        }
                    }
                }
                GridUnsafeMap.this.lru.poll(qAddr);
            }
            finally {
                this.writeUnlock();
                GridUnsafeMap.this.mem.release(relAddr, relSize);
            }
            if (keyBytes != null) {
                assert (GridUnsafeMap.this.evictLsnr != null);
                GridUnsafeMap.this.evictLsnr.onEvict(GridUnsafeMap.this.part, hash, keyBytes, valBytes);
            }
            return relSize;
        }

        void insert(int hash, byte[] keyBytes, byte[] valBytes) {
            if (this.cnt + 1L > this.threshold) {
                this.rehash();
            }
            int size = 28 + keyBytes.length + valBytes.length;
            boolean poll = !GridUnsafeMap.this.mem.reserve(size);
            long addr = GridUnsafeMap.this.mem.allocate(size, false, true);
            Entry.write(addr, hash, keyBytes, valBytes, GridUnsafeMap.this.mem);
            long binAddr = this.writeLock(hash);
            try {
                long first = Bin.first(binAddr, GridUnsafeMap.this.mem);
                Entry.nextAddress(addr, first, GridUnsafeMap.this.mem);
                Bin.first(binAddr, addr, GridUnsafeMap.this.mem);
                long qAddr = GridUnsafeMap.this.lru == null ? 0L : GridUnsafeMap.this.lru.offer(GridUnsafeMap.this.part, addr, hash);
                Entry.queueAddress(addr, qAddr, GridUnsafeMap.this.mem);
                ++this.cnt;
                GridUnsafeMap.this.totalCnt.increment();
            }
            catch (GridOffHeapOutOfMemoryException e) {
                GridUnsafeMap.this.mem.release(addr, size);
                throw e;
            }
            finally {
                this.writeUnlock();
                if (poll) {
                    GridUnsafeMap.this.lruPoller.lruPoll(size);
                }
                if (this.cnt > this.threshold) {
                    this.rehash();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean put(int hash, byte[] keyBytes, byte[] valBytes) {
            boolean isNew = true;
            boolean poll = false;
            int size = 0;
            int relSize = 0;
            long relAddr = 0L;
            long binAddr = this.writeLock(hash);
            try {
                long first = Bin.first(binAddr, GridUnsafeMap.this.mem);
                long qAddr = 0L;
                if (first != 0L) {
                    long next;
                    long prev = 0L;
                    long cur = first;
                    do {
                        next = Entry.nextAddress(cur, GridUnsafeMap.this.mem);
                        if (Entry.keyEquals(cur, keyBytes, GridUnsafeMap.this.mem)) {
                            if (Entry.readValueLength(cur, GridUnsafeMap.this.mem) == valBytes.length) {
                                Entry.writeValueBytes(cur, valBytes, GridUnsafeMap.this.mem);
                                isNew = false;
                                if (GridUnsafeMap.this.lru != null) {
                                    qAddr = Entry.queueAddress(cur, GridUnsafeMap.this.mem);
                                    if (qAddr == 0L) {
                                        qAddr = GridUnsafeMap.this.lru.offer(GridUnsafeMap.this.part, cur, hash);
                                        Entry.queueAddress(cur, qAddr, GridUnsafeMap.this.mem);
                                    } else {
                                        GridUnsafeMap.this.lru.touch(qAddr, cur);
                                    }
                                }
                                boolean bl = false;
                                return bl;
                            }
                            if (prev != 0L) {
                                Entry.nextAddress(prev, next, GridUnsafeMap.this.mem);
                            } else {
                                first = next;
                            }
                            qAddr = Entry.queueAddress(cur, GridUnsafeMap.this.mem);
                            if (qAddr == 0L && GridUnsafeMap.this.lru != null) {
                                qAddr = GridUnsafeMap.this.lru.offer(GridUnsafeMap.this.part, cur, hash);
                                Entry.queueAddress(cur, qAddr, GridUnsafeMap.this.mem);
                            }
                            relSize = Entry.size(cur, GridUnsafeMap.this.mem);
                            relAddr = cur;
                            isNew = false;
                            break;
                        }
                        prev = cur;
                        cur = next;
                    } while (next != 0L);
                }
                size = 28 + keyBytes.length + valBytes.length;
                poll = !GridUnsafeMap.this.mem.reserve(size);
                long addr = GridUnsafeMap.this.mem.allocate(size, false, true);
                Bin.first(binAddr, addr, GridUnsafeMap.this.mem);
                if (isNew) {
                    ++this.cnt;
                    GridUnsafeMap.this.totalCnt.increment();
                    qAddr = GridUnsafeMap.this.lru == null ? 0L : GridUnsafeMap.this.lru.offer(GridUnsafeMap.this.part, addr, hash);
                } else if (GridUnsafeMap.this.lru != null) {
                    GridUnsafeMap.this.lru.touch(qAddr, addr);
                }
                Entry.write(addr, hash, keyBytes, valBytes, qAddr, first, GridUnsafeMap.this.mem);
                boolean bl = isNew;
                return bl;
            }
            finally {
                this.writeUnlock();
                if (relAddr != 0L) {
                    GridUnsafeMap.this.mem.release(relAddr, relSize);
                }
                if (poll) {
                    GridUnsafeMap.this.lruPoller.lruPoll(size);
                }
                if (isNew && this.cnt > this.threshold) {
                    this.rehash();
                }
            }
        }

        byte[] remove(int hash, byte[] keyBytes) {
            return this.remove(hash, keyBytes, true, null);
        }

        boolean removex(int hash, byte[] keyBytes) {
            return this.remove(hash, keyBytes, false, null) == EMPTY_BYTES;
        }

        boolean removex(int hash, byte[] keyBytes, IgniteBiPredicate<Long, Integer> p) {
            return this.remove(hash, keyBytes, false, p) == EMPTY_BYTES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] remove(int hash, byte[] keyBytes, boolean retval, @Nullable IgniteBiPredicate<Long, Integer> p) {
            int relSize = 0;
            long relAddr = 0L;
            long qAddr = 0L;
            long binAddr = this.writeLock(hash);
            try {
                byte[] valBytes = null;
                long first = Bin.first(binAddr, GridUnsafeMap.this.mem);
                if (first != 0L) {
                    long prev = 0L;
                    long cur = first;
                    while (true) {
                        long next = Entry.nextAddress(cur, GridUnsafeMap.this.mem);
                        if (Entry.keyEquals(cur, keyBytes, GridUnsafeMap.this.mem)) {
                            int keyLen = 0;
                            int valLen = 0;
                            if (p != null) {
                                keyLen = Entry.readKeyLength(cur, GridUnsafeMap.this.mem);
                                valLen = Entry.readValueLength(cur, GridUnsafeMap.this.mem);
                                long valPtr = cur + 28L + (long)keyLen;
                                if (!p.apply(valPtr, valLen)) {
                                    byte[] byArray = null;
                                    return byArray;
                                }
                            }
                            if (prev != 0L) {
                                Entry.nextAddress(prev, next, GridUnsafeMap.this.mem);
                            } else if (next == 0L) {
                                Bin.clear(binAddr, GridUnsafeMap.this.mem);
                            } else {
                                Bin.first(binAddr, next, GridUnsafeMap.this.mem);
                            }
                            if (retval) {
                                if (keyLen == 0) {
                                    keyLen = Entry.readKeyLength(cur, GridUnsafeMap.this.mem);
                                    valLen = Entry.readValueLength(cur, GridUnsafeMap.this.mem);
                                }
                                valBytes = GridUnsafeMap.this.mem.readBytes(cur + 28L + (long)keyLen, valLen);
                            } else {
                                valBytes = EMPTY_BYTES;
                            }
                            qAddr = Entry.queueAddress(cur, GridUnsafeMap.this.mem);
                            relSize = Entry.size(cur, GridUnsafeMap.this.mem);
                            relAddr = cur;
                            --this.cnt;
                            GridUnsafeMap.this.totalCnt.decrement();
                            break;
                        }
                        if (next == 0L) break;
                        prev = cur;
                        cur = next;
                    }
                }
                byte[] byArray = valBytes;
                return byArray;
            }
            finally {
                if (relAddr != 0L && GridUnsafeMap.this.lru != null && qAddr != 0L) {
                    GridUnsafeMap.this.lru.remove(qAddr);
                }
                this.writeUnlock();
                if (relAddr != 0L) {
                    GridUnsafeMap.this.mem.release(relAddr, relSize);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean contains(int hash, byte[] keyBytes) {
            long binAddr = this.readLock(hash);
            try {
                long addr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                while (addr != 0L) {
                    if (Entry.keyEquals(addr, keyBytes, GridUnsafeMap.this.mem)) {
                        boolean bl = true;
                        return bl;
                    }
                    addr = Entry.nextAddress(addr, GridUnsafeMap.this.mem);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        IgniteBiTuple<Long, Integer> valuePointer(int hash, byte[] keyBytes) {
            long binAddr = this.readLock(hash);
            try {
                long addr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                while (addr != 0L) {
                    if (Entry.keyEquals(addr, keyBytes, GridUnsafeMap.this.mem)) {
                        long qAddr;
                        if (GridUnsafeMap.this.lru != null && (qAddr = Entry.queueAddress(addr, GridUnsafeMap.this.mem)) != 0L && Entry.clearQueueAddress(addr, qAddr, GridUnsafeMap.this.mem)) {
                            GridUnsafeMap.this.lru.remove(qAddr);
                        }
                        int keyLen = Entry.readKeyLength(addr, GridUnsafeMap.this.mem);
                        int valLen = Entry.readValueLength(addr, GridUnsafeMap.this.mem);
                        IgniteBiTuple<Long, Integer> igniteBiTuple = new IgniteBiTuple<Long, Integer>(addr + 28L + (long)keyLen, valLen);
                        return igniteBiTuple;
                    }
                    addr = Entry.nextAddress(addr, GridUnsafeMap.this.mem);
                }
                IgniteBiTuple<Long, Integer> igniteBiTuple = null;
                return igniteBiTuple;
            }
            finally {
                this.readUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enableEviction(int hash, byte[] keyBytes) {
            assert (GridUnsafeMap.this.lru != null);
            long binAddr = this.writeLock(hash);
            try {
                long addr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                while (addr != 0L) {
                    if (Entry.keyEquals(addr, keyBytes, GridUnsafeMap.this.mem)) {
                        long qAddr = Entry.queueAddress(addr, GridUnsafeMap.this.mem);
                        if (qAddr == 0L) {
                            qAddr = GridUnsafeMap.this.lru.offer(GridUnsafeMap.this.part, addr, hash);
                            Entry.queueAddress(addr, qAddr, GridUnsafeMap.this.mem);
                        }
                        return;
                    }
                    addr = Entry.nextAddress(addr, GridUnsafeMap.this.mem);
                }
            }
            finally {
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        byte[] get(int hash, byte[] keyBytes) {
            long binAddr = this.readLock(hash);
            try {
                long addr = Bin.first(binAddr, GridUnsafeMap.this.mem);
                while (addr != 0L) {
                    if (Entry.keyEquals(addr, keyBytes, GridUnsafeMap.this.mem)) {
                        int keyLen = Entry.readKeyLength(addr, GridUnsafeMap.this.mem);
                        int valLen = Entry.readValueLength(addr, GridUnsafeMap.this.mem);
                        byte[] byArray = GridUnsafeMap.this.mem.readBytes(addr + 28L + (long)keyLen, valLen);
                        return byArray;
                    }
                    addr = Entry.nextAddress(addr, GridUnsafeMap.this.mem);
                }
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.readUnlock();
            }
        }
    }
}

