/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class GridFilteredIterator<T>
implements Iterator<T> {
    protected final Iterator<? extends T> it;
    private boolean hasNext;
    private T next;

    protected GridFilteredIterator(Iterator<? extends T> it) {
        assert (it != null);
        this.it = it;
    }

    protected abstract boolean accept(T var1);

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        while (this.it.hasNext()) {
            T t2 = this.it.next();
            if (!this.accept(t2)) continue;
            this.next = t2;
            this.hasNext = true;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T res = this.next;
        this.next = null;
        this.hasNext = false;
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

