/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.future;

import java.util.concurrent.Executor;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

class GridFutureChainListener<T, R>
implements IgniteInClosure<IgniteInternalFuture<T>> {
    private static final long serialVersionUID = 0L;
    private final GridFutureAdapter<R> fut;
    private final IgniteClosure<? super IgniteInternalFuture<T>, R> doneCb;
    private Executor cbExec;

    public GridFutureChainListener(GridFutureAdapter<R> fut, IgniteClosure<? super IgniteInternalFuture<T>, R> doneCb, @Nullable Executor cbExec) {
        this.fut = fut;
        this.doneCb = doneCb;
        this.cbExec = cbExec;
    }

    @Override
    public void apply(final IgniteInternalFuture<T> t2) {
        if (this.cbExec != null) {
            this.cbExec.execute(new Runnable(){

                @Override
                public void run() {
                    GridFutureChainListener.this.applyCallback(t2);
                }
            });
        } else {
            this.applyCallback(t2);
        }
    }

    private void applyCallback(IgniteInternalFuture<T> t2) {
        try {
            this.fut.onDone(this.doneCb.apply(t2));
        }
        catch (GridClosureException e) {
            this.fut.onDone(e.unwrap());
        }
        catch (Error | RuntimeException e) {
            this.fut.onDone(e);
            throw e;
        }
    }
}

