/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridStringBuilder
implements Serializable {
    private static final long serialVersionUID = 0L;
    private StringBuilder impl;

    public GridStringBuilder() {
        this.impl = new StringBuilder(16);
    }

    public GridStringBuilder(int cap) {
        this.impl = new StringBuilder(cap);
    }

    public GridStringBuilder(String str) {
        this.impl = new StringBuilder(str);
    }

    public GridStringBuilder(CharSequence seq) {
        this.impl = new StringBuilder(seq);
    }

    public void setLength(int len) {
        this.impl.setLength(len);
    }

    public StringBuilder impl() {
        assert (this.impl != null);
        return this.impl;
    }

    public int length() {
        return this.impl.length();
    }

    public GridStringBuilder a(Object obj) {
        this.impl.append(String.valueOf(obj));
        return this;
    }

    public GridStringBuilder a(String str) {
        this.impl.append(str);
        return this;
    }

    public GridStringBuilder a(StringBuffer sb) {
        this.impl.append(sb);
        return this;
    }

    public GridStringBuilder a(CharSequence s2) {
        this.impl.append(s2);
        return this;
    }

    public GridStringBuilder a(CharSequence s2, int start, int end) {
        this.impl.append(s2, start, end);
        return this;
    }

    public GridStringBuilder a(char[] str) {
        this.impl.append(str);
        return this;
    }

    public GridStringBuilder a(char[] str, int offset, int len) {
        this.impl.append(str, offset, len);
        return this;
    }

    public GridStringBuilder a(boolean b) {
        this.impl.append(b);
        return this;
    }

    public GridStringBuilder a(char c) {
        this.impl.append(c);
        return this;
    }

    public GridStringBuilder a(int i) {
        this.impl.append(i);
        return this;
    }

    public GridStringBuilder a(long lng) {
        this.impl.append(lng);
        return this;
    }

    public GridStringBuilder a(float f) {
        this.impl.append(f);
        return this;
    }

    public GridStringBuilder a(double d) {
        this.impl.append(d);
        return this;
    }

    public GridStringBuilder appendCodePoint(int codePoint) {
        this.impl.appendCodePoint(codePoint);
        return this;
    }

    public GridStringBuilder d(int start, int end) {
        this.impl.delete(start, end);
        return this;
    }

    public GridStringBuilder d(int index) {
        this.impl.deleteCharAt(index);
        return this;
    }

    public GridStringBuilder nl() {
        this.impl.append(U.nl());
        return this;
    }

    public GridStringBuilder r(int start, int end, String str) {
        this.impl.replace(start, end, str);
        return this;
    }

    public GridStringBuilder i(int index, char[] str, int off, int len) {
        this.impl.insert(index, str, off, len);
        return this;
    }

    public GridStringBuilder i(int off, Object obj) {
        return this.i(off, String.valueOf(obj));
    }

    public GridStringBuilder i(int off, String str) {
        this.impl.insert(off, str);
        return this;
    }

    public GridStringBuilder i(int off, char[] str) {
        this.impl.insert(off, str);
        return this;
    }

    public GridStringBuilder i(int dstOff, CharSequence s2) {
        this.impl.insert(dstOff, s2);
        return this;
    }

    public GridStringBuilder i(int dstOff, CharSequence s2, int start, int end) {
        this.impl.insert(dstOff, s2, start, end);
        return this;
    }

    public GridStringBuilder i(int off, boolean b) {
        this.impl.insert(off, b);
        return this;
    }

    public GridStringBuilder i(int off, char c) {
        this.impl.insert(off, c);
        return this;
    }

    public GridStringBuilder i(int off, int i) {
        return this.i(off, String.valueOf(i));
    }

    public GridStringBuilder i(int off, long l) {
        return this.i(off, String.valueOf(l));
    }

    public GridStringBuilder i(int off, float f) {
        return this.i(off, String.valueOf(f));
    }

    public GridStringBuilder i(int off, double d) {
        return this.i(off, String.valueOf(d));
    }

    public GridStringBuilder appendHex(long val) {
        String hex = Long.toHexString(val);
        int len = hex.length();
        for (int i = 0; i < 16 - len; ++i) {
            this.a('0');
        }
        this.a(hex);
        return this;
    }

    public GridStringBuilder appendHex(int val) {
        String hex = Integer.toHexString(val);
        int len = hex.length();
        for (int i = 0; i < 8 - len; ++i) {
            this.a('0');
        }
        this.a(hex);
        return this;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.writeObject(this.impl);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        this.impl = (StringBuilder)s2.readObject();
    }

    public String toString() {
        return this.impl.toString();
    }
}

