/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridConsistentHash<N> {
    private static final int PRIME = 15485857;
    private static final Random RAND = new Random();
    private final Object affSeed;
    @GridToStringInclude
    private final NavigableMap<Integer, SortedSet<N>> circle = new TreeMap<Integer, SortedSet<N>>();
    private final ReadWriteLock rw = new ReentrantReadWriteLock();
    @GridToStringInclude
    private final Collection<N> nodes = new HashSet<N>();
    private final Comparator<N> nodesComp;

    public GridConsistentHash(@Nullable Object affSeed) {
        this(null, affSeed);
    }

    public GridConsistentHash() {
        this(null, null);
    }

    public GridConsistentHash(@Nullable Comparator<N> nodesComp, @Nullable Object affSeed) {
        this.nodesComp = nodesComp;
        this.affSeed = affSeed == null ? new Integer(15485857) : affSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(@Nullable Collection<N> nodes, int replicas) {
        if (F.isEmpty(nodes)) {
            return;
        }
        assert (nodes != null);
        this.rw.writeLock().lock();
        try {
            for (N node : nodes) {
                this.addNode(node, replicas);
            }
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(@Nullable N node, int replicas) {
        if (node == null) {
            return false;
        }
        long seed = this.affSeed.hashCode() * 31 + this.hash(node);
        this.rw.writeLock().lock();
        try {
            if (!this.nodes.add(node)) {
                boolean bl = false;
                return bl;
            }
            int hash = this.hash(seed);
            SortedSet<Object> set = (TreeSet<N>)this.circle.get(hash);
            if (set == null) {
                set = new TreeSet<N>(this.nodesComp);
                this.circle.put(hash, set);
            }
            set.add(node);
            for (int i = 1; i <= replicas; ++i) {
                hash = this.hash(seed = seed * (long)this.affSeed.hashCode() + (long)i);
                set = (SortedSet)this.circle.get(hash);
                if (set == null) {
                    set = new TreeSet<N>(this.nodesComp);
                    this.circle.put(hash, set);
                }
                set.add(node);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodes(@Nullable Collection<N> nodes) {
        if (F.isEmpty(nodes)) {
            return;
        }
        this.rw.writeLock().lock();
        try {
            if (!this.nodes.removeAll(nodes)) {
                return;
            }
            Iterator it = this.circle.values().iterator();
            while (it.hasNext()) {
                SortedSet set = (SortedSet)it.next();
                if (!set.removeAll(nodes) || !set.isEmpty()) continue;
                it.remove();
            }
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(@Nullable N node) {
        if (node == null) {
            return false;
        }
        this.rw.writeLock().lock();
        try {
            if (!this.nodes.remove(node)) {
                boolean bl = false;
                return bl;
            }
            Iterator it = this.circle.values().iterator();
            while (it.hasNext()) {
                SortedSet set = (SortedSet)it.next();
                if (!set.remove(node) || !set.isEmpty()) continue;
                it.remove();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    public void clear() {
        this.rw.writeLock().lock();
        try {
            this.nodes.clear();
            this.circle.clear();
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    public int count() {
        this.rw.readLock().lock();
        try {
            int n = this.nodes.size();
            return n;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.rw.readLock().lock();
        try {
            int size = 0;
            for (SortedSet set : this.circle.values()) {
                size += set.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set<N> nodes() {
        this.rw.readLock().lock();
        try {
            HashSet<N> hashSet = new HashSet<N>(this.nodes);
            return hashSet;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    @Nullable
    public N random() {
        return this.node(RAND.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public N node(@Nullable Object key) {
        int hash = this.hash(key);
        this.rw.readLock().lock();
        try {
            Map.Entry<Integer, SortedSet<N>> firstEntry = this.circle.firstEntry();
            if (firstEntry == null) {
                N n = null;
                return n;
            }
            Map.Entry<Integer, SortedSet<N>> tailEntry = this.circle.tailMap(hash, true).firstEntry();
            Object e = ((SortedSet)this.circle.get(tailEntry == null ? firstEntry.getKey() : tailEntry.getKey())).first();
            return (N)e;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    @Nullable
    public N node(@Nullable Object key, @Nullable Collection<N> inc) {
        return this.node(key, inc, null);
    }

    @Nullable
    public N node(@Nullable Object key, final @Nullable Collection<N> inc, final @Nullable Collection<N> exc) {
        if (inc == null && exc == null) {
            return this.node(key);
        }
        return this.node(key, new IgnitePredicate<N>(){

            @Override
            public boolean apply(N n) {
                return !(inc != null && !inc.contains(n) || exc != null && exc.contains(n));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public N node(@Nullable Object key, IgnitePredicate<N> ... p) {
        if (p == null || p.length == 0) {
            return this.node(key);
        }
        int hash = this.hash(key);
        this.rw.readLock().lock();
        try {
            int size = this.nodes.size();
            if (size == 0) {
                N n = null;
                return n;
            }
            GridLeanSet failed = null;
            for (SortedSet set : this.circle.tailMap(hash, true).values()) {
                for (Object n : set) {
                    if (failed != null && failed.contains(n)) continue;
                    if (this.apply(p, n)) {
                        Object e = n;
                        return (N)e;
                    }
                    if (failed == null) {
                        failed = new GridLeanSet(size);
                    }
                    failed.add(n);
                    if (failed.size() != size) continue;
                    N n2 = null;
                    return n2;
                }
            }
            for (SortedSet set : this.circle.headMap(hash, false).values()) {
                for (Object n : set) {
                    if (failed != null && failed.contains(n)) continue;
                    if (this.apply(p, n)) {
                        Object e = n;
                        return (N)e;
                    }
                    if (failed == null) {
                        failed = new GridLeanSet(size);
                    }
                    failed.add(n);
                    if (failed.size() != size) continue;
                    N n3 = null;
                    return n3;
                }
            }
            Iterator iterator = null;
            return (N)iterator;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    public List<N> nodes(@Nullable Object key, int cnt) {
        return this.nodes(key, cnt, (Collection<N>)null, (Collection<N>)null);
    }

    public List<N> nodes(@Nullable Object key, int cnt, @Nullable Collection<N> inc) {
        return this.nodes(key, cnt, inc, null);
    }

    public List<N> nodes(@Nullable Object key, int cnt, final @Nullable Collection<N> inc, final @Nullable Collection<N> exc) {
        A.ensure(cnt >= 0, "cnt >= 0");
        if (cnt == 0) {
            return Collections.emptyList();
        }
        if (cnt == 1) {
            return F.asList(this.node(key, inc, exc));
        }
        return this.nodes(key, cnt, new IgnitePredicate<N>(){

            @Override
            public boolean apply(N n) {
                return !(inc != null && !inc.contains(n) || exc != null && exc.contains(n));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<N> nodes(@Nullable Object key, int cnt, IgnitePredicate<N> ... p) {
        A.ensure(cnt >= 0, "cnt >= 0");
        if (cnt == 0) {
            return Collections.emptyList();
        }
        if (cnt == 1) {
            return F.asList(this.node(key, p));
        }
        int hash = this.hash(key);
        GridLeanSet failed = new GridLeanSet();
        this.rw.readLock().lock();
        try {
            if (this.circle.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
            int size = this.nodes.size();
            ArrayList ret = new ArrayList(Math.min(cnt, size));
            for (SortedSet set : this.circle.tailMap(hash, true).values()) {
                for (Object n : set) {
                    if (ret.contains(n) || failed.contains(n)) continue;
                    if (this.apply(p, n)) {
                        ret.add(n);
                    } else {
                        failed.add(n);
                    }
                    if (cnt != ret.size() && size != ret.size() + failed.size()) continue;
                    ArrayList arrayList = ret;
                    return arrayList;
                }
            }
            for (SortedSet set : this.circle.headMap(hash, false).values()) {
                for (Object n : set) {
                    if (ret.contains(n) || failed.contains(n)) continue;
                    if (this.apply(p, n)) {
                        ret.add(n);
                    } else {
                        failed.add(n);
                    }
                    if (cnt != ret.size() && size != ret.size() + failed.size()) continue;
                    ArrayList arrayList = ret;
                    return arrayList;
                }
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    private boolean apply(IgnitePredicate<N>[] p, N n) {
        return F.isAll(n, p);
    }

    public boolean belongs(@Nullable Object key, N node) {
        A.notNull(node, "node");
        N n = this.node(key);
        return n != null && n.equals(node);
    }

    public boolean belongs(@Nullable Object key, @Nullable Collection<N> nodes) {
        if (F.isEmpty(nodes)) {
            return false;
        }
        assert (nodes != null);
        N n = this.node(key);
        return n != null && nodes.contains(n);
    }

    public boolean belongs(@Nullable Object key, int cnt, N node) {
        return this.nodes(key, cnt).contains(node);
    }

    public boolean belongs(@Nullable Object key, int cnt, @Nullable Collection<N> nodes) {
        if (F.isEmpty(nodes)) {
            return false;
        }
        assert (nodes != null);
        return nodes.containsAll(this.nodes(key, cnt));
    }

    protected int hash(Object o) {
        int h2 = o == null ? 0 : o.hashCode();
        h2 += h2 << 15 ^ 0xFFFFCD7D;
        h2 ^= h2 >>> 10;
        h2 += h2 << 3;
        h2 ^= h2 >>> 6;
        h2 += (h2 << 2) + (h2 << 14);
        return h2 ^ h2 >>> 16;
    }

    public String toString() {
        return S.toString(GridConsistentHash.class, this);
    }
}

