/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.jetbrains.annotations.Nullable;

public class GridConcurrentSkipListSet<E>
extends GridSerializableSet<E>
implements NavigableSet<E>,
Cloneable {
    private static final long serialVersionUID = 0L;
    private ConcurrentNavigableMap<E, Object> m;

    public GridConcurrentSkipListSet() {
        this.m = new ConcurrentSkipListMap<E, Object>();
    }

    public GridConcurrentSkipListSet(Comparator<? super E> comp) {
        this.m = new ConcurrentSkipListMap<E, Object>(comp);
    }

    public GridConcurrentSkipListSet(Collection<? extends E> c) {
        this.m = new ConcurrentSkipListMap<E, Object>();
        this.addAll(c);
    }

    public GridConcurrentSkipListSet(SortedSet<E> s2) {
        this.m = new ConcurrentSkipListMap<E, Object>(s2.comparator());
        this.addAll(s2);
    }

    private GridConcurrentSkipListSet(ConcurrentNavigableMap<E, Object> m4) {
        this.m = m4;
    }

    public GridConcurrentSkipListSet<E> clone() {
        try {
            GridConcurrentSkipListSet clone = (GridConcurrentSkipListSet)super.clone();
            clone.m = new ConcurrentSkipListMap<E, Object>(this.m);
            return clone;
        }
        catch (CloneNotSupportedException ignored) {
            throw new Error("Clone should be supported on GridConcurrentSkipListSet class: " + this);
        }
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.m.putIfAbsent(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o, Boolean.TRUE);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        try {
            return this.containsAll(c) && c.containsAll(this);
        }
        catch (ClassCastException ignored) {
            return false;
        }
        catch (NullPointerException ignored) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public E lower(E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.m.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.m.higherKey(e);
    }

    @Override
    @Nullable
    public E pollFirst() {
        Map.Entry e = this.m.pollFirstEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    @Nullable
    public E pollLast() {
        Map.Entry e = this.m.pollLastEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Nullable
    public E firstx() {
        Map.Entry e = this.m.firstEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Nullable
    public E lastx() {
        Map.Entry e = this.m.lastEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new GridConcurrentSkipListSet<E>(this.m.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new GridConcurrentSkipListSet<E>(this.m.headMap((Object)toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new GridConcurrentSkipListSet<E>(this.m.tailMap((Object)fromElement, inclusive));
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new GridConcurrentSkipListSet<E>(this.m.descendingMap());
    }
}

