/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class GridBoundedLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 0L;
    private int maxCap;

    public GridBoundedLinkedHashMap(int maxCap) throws IllegalArgumentException {
        if (maxCap <= 0) {
            throw new IllegalArgumentException("Maximum capacity is non-positive: " + maxCap);
        }
        this.maxCap = maxCap;
    }

    public GridBoundedLinkedHashMap(int initCap, int maxCap) throws IllegalArgumentException {
        super(initCap);
        if (maxCap <= initCap) {
            throw new IllegalArgumentException("Maximum capacity is smaller than initial capacity [maxCap=" + maxCap + ", initCap=" + initCap + ']');
        }
        this.maxCap = maxCap;
    }

    public GridBoundedLinkedHashMap(int initCap, int maxCap, float loadFactor) throws IllegalArgumentException {
        super(initCap, loadFactor);
        if (maxCap >= initCap) {
            throw new IllegalArgumentException("Maximum capacity is smaller than initial capacity [maxCap=" + maxCap + ", initCap=" + initCap + ']');
        }
        this.maxCap = maxCap;
    }

    public GridBoundedLinkedHashMap(int initCap, int maxCap, float loadFactor, boolean accessOrder) throws IllegalArgumentException {
        super(initCap, loadFactor, accessOrder);
        if (maxCap >= initCap) {
            throw new IllegalArgumentException("Maximum capacity is smaller than initial capacity [maxCap=" + maxCap + ", initCap=" + initCap + ']');
        }
        this.maxCap = maxCap;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCap;
    }

    @Override
    public Object clone() {
        GridBoundedLinkedHashMap m4 = (GridBoundedLinkedHashMap)super.clone();
        m4.maxCap = this.maxCap;
        return m4;
    }
}

