/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.io.Externalizable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.systemview.walker.ServiceViewWalker;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.platform.services.PlatformServiceConfiguration;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.service.CompositeServiceCallInterceptor;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentCompoundFuture;
import org.apache.ignite.internal.processors.service.GridServiceDeploymentFuture;
import org.apache.ignite.internal.processors.service.GridServiceProxy;
import org.apache.ignite.internal.processors.service.LazyServiceConfiguration;
import org.apache.ignite.internal.processors.service.PreparedConfigurations;
import org.apache.ignite.internal.processors.service.ServiceChangeAbstractRequest;
import org.apache.ignite.internal.processors.service.ServiceChangeBatchRequest;
import org.apache.ignite.internal.processors.service.ServiceClusterDeploymentResult;
import org.apache.ignite.internal.processors.service.ServiceClusterDeploymentResultBatch;
import org.apache.ignite.internal.processors.service.ServiceContextImpl;
import org.apache.ignite.internal.processors.service.ServiceDeploymentActions;
import org.apache.ignite.internal.processors.service.ServiceDeploymentManager;
import org.apache.ignite.internal.processors.service.ServiceDeploymentRequest;
import org.apache.ignite.internal.processors.service.ServiceInfo;
import org.apache.ignite.internal.processors.service.ServiceProcessorCommonDiscoveryData;
import org.apache.ignite.internal.processors.service.ServiceProcessorJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.service.ServiceSingleNodeDeploymentResult;
import org.apache.ignite.internal.processors.service.ServiceUndeploymentRequest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceCallInterceptor;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.services.ServiceDeploymentException;
import org.apache.ignite.services.ServiceDescriptor;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.spi.systemview.view.ServiceView;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.thread.OomExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteServiceProcessor
extends GridProcessorAdapter
implements IgniteChangeGlobalStateSupport {
    public static final String SVCS_VIEW = "services";
    public static final String SVCS_VIEW_DESC = "Services";
    private static final String SERVICE_METRIC_REGISTRY = "Services";
    private static final String DESCRIPTION_OF_INVOCATION_METRIC_PREF = "Duration in milliseconds of ";
    public static final long[] DEFAULT_INVOCATION_BOUNDS = new long[]{TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(50L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(200L, TimeUnit.MILLISECONDS), TimeUnit.NANOSECONDS.convert(1000L, TimeUnit.MILLISECONDS)};
    private final ConcurrentMap<IgniteUuid, Collection<ServiceContextImpl>> locServices = new ConcurrentHashMap<IgniteUuid, Collection<ServiceContextImpl>>();
    private final ConcurrentMap<IgniteUuid, ServiceInfo> registeredServices = new ConcurrentHashMap<IgniteUuid, ServiceInfo>();
    private final ConcurrentMap<String, ServiceInfo> registeredServicesByName = new ConcurrentHashMap<String, ServiceInfo>();
    private final ConcurrentMap<IgniteUuid, ServiceInfo> deployedServices = new ConcurrentHashMap<IgniteUuid, ServiceInfo>();
    private final ConcurrentMap<String, ServiceInfo> deployedServicesByName = new ConcurrentHashMap<String, ServiceInfo>();
    private final ConcurrentMap<IgniteUuid, GridServiceDeploymentFuture<IgniteUuid>> depFuts = new ConcurrentHashMap<IgniteUuid, GridServiceDeploymentFuture<IgniteUuid>>();
    private final ConcurrentMap<IgniteUuid, GridFutureAdapter<?>> undepFuts = new ConcurrentHashMap();
    private final ThreadFactory threadFactory = new IgniteThreadFactory(this.ctx.igniteInstanceName(), "service", new OomExceptionHandler(this.ctx));
    private final Marshaller marsh = new JdkMarshaller();
    private volatile ServiceDeploymentManager depMgr = new ServiceDeploymentManager(this.ctx);
    private final Object servicesTopsUpdateMux = new Object();
    private final ReentrantReadWriteLock opsLock = new ReentrantReadWriteLock();
    private volatile boolean disconnected;

    public IgniteServiceProcessor(GridKernalContext ctx) {
        super(ctx);
        ctx.systemView().registerView(SVCS_VIEW, "Services", new ServiceViewWalker(), this.registeredServices.values(), ServiceView::new);
    }

    @Override
    public void start() throws IgniteCheckedException {
        IgniteConfiguration cfg = this.ctx.config();
        DeploymentMode depMode = cfg.getDeploymentMode();
        if (cfg.isPeerClassLoadingEnabled() && (depMode == DeploymentMode.PRIVATE || depMode == DeploymentMode.ISOLATED) && !F.isEmpty(cfg.getServiceConfiguration())) {
            throw new IgniteCheckedException("Cannot deploy services in PRIVATE or ISOLATED deployment mode: " + (Object)((Object)depMode));
        }
        this.ctx.discovery().setCustomEventListener(ServiceChangeBatchRequest.class, new CustomEventListener<ServiceChangeBatchRequest>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, ServiceChangeBatchRequest msg) {
                IgniteServiceProcessor.this.processServicesChangeRequest(snd, msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(ChangeGlobalStateMessage.class, new CustomEventListener<ChangeGlobalStateMessage>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, ChangeGlobalStateMessage msg) {
                IgniteServiceProcessor.this.processChangeGlobalStateRequest(msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(DynamicCacheChangeBatch.class, new CustomEventListener<DynamicCacheChangeBatch>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, DynamicCacheChangeBatch msg) {
                IgniteServiceProcessor.this.processDynamicCacheChangeRequest(msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(ServiceClusterDeploymentResultBatch.class, new CustomEventListener<ServiceClusterDeploymentResultBatch>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, ServiceClusterDeploymentResultBatch msg) {
                IgniteServiceProcessor.this.processServicesFullDeployments(msg);
            }
        });
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        this.depMgr.startProcessing();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started service processor.");
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.opsLock.writeLock().lock();
        try {
            if (this.disconnected) {
                return;
            }
            this.stopProcessor(new IgniteCheckedException("Operation has been cancelled (node is stopping)."));
        }
        finally {
            this.opsLock.writeLock().unlock();
        }
    }

    private void stopProcessor(IgniteCheckedException stopError) {
        assert (this.opsLock.isWriteLockedByCurrentThread());
        this.depMgr.stopProcessing(stopError);
        this.cancelDeployedServices();
        this.registeredServices.clear();
        this.registeredServicesByName.clear();
        Stream.concat(this.depFuts.values().stream(), this.undepFuts.values().stream()).forEach(fut -> {
            try {
                fut.onDone(stopError);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.depFuts.clear();
        this.undepFuts.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped service processor.");
        }
    }

    private void cancelDeployedServices() {
        assert (this.opsLock.isWriteLockedByCurrentThread());
        this.deployedServices.clear();
        this.deployedServicesByName.clear();
        this.ctx.metric().remove("Services");
        this.locServices.values().stream().flatMap(Collection::stream).forEach(srvcCtx -> {
            this.cancel((ServiceContextImpl)srvcCtx);
            if (this.ctx.isStopping()) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Shutting down distributed service [name=" + srvcCtx.name() + ", execId8=" + U.id8(srvcCtx.executionId()) + ']');
                    }
                    srvcCtx.executor().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    U.error(this.log, "Got interrupted while waiting for service to shutdown (will continue stopping node): " + srvcCtx.name());
                }
            }
        });
        this.locServices.clear();
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.SERVICE_PROC.ordinal())) {
            return;
        }
        ServiceProcessorCommonDiscoveryData clusterData = new ServiceProcessorCommonDiscoveryData(new ArrayList<ServiceInfo>(this.registeredServices.values()));
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.SERVICE_PROC.ordinal(), clusterData);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        if (data.commonData() == null) {
            return;
        }
        ServiceProcessorCommonDiscoveryData clusterData = (ServiceProcessorCommonDiscoveryData)data.commonData();
        for (ServiceInfo desc : clusterData.registeredServices()) {
            this.registerService(desc);
        }
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        ArrayList<ServiceInfo> staticServicesInfo = this.staticallyConfiguredServices(true);
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.SERVICE_PROC.ordinal(), new ServiceProcessorJoinNodeDiscoveryData(staticServicesInfo));
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        if (data.joiningNodeData() == null || !this.ctx.security().enabled()) {
            return null;
        }
        ArrayList<ServiceInfo> svcs = ((ServiceProcessorJoinNodeDiscoveryData)data.joiningNodeData()).services();
        SecurityException err = this.checkDeployPermissionDuringJoin(node, svcs);
        if (err != null) {
            return new IgniteNodeValidationResult(node.id(), err.getMessage());
        }
        return null;
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        if (data.joiningNodeData() == null) {
            return;
        }
        ServiceProcessorJoinNodeDiscoveryData joinData = (ServiceProcessorJoinNodeDiscoveryData)data.joiningNodeData();
        for (ServiceInfo desc : joinData.services()) {
            assert (desc.topologySnapshot().isEmpty());
            ServiceInfo oldDesc = (ServiceInfo)this.registeredServices.get(desc.serviceId());
            if (oldDesc != null) {
                U.warn(this.log, "Failed to register service configuration received from joining node : [nodeId=" + data.joiningNodeId() + ", cfgName=" + desc.name() + "]. Service with the same service id already exists, cfg=" + oldDesc.configuration());
                continue;
            }
            oldDesc = this.lookupInRegisteredServices(desc.name());
            if (oldDesc == null) {
                this.registerService(desc);
                continue;
            }
            if (oldDesc.configuration().equalsIgnoreNodeFilter(desc.configuration())) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Ignore service configuration received from joining node : [nodeId=" + data.joiningNodeId() + ", cfgName=" + desc.name() + "]. The same service configuration already registered.");
                continue;
            }
            U.warn(this.log, "Failed to register service configuration received from joining node : [nodeId=" + data.joiningNodeId() + ", cfgName=" + desc.name() + "]. Service already exists with different configuration, cfg=" + desc.configuration());
        }
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.SERVICE_PROC;
    }

    @Override
    public void onActivate(GridKernalContext kctx) {
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        try {
            this.opsLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException(e);
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("DeActivate service processor [nodeId=" + this.ctx.localNodeId() + " topVer=" + this.ctx.discovery().topologyVersionEx() + " ]");
            }
            this.cancelDeployedServices();
        }
        finally {
            this.opsLock.writeLock().unlock();
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        assert (!this.disconnected);
        this.opsLock.writeLock().lock();
        try {
            if (this.ctx.isStopping()) {
                return;
            }
            this.disconnected = true;
            this.stopProcessor(new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Client node disconnected, the operation's result is unknown."));
        }
        finally {
            this.opsLock.writeLock().unlock();
        }
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean active) throws IgniteCheckedException {
        assert (this.disconnected);
        this.opsLock.writeLock().lock();
        try {
            this.disconnected = false;
            this.depMgr = new ServiceDeploymentManager(this.ctx);
            this.onKernalStart(active);
            IgniteInternalFuture<?> igniteInternalFuture = null;
            return igniteInternalFuture;
        }
        finally {
            this.opsLock.writeLock().unlock();
        }
    }

    private void validate(ServiceConfiguration c) throws IgniteException {
        IgniteConfiguration cfg = this.ctx.config();
        DeploymentMode depMode = cfg.getDeploymentMode();
        if (cfg.isPeerClassLoadingEnabled() && (depMode == DeploymentMode.PRIVATE || depMode == DeploymentMode.ISOLATED)) {
            throw new IgniteException("Cannot deploy services in PRIVATE or ISOLATED deployment mode: " + (Object)((Object)depMode));
        }
        this.ensure(c.getName() != null, "getName() != null", null);
        this.ensure(c.getTotalCount() >= 0, "getTotalCount() >= 0", c.getTotalCount());
        this.ensure(c.getMaxPerNodeCount() >= 0, "getMaxPerNodeCount() >= 0", c.getMaxPerNodeCount());
        this.ensure(c.getService() != null, "getService() != null", c.getService());
        this.ensure(c.getTotalCount() > 0 || c.getMaxPerNodeCount() > 0, "c.getTotalCount() > 0 || c.getMaxPerNodeCount() > 0", null);
        this.ensure(!c.isStatisticsEnabled() || !(c.getService() instanceof PlatformService) || c instanceof PlatformServiceConfiguration, "The service is a platform service and has statisticsenabled. Service configuration must be PlatformServiceConfiguration.", null);
    }

    private void ensure(boolean cond, String desc, @Nullable Object v) {
        if (!cond) {
            if (v != null) {
                throw new IgniteException("Service configuration check failed (" + desc + "): " + v);
            }
            throw new IgniteException("Service configuration check failed (" + desc + ")");
        }
    }

    public IgniteInternalFuture<?> deployNodeSingleton(ClusterGroup prj, String name, Service srvc) {
        return this.deployMultiple(prj, name, srvc, 0, 1);
    }

    public IgniteInternalFuture<?> deployClusterSingleton(ClusterGroup prj, String name, Service srvc) {
        return this.deployMultiple(prj, name, srvc, 1, 1);
    }

    public IgniteInternalFuture<?> deployMultiple(ClusterGroup prj, String name, Service srvc, int totalCnt, int maxPerNodeCnt) {
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.setName(name);
        cfg.setService(srvc);
        cfg.setTotalCount(totalCnt);
        cfg.setMaxPerNodeCount(maxPerNodeCnt);
        return this.deployAll(prj, Collections.singleton(cfg));
    }

    public IgniteInternalFuture<?> deployKeyAffinitySingleton(String name, Service srvc, String cacheName, Object affKey) {
        A.notNull(affKey, "affKey");
        ServiceConfiguration cfg = new ServiceConfiguration();
        cfg.setName(name);
        cfg.setService(srvc);
        cfg.setCacheName(cacheName);
        cfg.setAffinityKey(affKey);
        cfg.setTotalCount(1);
        cfg.setMaxPerNodeCount(1);
        return this.deployAll(Collections.singleton(cfg), null);
    }

    private PreparedConfigurations<IgniteUuid> prepareServiceConfigurations(Collection<ServiceConfiguration> cfgs, IgnitePredicate<ClusterNode> dfltNodeFilter) {
        ArrayList<ServiceConfiguration> cfgsCp = new ArrayList<ServiceConfiguration>(cfgs.size());
        ArrayList<GridServiceDeploymentFuture<Object>> failedFuts = null;
        for (ServiceConfiguration cfg : cfgs) {
            Exception err = null;
            if (cfg.getNodeFilter() == null && dfltNodeFilter != null) {
                cfg.setNodeFilter(dfltNodeFilter);
            }
            try {
                this.validate(cfg);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to validate service configuration [name=" + cfg.getName() + ", srvc=" + cfg.getService() + ']', e);
                err = e;
            }
            if (err == null) {
                try {
                    byte[] srvcBytes = U.marshal(this.marsh, (Object)cfg.getService());
                    byte[] interceptorsBytes = U.marshal(this.marsh, (Object)cfg.getInterceptors());
                    String[] knownSvcMdtNames = cfg instanceof PlatformServiceConfiguration ? ((PlatformServiceConfiguration)cfg).mtdNames() : null;
                    cfgsCp.add(new LazyServiceConfiguration(cfg, srvcBytes, interceptorsBytes).platformMtdNames(knownSvcMdtNames));
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to marshal service with configured marshaller [name=" + cfg.getName() + ", srvc=" + cfg.getService() + ", marsh=" + this.marsh + "]", e);
                    err = e;
                }
            }
            if (err == null) continue;
            if (failedFuts == null) {
                failedFuts = new ArrayList<GridServiceDeploymentFuture<Object>>();
            }
            GridServiceDeploymentFuture<Object> fut = new GridServiceDeploymentFuture<Object>(cfg, null);
            fut.onDone(err);
            failedFuts.add(fut);
        }
        return new PreparedConfigurations<IgniteUuid>(cfgsCp, failedFuts);
    }

    private SecurityException checkPermissions(String name, SecurityPermission perm) {
        try {
            this.ctx.security().authorize(name, perm);
            return null;
        }
        catch (SecurityException e) {
            U.error(this.log, "Failed to authorize service access [name=" + name + ", perm=" + (Object)((Object)perm) + ']', e);
            return e;
        }
    }

    public IgniteInternalFuture<?> deployAll(ClusterGroup prj, Collection<ServiceConfiguration> cfgs) {
        if (prj == null) {
            return this.deployAll(cfgs, this.ctx.cluster().get().forServers().predicate());
        }
        if (prj.predicate() == F.alwaysTrue()) {
            return this.deployAll(cfgs, null);
        }
        return this.deployAll(cfgs, prj.predicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<?> deployAll(@NotNull Collection<ServiceConfiguration> cfgs, @Nullable IgnitePredicate<ClusterNode> dfltNodeFilter) {
        this.opsLock.readLock().lock();
        try {
            if (this.disconnected) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture(new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to deploy services, client node disconnected: " + cfgs));
                return gridFinishedFuture;
            }
            if (this.ctx.isStopping()) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture(new IgniteCheckedException("Failed to deploy services, node is stopping: " + cfgs));
                return gridFinishedFuture;
            }
            if (cfgs.isEmpty()) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                return gridFinishedFuture;
            }
            PreparedConfigurations<IgniteUuid> srvcCfg = this.prepareServiceConfigurations(cfgs, dfltNodeFilter);
            List<ServiceConfiguration> cfgsCp = srvcCfg.cfgs;
            List failedFuts = srvcCfg.failedFuts;
            GridServiceDeploymentCompoundFuture<IgniteUuid> res = new GridServiceDeploymentCompoundFuture<IgniteUuid>();
            if (!cfgsCp.isEmpty()) {
                try {
                    ArrayList<ServiceChangeAbstractRequest> reqs = new ArrayList<ServiceChangeAbstractRequest>();
                    for (ServiceConfiguration cfg : cfgsCp) {
                        IgniteUuid srvcId = IgniteUuid.randomUuid();
                        GridServiceDeploymentFuture<IgniteUuid> fut = new GridServiceDeploymentFuture<IgniteUuid>(cfg, srvcId);
                        res.add(fut, true);
                        reqs.add(new ServiceDeploymentRequest(srvcId, cfg));
                        this.depFuts.put(srvcId, fut);
                    }
                    ServiceChangeBatchRequest serviceChangeBatchRequest = new ServiceChangeBatchRequest(reqs);
                    this.ctx.discovery().sendCustomEvent(serviceChangeBatchRequest);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Services have been sent to deploy, req=" + serviceChangeBatchRequest);
                    }
                }
                catch (IgniteCheckedException | IgniteException e) {
                    for (IgniteUuid id : res.servicesToRollback()) {
                        ((GridServiceDeploymentFuture)this.depFuts.remove(id)).onDone(e);
                    }
                    res.onDone(new IgniteCheckedException(new ServiceDeploymentException("Failed to deploy provided services.", e, cfgs)));
                    GridServiceDeploymentCompoundFuture<IgniteUuid> gridServiceDeploymentCompoundFuture = res;
                    this.opsLock.readLock().unlock();
                    return gridServiceDeploymentCompoundFuture;
                }
            }
            if (failedFuts != null) {
                for (GridServiceDeploymentFuture gridServiceDeploymentFuture : failedFuts) {
                    res.add(gridServiceDeploymentFuture, false);
                }
            }
            res.markInitialized();
            GridServiceDeploymentCompoundFuture<IgniteUuid> gridServiceDeploymentCompoundFuture = res;
            return gridServiceDeploymentCompoundFuture;
        }
        finally {
            this.opsLock.readLock().unlock();
        }
    }

    public IgniteInternalFuture<?> cancel(String name) {
        return this.cancelAll(Collections.singleton(name));
    }

    public IgniteInternalFuture<?> cancelAll() {
        return this.cancelAll(this.deployedServices.values().stream().map(ServiceInfo::name).collect(Collectors.toSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> cancelAll(@NotNull Collection<String> servicesNames) {
        this.opsLock.readLock().lock();
        try {
            if (this.disconnected) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture(new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to undeploy services, client node disconnected: " + servicesNames));
                return gridFinishedFuture;
            }
            if (this.ctx.isStopping()) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture(new IgniteCheckedException("Failed to undeploy services, node is stopping: " + servicesNames));
                return gridFinishedFuture;
            }
            if (servicesNames.isEmpty()) {
                GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
                return gridFinishedFuture;
            }
            GridCompoundFuture res = new GridCompoundFuture();
            HashSet<IgniteUuid> toRollback = new HashSet<IgniteUuid>();
            ArrayList<ServiceChangeAbstractRequest> reqs = new ArrayList<ServiceChangeAbstractRequest>();
            try {
                for (String name : servicesNames) {
                    IgniteUuid srvcId = this.lookupDeployedServiceId(name);
                    if (srvcId == null) continue;
                    SecurityException err = this.checkPermissions(name, SecurityPermission.SERVICE_CANCEL);
                    if (err != null) {
                        res.add(new GridFinishedFuture(err));
                        continue;
                    }
                    GridFutureAdapter fut = new GridFutureAdapter();
                    GridFutureAdapter old = this.undepFuts.putIfAbsent(srvcId, fut);
                    if (old != null) {
                        res.add(old);
                        continue;
                    }
                    res.add(fut);
                    toRollback.add(srvcId);
                    reqs.add(new ServiceUndeploymentRequest(srvcId));
                }
                if (!reqs.isEmpty()) {
                    ServiceChangeBatchRequest msg = new ServiceChangeBatchRequest(reqs);
                    this.ctx.discovery().sendCustomEvent(msg);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Services have been sent to cancel, msg=" + msg);
                    }
                }
            }
            catch (IgniteCheckedException | IgniteException e) {
                for (IgniteUuid id : toRollback) {
                    ((GridFutureAdapter)this.undepFuts.remove(id)).onDone(e);
                }
                U.error(this.log, "Failed to undeploy services: " + servicesNames, e);
                res.onDone(e);
                GridCompoundFuture gridCompoundFuture = res;
                this.opsLock.readLock().unlock();
                return gridCompoundFuture;
            }
            res.markInitialized();
            GridCompoundFuture gridCompoundFuture = res;
            return gridCompoundFuture;
        }
        finally {
            this.opsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, Integer> serviceTopology(String name, long timeout) throws IgniteCheckedException {
        assert (timeout >= 0L);
        long startTime = U.currentTimeMillis();
        while (true) {
            Object object = this.servicesTopsUpdateMux;
            synchronized (object) {
                ServiceInfo desc = this.lookupInRegisteredServices(name);
                if (timeout == 0L && desc == null) {
                    return null;
                }
                if (desc != null && desc.topologyInitialized()) {
                    return desc.topologySnapshot();
                }
                long wait = 0L;
                if (timeout != 0L && (wait = timeout - (U.currentTimeMillis() - startTime)) <= 0L) {
                    return desc == null ? null : desc.topologySnapshot();
                }
                try {
                    this.servicesTopsUpdateMux.wait(wait);
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedCheckedException(e);
                }
            }
        }
    }

    public Collection<ServiceDescriptor> serviceDescriptors() {
        return new ArrayList<ServiceDescriptor>(this.registeredServices.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T> T service(String name) {
        ServiceContextImpl ctx;
        Service srvc;
        Collection<ServiceContextImpl> ctxs;
        block11: {
            T t2;
            block10: {
                if (!this.enterBusy()) {
                    return null;
                }
                this.ctx.security().authorize(name, SecurityPermission.SERVICE_INVOKE);
                ctxs = this.serviceContexts(name);
                if (ctxs != null) break block10;
                T t3 = null;
                this.leaveBusy();
                return t3;
            }
            try {
                Collection<ServiceContextImpl> collection = ctxs;
                // MONITORENTER : collection
                if (!F.isEmpty(ctxs)) break block11;
                t2 = null;
                // MONITOREXIT : collection
                this.leaveBusy();
            }
            catch (Throwable throwable) {
                this.leaveBusy();
                throw throwable;
            }
            return t2;
        }
        Iterator<ServiceContextImpl> iterator = ctxs.iterator();
        do {
            if (iterator.hasNext()) continue;
            iterator = null;
            // MONITOREXIT : collection
            this.leaveBusy();
            return (T)iterator;
        } while ((srvc = (ctx = iterator.next()).service()) == null);
        Service service = srvc;
        // MONITOREXIT : collection
        this.leaveBusy();
        return (T)service;
    }

    /*
     * Exception decompiling
     */
    public ServiceContextImpl serviceContext(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Collection<ServiceContextImpl> serviceContexts(String name) {
        IgniteUuid srvcId = this.lookupDeployedServiceId(name);
        if (srvcId == null) {
            return null;
        }
        return (Collection)this.locServices.get(srvcId);
    }

    public <T> T serviceProxy(ClusterGroup prj, String name, Class<? super T> srvcCls, boolean sticky, @Nullable Supplier<Map<String, Object>> callAttrsProvider, long timeout, boolean keepBinary) throws IgniteException {
        this.ctx.security().authorize(name, SecurityPermission.SERVICE_INVOKE);
        return new GridServiceProxy<T>(prj, name, srvcCls, sticky, timeout, this.ctx, callAttrsProvider, keepBinary).proxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T> Collection<T> services(String name) {
        Object object;
        ArrayList<Service> res;
        if (!this.enterBusy()) {
            return null;
        }
        try {
            this.ctx.security().authorize(name, SecurityPermission.SERVICE_INVOKE);
            Collection<ServiceContextImpl> ctxs = this.serviceContexts(name);
            if (ctxs == null) {
                Collection<T> collection = null;
                this.leaveBusy();
                return collection;
            }
            Collection<ServiceContextImpl> collection = ctxs;
            // MONITORENTER : collection
            if (F.isEmpty(ctxs)) {
                Collection<T> collection2 = null;
                // MONITOREXIT : collection
                this.leaveBusy();
                return collection2;
            }
            res = new ArrayList<Service>(ctxs.size());
            object = ctxs.iterator();
        }
        catch (Throwable throwable) {
            this.leaveBusy();
            throw throwable;
        }
        while (true) {
            if (!object.hasNext()) {
                object = res;
                // MONITOREXIT : collection
                this.leaveBusy();
                return object;
            }
            ServiceContextImpl ctx = object.next();
            Service srvc = ctx.service();
            if (srvc == null) continue;
            res.add(srvc);
        }
    }

    Map<UUID, Integer> reassign(@NotNull IgniteUuid srvcId, @NotNull ServiceConfiguration cfg, @NotNull AffinityTopologyVersion topVer, @Nullable TreeMap<UUID, Integer> oldTop) throws IgniteCheckedException {
        TreeMap<UUID, Integer> cnts;
        block10: {
            Random rnd;
            int remainder;
            block12: {
                int maxPerNodeCnt;
                int totalCnt;
                block11: {
                    IgnitePredicate<ClusterNode> nodeFilter = cfg.getNodeFilter();
                    if (nodeFilter != null) {
                        this.ctx.resource().injectGeneric(nodeFilter);
                    }
                    totalCnt = cfg.getTotalCount();
                    maxPerNodeCnt = cfg.getMaxPerNodeCount();
                    String cacheName = cfg.getCacheName();
                    Object affKey = cfg.getAffinityKey();
                    cnts = new TreeMap<UUID, Integer>();
                    if (affKey == null || cacheName == null) break block11;
                    ClusterNode n = this.ctx.affinity().mapKeyToNode(cacheName, affKey, topVer);
                    if (n == null) break block10;
                    int cnt = maxPerNodeCnt == 0 ? (totalCnt == 0 ? 1 : totalCnt) : maxPerNodeCnt;
                    cnts.put(n.id(), cnt);
                    break block10;
                }
                Collection<ClusterNode> nodes = this.ctx.discovery().nodes(topVer);
                if (cfg.getNodeFilter() != null) {
                    ArrayList<ClusterNode> nodes0 = new ArrayList<ClusterNode>();
                    for (ClusterNode node : nodes) {
                        if (!cfg.getNodeFilter().apply(node)) continue;
                        nodes0.add(node);
                    }
                    nodes = nodes0;
                }
                if (nodes.isEmpty()) break block10;
                int size = nodes.size();
                int perNodeCnt = totalCnt != 0 ? totalCnt / size : maxPerNodeCnt;
                int n = remainder = totalCnt != 0 ? totalCnt % size : 0;
                if (perNodeCnt >= maxPerNodeCnt && maxPerNodeCnt != 0) {
                    perNodeCnt = maxPerNodeCnt;
                    remainder = 0;
                }
                for (ClusterNode n2 : nodes) {
                    cnts.put(n2.id(), perNodeCnt);
                }
                assert (perNodeCnt >= 0);
                assert (remainder >= 0);
                if (remainder <= 0) break block10;
                int cnt = perNodeCnt + 1;
                rnd = new Random(srvcId.localId());
                if (oldTop == null || oldTop.isEmpty()) break block12;
                TreeSet<UUID> used = new TreeSet<UUID>();
                for (Map.Entry<UUID, Integer> entry : oldTop.entrySet()) {
                    if (entry.getValue() != cnt) continue;
                    cnts.put(entry.getKey(), cnt);
                    used.add(entry.getKey());
                    if (--remainder != 0) continue;
                    break;
                }
                if (remainder <= 0) break block10;
                ArrayList entries = new ArrayList(cnts.entrySet());
                Collections.shuffle(entries, rnd);
                for (Map.Entry entry : entries) {
                    if (used.contains(entry.getKey()) || (Integer)entry.getValue() >= maxPerNodeCnt && maxPerNodeCnt != 0) continue;
                    entry.setValue((Integer)entry.getValue() + 1);
                    if (--remainder != 0) continue;
                    break block10;
                }
                break block10;
            }
            ArrayList entries = new ArrayList(cnts.entrySet());
            Collections.shuffle(entries, rnd);
            for (Map.Entry entry : entries) {
                entry.setValue((Integer)entry.getValue() + 1);
                if (--remainder != 0) continue;
                break;
            }
        }
        return cnts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redeploy(IgniteUuid srvcId, ServiceConfiguration cfg, Map<UUID, Integer> top) throws IgniteCheckedException {
        String name = cfg.getName();
        String cacheName = cfg.getCacheName();
        Object affKey = cfg.getAffinityKey();
        int assignCnt = top.getOrDefault(this.ctx.localNodeId(), 0);
        Collection ctxs = this.locServices.computeIfAbsent(srvcId, c -> new ArrayList());
        ArrayList<ServiceContextImpl> toInit = new ArrayList<ServiceContextImpl>();
        Collection collection = ctxs;
        synchronized (collection) {
            if (ctxs.size() > assignCnt) {
                int cancelCnt = ctxs.size() - assignCnt;
                this.cancel(ctxs, cancelCnt);
            } else if (ctxs.size() < assignCnt) {
                int createCnt = assignCnt - ctxs.size();
                for (int i = 0; i < createCnt; ++i) {
                    ServiceContextImpl srvcCtx = new ServiceContextImpl(name, UUID.randomUUID(), cacheName, affKey, Executors.newSingleThreadExecutor(this.threadFactory), cfg.isStatisticsEnabled());
                    ctxs.add(srvcCtx);
                    toInit.add(srvcCtx);
                }
            }
        }
        ReadOnlyMetricRegistry invocationMetrics = null;
        for (final ServiceContextImpl srvcCtx : toInit) {
            Service srvc;
            try {
                srvc = this.copyAndInject(cfg, srvcCtx);
                srvc.init(srvcCtx);
                srvcCtx.service(srvc);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to initialize service (service will not be deployed): " + name, e);
                Collection collection2 = ctxs;
                synchronized (collection2) {
                    ctxs.removeAll(toInit);
                }
                throw new IgniteCheckedException("Error occured during service initialization: [locId=" + this.ctx.localNodeId() + ", name=" + name + ']', e);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting service instance [name=" + srvcCtx.name() + ", execId=" + srvcCtx.executionId() + ']');
            }
            if (cfg.isStatisticsEnabled()) {
                if (invocationMetrics == null) {
                    invocationMetrics = this.createServiceMetrics(srvcCtx, cfg);
                }
                srvcCtx.metrics(invocationMetrics);
            }
            final ExecutorService exe = srvcCtx.executor();
            exe.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        srvc.execute(srvcCtx);
                    }
                    catch (InterruptedException | IgniteInterruptedCheckedException ignore) {
                        if (IgniteServiceProcessor.this.log.isDebugEnabled()) {
                            IgniteServiceProcessor.this.log.debug("Service thread was interrupted [name=" + srvcCtx.name() + ", execId=" + srvcCtx.executionId() + ']');
                        }
                    }
                    catch (IgniteException e) {
                        if (e.hasCause(InterruptedException.class) || e.hasCause(IgniteInterruptedCheckedException.class)) {
                            if (IgniteServiceProcessor.this.log.isDebugEnabled()) {
                                IgniteServiceProcessor.this.log.debug("Service thread was interrupted [name=" + srvcCtx.name() + ", execId=" + srvcCtx.executionId() + ']');
                            }
                        } else {
                            U.error(IgniteServiceProcessor.this.log, "Service execution stopped with error [name=" + srvcCtx.name() + ", execId=" + srvcCtx.executionId() + ']', e);
                        }
                    }
                    catch (Throwable e) {
                        U.error(IgniteServiceProcessor.this.log, "Service execution stopped with error [name=" + srvcCtx.name() + ", execId=" + srvcCtx.executionId() + ']', e);
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                    }
                    finally {
                        exe.shutdownNow();
                    }
                }
            });
        }
    }

    private Service copyAndInject(ServiceConfiguration cfg, ServiceContextImpl svcCtx) throws IgniteCheckedException {
        if (cfg instanceof LazyServiceConfiguration) {
            LazyServiceConfiguration srvcCfg = (LazyServiceConfiguration)cfg;
            GridDeployment srvcDep = this.ctx.deploy().getDeployment(srvcCfg.serviceClassName());
            ClassLoader clsLdr = U.resolveClassLoader(srvcDep != null ? srvcDep.classLoader() : null, this.ctx.config());
            byte[] bytes = srvcCfg.serviceBytes();
            Service srvc = (Service)U.unmarshal(this.marsh, bytes, clsLdr);
            this.ctx.resource().inject(srvc, svcCtx);
            ServiceCallInterceptor[] interceptors = (ServiceCallInterceptor[])U.unmarshal(this.marsh, srvcCfg.interceptorBytes(), clsLdr);
            if (F.isEmpty(interceptors)) {
                return srvc;
            }
            for (int i = 0; i < interceptors.length; ++i) {
                this.ctx.resource().injectGeneric(interceptors[i]);
            }
            svcCtx.interceptor(interceptors.length == 1 ? interceptors[0] : new CompositeServiceCallInterceptor(interceptors));
            return srvc;
        }
        Service srvc = cfg.getService();
        try {
            byte[] bytes = U.marshal(this.marsh, (Object)srvc);
            Service cp = (Service)U.unmarshal(this.marsh, bytes, U.resolveClassLoader(srvc.getClass().getClassLoader(), this.ctx.config()));
            this.ctx.resource().inject(cp, svcCtx);
            return cp;
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to copy service (will reuse same instance): " + srvc.getClass(), e);
            return srvc;
        }
    }

    private void cancel(Collection<ServiceContextImpl> ctxs, int cancelCnt) {
        Iterator<ServiceContextImpl> it = ctxs.iterator();
        while (it.hasNext()) {
            ServiceContextImpl svcCtx = it.next();
            this.cancel(svcCtx);
            it.remove();
            if (--cancelCnt != 0) continue;
            if (!ctxs.isEmpty()) break;
            this.ctx.metric().remove(IgniteServiceProcessor.serviceMetricRegistryName(svcCtx.name()));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(ServiceContextImpl ctx) {
        ctx.setCancelled(true);
        Service srvc = ctx.service();
        if (srvc != null) {
            try {
                srvc.cancel(ctx);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to cancel service (ignoring) [name=" + ctx.name() + ", execId=" + ctx.executionId() + ']', e);
                if (e instanceof Error) {
                    throw e;
                }
            }
            finally {
                try {
                    this.ctx.resource().cleanup(srvc);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to clean up service (will ignore): " + ctx.name(), e);
                }
            }
        }
        ctx.executor().shutdownNow();
        if (this.log.isInfoEnabled()) {
            this.log.info("Cancelled service instance [name=" + ctx.name() + ", execId=" + ctx.executionId() + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undeploy(@NotNull IgniteUuid srvcId) {
        Collection ctxs = (Collection)this.locServices.remove(srvcId);
        if (ctxs != null) {
            Collection collection = ctxs;
            synchronized (collection) {
                this.cancel(ctxs, ctxs.size());
            }
        }
    }

    void completeInitiatingFuture(boolean deploy, IgniteUuid reqSrvcId, Throwable err) {
        GridFutureAdapter fut;
        GridFutureAdapter gridFutureAdapter = fut = deploy ? (GridFutureAdapter)this.depFuts.remove(reqSrvcId) : (GridFutureAdapter)this.undepFuts.remove(reqSrvcId);
        if (fut == null) {
            return;
        }
        if (err != null) {
            fut.onDone(err);
            if (deploy) {
                U.warn(this.log, "Failed to deploy service, cfg=" + ((GridServiceDeploymentFuture)fut).configuration(), err);
            } else {
                U.warn(this.log, "Failed to undeploy service, srvcId=" + reqSrvcId, err);
            }
        } else {
            fut.onDone();
        }
    }

    void updateServicesTopologies(@NotNull Map<IgniteUuid, Map<UUID, Integer>> fullTops) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            this.updateServicesMap(this.deployedServices, fullTops);
        }
        finally {
            this.leaveBusy();
        }
    }

    @Nullable
    private IgniteUuid lookupDeployedServiceId(String name) {
        ServiceInfo serviceInfo = (ServiceInfo)this.deployedServicesByName.get(name);
        if (serviceInfo != null) {
            return serviceInfo.serviceId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int localInstancesCount(IgniteUuid srvcId) {
        Collection ctxs = (Collection)this.locServices.get(srvcId);
        if (ctxs == null) {
            return 0;
        }
        Collection collection = ctxs;
        synchronized (collection) {
            return ctxs.size();
        }
    }

    void updateDeployedServices(ServiceDeploymentActions depActions) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            depActions.servicesToDeploy().forEach((uuid, serviceInfo) -> {
                if (this.deployedServices.putIfAbsent((IgniteUuid)uuid, (ServiceInfo)serviceInfo) == null) {
                    this.deployedServicesByName.put(serviceInfo.name(), (ServiceInfo)serviceInfo);
                }
            });
            depActions.servicesToUndeploy().forEach((srvcId, desc) -> {
                ServiceInfo rmv = (ServiceInfo)this.deployedServices.remove(srvcId);
                assert (rmv != null && rmv == desc) : "Concurrent map modification.";
                this.deployedServicesByName.remove(rmv.name());
            });
        }
        finally {
            this.leaveBusy();
        }
    }

    Map<IgniteUuid, ServiceInfo> deployedServices() {
        return new HashMap<IgniteUuid, ServiceInfo>(this.deployedServices);
    }

    @NotNull
    Map<IgniteUuid, ServiceInfo> servicesReceivedFromJoin(UUID nodeId) {
        HashMap<IgniteUuid, ServiceInfo> descs = new HashMap<IgniteUuid, ServiceInfo>();
        this.registeredServices.forEach((srvcId, desc) -> {
            if (desc.staticallyConfigured() && desc.originNodeId().equals(nodeId)) {
                descs.put((IgniteUuid)srvcId, (ServiceInfo)desc);
            }
        });
        return descs;
    }

    @Nullable
    ClusterNode coordinator() {
        return U.oldest(this.ctx.discovery().aliveServerNodes(), null);
    }

    private boolean isLocalNodeCoordinator() {
        DiscoverySpi spi = this.ctx.discovery().getInjectedDiscoverySpi();
        return spi instanceof TcpDiscoverySpi ? ((TcpDiscoverySpi)spi).isLocalNodeCoordinator() : F.eq(this.ctx.discovery().localNode(), this.coordinator());
    }

    public void onLocalJoin(DiscoveryEvent evt, DiscoCache discoCache) {
        assert (this.ctx.localNodeId().equals(evt.eventNode().id()));
        assert (evt.type() == 10);
        if (this.isLocalNodeCoordinator()) {
            SecurityException err;
            ArrayList<ServiceInfo> staticServicesInfo = this.staticallyConfiguredServices(false);
            if (this.ctx.security().enabled() && (err = this.checkDeployPermissionDuringJoin(evt.node(), staticServicesInfo)) != null) {
                throw err;
            }
            staticServicesInfo.forEach(this::registerService);
        }
        ServiceDeploymentActions depActions = null;
        if (!this.registeredServices.isEmpty()) {
            depActions = new ServiceDeploymentActions(this.ctx);
            depActions.servicesToDeploy(this.registeredServices);
        }
        this.depMgr.onLocalJoin(evt, discoCache, depActions);
    }

    public ServiceDeploymentManager deployment() {
        return this.depMgr;
    }

    @NotNull
    private ArrayList<ServiceInfo> staticallyConfiguredServices(boolean logErrors) {
        ServiceConfiguration[] cfgs = this.ctx.config().getServiceConfiguration();
        ArrayList<ServiceInfo> staticServicesInfo = new ArrayList<ServiceInfo>();
        if (cfgs != null) {
            PreparedConfigurations<IgniteUuid> prepCfgs = this.prepareServiceConfigurations(Arrays.asList(cfgs), node -> !node.isClient());
            if (logErrors && prepCfgs.failedFuts != null) {
                for (GridServiceDeploymentFuture gridServiceDeploymentFuture : prepCfgs.failedFuts) {
                    U.warn(this.log, "Failed to validate static service configuration (won't be deployed), cfg=" + gridServiceDeploymentFuture.configuration() + ", err=" + gridServiceDeploymentFuture.result());
                }
            }
            for (ServiceConfiguration serviceConfiguration : prepCfgs.cfgs) {
                ServiceInfo serviceInfo = new ServiceInfo(this.ctx.localNodeId(), IgniteUuid.randomUuid(), serviceConfiguration, true);
                serviceInfo.context(this.ctx);
                staticServicesInfo.add(serviceInfo);
            }
        }
        return staticServicesInfo;
    }

    private void processServicesChangeRequest(ClusterNode snd, ServiceChangeBatchRequest msg) {
        DiscoveryDataClusterState state = this.ctx.state().clusterState();
        if (!state.active() || state.transition()) {
            for (ServiceChangeAbstractRequest req : msg.requests()) {
                GridFutureAdapter fut = null;
                if (req instanceof ServiceDeploymentRequest) {
                    fut = (GridFutureAdapter)this.depFuts.remove(req.serviceId());
                } else if (req instanceof ServiceUndeploymentRequest) {
                    fut = (GridFutureAdapter)this.undepFuts.remove(req.serviceId());
                }
                if (fut == null) continue;
                fut.onDone(new IgniteCheckedException("Operation has been canceled, cluster state change is in progress."));
            }
            return;
        }
        HashMap<IgniteUuid, ServiceInfo> toDeploy = new HashMap<IgniteUuid, ServiceInfo>();
        HashMap<IgniteUuid, ServiceInfo> toUndeploy = new HashMap<IgniteUuid, ServiceInfo>();
        for (ServiceChangeAbstractRequest req : msg.requests()) {
            IgniteUuid reqSrvcId = req.serviceId();
            ServiceInfo oldDesc = (ServiceInfo)this.registeredServices.get(reqSrvcId);
            if (req instanceof ServiceDeploymentRequest) {
                Exception err = null;
                if (oldDesc != null) {
                    err = new IgniteCheckedException("Failed to deploy service. Service with generated id alreadyexists : [srvcId" + reqSrvcId + ", srvcTop=" + oldDesc.topologySnapshot() + ']');
                } else {
                    ServiceConfiguration cfg = ((ServiceDeploymentRequest)req).configuration();
                    if (this.ctx.security().enabled()) {
                        err = this.checkPermissions(((ServiceDeploymentRequest)req).configuration().getName(), SecurityPermission.SERVICE_DEPLOY);
                    }
                    if (err == null) {
                        oldDesc = this.lookupInRegisteredServices(cfg.getName());
                        if (oldDesc == null) {
                            if (cfg.getCacheName() != null && this.ctx.cache().cacheDescriptor(cfg.getCacheName()) == null) {
                                err = new IgniteCheckedException("Failed to deploy service, affinity cache is not found, cfg=" + cfg);
                            } else {
                                ServiceInfo desc = new ServiceInfo(snd.id(), reqSrvcId, cfg);
                                this.registerService(desc);
                                toDeploy.put(reqSrvcId, desc);
                            }
                        } else if (!oldDesc.configuration().equalsIgnoreNodeFilter(cfg)) {
                            err = new IgniteCheckedException("Failed to deploy service (service already exists with different configuration) : [deployed=" + oldDesc.configuration() + ", new=" + cfg + ']');
                        } else {
                            GridServiceDeploymentFuture fut = (GridServiceDeploymentFuture)this.depFuts.remove(reqSrvcId);
                            if (fut != null) {
                                fut.onDone();
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Service sent to deploy is already deployed : [srvcId=" + oldDesc.serviceId() + ", cfg=" + oldDesc.configuration());
                                }
                            }
                        }
                    }
                }
                if (err == null) continue;
                this.completeInitiatingFuture(true, reqSrvcId, err);
                U.warn(this.log, err.getMessage(), err);
                continue;
            }
            if (!(req instanceof ServiceUndeploymentRequest)) continue;
            ServiceInfo rmv = (ServiceInfo)this.registeredServices.remove(reqSrvcId);
            this.registeredServicesByName.remove(oldDesc.name());
            assert (oldDesc == rmv) : "Concurrent map modification.";
            toUndeploy.put(reqSrvcId, rmv);
        }
        if (!toDeploy.isEmpty() || !toUndeploy.isEmpty()) {
            ServiceDeploymentActions depActions = new ServiceDeploymentActions(this.ctx);
            if (!toDeploy.isEmpty()) {
                depActions.servicesToDeploy(toDeploy);
            }
            if (!toUndeploy.isEmpty()) {
                depActions.servicesToUndeploy(toUndeploy);
            }
            msg.servicesDeploymentActions(depActions);
        }
    }

    private void registerService(ServiceInfo desc) {
        desc.context(this.ctx);
        this.registeredServices.put(desc.serviceId(), desc);
        this.registeredServicesByName.put(desc.name(), desc);
    }

    private void processChangeGlobalStateRequest(ChangeGlobalStateMessage msg) {
        if (msg.activate() && this.registeredServices.isEmpty()) {
            return;
        }
        ServiceDeploymentActions depActions = new ServiceDeploymentActions(this.ctx);
        if (msg.activate()) {
            depActions.servicesToDeploy(this.registeredServices);
        } else {
            depActions.deactivate(true);
        }
        msg.servicesDeploymentActions(depActions);
    }

    private void processDynamicCacheChangeRequest(DynamicCacheChangeBatch msg) {
        HashMap<IgniteUuid, ServiceInfo> toUndeploy = new HashMap<IgniteUuid, ServiceInfo>();
        for (DynamicCacheChangeRequest chReq : msg.requests()) {
            if (!chReq.stop()) continue;
            this.registeredServices.entrySet().removeIf(e -> {
                ServiceInfo desc = (ServiceInfo)e.getValue();
                if (Objects.equals(desc.cacheName(), chReq.cacheName())) {
                    toUndeploy.put(desc.serviceId(), desc);
                    return true;
                }
                return false;
            });
        }
        if (!toUndeploy.isEmpty()) {
            ServiceDeploymentActions depActions = new ServiceDeploymentActions(this.ctx);
            depActions.servicesToUndeploy(toUndeploy);
            msg.servicesDeploymentActions(depActions);
            toUndeploy.values().forEach(desc -> {
                ServiceInfo cfr_ignored_0 = (ServiceInfo)this.registeredServicesByName.remove(desc.name());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processServicesFullDeployments(ServiceClusterDeploymentResultBatch msg) {
        HashMap<IgniteUuid, Map<UUID, Integer>> fullTops = new HashMap<IgniteUuid, Map<UUID, Integer>>();
        HashMap<IgniteUuid, Collection<byte[]>> fullErrors = new HashMap<IgniteUuid, Collection<byte[]>>();
        for (ServiceClusterDeploymentResult depRes : msg.results()) {
            IgniteUuid srvcId = depRes.serviceId();
            Map<UUID, ServiceSingleNodeDeploymentResult> deps = depRes.results();
            HashMap top = new HashMap();
            ArrayList errors = new ArrayList();
            deps.forEach((nodeId, res) -> {
                int cnt = res.count();
                if (cnt > 0) {
                    top.put(nodeId, cnt);
                }
                if (!res.errors().isEmpty()) {
                    errors.addAll(res.errors());
                }
            });
            if (!errors.isEmpty()) {
                fullErrors.computeIfAbsent(srvcId, e -> new ArrayList()).addAll(errors);
            }
            fullTops.put(srvcId, top);
        }
        Object object = this.servicesTopsUpdateMux;
        synchronized (object) {
            this.updateServicesMap(this.registeredServices, fullTops);
            this.servicesTopsUpdateMux.notifyAll();
        }
        ServiceDeploymentActions depActions = new ServiceDeploymentActions(this.ctx);
        depActions.deploymentTopologies(fullTops);
        depActions.deploymentErrors(fullErrors);
        msg.servicesDeploymentActions(depActions);
    }

    @Nullable
    private ServiceInfo lookupInRegisteredServices(String name) {
        return (ServiceInfo)this.registeredServicesByName.get(name);
    }

    private void updateServicesMap(Map<IgniteUuid, ServiceInfo> services, Map<IgniteUuid, Map<UUID, Integer>> tops) {
        tops.forEach((srvcId, top) -> {
            ServiceInfo desc = (ServiceInfo)services.get(srvcId);
            if (desc != null) {
                desc.topologySnapshot((Map<UUID, Integer>)top);
            }
        });
    }

    private boolean enterBusy() {
        return this.opsLock.readLock().tryLock();
    }

    private void leaveBusy() {
        this.opsLock.readLock().unlock();
    }

    private SecurityException checkDeployPermissionDuringJoin(ClusterNode node, List<ServiceInfo> svcs) {
        SecurityContext secCtx;
        try {
            secCtx = SecurityUtils.nodeSecurityContext(this.marsh, U.resolveClassLoader(this.ctx.config()), node);
            assert (secCtx != null);
        }
        catch (SecurityException err) {
            return err;
        }
        try (OperationSecurityContext ignored = this.ctx.security().withContext(secCtx);){
            for (ServiceInfo desc : svcs) {
                SecurityException err = this.checkPermissions(desc.name(), SecurityPermission.SERVICE_DEPLOY);
                if (err == null) continue;
                SecurityException securityException = err;
                return securityException;
            }
        }
        return null;
    }

    private ReadOnlyMetricRegistry createServiceMetrics(ServiceContextImpl srvcCtx, ServiceConfiguration cfg) {
        MetricRegistry metricRegistry = this.ctx.metric().registry(IgniteServiceProcessor.serviceMetricRegistryName(srvcCtx.name()));
        if (cfg instanceof LazyServiceConfiguration && ((LazyServiceConfiguration)cfg).platformMtdNames() != null) {
            for (String definedMtdName : ((LazyServiceConfiguration)cfg).platformMtdNames()) {
                metricRegistry.histogram(definedMtdName, DEFAULT_INVOCATION_BOUNDS, "Duration in milliseconds of '" + definedMtdName + "()'");
            }
        } else {
            for (Class<?> itf : IgniteUtils.allInterfaces(srvcCtx.service().getClass())) {
                for (Method mtd : itf.getMethods()) {
                    if (IgniteServiceProcessor.metricIgnored(mtd.getDeclaringClass())) continue;
                    metricRegistry.histogram(mtd.getName(), DEFAULT_INVOCATION_BOUNDS, "Duration in milliseconds of '" + mtd.getName() + "()'");
                }
            }
        }
        return metricRegistry;
    }

    private static boolean metricIgnored(Class<?> cls) {
        return Service.class.equals(cls) || Externalizable.class.equals(cls) || PlatformService.class.equals(cls);
    }

    public static String serviceMetricRegistryName(String srvcName) {
        return MetricUtils.metricName("Services", srvcName);
    }
}

