/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsObsolescence;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.StatisticsUtils;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsObjectData;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;

public class IgniteStatisticsPersistenceStoreImpl
implements IgniteStatisticsStore,
MetastorageLifecycleListener {
    private static final String META_SEPARATOR = ".";
    private static final String META_STAT_PREFIX = "stats";
    private static final String STAT_OBS_PREFIX = "stats.obs";
    private static final String STAT_DATA_PREFIX = "stats.data";
    private static final String META_VERSION_KEY = "stats.version";
    public static final Integer VERSION = 3;
    private final IgniteLogger log;
    private final IgniteCacheDatabaseSharedManager db;
    private volatile ReadWriteMetastorage metastore;

    public IgniteStatisticsPersistenceStoreImpl(GridInternalSubscriptionProcessor subscriptionProcessor, IgniteCacheDatabaseSharedManager db, Function<Class<?>, IgniteLogger> logSupplier) {
        this.db = db;
        subscriptionProcessor.registerMetastorageListener(this);
        this.log = logSupplier.apply(IgniteStatisticsPersistenceStoreImpl.class);
    }

    private int getPartitionId(String metaKey) {
        int partIdx = metaKey.lastIndexOf(META_SEPARATOR);
        String partIdStr = metaKey.substring(partIdx + 1);
        return Integer.parseInt(partIdStr);
    }

    private StatisticsKey getStatsKey(String metaKey) {
        int objIdx = metaKey.indexOf(META_SEPARATOR, STAT_DATA_PREFIX.length() + 1);
        int partIdx = metaKey.indexOf(META_SEPARATOR, objIdx + 1);
        return new StatisticsKey(metaKey.substring(STAT_DATA_PREFIX.length() + 1, objIdx), metaKey.substring(objIdx + 1, partIdx));
    }

    private String getPartKeyPrefix(StatisticsKey key) {
        return "stats.data." + key.schema() + META_SEPARATOR + key.obj() + META_SEPARATOR;
    }

    private static StatisticsKey getObsolescenceStatsKey(String metaKey) {
        int objIdx = metaKey.indexOf(META_SEPARATOR, STAT_OBS_PREFIX.length() + 1);
        int partIdx = metaKey.indexOf(META_SEPARATOR, objIdx + 1);
        return new StatisticsKey(metaKey.substring(STAT_DATA_PREFIX.length(), objIdx), metaKey.substring(objIdx + 1, partIdx));
    }

    private static Integer getObsolescenceStatsPartId(String metaKey) {
        int sepId = metaKey.lastIndexOf(META_SEPARATOR);
        return Integer.valueOf(metaKey.substring(sepId + 1));
    }

    private String getObsolescencePartKeyPrefix(StatisticsKey key) {
        return "stats.obs." + key.schema() + META_SEPARATOR + key.obj() + META_SEPARATOR;
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) {
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
        Integer storeVer;
        this.metastore = metastorage;
        try {
            storeVer = (Integer)this.readMeta(META_VERSION_KEY);
        }
        catch (Exception e) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Unable to read statistics version due to " + e.getMessage());
            }
            storeVer = null;
        }
        if (!VERSION.equals(storeVer)) {
            if (storeVer == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No statistics version found.");
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info(String.format("Found inconsistent statistics version %d instead of %d. Collected local statistics will be cleaned.", storeVer, VERSION));
            }
            this.clearAllStatistics();
            this.writeMeta(META_VERSION_KEY, VERSION);
        } else {
            try {
                this.checkLocalStatistics();
            }
            catch (IgniteCheckedException e) {
                this.log.warning(String.format("Unable to read statistics due to %s, clearing local statistics store.", e.getMessage()));
                this.clearAllStatistics();
                this.writeMeta(META_VERSION_KEY, VERSION);
            }
        }
    }

    private void checkLocalStatistics() throws IgniteCheckedException {
        HashSet brokenObjects = new HashSet();
        this.iterateMeta(STAT_DATA_PREFIX, (keyStr, statMsg) -> {
            StatisticsKey key = this.getStatsKey((String)keyStr);
            if (!brokenObjects.contains(key)) {
                try {
                    ObjectPartitionStatisticsImpl objectPartitionStatisticsImpl = StatisticsUtils.toObjectPartitionStatistics(null, (StatisticsObjectData)statMsg);
                }
                catch (Exception e) {
                    if (!brokenObjects.contains(key)) {
                        this.log.warning("Unable to read statistics by key " + key + ". Statistics for this object will be removed.", e);
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Unable to read statistics by key " + key);
                    }
                    brokenObjects.add(key);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Local statistics for object " + key + " loaded");
            }
        }, true);
        if (!brokenObjects.isEmpty()) {
            this.log.warning(String.format("Removing statistics by %d objects.", brokenObjects.size()));
        }
        for (StatisticsKey key : brokenObjects) {
            this.clearLocalPartitionsStatistics(key);
        }
    }

    @Override
    public void clearAllStatistics() {
        if (!this.checkMetastore("Unable to clear all statistics.", new Object[0])) {
            return;
        }
        try {
            this.iterateMeta(META_STAT_PREFIX, (k, v) -> {
                try {
                    this.metastore.remove((String)k);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Statistics by key " + k + " removed.");
                    }
                }
                catch (IgniteCheckedException e) {
                    this.log.warning("Error during clearing statistics by key " + k, e);
                }
            }, false);
            this.iterateMeta(STAT_OBS_PREFIX, (k, v) -> {
                try {
                    this.metastore.remove((String)k);
                }
                catch (IgniteCheckedException e) {
                    this.log.warning("Error during clearing statistics obsolescence info by key " + k, e);
                }
            }, false);
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Error during clearing statistics", e);
        }
    }

    @Override
    public Map<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>> getAllLocalPartitionsStatistics(String schema) {
        String prefix = schema == null ? STAT_DATA_PREFIX : "stats.data." + schema;
        HashMap<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>> res = new HashMap<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>>();
        try {
            this.iterateMeta(prefix, (k, v) -> {
                StatisticsKey key = this.getStatsKey((String)k);
                StatisticsObjectData statData = (StatisticsObjectData)v;
                try {
                    ObjectPartitionStatisticsImpl stat = StatisticsUtils.toObjectPartitionStatistics(null, statData);
                    res.computeIfAbsent(key, k1 -> new ArrayList()).add(stat);
                }
                catch (IgniteCheckedException e) {
                    this.log.warning(String.format("Error during reading statistics %s.%s by key %s", key.schema(), key.obj(), k));
                }
            }, true);
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Unable to read local partition statistcs", e);
        }
        return res;
    }

    @Override
    public void replaceLocalPartitionsStatistics(StatisticsKey key, Collection<ObjectPartitionStatisticsImpl> statistics) {
        if (!this.checkMetastore("Unable to save local partitions statistics: %s.%s for %d partitions", key.schema(), key.obj(), statistics.size())) {
            return;
        }
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(key.schema(), key.obj(), null);
        Map<Integer, ObjectPartitionStatisticsImpl> partStatistics = statistics.stream().collect(Collectors.toMap(ObjectPartitionStatisticsImpl::partId, s2 -> s2));
        String objPrefix = this.getPartKeyPrefix(key);
        try {
            this.iterateMeta(objPrefix, (k, v) -> {
                ObjectPartitionStatisticsImpl newStats = (ObjectPartitionStatisticsImpl)partStatistics.remove(this.getPartitionId((String)k));
                try {
                    if (newStats == null) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Removing statistics by key" + k);
                        }
                        this.metastore.remove((String)k);
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Rewriting statistics by key " + k);
                        }
                        this.metastore.write((String)k, StatisticsUtils.toObjectData(keyMsg, StatisticsType.PARTITION, newStats));
                    }
                }
                catch (IgniteCheckedException e) {
                    this.log.warning(String.format("Error during saving statistics %s.%s to %s", key.schema(), key.obj(), k), e);
                }
            }, false);
            if (!partStatistics.isEmpty()) {
                for (Map.Entry<Integer, ObjectPartitionStatisticsImpl> entry : partStatistics.entrySet()) {
                    this.writeMeta(objPrefix + entry.getKey(), StatisticsUtils.toObjectData(keyMsg, StatisticsType.PARTITION, entry.getValue()));
                }
            }
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error during saving statistics %s.%s", key.schema(), key.obj()), e);
        }
    }

    @Override
    public Collection<ObjectPartitionStatisticsImpl> getLocalPartitionsStatistics(StatisticsKey key) {
        if (!this.checkMetastore("Unable to get local partitions statistics %s.%s", key.schema(), key.obj())) {
            return Collections.emptyList();
        }
        ArrayList<ObjectPartitionStatisticsImpl> res = new ArrayList<ObjectPartitionStatisticsImpl>();
        try {
            this.iterateMeta(this.getPartKeyPrefix(key), (k, v) -> {
                try {
                    ObjectPartitionStatisticsImpl partStats = StatisticsUtils.toObjectPartitionStatistics(null, (StatisticsObjectData)v);
                    res.add(partStats);
                }
                catch (IgniteCheckedException e) {
                    this.log.warning(String.format("Error during reading statistics %s.%s by key %s", key.schema(), key.obj(), k));
                }
            }, true);
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error during reading statistics %s.%s", key.schema(), key.obj()), e);
        }
        return res;
    }

    @Override
    public void clearLocalPartitionsStatistics(StatisticsKey key) {
        if (!this.checkMetastore("Unable to clear local partitions statistics %s.%s", key.schema(), key.obj())) {
            return;
        }
        try {
            this.iterateMeta(this.getPartKeyPrefix(key), (k, v) -> {
                try {
                    this.metastore.remove((String)k);
                }
                catch (IgniteCheckedException e) {
                    this.log.warning(String.format("Error during clearing statistics %s.%s", key.schema(), key.obj()), e);
                }
            }, false);
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error during clearing statistics %s.%s", key.schema(), key.obj()), e);
        }
    }

    @Override
    public void saveLocalPartitionStatistics(StatisticsKey key, ObjectPartitionStatisticsImpl stat) {
        if (!this.checkMetastore("Unable to store local partition statistics %s.%s:%d", key.schema(), key.obj(), stat.partId())) {
            return;
        }
        String partKey = this.getPartKeyPrefix(key) + stat.partId();
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(key.schema(), key.obj(), null);
        try {
            StatisticsObjectData statsMsg = StatisticsUtils.toObjectData(keyMsg, StatisticsType.PARTITION, stat);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Writing statistics by key " + partKey);
            }
            this.writeMeta(partKey, statsMsg);
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error while storing local partition statistics %s.%s:%d", key.schema(), key.obj(), stat.partId()), e);
        }
    }

    @Override
    public ObjectPartitionStatisticsImpl getLocalPartitionStatistics(StatisticsKey key, int partId) {
        if (!this.checkMetastore("Unable to get local partition statistics: %s.%s:%d", key.schema(), key.obj(), partId)) {
            return null;
        }
        String metaKey = this.getPartKeyPrefix(key) + partId;
        try {
            return StatisticsUtils.toObjectPartitionStatistics(null, (StatisticsObjectData)this.readMeta(metaKey));
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error while reading local partition statistics %s.%s:%d", key.schema(), key.obj(), partId), e);
            return null;
        }
    }

    @Override
    public void clearLocalPartitionStatistics(StatisticsKey key, int partId) {
        if (!this.checkMetastore("Unable to clean local partition statistics: %s.%s:%d", key.schema(), key.obj(), partId)) {
            return;
        }
        String metaKey = this.getPartKeyPrefix(key) + partId;
        try {
            this.removeMeta(metaKey);
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error while clearing local partition statistics %s.%s:%d", key.schema(), key.obj(), partId), e);
        }
    }

    @Override
    public void clearLocalPartitionsStatistics(StatisticsKey key, Collection<Integer> partIds) {
        if (!this.checkMetastore("Unable to clean local partitions statistics: %s.%s:%s", key.schema(), key.obj(), partIds)) {
            return;
        }
        String metaKeyPrefix = this.getPartKeyPrefix(key);
        ArrayList<String> metaKeys = new ArrayList<String>(partIds.size());
        for (Integer partId : partIds) {
            metaKeys.add(metaKeyPrefix + partId);
        }
        try {
            this.removeMeta(metaKeys);
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error while clearing local partitions statistics %s.%s %s", key.schema(), key.obj(), partIds), e);
        }
    }

    @Override
    public void saveObsolescenceInfo(Map<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> obsolescence) {
        for (Map.Entry<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> objObs : obsolescence.entrySet()) {
            String keyPrefix = this.getObsolescencePartKeyPrefix(objObs.getKey());
            try {
                objObs.getValue().forEach((k, v) -> this.writeMeta(keyPrefix + k, (Serializable)v));
            }
            catch (IgniteCheckedException e) {
                this.log.warning(String.format("Error while saving statistics obs %s - %s", objObs.getKey(), e.getMessage()));
            }
        }
    }

    @Override
    public void saveObsolescenceInfo(StatisticsKey key, int partId, ObjectPartitionStatisticsObsolescence partObs) {
        String keyPrefix = this.getObsolescencePartKeyPrefix(key);
        try {
            this.writeMeta(keyPrefix + partId, partObs);
        }
        catch (IgniteCheckedException e) {
            this.log.warning(String.format("Error while saving statistics obs %s:%d - %s", key, partId, e.getMessage()));
        }
    }

    @Override
    public void clearObsolescenceInfo(StatisticsKey key, Collection<Integer> partIds) {
        block7: {
            String keyPrefix = this.getObsolescencePartKeyPrefix(key);
            ArrayList<String> keysToRmv = new ArrayList<String>();
            if (partIds == null) {
                try {
                    this.iterateMeta(keyPrefix, (k, v) -> keysToRmv.add((String)k), false);
                }
                catch (IgniteCheckedException e) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(String.format("Unable to clean statistics obsolescence keys in %s due to %s", key, e.getMessage()));
                    }
                }
            } else {
                partIds.forEach(partId -> keysToRmv.add(keyPrefix + partId));
            }
            try {
                this.removeMeta(keysToRmv);
            }
            catch (IgniteCheckedException e) {
                if (!this.log.isInfoEnabled()) break block7;
                this.log.info(String.format("Unable to clean statistics obsolescence keys in %s due to %s", key, e.getMessage()));
            }
        }
    }

    @Override
    public Map<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> loadAllObsolescence() {
        HashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> res;
        block2: {
            res = new HashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>>();
            try {
                this.iterateMeta(STAT_OBS_PREFIX, (k, v) -> {
                    StatisticsKey key = IgniteStatisticsPersistenceStoreImpl.getObsolescenceStatsKey(k);
                    Integer partId = IgniteStatisticsPersistenceStoreImpl.getObsolescenceStatsPartId(k);
                    res.computeIfAbsent(key, key1 -> new IntHashMap()).put(partId, (ObjectPartitionStatisticsObsolescence)v);
                }, true);
            }
            catch (IgniteCheckedException e) {
                if (!this.log.isInfoEnabled()) break block2;
                this.log.info(String.format("Unable to load statistics obsolescence keys due to %s", e.getMessage()));
            }
        }
        return res;
    }

    @Override
    public Collection<Integer> loadLocalPartitionMap(StatisticsKey key) {
        ArrayList<Integer> res;
        block2: {
            res = new ArrayList<Integer>();
            String prefix = this.getPartKeyPrefix(key);
            try {
                this.iterateMeta(prefix, (k, v) -> {
                    int partId = this.getPartitionId((String)k);
                    res.add(partId);
                }, false);
            }
            catch (IgniteCheckedException e) {
                if (!this.log.isInfoEnabled()) break block2;
                this.log.info(String.format("Error during reading statistics %s.%s due to %s", key.schema(), key.obj(), e.getMessage()));
            }
        }
        return res;
    }

    private boolean checkMetastore(String msg, Object ... args) {
        if (this.metastore == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Metastore doesn't available: " + String.format(msg, args));
            }
            return false;
        }
        return true;
    }

    private void writeMeta(String key, Serializable obj) throws IgniteCheckedException {
        assert (obj != null);
        if (!this.checkMetastore("Unable to save metadata to %s", key)) {
            return;
        }
        this.db.checkpointReadLock();
        try {
            this.metastore.write(key, obj);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    private Serializable readMeta(String key) throws IgniteCheckedException {
        assert (key != null);
        this.db.checkpointReadLock();
        try {
            Serializable serializable = this.metastore.read(key);
            return serializable;
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    private void removeMeta(String key) throws IgniteCheckedException {
        this.db.checkpointReadLock();
        try {
            this.metastore.remove(key);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMeta(Collection<String> keys) throws IgniteCheckedException {
        this.db.checkpointReadLock();
        try {
            for (String key : keys) {
                this.metastore.remove(key);
            }
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateMeta(String keyPrefix, BiConsumer<String, ? super Serializable> cb, boolean unmarshall) throws IgniteCheckedException {
        assert (this.metastore != null);
        this.db.checkpointReadLock();
        try {
            this.metastore.iterate(keyPrefix, cb, unmarshall);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }
}

