/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.SchemaManager;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ColumnStatisticsCollector;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAddressedRequest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class IgniteStatisticsHelper {
    private final IgniteLogger log;
    private final SchemaManager schemaMgr;

    public IgniteStatisticsHelper(UUID locNodeId, SchemaManager schemaMgr, Function<Class<?>, IgniteLogger> logSupplier) {
        this.schemaMgr = schemaMgr;
        this.log = logSupplier.apply(IgniteStatisticsHelper.class);
    }

    public CacheGroupContext groupContext(StatisticsKey key) throws IgniteCheckedException {
        TableDescriptor tbl = this.schemaMgr.table(key.schema(), key.obj());
        if (tbl == null) {
            throw new IgniteCheckedException(String.format("Can't find object %s.%s", key.schema(), key.obj()));
        }
        return tbl.cacheInfo().cacheContext().group();
    }

    public List<StatisticsAddressedRequest> generateGatheringRequests(StatisticsTarget target, StatisticsObjectConfiguration cfg) throws IgniteCheckedException {
        List<String> cols = target.columns() == null ? null : Arrays.asList(target.columns());
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(target.schema(), target.obj(), cols);
        Map<String, Long> versions = cfg.columns().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatisticsColumnConfiguration)e.getValue()).version()));
        CacheGroupContext grpCtx = this.groupContext(target.key());
        AffinityTopologyVersion topVer = grpCtx.affinity().lastVersion();
        StatisticsRequest req = new StatisticsRequest(UUID.randomUUID(), keyMsg, StatisticsType.LOCAL, topVer, versions);
        List<List<ClusterNode>> assignments = grpCtx.affinity().assignments(topVer);
        HashSet<UUID> nodes = new HashSet<UUID>();
        for (List<ClusterNode> partNodes : assignments) {
            if (F.isEmpty(partNodes)) continue;
            nodes.add(partNodes.get(0).id());
        }
        ArrayList<StatisticsAddressedRequest> res = new ArrayList<StatisticsAddressedRequest>(nodes.size());
        for (UUID nodeId : nodes) {
            res.add(new StatisticsAddressedRequest(req, nodeId));
        }
        return res;
    }

    public ObjectStatisticsImpl aggregateLocalStatistics(StatisticsObjectConfiguration cfg, Collection<? extends ObjectStatisticsImpl> stats) {
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(cfg.key().schema(), cfg.key().obj(), new ArrayList<String>(cfg.columns().keySet()));
        TableDescriptor tbl = this.schemaMgr.table(keyMsg.schema(), keyMsg.obj());
        if (tbl == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Removing statistics for object %s.%s cause table doesn't exists.", keyMsg.schema(), keyMsg.obj()));
            }
            return null;
        }
        return IgniteStatisticsHelper.aggregateLocalStatistics(tbl.type(), cfg, stats, this.log);
    }

    public static ObjectStatisticsImpl aggregateLocalStatistics(GridQueryTypeDescriptor tbl, StatisticsObjectConfiguration cfg, Collection<? extends ObjectStatisticsImpl> stats, IgniteLogger log) {
        assert (!stats.isEmpty());
        List selectedCols = IgniteStatisticsHelper.filterColumns(tbl, cfg.columns().keySet()).stream().map(IgniteBiTuple::getValue).collect(Collectors.toList());
        HashMap colPartStats = new HashMap(selectedCols.size());
        long rowCnt = 0L;
        for (String string : selectedCols) {
            colPartStats.put(string, new ArrayList());
        }
        for (ObjectStatisticsImpl objectStatisticsImpl : stats) {
            for (String col : selectedCols) {
                ColumnStatistics colPartStat = objectStatisticsImpl.columnStatistics(col);
                if (colPartStat == null) continue;
                ((List)colPartStats.get(col)).add(colPartStat);
            }
            rowCnt += objectStatisticsImpl.rowCount();
        }
        HashMap<String, ColumnStatistics> colStats = new HashMap<String, ColumnStatistics>(selectedCols.size());
        for (String col : selectedCols) {
            StatisticsColumnConfiguration colCfg = cfg.columns().get(col);
            ColumnStatistics stat = ColumnStatisticsCollector.aggregate((List)colPartStats.get(col), colCfg.overrides());
            if (log.isDebugEnabled()) {
                log.debug("Aggregate column statistic done [col=" + col + ", stat=" + stat + ']');
            }
            colStats.put(col, stat);
        }
        rowCnt = IgniteStatisticsHelper.calculateRowCount(cfg, rowCnt);
        return new ObjectStatisticsImpl(rowCnt, colStats);
    }

    public static long calculateRowCount(StatisticsObjectConfiguration cfg, long actualRowCount) {
        long overridedRowCnt = -1L;
        for (StatisticsColumnConfiguration ccfg : cfg.columns().values()) {
            if (ccfg.overrides() == null || ccfg.overrides().total() == null) continue;
            Long colRowCnt = ccfg.overrides().total();
            overridedRowCnt = Math.max(overridedRowCnt, colRowCnt);
        }
        return overridedRowCnt == -1L ? actualRowCount : overridedRowCnt;
    }

    public static StatisticsObjectConfiguration[] buildDefaultConfigurations(StatisticsTarget ... targets) {
        StatisticsObjectConfiguration[] res = (StatisticsObjectConfiguration[])Arrays.stream(targets).map(t2 -> {
            List<StatisticsColumnConfiguration> colCfgs = t2.columns() == null ? Collections.emptyList() : Arrays.stream(t2.columns()).map(name -> new StatisticsColumnConfiguration((String)name, null)).collect(Collectors.toList());
            return new StatisticsObjectConfiguration(t2.key(), colCfgs, 15);
        }).toArray(StatisticsObjectConfiguration[]::new);
        return res;
    }

    public static List<T2<Integer, String>> filterColumns(GridQueryTypeDescriptor typeDescriptor, @Nullable Collection<String> colNames) {
        Stream colStream = IgniteStatisticsHelper.enumerate(typeDescriptor.fields().keySet().stream(), 2);
        if (F.isEmpty(colNames)) {
            return colStream.filter(col -> !"_KEY".equals(col.getValue()) && !"_VAL".equals(col.getValue())).collect(Collectors.toList());
        }
        HashSet<String> colNamesSet = new HashSet<String>(colNames);
        return colStream.filter(col -> colNamesSet.contains(col.getValue())).collect(Collectors.toList());
    }

    private static <T> Stream<T2<Integer, T>> enumerate(final Stream<? extends T> stream, final int startIdx) {
        Iterator iter = new Iterator<T2<Integer, T>>(){
            private final Iterator<? extends T> streamIter;
            private int idx;
            {
                this.streamIter = stream.iterator();
                this.idx = startIdx;
            }

            @Override
            public boolean hasNext() {
                return this.streamIter.hasNext();
            }

            @Override
            public T2<Integer, T> next() {
                return new T2(this.idx++, this.streamIter.next());
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 1040), false);
    }
}

