/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.stat.CancellableTask;
import org.apache.ignite.internal.processors.query.stat.StatisticsProcessor;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public class BusyExecutor {
    private final IgniteLogger log;
    private final String name;
    private volatile boolean active;
    private volatile GridBusyLock busyLock = new GridBusyLock();
    private final IgniteThreadPoolExecutor pool;
    private final GridConcurrentHashSet<CancellableTask> cancellableTasks = new GridConcurrentHashSet();
    Supplier<Boolean> stopping;

    public BusyExecutor(String name, IgniteThreadPoolExecutor pool, Supplier<Boolean> stopping, Function<Class<?>, IgniteLogger> logSupplier) {
        this.name = name;
        this.pool = pool;
        this.stopping = stopping;
        this.log = logSupplier.apply(StatisticsProcessor.class);
        this.busyLock.block();
    }

    public synchronized void activate() {
        this.busyLock = new GridBusyLock();
        this.active = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Busy executor " + this.name + " activated.");
        }
    }

    public synchronized void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Busy executor " + this.name + " deactivating.");
        }
        this.cancellableTasks.forEach(CancellableTask::cancel);
        this.busyLock.block();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Busy executor " + this.name + " deactivated.");
        }
    }

    public boolean busyRun(Runnable r) {
        return this.busyRun(r, this.busyLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean busyRun(Runnable r, GridBusyLock taskLock) {
        if (!taskLock.enterBusy()) {
            return false;
        }
        try {
            if (!this.active) {
                boolean bl = false;
                return bl;
            }
            r.run();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t2) {
            if (this.stopping.get().booleanValue()) {
                this.log.debug("Unexpected exception on statistics processing: " + t2);
            } else {
                this.log.warning("Unexpected exception on statistics processing: " + t2.getMessage(), t2);
            }
        }
        finally {
            taskLock.leaveBusy();
        }
        return false;
    }

    public CompletableFuture<Boolean> submit(Runnable r) {
        GridBusyLock lock = this.busyLock;
        CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        if (r instanceof CancellableTask) {
            CancellableTask ct = (CancellableTask)r;
            res.thenApply(result -> {
                this.cancellableTasks.remove(ct);
                return result;
            });
            this.cancellableTasks.add(ct);
        }
        this.pool.execute(() -> res.complete(this.busyRun(r, lock)));
        return res;
    }

    public void execute(Runnable r) {
        this.submit(r);
    }

    public void execute(CancellableTask ct) {
        GridBusyLock lock = this.busyLock;
        this.cancellableTasks.add(ct);
        this.pool.execute(() -> {
            this.busyRun(ct, lock);
            this.cancellableTasks.remove(ct);
        });
    }
}

