/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cluster;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.MemoryMetrics;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.cluster.ClusterGroupEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.compute.PlatformCompute;
import org.apache.ignite.internal.processors.platform.events.PlatformEvents;
import org.apache.ignite.internal.processors.platform.messaging.PlatformMessaging;
import org.apache.ignite.internal.processors.platform.services.PlatformServices;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.jetbrains.annotations.Nullable;

public class PlatformClusterGroup
extends PlatformAbstractTarget {
    private static final int OP_FOR_ATTRIBUTE = 2;
    private static final int OP_FOR_CACHE = 3;
    private static final int OP_FOR_CLIENT = 4;
    private static final int OP_FOR_DATA = 5;
    private static final int OP_FOR_HOST = 6;
    private static final int OP_FOR_NODE_IDS = 7;
    private static final int OP_METRICS = 9;
    private static final int OP_METRICS_FILTERED = 10;
    private static final int OP_NODE_METRICS = 11;
    private static final int OP_NODES = 12;
    private static final int OP_PING_NODE = 13;
    private static final int OP_TOPOLOGY = 14;
    private static final int OP_FOR_OTHERS = 16;
    private static final int OP_FOR_REMOTES = 17;
    private static final int OP_FOR_RANDOM = 19;
    private static final int OP_FOR_OLDEST = 20;
    private static final int OP_FOR_YOUNGEST = 21;
    private static final int OP_RESET_METRICS = 22;
    private static final int OP_FOR_SERVERS = 23;
    private static final int OP_CACHE_METRICS = 24;
    private static final int OP_RESET_LOST_PARTITIONS = 25;
    private static final int OP_MEMORY_METRICS = 26;
    private static final int OP_MEMORY_METRICS_BY_NAME = 27;
    private static final int OP_SET_ACTIVE = 28;
    private static final int OP_IS_ACTIVE = 29;
    private static final int OP_GET_COMPUTE = 31;
    private static final int OP_GET_MESSAGING = 32;
    private static final int OP_GET_EVENTS = 33;
    private static final int OP_GET_SERVICES = 34;
    private static final int OP_DATA_REGION_METRICS = 35;
    private static final int OP_DATA_REGION_METRICS_BY_NAME = 36;
    private static final int OP_ENABLE_STATISTICS = 38;
    private static final int OP_CLEAR_STATISTICS = 39;
    private final ClusterGroupEx prj;

    public PlatformClusterGroup(PlatformContext platformCtx, ClusterGroupEx prj) {
        super(platformCtx);
        this.prj = prj;
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 9: {
                this.platformCtx.writeClusterMetrics(writer, this.prj.metrics());
                break;
            }
            case 26: {
                Collection<MemoryMetrics> metrics = this.prj.ignite().memoryMetrics();
                writer.writeInt(metrics.size());
                for (MemoryMetrics m4 : metrics) {
                    PlatformClusterGroup.writeMemoryMetrics(writer, m4);
                }
                break;
            }
            case 35: {
                Collection<DataRegionMetrics> metrics = this.prj.ignite().dataRegionMetrics();
                writer.writeInt(metrics.size());
                for (DataRegionMetrics m5 : metrics) {
                    PlatformClusterGroup.writeDataRegionMetrics(writer, m5);
                }
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 10: {
                List<UUID> ids = PlatformUtils.readCollection(reader);
                this.platformCtx.writeClusterMetrics(writer, this.prj.forNodeIds(ids).metrics());
                break;
            }
            case 12: {
                long oldTopVer = reader.readLong();
                long curTopVer = this.platformCtx.kernalContext().discovery().topologyVersion();
                if (curTopVer > oldTopVer) {
                    writer.writeBoolean(true);
                    writer.writeLong(curTopVer);
                    Collection<ClusterNode> nodes = this.prj.nodes();
                    this.platformCtx.writeNodes(writer, nodes);
                    break;
                }
                writer.writeBoolean(false);
                break;
            }
            case 11: {
                UUID nodeId = reader.readUuid();
                long lastUpdateTime = reader.readLong();
                ClusterNode node = this.platformCtx.kernalContext().discovery().node(nodeId);
                ClusterMetrics metrics = null;
                if (node != null) {
                    ClusterMetrics metrics0 = node.metrics();
                    long triggerTime = lastUpdateTime + this.platformCtx.kernalContext().config().getMetricsUpdateFrequency();
                    metrics = metrics0.getLastUpdateTime() > triggerTime ? metrics0 : null;
                }
                this.platformCtx.writeClusterMetrics(writer, metrics);
                break;
            }
            case 14: {
                long topVer = reader.readLong();
                this.platformCtx.writeNodes(writer, this.topology(topVer));
                break;
            }
            case 24: {
                String cacheName = reader.readString();
                IgniteCache cache = this.platformCtx.kernalContext().grid().cache(cacheName);
                PlatformCache.writeCacheMetrics(writer, cache.metrics(this.prj));
                break;
            }
            case 27: {
                String plcName = reader.readString();
                MemoryMetrics metrics = this.platformCtx.kernalContext().grid().memoryMetrics(plcName);
                if (metrics != null) {
                    writer.writeBoolean(true);
                    PlatformClusterGroup.writeMemoryMetrics(writer, metrics);
                    break;
                }
                writer.writeBoolean(false);
                break;
            }
            case 36: {
                String name = reader.readString();
                DataRegionMetrics metrics = this.platformCtx.kernalContext().grid().dataRegionMetrics(name);
                if (metrics != null) {
                    writer.writeBoolean(true);
                    PlatformClusterGroup.writeDataRegionMetrics(writer, metrics);
                    break;
                }
                writer.writeBoolean(false);
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 13: {
                return this.pingNode(reader.readUuid()) ? 1L : 0L;
            }
            case 25: {
                Collection<String> cacheNames = PlatformUtils.readStrings(reader);
                this.platformCtx.kernalContext().grid().resetLostPartitions(cacheNames);
                return 1L;
            }
            case 38: {
                boolean enabled = reader.readBoolean();
                Collection<String> cacheNames = PlatformUtils.readStrings(reader);
                this.platformCtx.kernalContext().grid().cluster().enableStatistics(cacheNames, enabled);
                return 1L;
            }
            case 39: {
                Collection<String> cacheNames = PlatformUtils.readStrings(reader);
                this.platformCtx.kernalContext().grid().cluster().clearStatistics(cacheNames);
                return 1L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 7: {
                List<UUID> ids = PlatformUtils.readCollection(reader);
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forNodeIds(ids));
            }
            case 2: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forAttribute(reader.readString(), reader.readString()));
            }
            case 3: {
                String cacheName = reader.readString();
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forCacheNodes(cacheName));
            }
            case 4: {
                String cacheName = reader.readString();
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forClientNodes(cacheName));
            }
            case 5: {
                String cacheName = reader.readString();
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forDataNodes(cacheName));
            }
            case 6: {
                UUID nodeId = reader.readUuid();
                ClusterNode node = this.prj.node(nodeId);
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forHost(node));
            }
        }
        return super.processInStreamOutObject(type, reader);
    }

    @Override
    public PlatformTarget processInObjectStreamOutObjectStream(int type, @Nullable PlatformTarget arg, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 16: {
                PlatformClusterGroup exclude = (PlatformClusterGroup)arg;
                assert (exclude != null);
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forOthers(exclude.prj));
            }
        }
        return super.processInObjectStreamOutObjectStream(type, arg, reader, writer);
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 17: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forRemotes());
            }
            case 19: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forRandom());
            }
            case 20: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forOldest());
            }
            case 21: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forYoungest());
            }
            case 23: {
                return new PlatformClusterGroup(this.platformCtx, (ClusterGroupEx)this.prj.forServers());
            }
            case 31: {
                return new PlatformCompute(this.platformCtx, this.prj, "org.apache.ignite.platform");
            }
            case 32: {
                return new PlatformMessaging(this.platformCtx, this.platformCtx.kernalContext().grid().message(this.prj));
            }
            case 33: {
                return new PlatformEvents(this.platformCtx, this.platformCtx.kernalContext().grid().events(this.prj));
            }
            case 34: {
                return new PlatformServices(this.platformCtx, this.platformCtx.kernalContext().grid().services(this.prj), false);
            }
        }
        return super.processOutObject(type);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 22: {
                assert (this.prj instanceof IgniteCluster);
                ((IgniteCluster)((Object)this.prj)).resetMetrics();
                return 1L;
            }
            case 28: {
                this.prj.ignite().cluster().state(val == 1L ? ClusterState.ACTIVE : ClusterState.INACTIVE);
                return 1L;
            }
            case 29: {
                return this.prj.ignite().cluster().state().active() ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    public ClusterGroupEx projection() {
        return this.prj;
    }

    private boolean pingNode(UUID nodeId) {
        assert (this.prj instanceof IgniteCluster);
        return ((IgniteCluster)((Object)this.prj)).pingNode(nodeId);
    }

    private Collection<ClusterNode> topology(long topVer) {
        assert (this.prj instanceof IgniteCluster);
        return ((IgniteCluster)((Object)this.prj)).topology(topVer);
    }

    private static void writeMemoryMetrics(BinaryRawWriter writer, MemoryMetrics metrics) {
        assert (writer != null);
        assert (metrics != null);
        writer.writeString(metrics.getName());
        writer.writeLong(metrics.getTotalAllocatedPages());
        writer.writeFloat(metrics.getAllocationRate());
        writer.writeFloat(metrics.getEvictionRate());
        writer.writeFloat(metrics.getLargeEntriesPagesPercentage());
        writer.writeFloat(metrics.getPagesFillFactor());
    }

    private static void writeDataRegionMetrics(BinaryRawWriter writer, DataRegionMetrics metrics) {
        assert (writer != null);
        assert (metrics != null);
        writer.writeString(metrics.getName());
        writer.writeLong(metrics.getTotalAllocatedPages());
        writer.writeLong(metrics.getTotalUsedPages());
        writer.writeLong(metrics.getTotalAllocatedSize());
        writer.writeFloat(metrics.getAllocationRate());
        writer.writeFloat(metrics.getEvictionRate());
        writer.writeFloat(metrics.getLargeEntriesPagesPercentage());
        writer.writeFloat(metrics.getPagesFillFactor());
        writer.writeLong(metrics.getDirtyPages());
        writer.writeFloat(metrics.getPagesReplaceRate());
        writer.writeFloat(metrics.getPagesReplaceAge());
        writer.writeLong(metrics.getPhysicalMemoryPages());
        writer.writeLong(metrics.getPhysicalMemorySize());
        writer.writeLong(metrics.getUsedCheckpointBufferPages());
        writer.writeLong(metrics.getUsedCheckpointBufferSize());
        writer.writeInt(metrics.getPageSize());
        writer.writeLong(metrics.getCheckpointBufferSize());
        writer.writeLong(metrics.getPagesRead());
        writer.writeLong(metrics.getPagesWritten());
        writer.writeLong(metrics.getPagesReplaced());
        writer.writeLong(metrics.getOffHeapSize());
        writer.writeLong(metrics.getOffheapUsedSize());
    }
}

