/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrExpirationInfo;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClientCachePutAllConflictRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private final Map<KeyCacheObject, GridCacheDrInfo> map;

    public ClientCachePutAllConflictRequest(BinaryReaderExImpl reader, ClientConnectionContext ctx) {
        super(reader);
        boolean expPlc = this.cachex(ctx).configuration().getExpiryPolicyFactory() != null;
        int cnt = reader.readInt();
        this.map = new LinkedHashMap<KeyCacheObject, GridCacheDrInfo>(cnt);
        for (int i = 0; i < cnt; ++i) {
            KeyCacheObject key = (KeyCacheObject)PlatformUtils.readCacheObject(reader, true);
            Object val = PlatformUtils.readCacheObject(reader, false);
            GridCacheVersion ver = (GridCacheVersion)reader.readObjectDetached();
            long expireTime = reader.readLong();
            GridCacheDrInfo info = expireTime != 0L ? new GridCacheDrExpirationInfo((CacheObject)val, ver, 0L, expireTime) : (expPlc ? new GridCacheDrExpirationInfo((CacheObject)val, ver, -1L, -1L) : new GridCacheDrInfo((CacheObject)val, ver));
            this.map.put(key, info);
        }
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            this.cachex(ctx).putAllConflict(this.map);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        return super.process(ctx);
    }
}

