/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.BooleanGauge;
import org.apache.ignite.internal.processors.metric.impl.BooleanMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.DoubleGauge;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.IntGauge;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderWithDelegateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongGauge;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.metric.impl.ObjectGauge;
import org.apache.ignite.internal.processors.metric.impl.ObjectMetricImpl;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetricRegistry
implements ReadOnlyMetricRegistry {
    private String regName;
    private IgniteLogger log;
    private final ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();
    private final Function<String, Long> hitRateCfgProvider;
    private final Function<String, long[]> histogramCfgProvider;

    public MetricRegistry(String regName, Function<String, Long> hitRateCfgProvider, Function<String, long[]> histogramCfgProvider, IgniteLogger log) {
        this.regName = regName;
        this.log = log;
        this.hitRateCfgProvider = hitRateCfgProvider;
        this.histogramCfgProvider = histogramCfgProvider;
    }

    @Override
    @Nullable
    public <M extends Metric> M findMetric(String name) {
        return (M)this.metrics.get(name);
    }

    public void reset() {
        for (Metric m4 : this.metrics.values()) {
            m4.reset();
        }
    }

    public <T> ObjectMetricImpl<T> objectMetric(String name, Class<T> type, @Nullable String desc) {
        return this.addMetric(name, new ObjectMetricImpl<T>(MetricUtils.metricName(this.regName, name), desc, type));
    }

    @Override
    @NotNull
    public Iterator<Metric> iterator() {
        return this.metrics.values().iterator();
    }

    public void register(Metric metric) {
        assert (((String)MetricUtils.fromFullName(metric.name()).get1()).equals(this.regName));
        this.addMetric((String)MetricUtils.fromFullName(metric.name()).get2(), metric);
    }

    public void remove(String name) {
        this.metrics.remove(name);
    }

    public void register(String name, BooleanSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new BooleanGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public void register(String name, DoubleSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new DoubleGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public void register(String name, IntSupplier supplier, @Nullable String desc) {
        this.addMetric(name, new IntGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public LongGauge register(String name, LongSupplier supplier, @Nullable String desc) {
        return this.addMetric(name, new LongGauge(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log)));
    }

    public <T> void register(String name, Supplier<T> supplier, Class<T> type, @Nullable String desc) {
        this.addMetric(name, new ObjectGauge<T>(MetricUtils.metricName(this.regName, name), desc, GridFunc.nonThrowableSupplier(supplier, this.log), type));
    }

    public DoubleMetricImpl doubleMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new DoubleMetricImpl(MetricUtils.metricName(this.regName, name), desc));
    }

    public IntMetricImpl intMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new IntMetricImpl(MetricUtils.metricName(this.regName, name), desc));
    }

    public AtomicLongMetric longMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new AtomicLongMetric(MetricUtils.metricName(this.regName, name), desc));
    }

    public LongAdderMetric longAdderMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new LongAdderMetric(MetricUtils.metricName(this.regName, name), desc));
    }

    public LongAdderWithDelegateMetric longAdderMetric(String name, LongAdderWithDelegateMetric.Delegate delegate, @Nullable String desc) {
        return this.addMetric(name, new LongAdderWithDelegateMetric(MetricUtils.metricName(this.regName, name), delegate, desc));
    }

    public HitRateMetric hitRateMetric(String name, @Nullable String desc, long rateTimeInterval, int size) {
        String fullName = MetricUtils.metricName(this.regName, name);
        HitRateMetric metric = this.addMetric(name, new HitRateMetric(fullName, desc, rateTimeInterval, size));
        Long cfgRateTimeInterval = this.hitRateCfgProvider.apply(fullName);
        if (cfgRateTimeInterval != null) {
            metric.reset(cfgRateTimeInterval, 10);
        }
        return metric;
    }

    public BooleanMetricImpl booleanMetric(String name, @Nullable String desc) {
        return this.addMetric(name, new BooleanMetricImpl(MetricUtils.metricName(this.regName, name), desc));
    }

    public HistogramMetricImpl histogram(String name, long[] bounds, @Nullable String desc) {
        String fullName = MetricUtils.metricName(this.regName, name);
        HistogramMetricImpl metric = this.addMetric(name, new HistogramMetricImpl(fullName, desc, bounds));
        long[] cfgBounds = this.histogramCfgProvider.apply(fullName);
        if (cfgBounds != null) {
            metric.reset(cfgBounds);
        }
        return metric;
    }

    private <T extends Metric> T addMetric(String name, T metric) {
        Metric old = this.metrics.putIfAbsent(name, metric);
        if (old != null) {
            return (T)old;
        }
        return metric;
    }

    @Override
    public String name() {
        return this.regName;
    }
}

