/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;

public class CompressionProcessor
extends GridProcessorAdapter {
    public static final int LZ4_MIN_LEVEL = 0;
    public static final int LZ4_MAX_LEVEL = 17;
    public static final int LZ4_DEFAULT_LEVEL = 0;
    public static final int ZSTD_MIN_LEVEL = -131072;
    public static final int ZSTD_MAX_LEVEL = 22;
    public static final int ZSTD_DEFAULT_LEVEL = 3;
    public static final byte UNCOMPRESSED_PAGE = 0;
    protected static final byte COMPACTED_PAGE = 1;
    protected static final byte ZSTD_COMPRESSED_PAGE = 2;
    protected static final byte LZ4_COMPRESSED_PAGE = 3;
    protected static final byte SNAPPY_COMPRESSED_PAGE = 4;

    public CompressionProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public static int getDefaultCompressionLevel(DiskPageCompression compression) {
        switch (compression) {
            case ZSTD: {
                return 3;
            }
            case LZ4: {
                return 0;
            }
            case SNAPPY: 
            case SKIP_GARBAGE: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Compression: " + (Object)((Object)compression));
    }

    public static int checkCompressionLevelBounds(int compressLevel, DiskPageCompression compression) {
        switch (compression) {
            case ZSTD: {
                CompressionProcessor.checkCompressionLevelBounds(compressLevel, -131072, 22);
                break;
            }
            case LZ4: {
                CompressionProcessor.checkCompressionLevelBounds(compressLevel, 0, 17);
                break;
            }
            default: {
                throw new IllegalArgumentException("Compression level for " + (Object)((Object)compression) + " is not supported.");
            }
        }
        return compressLevel;
    }

    private static void checkCompressionLevelBounds(int compressLevel, int min2, int max) {
        if (compressLevel < min2 || compressLevel > max) {
            throw new IllegalArgumentException("Compression level for LZ4 must be between " + min2 + " and " + max + ".");
        }
    }

    private static <T> T fail() throws IgniteCheckedException {
        throw new IgniteCheckedException("Make sure that ignite-compress module is in classpath.");
    }

    public void checkPageCompressionSupported() throws IgniteCheckedException {
        CompressionProcessor.fail();
    }

    public void checkPageCompressionSupported(Path storagePath, int pageSize) throws IgniteCheckedException {
        CompressionProcessor.fail();
    }

    public ByteBuffer compressPage(ByteBuffer page, int pageSize, int storeBlockSize, DiskPageCompression compression, int compressLevel) throws IgniteCheckedException {
        return (ByteBuffer)CompressionProcessor.fail();
    }

    public void decompressPage(ByteBuffer page, int pageSize) throws IgniteCheckedException {
        if (PageIO.getCompressionType(page) != 0) {
            CompressionProcessor.fail();
        }
    }
}

