/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.security.AccessControlException;
import java.util.UUID;
import javax.cache.configuration.Factory;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.lang.IgniteClosure;

public class SecurityAwareTransformerFactory<E, R>
extends AbstractSecurityAwareExternalizable<Factory<IgniteClosure<E, R>>>
implements Factory<IgniteClosure<E, R>> {
    private static final long serialVersionUID = 0L;

    public SecurityAwareTransformerFactory() {
    }

    public SecurityAwareTransformerFactory(UUID subjectId, Factory<IgniteClosure<E, R>> original) {
        super(subjectId, original);
    }

    @Override
    public IgniteClosure<E, R> create() {
        final IgniteClosure cl = (IgniteClosure)((Factory)this.original).create();
        return new IgniteClosure<E, R>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public R apply(E e) {
                IgniteSecurity security = SecurityAwareTransformerFactory.this.ignite.context().security();
                try (OperationSecurityContext c = security.withContext(SecurityAwareTransformerFactory.this.subjectId);){
                    IgniteSandbox sandbox = security.sandbox();
                    Object r = sandbox.enabled() ? sandbox.execute(() -> cl.apply(e)) : cl.apply(e);
                    return r;
                }
                catch (AccessControlException ace) {
                    SecurityAwareTransformerFactory.this.logAccessDeniedMessage(ace);
                    throw ace;
                }
            }
        };
    }
}

