/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class GridCacheQueryMetricsKey
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private GridCacheQueryType type;
    private Class<?> cls;
    private String clause;

    GridCacheQueryMetricsKey(@Nullable GridCacheQueryType type, @Nullable Class<?> cls, @Nullable String clause) {
        this.type = type;
        this.cls = cls;
        this.clause = clause;
    }

    public GridCacheQueryMetricsKey() {
    }

    GridCacheQueryType type() {
        return this.type;
    }

    Class<?> queryClass() {
        return this.cls;
    }

    String clause() {
        return this.clause;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridCacheQueryMetricsKey)) {
            return false;
        }
        GridCacheQueryMetricsKey oth = (GridCacheQueryMetricsKey)obj;
        return oth.type() == this.type && F.eq(oth.queryClass(), this.cls) && F.eq(oth.clause(), this.clause);
    }

    public int hashCode() {
        return (this.type != null ? this.type.ordinal() : -1) + 31 * (this.cls != null ? this.cls.hashCode() : 0) + 961 * (this.clause != null ? this.clause.hashCode() : 0);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.type);
        out.writeObject(this.cls);
        U.writeString(out, this.clause);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = GridCacheQueryType.fromOrdinal(in.readByte());
        this.cls = (Class)in.readObject();
        this.clause = U.readString(in);
    }
}

