/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotVerificationTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class SnapshotPartitionsVerifyTask
extends AbstractSnapshotVerificationTask {
    private static final long serialVersionUID = 0L;

    @Override
    protected ComputeJob createJob(String name, String path, int incIdx, String constId, Collection<String> groups, boolean check) {
        return new VisorVerifySnapshotPartitionsJob(name, path, constId, groups, check);
    }

    @Override
    @Nullable
    public SnapshotPartitionsVerifyTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        return new SnapshotPartitionsVerifyTaskResult(this.metas, VerifyBackupPartitionsTaskV2.reduce0(results));
    }

    private static class VisorVerifySnapshotPartitionsJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private final String snpName;
        private final String snpPath;
        private final String consId;
        private final Collection<String> rqGrps;
        private final boolean check;

        public VisorVerifySnapshotPartitionsJob(String snpName, @Nullable String snpPath, String consId, Collection<String> rqGrps, boolean check) {
            this.snpName = snpName;
            this.consId = consId;
            this.rqGrps = rqGrps;
            this.snpPath = snpPath;
            this.check = check;
        }

        @Override
        public Map<PartitionKeyV2, PartitionHashRecordV2> execute() throws IgniteException {
            GridCacheSharedContext cctx = this.ignite.context().cache().context();
            if (this.log.isInfoEnabled()) {
                this.log.info("Verify snapshot partitions procedure has been initiated [snpName=" + this.snpName + ", consId=" + this.consId + ']');
            }
            try {
                File snpDir = cctx.snapshotMgr().snapshotLocalDir(this.snpName, this.snpPath);
                SnapshotMetadata meta = cctx.snapshotMgr().readSnapshotMetadata(snpDir, this.consId);
                return new SnapshotPartitionsVerifyHandler(cctx).invoke(new SnapshotHandlerContext(meta, this.rqGrps, this.ignite.localNode(), snpDir, false, this.check));
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VisorVerifySnapshotPartitionsJob job = (VisorVerifySnapshotPartitionsJob)o;
            return this.snpName.equals(job.snpName) && this.consId.equals(job.consId) && Objects.equals(this.rqGrps, job.rqGrps) && Objects.equals(this.snpPath, job.snpPath) && Objects.equals(this.check, job.check);
        }

        public int hashCode() {
            return Objects.hash(this.snpName, this.consId, this.rqGrps, this.snpPath, this.check);
        }
    }
}

