/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class SnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final UUID rqId;
    @GridToStringInclude
    private final String snpName;
    @GridToStringInclude
    private final String consId;
    private final String folderName;
    private final int pageSize;
    @GridToStringInclude
    private final List<Integer> grpIds;
    @GridToStringInclude
    private final Set<String> bltNodes;
    @Nullable
    private final WALPointer snpRecPtr;
    @GridToStringInclude
    private transient Map<Integer, Set<Integer>> locParts = new HashMap<Integer, Set<Integer>>();
    @GridToStringInclude
    @Nullable
    private final byte[] masterKeyDigest;
    @GridToStringInclude
    @Nullable
    private List<String> warnings;
    private transient Set<Integer> comprGrpIds;
    private boolean hasComprGrps;
    private boolean onlyPrimary;

    public SnapshotMetadata(UUID rqId, String snpName, String consId, String folderName, int pageSize, List<Integer> grpIds, Collection<Integer> compGrpIds, Set<String> bltNodes, Set<GroupPartitionId> pairs, @Nullable WALPointer snpRecPtr, @Nullable byte[] masterKeyDigest, boolean onlyPrimary) {
        this.rqId = rqId;
        this.snpName = snpName;
        this.consId = consId;
        this.folderName = folderName;
        this.pageSize = pageSize;
        this.grpIds = grpIds;
        this.bltNodes = bltNodes;
        this.snpRecPtr = snpRecPtr;
        this.masterKeyDigest = masterKeyDigest;
        this.onlyPrimary = onlyPrimary;
        if (!F.isEmpty(compGrpIds)) {
            this.hasComprGrps = true;
            this.comprGrpIds = new HashSet<Integer>(compGrpIds);
        }
        pairs.forEach(p -> this.locParts.computeIfAbsent(p.getGroupId(), k -> new HashSet()).add(p.getPartitionId()));
    }

    public UUID requestId() {
        return this.rqId;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public String consistentId() {
        return this.consId;
    }

    public String folderName() {
        return this.folderName;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public List<Integer> cacheGroupIds() {
        return this.grpIds;
    }

    public Set<String> baselineNodes() {
        return this.bltNodes;
    }

    public Map<Integer, Set<Integer>> partitions() {
        return Collections.unmodifiableMap(this.locParts);
    }

    public boolean isGroupWithCompresion(int grpId) {
        return this.hasComprGrps && this.comprGrpIds.contains(grpId);
    }

    public boolean hasCompressedGroups() {
        return this.hasComprGrps;
    }

    @Nullable
    public WALPointer snapshotRecordPointer() {
        return this.snpRecPtr;
    }

    public boolean onlyPrimary() {
        return this.onlyPrimary;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.locParts.size());
        for (Map.Entry<Integer, Set<Integer>> e : this.locParts.entrySet()) {
            s2.writeInt(e.getKey());
            s2.writeInt(e.getValue().size());
            for (Integer partId : e.getValue()) {
                s2.writeInt(partId);
            }
        }
        if (this.hasComprGrps) {
            U.writeCollection(s2, this.comprGrpIds);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int size = s2.readInt();
        if (size < 0) {
            throw new InvalidObjectException("Illegal size: " + size);
        }
        this.locParts = U.newHashMap(size);
        for (int i = 0; i < size; ++i) {
            int grpId = s2.readInt();
            int total = s2.readInt();
            if (total < 0) {
                throw new InvalidObjectException("Illegal size: " + total);
            }
            HashSet parts = U.newHashSet(total);
            for (int k = 0; k < total; ++k) {
                parts.add(s2.readInt());
            }
            this.locParts.put(grpId, parts);
        }
        if (this.hasComprGrps) {
            this.comprGrpIds = U.readSet(s2);
        }
    }

    public boolean sameSnapshot(SnapshotMetadata compare) {
        return this.requestId().equals(compare.requestId()) && this.snapshotName().equals(compare.snapshotName()) && this.pageSize() == compare.pageSize() && Objects.equals(this.cacheGroupIds(), compare.cacheGroupIds()) && Arrays.equals(this.masterKeyDigest, compare.masterKeyDigest) && Objects.equals(this.baselineNodes(), compare.baselineNodes()) && this.onlyPrimary == compare.onlyPrimary;
    }

    public byte[] masterKeyDigest() {
        return this.masterKeyDigest;
    }

    public void warnings(List<String> warnings) {
        assert (this.warnings == null) : "Snapshot warnings are already set. No rewriting is supposed.";
        this.warnings = warnings;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotMetadata meta = (SnapshotMetadata)o;
        return this.rqId.equals(meta.rqId) && this.snpName.equals(meta.snpName) && this.consId.equals(meta.consId) && Objects.equals(this.grpIds, meta.grpIds) && Objects.equals(this.bltNodes, meta.bltNodes) && Arrays.equals(this.masterKeyDigest, meta.masterKeyDigest) && Objects.equals(this.warnings, meta.warnings) && Objects.equals(this.hasComprGrps, meta.hasComprGrps) && Objects.equals(this.comprGrpIds, meta.comprGrpIds) && this.onlyPrimary == meta.onlyPrimary;
    }

    public int hashCode() {
        return Objects.hash(this.rqId, this.snpName, this.consId, this.grpIds, this.bltNodes, this.onlyPrimary);
    }

    public String toString() {
        return S.toString(SnapshotMetadata.class, this);
    }
}

