/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitter;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.schema.message.SchemaFinishDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class DynamicCacheDescriptor {
    private IgniteUuid deploymentId;
    @GridToStringExclude
    private volatile CacheConfiguration cacheCfg;
    private final boolean staticCfg;
    private boolean sql;
    private CacheType cacheType;
    private boolean template;
    private boolean updatesAllowed = true;
    private int cacheId;
    private final UUID rcvdFrom;
    private final Object mux = new Object();
    private volatile CacheObjectContext objCtx;
    private boolean rcvdOnDiscovery;
    private AffinityTopologyVersion startTopVer;
    private AffinityTopologyVersion rcvdFromVer;
    private AffinityTopologyVersion clientCacheStartVer;
    private final Object schemaMux = new Object();
    private QuerySchema schema;
    private final CacheGroupDescriptor grpDesc;
    @Nullable
    private final CacheConfigurationEnrichment cacheCfgEnrichment;
    private volatile boolean cacheCfgEnriched;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicCacheDescriptor(GridKernalContext ctx, CacheConfiguration cacheCfg, CacheType cacheType, CacheGroupDescriptor grpDesc, boolean template, UUID rcvdFrom, boolean staticCfg, boolean sql, IgniteUuid deploymentId, QuerySchema schema, @Nullable CacheConfigurationEnrichment cacheCfgEnrichment) {
        assert (cacheCfg != null);
        assert (grpDesc != null || template);
        assert (schema != null);
        if (cacheCfg.getCacheMode() == CacheMode.REPLICATED && cacheCfg.getNearConfiguration() != null) {
            cacheCfg = new CacheConfiguration(cacheCfg);
            cacheCfg.setNearConfiguration(null);
        }
        this.cacheCfg = cacheCfg;
        this.cacheType = cacheType;
        this.grpDesc = grpDesc;
        this.template = template;
        this.rcvdFrom = rcvdFrom;
        this.staticCfg = staticCfg;
        this.sql = sql;
        this.deploymentId = deploymentId;
        this.cacheId = CU.cacheId(cacheCfg.getName());
        Object object = this.schemaMux;
        synchronized (object) {
            this.schema = schema.copy();
        }
        this.cacheCfgEnrichment = cacheCfgEnrichment;
    }

    public int groupId() {
        assert (this.grpDesc != null) : this;
        return this.grpDesc.groupId();
    }

    public CacheGroupDescriptor groupDescriptor() {
        assert (this.grpDesc != null) : this;
        return this.grpDesc;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public boolean template() {
        return this.template;
    }

    public CacheType cacheType() {
        return this.cacheType;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public boolean staticallyConfigured() {
        return this.staticCfg;
    }

    public boolean sql() {
        return this.sql;
    }

    public String cacheName() {
        assert (this.cacheCfg != null) : this;
        return this.cacheCfg.getName();
    }

    public CacheConfiguration cacheConfiguration() {
        return this.cacheCfg;
    }

    public void cacheConfiguration(CacheConfiguration cacheCfg) {
        this.cacheCfg = cacheCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObjectContext cacheObjectContext(IgniteCacheObjectProcessor proc) throws IgniteCheckedException {
        if (this.objCtx == null) {
            Object object = this.mux;
            synchronized (object) {
                if (this.objCtx == null) {
                    this.objCtx = proc.contextForCache(this.cacheCfg);
                }
            }
        }
        return this.objCtx;
    }

    public boolean updatesAllowed() {
        return this.updatesAllowed;
    }

    public void updatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    boolean receivedOnDiscovery() {
        return this.rcvdOnDiscovery;
    }

    void receivedOnDiscovery(boolean rcvdOnDiscovery) {
        this.rcvdOnDiscovery = rcvdOnDiscovery;
    }

    @Nullable
    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    @Nullable
    AffinityTopologyVersion receivedFromStartVersion() {
        return this.rcvdFromVer;
    }

    void receivedFromStartVersion(AffinityTopologyVersion rcvdFromVer) {
        this.rcvdFromVer = rcvdFromVer;
    }

    @Nullable
    public AffinityTopologyVersion startTopologyVersion() {
        return this.startTopVer;
    }

    public void startTopologyVersion(AffinityTopologyVersion startTopVer) {
        this.startTopVer = startTopVer;
    }

    @Nullable
    AffinityTopologyVersion clientCacheStartVersion() {
        return this.clientCacheStartVer;
    }

    void clientCacheStartVersion(AffinityTopologyVersion clientCacheStartVer) {
        this.clientCacheStartVer = clientCacheStartVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchema schema() {
        Object object = this.schemaMux;
        synchronized (object) {
            return this.schema.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schema(QuerySchema schema) {
        assert (schema != null);
        Object object = this.schemaMux;
        synchronized (object) {
            this.schema = schema.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schemaChangeFinish(SchemaFinishDiscoveryMessage msg) {
        Object object = this.schemaMux;
        synchronized (object) {
            this.schema.finish(msg);
            if (msg.operation() instanceof SchemaAddQueryEntityOperation) {
                this.cacheCfg = GridCacheUtils.patchCacheConfiguration(this.cacheCfg, (SchemaAddQueryEntityOperation)msg.operation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchemaPatch makeSchemaPatch(StoredCacheData cacheData) {
        Object object = this.schemaMux;
        synchronized (object) {
            return this.schema.makePatch(cacheData.config(), cacheData.queryEntities());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchemaPatch makeSchemaPatch(Collection<QueryEntity> target) {
        Object object = this.schemaMux;
        synchronized (object) {
            return this.schema.makePatch(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applySchemaPatch(QuerySchemaPatch patch) {
        Object object = this.schemaMux;
        synchronized (object) {
            boolean res = this.schema.applyPatch(patch);
            if (res) {
                for (SchemaAbstractOperation op : patch.getPatchOperations()) {
                    if (!(op instanceof SchemaAddQueryEntityOperation)) continue;
                    this.cacheCfg = GridCacheUtils.patchCacheConfiguration(this.cacheCfg, (SchemaAddQueryEntityOperation)op);
                }
            }
            return res;
        }
    }

    public StoredCacheData toStoredData(CacheConfigurationSplitter splitter) {
        assert (this.schema != null);
        StoredCacheData res = new StoredCacheData(this.cacheConfiguration());
        res.queryEntities(this.schema().entities());
        res.sql(this.sql());
        if (this.isConfigurationEnriched()) {
            T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = splitter.split(this.cacheCfg);
            res.config((CacheConfiguration)splitCfg.get1());
            res.cacheConfigurationEnrichment(this.cacheCfgEnrichment == null ? (CacheConfigurationEnrichment)splitCfg.get2() : this.cacheCfgEnrichment);
        } else {
            res.cacheConfigurationEnrichment(this.cacheCfgEnrichment);
        }
        return res;
    }

    public CacheConfigurationEnrichment cacheConfigurationEnrichment() {
        return this.cacheCfgEnrichment;
    }

    public boolean isConfigurationEnriched() {
        return this.cacheCfgEnrichment == null || this.cacheCfgEnriched;
    }

    public void configurationEnriched(boolean cacheCfgEnriched) {
        this.cacheCfgEnriched = cacheCfgEnriched;
    }

    public String toString() {
        return S.toString(DynamicCacheDescriptor.class, this, "cacheName", (Object)U.maskName(this.cacheCfg.getName()));
    }
}

