/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.spi.metric.LongMetric;
import org.jetbrains.annotations.Nullable;

public class CacheGroupMetricsImpl {
    public static final String CACHE_GROUP_METRICS_PREFIX = "cacheGroups";
    private final AtomicLongMetric idxBuildCntPartitionsLeft;
    private final CacheGroupContext ctx;
    private final LongMetric storageSize;
    private final LongMetric sparseStorageSize;
    private final AtomicLongMetric initLocPartitionsNum;
    @Nullable
    private final PageMetrics pageMetrics;

    public CacheGroupMetricsImpl(CacheGroupContext ctx) {
        this.ctx = ctx;
        CacheConfiguration cacheCfg = ctx.config();
        GridKernalContext kernalCtx = ctx.shared().kernalContext();
        DataStorageConfiguration dsCfg = kernalCtx.config().getDataStorageConfiguration();
        boolean persistenceEnabled = !kernalCtx.clientNode() && CU.isPersistentCache(cacheCfg, dsCfg);
        MetricRegistry mreg = kernalCtx.metric().registry(this.metricGroupName());
        mreg.register("Caches", this::getCaches, List.class, null);
        this.storageSize = mreg.register("StorageSize", () -> persistenceEnabled ? this.database().forGroupPageStores(ctx, PageStore::size) : 0L, "Storage space allocated for group, in bytes.");
        this.sparseStorageSize = mreg.register("SparseStorageSize", () -> persistenceEnabled ? this.database().forGroupPageStores(ctx, PageStore::getSparseSize) : 0L, "Storage space allocated for group adjusted for possible sparsity, in bytes.");
        this.idxBuildCntPartitionsLeft = mreg.longMetric("IndexBuildCountPartitionsLeft", "Number of partitions need processed for finished indexes create or rebuilding.");
        this.initLocPartitionsNum = mreg.longMetric("InitializedLocalPartitionsNumber", "Number of local partitions initialized on current node.");
        this.pageMetrics = ctx.dataRegion() == null ? null : ctx.dataRegion().metrics().cacheGrpPageMetrics(ctx.groupId());
    }

    public void onTopologyInitialized() {
        MetricRegistry mreg = this.ctx.shared().kernalContext().metric().registry(this.metricGroupName());
        mreg.register("MinimumNumberOfPartitionCopies", this::getMinimumNumberOfPartitionCopies, "Minimum number of partition copies for all partitions of this cache group.");
        mreg.register("MaximumNumberOfPartitionCopies", this::getMaximumNumberOfPartitionCopies, "Maximum number of partition copies for all partitions of this cache group.");
        mreg.register("LocalNodeOwningPartitionsCount", this::getLocalNodeOwningPartitionsCount, "Count of partitions with state OWNING for this cache group located on this node.");
        mreg.register("LocalNodeMovingPartitionsCount", this::getLocalNodeMovingPartitionsCount, "Count of partitions with state MOVING for this cache group located on this node.");
        mreg.register("LocalNodeRentingPartitionsCount", this::getLocalNodeRentingPartitionsCount, "Count of partitions with state RENTING for this cache group located on this node.");
        mreg.register("LocalNodeRentingEntriesCount", this::getLocalNodeRentingEntriesCount, "Count of entries remains to evict in RENTING partitions located on this node for this cache group.");
        mreg.register("OwningPartitionsAllocationMap", this::getOwningPartitionsAllocationMap, Map.class, "Allocation map of partitions with state OWNING in the cluster.");
        mreg.register("MovingPartitionsAllocationMap", this::getMovingPartitionsAllocationMap, Map.class, "Allocation map of partitions with state MOVING in the cluster.");
        mreg.register("AffinityPartitionsAssignmentMap", this::getAffinityPartitionsAssignmentMap, Map.class, "Affinity partitions assignment map.");
        mreg.register("PartitionIds", this::getPartitionIds, List.class, "Local partition ids.");
        mreg.register("TotalAllocatedSize", this::getTotalAllocatedSize, "Total size of memory allocated for group, in bytes.");
        mreg.register("ClusterOwningPartitionsCount", this::getClusterOwningPartitionsCount, "Count of partitions for this cache group in the entire cluster with state OWNING.");
        mreg.register("ClusterMovingPartitionsCount", this::getClusterMovingPartitionsCount, "Count of partitions for this cache group in the entire cluster with state MOVING.");
        if (this.ctx.config().isEncryptionEnabled()) {
            mreg.register("ReencryptionFinished", () -> !this.ctx.shared().kernalContext().encryption().reencryptionInProgress(this.ctx.groupId()), "The flag indicates whether reencryption is finished or not.");
            mreg.register("ReencryptionBytesLeft", () -> this.ctx.shared().kernalContext().encryption().getBytesLeftForReencryption(this.ctx.groupId()), "The number of bytes left for re-ecryption.");
        }
    }

    public long getIndexBuildCountPartitionsLeft() {
        return this.idxBuildCntPartitionsLeft.value();
    }

    public void addIndexBuildCountPartitionsLeft(long idxBuildCntPartitionsLeft) {
        this.idxBuildCntPartitionsLeft.add(idxBuildCntPartitionsLeft);
    }

    public void decrementIndexBuildCountPartitionsLeft() {
        this.idxBuildCntPartitionsLeft.decrement();
    }

    public void incrementInitializedLocalPartitions() {
        this.initLocPartitionsNum.increment();
    }

    public void decrementInitializedLocalPartitions() {
        this.initLocPartitionsNum.decrement();
    }

    public int getGroupId() {
        return this.ctx.groupId();
    }

    public String getGroupName() {
        return this.ctx.name();
    }

    public List<String> getCaches() {
        ArrayList<String> caches = new ArrayList<String>(this.ctx.caches().size());
        for (GridCacheContext cache : this.ctx.caches()) {
            caches.add(cache.name());
        }
        Collections.sort(caches);
        return caches;
    }

    public int getBackups() {
        return this.ctx.config().getBackups();
    }

    public int getPartitions() {
        return this.ctx.topology().partitions();
    }

    private int numberOfPartitionCopies(IntBiPredicate pred) {
        GridDhtPartitionFullMap partFullMap = this.ctx.topology().partitionMap(false);
        if (partFullMap == null) {
            return 0;
        }
        int parts = this.ctx.topology().partitions();
        int res = -1;
        for (int part = 0; part < parts; ++part) {
            int cnt = 0;
            for (Map.Entry entry : partFullMap.entrySet()) {
                if (((GridDhtPartitionMap)entry.getValue()).get(part) != GridDhtPartitionState.OWNING) continue;
                ++cnt;
            }
            if (part != 0 && !pred.apply(res, cnt)) continue;
            res = cnt;
        }
        return res;
    }

    public int getMinimumNumberOfPartitionCopies() {
        return this.numberOfPartitionCopies(new IntBiPredicate(){

            @Override
            public boolean apply(int targetVal, int nextVal) {
                return nextVal < targetVal;
            }
        });
    }

    public int getMaximumNumberOfPartitionCopies() {
        return this.numberOfPartitionCopies(new IntBiPredicate(){

            @Override
            public boolean apply(int targetVal, int nextVal) {
                return nextVal > targetVal;
            }
        });
    }

    private int nodePartitionsCountByState(UUID nodeId, GridDhtPartitionState state) {
        int parts = this.ctx.topology().partitions();
        GridDhtPartitionMap partMap = (GridDhtPartitionMap)this.ctx.topology().partitionMap(false).get(nodeId);
        int cnt = 0;
        for (int part = 0; part < parts; ++part) {
            if (partMap.get(part) != state) continue;
            ++cnt;
        }
        return cnt;
    }

    private int clusterPartitionsCountByState(GridDhtPartitionState state) {
        GridDhtPartitionFullMap partFullMap = this.ctx.topology().partitionMap(true);
        int cnt = 0;
        for (UUID nodeId : partFullMap.keySet()) {
            cnt += this.nodePartitionsCountByState(nodeId, state);
        }
        return cnt;
    }

    private int localNodePartitionsCountByState(GridDhtPartitionState state) {
        int cnt = 0;
        for (GridDhtLocalPartition part : this.ctx.topology().localPartitions()) {
            if (part.state() != state) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getLocalNodeOwningPartitionsCount() {
        return this.localNodePartitionsCountByState(GridDhtPartitionState.OWNING);
    }

    public int getLocalNodeMovingPartitionsCount() {
        return this.localNodePartitionsCountByState(GridDhtPartitionState.MOVING);
    }

    public int getLocalNodeRentingPartitionsCount() {
        return this.localNodePartitionsCountByState(GridDhtPartitionState.RENTING);
    }

    public long getLocalNodeRentingEntriesCount() {
        long entriesCnt = 0L;
        for (GridDhtLocalPartition part : this.ctx.topology().localPartitions()) {
            if (part.state() != GridDhtPartitionState.RENTING) continue;
            entriesCnt += part.dataStore().fullSize();
        }
        return entriesCnt;
    }

    public int getClusterOwningPartitionsCount() {
        return this.clusterPartitionsCountByState(GridDhtPartitionState.OWNING);
    }

    public int getClusterMovingPartitionsCount() {
        return this.clusterPartitionsCountByState(GridDhtPartitionState.MOVING);
    }

    private Map<Integer, Set<String>> clusterPartitionsMapByState(GridDhtPartitionState state) {
        GridDhtPartitionFullMap partFullMap = this.ctx.topology().partitionMap(false);
        if (partFullMap == null) {
            return Collections.emptyMap();
        }
        int parts = this.ctx.topology().partitions();
        LinkedHashMap<Integer, Set<String>> partsMap = new LinkedHashMap<Integer, Set<String>>();
        for (int part = 0; part < parts; ++part) {
            HashSet<String> partNodesSet = new HashSet<String>();
            for (Map.Entry entry : partFullMap.entrySet()) {
                if (((GridDhtPartitionMap)entry.getValue()).get(part) != state) continue;
                partNodesSet.add(((UUID)entry.getKey()).toString());
            }
            partsMap.put(part, partNodesSet);
        }
        return partsMap;
    }

    public Map<Integer, Set<String>> getOwningPartitionsAllocationMap() {
        return this.clusterPartitionsMapByState(GridDhtPartitionState.OWNING);
    }

    public Map<Integer, Set<String>> getMovingPartitionsAllocationMap() {
        return this.clusterPartitionsMapByState(GridDhtPartitionState.MOVING);
    }

    public Map<Integer, List<String>> getAffinityPartitionsAssignmentMap() {
        if (this.ctx.affinity().lastVersion().topologyVersion() < 0L) {
            return Collections.emptyMap();
        }
        AffinityAssignment assignment = this.ctx.affinity().cachedAffinity(AffinityTopologyVersion.NONE);
        int part = 0;
        LinkedHashMap<Integer, List<String>> assignmentMap = new LinkedHashMap<Integer, List<String>>();
        for (List<ClusterNode> partAssignment : assignment.assignment()) {
            ArrayList<String> partNodeIds = new ArrayList<String>(partAssignment.size());
            for (ClusterNode node : partAssignment) {
                partNodeIds.add(node.id().toString());
            }
            assignmentMap.put(part, partNodeIds);
            ++part;
        }
        return assignmentMap;
    }

    public String getType() {
        CacheMode type = this.ctx.config().getCacheMode();
        return String.valueOf((Object)type);
    }

    public List<Integer> getPartitionIds() {
        List<GridDhtLocalPartition> parts = this.ctx.topology().localPartitions();
        ArrayList<Integer> partsRes = new ArrayList<Integer>(parts.size());
        for (GridDhtLocalPartition part : parts) {
            partsRes.add(part.id());
        }
        return partsRes;
    }

    public long getTotalAllocatedPages() {
        return this.pageMetrics == null ? 0L : this.pageMetrics.totalPages().value();
    }

    public long getTotalAllocatedSize() {
        return this.ctx.shared().kernalContext().clientNode() ? 0L : this.getTotalAllocatedPages() * (long)this.ctx.dataRegion().pageMemory().pageSize();
    }

    public long getStorageSize() {
        return this.storageSize == null ? 0L : this.storageSize.value();
    }

    public long getSparseStorageSize() {
        return this.sparseStorageSize == null ? 0L : this.sparseStorageSize.value();
    }

    public void remove(boolean destroy) {
        if (this.ctx.shared().kernalContext().isStopping()) {
            return;
        }
        if (this.ctx.config().getNearConfiguration() != null) {
            this.ctx.shared().kernalContext().metric().remove(MetricUtils.cacheMetricsRegistryName(this.ctx.config().getName(), true), destroy);
        }
        this.ctx.shared().kernalContext().metric().remove(MetricUtils.cacheMetricsRegistryName(this.ctx.config().getName(), false), destroy);
        this.ctx.shared().kernalContext().metric().remove(this.metricGroupName(), destroy);
    }

    private GridCacheDatabaseSharedManager database() {
        return (GridCacheDatabaseSharedManager)this.ctx.shared().database();
    }

    private String metricGroupName() {
        return MetricUtils.metricName(CACHE_GROUP_METRICS_PREFIX, this.ctx.cacheOrGroupName());
    }

    private static interface IntBiPredicate {
        public boolean apply(int var1, int var2);
    }
}

