/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.defragmentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.defragmentation.DefragIndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccIO;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.LinkMap;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.TreeIterator;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IndexingDefragmentation {
    private final IndexProcessor indexing;

    public IndexingDefragmentation(IndexProcessor indexing) {
        this.indexing = indexing;
    }

    public void defragment(CacheGroupContext grpCtx, CacheGroupContext newCtx, PageMemoryEx partPageMem, IntMap<LinkMap> mappingByPartition, CheckpointTimeoutLock cpLock, Runnable cancellationChecker, IgniteThreadPoolExecutor defragmentationThreadPool, IgniteLogger log) throws IgniteCheckedException {
        int pageSize = grpCtx.cacheObjectContext().kernalContext().grid().configuration().getDataStorageConfiguration().getPageSize();
        PageMemoryEx oldCachePageMem = (PageMemoryEx)grpCtx.dataRegion().pageMemory();
        PageMemoryEx newCachePageMemory = partPageMem;
        Collection<TableIndexes> tables = this.tables(grpCtx);
        long cpLockThreshold = 150L;
        AtomicLong lastCpLockTs = new AtomicLong(System.currentTimeMillis());
        IgniteUtils.doInParallel(defragmentationThreadPool, tables, table -> this.defragmentTable(newCtx, mappingByPartition, cpLock, cancellationChecker, pageSize, oldCachePageMem, newCachePageMemory, cpLockThreshold, lastCpLockTs, (TableIndexes)table));
        if (log.isInfoEnabled()) {
            log.info("Defragmentation indexes completed for group '" + grpCtx.groupId() + "'");
        }
    }

    private boolean defragmentTable(CacheGroupContext newCtx, IntMap<LinkMap> mappingByPartition, CheckpointTimeoutLock cpLock, Runnable cancellationChecker, int pageSize, PageMemoryEx oldCachePageMem, PageMemory newCachePageMemory, long cpLockThreshold, AtomicLong lastCpLockTs, TableIndexes indexes) throws IgniteCheckedException {
        cpLock.checkpointReadLock();
        try {
            TreeIterator treeIterator = new TreeIterator(pageSize);
            GridCacheContext<?, ?> cctx = indexes.cctx;
            cancellationChecker.run();
            for (InlineIndex oldIdx : indexes.idxs) {
                InlineIndexRowHandler oldRowHnd = oldIdx.segment(0).rowHandler();
                SortedIndexDefinition idxDef = (SortedIndexDefinition)this.indexing.indexDefinition(oldIdx.id());
                InlineIndexImpl newIdx = new DefragIndexFactory(newCtx.offheap(), newCachePageMemory, oldIdx).createIndex(cctx, idxDef).unwrap(InlineIndexImpl.class);
                int segments = oldIdx.segmentsCount();
                for (int i = 0; i < segments; ++i) {
                    treeIterator.iterate(oldIdx.segment(i), oldCachePageMem, (theTree, io, pageAddr, idx) -> {
                        cancellationChecker.run();
                        if (System.currentTimeMillis() - lastCpLockTs.get() >= cpLockThreshold) {
                            cpLock.checkpointReadUnlock();
                            cpLock.checkpointReadLock();
                            lastCpLockTs.set(System.currentTimeMillis());
                        }
                        assert (1 == io.getVersion()) : "IO version " + io.getVersion() + " is not supported by current defragmentation algorithm. Please implement copying of tree in a new format.";
                        BPlusIO<IndexRow> h2IO = DefragIndexFactory.wrap(io, oldRowHnd);
                        IndexRow row = (IndexRow)theTree.getRow(h2IO, pageAddr, idx);
                        if (row instanceof DefragIndexFactory.DefragIndexRowImpl) {
                            DefragIndexFactory.DefragIndexRowImpl r = (DefragIndexFactory.DefragIndexRowImpl)row;
                            CacheDataRow cacheDataRow = r.cacheDataRow();
                            int partition = cacheDataRow.partition();
                            long link = r.link();
                            LinkMap map = (LinkMap)mappingByPartition.get(partition);
                            long newLink = map.get(link);
                            DefragIndexFactory.DefragIndexRowImpl newRow = DefragIndexFactory.DefragIndexRowImpl.create(oldRowHnd, newLink, r, ((MvccIO)((Object)io)).storeMvccInfo());
                            newIdx.putIndexRow(newRow);
                        }
                        return true;
                    });
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t2) {
            newCtx.cacheObjectContext().kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t2));
            throw t2;
        }
        finally {
            cpLock.checkpointReadUnlock();
        }
    }

    private Collection<TableIndexes> tables(CacheGroupContext gctx) {
        ArrayList<TableIndexes> tables = new ArrayList<TableIndexes>();
        for (GridCacheContext cctx : gctx.caches()) {
            HashMap<String, TableIndexes> idxs = new HashMap<String, TableIndexes>();
            List<InlineIndex> indexes = this.indexing.treeIndexes(cctx.name(), false);
            for (InlineIndex idx : indexes) {
                String table = this.indexing.indexDefinition(idx.id()).idxName().tableName();
                idxs.putIfAbsent(table, new TableIndexes(cctx, table));
                ((TableIndexes)idxs.get(table)).addIndex(idx);
            }
            tables.addAll(idxs.values());
        }
        return tables;
    }

    private static class TableIndexes {
        @Nullable
        final String tableName;
        final GridCacheContext<?, ?> cctx;
        final List<InlineIndex> idxs = new ArrayList<InlineIndex>();

        TableIndexes(GridCacheContext<?, ?> cctx, String tableName) {
            this.cctx = cctx;
            this.tableName = tableName;
        }

        void addIndex(InlineIndex idx) {
            this.idxs.add(idx);
        }
    }
}

