/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.IndexRenameRootPageRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class DurableBackgroundCleanupIndexTreeTaskV2
extends IgniteDataTransferObject
implements DurableBackgroundTask<Long> {
    private static final long serialVersionUID = 0L;
    public static InlineIndexTreeFactory idxTreeFactory = new InlineIndexTreeFactory();
    @Nullable
    private volatile transient IgniteLogger log;
    private String uid;
    @Nullable
    private String grpName;
    private String cacheName;
    private String idxName;
    private String oldTreeName;
    private String newTreeName;
    private int segments;
    private volatile transient boolean needToRen;
    private final transient Map<Integer, RootPage> rootPages = new ConcurrentHashMap<Integer, RootPage>();
    @Nullable
    private volatile transient GridWorker worker;
    private final transient AtomicLong pageCnt = new AtomicLong();

    public DurableBackgroundCleanupIndexTreeTaskV2(@Nullable String grpName, String cacheName, String idxName, String oldTreeName, String newTreeName, int segments, @Nullable InlineIndexTree[] trees) {
        this.uid = UUID.randomUUID().toString();
        this.grpName = grpName;
        this.cacheName = cacheName;
        this.idxName = idxName;
        this.oldTreeName = oldTreeName;
        this.newTreeName = newTreeName;
        this.segments = segments;
        if (trees != null) {
            assert (trees.length == segments) : "Invalid number of index trees [trees=" + trees.length + ", segments=" + segments + ']';
            this.rootPages.putAll(DurableBackgroundCleanupIndexTreeTaskV2.toRootPages(trees));
        }
        this.needToRen = true;
    }

    public DurableBackgroundCleanupIndexTreeTaskV2() {
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeLongString(out, this.uid);
        U.writeLongString(out, this.grpName);
        U.writeLongString(out, this.cacheName);
        U.writeLongString(out, this.idxName);
        U.writeLongString(out, this.oldTreeName);
        U.writeLongString(out, this.newTreeName);
        out.writeInt(this.segments);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.uid = U.readLongString(in);
        this.grpName = U.readLongString(in);
        this.cacheName = U.readLongString(in);
        this.idxName = U.readLongString(in);
        this.oldTreeName = U.readLongString(in);
        this.newTreeName = U.readLongString(in);
        this.segments = in.readInt();
    }

    @Override
    public String name() {
        return "drop-sql-index-" + this.cacheName + "-" + this.idxName + "-" + this.uid;
    }

    @Override
    public void cancel() {
        this.rootPages.clear();
        GridWorker w = this.worker;
        if (w != null) {
            this.worker = null;
            U.awaitForWorkersStop(Collections.singleton(w), true, this.log);
        }
    }

    @Override
    public IgniteInternalFuture<DurableBackgroundTaskResult<Long>> executeAsync(GridKernalContext ctx) {
        IgniteInternalFuture<DurableBackgroundTaskResult<Long>> outFut;
        block8: {
            assert (this.worker == null);
            this.log = ctx.log(DurableBackgroundCleanupIndexTreeTaskV2.class);
            final CacheGroupContext grpCtx = ctx.cache().cacheGroup(CU.cacheGroupId(this.cacheName, this.grpName));
            if (grpCtx != null) {
                try {
                    if (this.needToRen) {
                        DurableBackgroundCleanupIndexTreeTaskV2.renameIndexRootPages(grpCtx, this.cacheName, this.oldTreeName, this.newTreeName, this.segments);
                        this.needToRen = false;
                    }
                    if (this.rootPages.isEmpty()) {
                        this.rootPages.putAll(DurableBackgroundCleanupIndexTreeTaskV2.findIndexRootPages(grpCtx, this.cacheName, this.newTreeName, this.segments));
                    }
                    if (!this.rootPages.isEmpty()) {
                        final GridFutureAdapter fut = new GridFutureAdapter();
                        GridWorker w = new GridWorker(ctx.igniteInstanceName(), "async-worker-" + this.name(), this.log){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void body() {
                                try {
                                    Iterator it = DurableBackgroundCleanupIndexTreeTaskV2.this.rootPages.entrySet().iterator();
                                    while (it.hasNext()) {
                                        Map.Entry e = it.next();
                                        RootPage rootPage = (RootPage)e.getValue();
                                        int segment = (Integer)e.getKey();
                                        long pages = DurableBackgroundCleanupIndexTreeTaskV2.destroyIndexTrees(grpCtx, rootPage, DurableBackgroundCleanupIndexTreeTaskV2.this.cacheName, DurableBackgroundCleanupIndexTreeTaskV2.this.newTreeName, segment);
                                        if (pages > 0L) {
                                            DurableBackgroundCleanupIndexTreeTaskV2.this.pageCnt.addAndGet(pages);
                                        }
                                        it.remove();
                                    }
                                    fut.onDone(DurableBackgroundTaskResult.complete(DurableBackgroundCleanupIndexTreeTaskV2.this.pageCnt.get()));
                                }
                                catch (Throwable t2) {
                                    fut.onDone(DurableBackgroundTaskResult.restart(t2));
                                }
                                finally {
                                    DurableBackgroundCleanupIndexTreeTaskV2.this.worker = null;
                                }
                            }
                        };
                        new IgniteThread(w).start();
                        this.worker = w;
                        outFut = fut;
                        break block8;
                    }
                    outFut = new GridFinishedFuture(DurableBackgroundTaskResult.complete());
                }
                catch (Throwable t2) {
                    outFut = new GridFinishedFuture(DurableBackgroundTaskResult.restart(t2));
                }
            } else {
                outFut = new GridFinishedFuture<DurableBackgroundTaskResult<Long>>(DurableBackgroundTaskResult.complete());
            }
        }
        return outFut;
    }

    public void renameIndexTrees(CacheGroupContext grpCtx) throws IgniteCheckedException {
        DurableBackgroundCleanupIndexTreeTaskV2.renameIndexRootPages(grpCtx, this.cacheName, this.oldTreeName, this.newTreeName, this.segments);
        this.needToRen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long destroyIndexTrees(CacheGroupContext grpCtx, RootPage rootPage, String cacheName, String treeName, int segment) throws IgniteCheckedException {
        long pageCnt = 0L;
        grpCtx.shared().database().checkpointReadLock();
        try {
            InlineIndexTree tree = idxTreeFactory.create(grpCtx, rootPage, treeName);
            pageCnt += tree.destroy(null, true);
            if (grpCtx.offheap().dropRootPageForIndex(CU.cacheId(cacheName), treeName, segment) != null) {
                ++pageCnt;
            }
        }
        finally {
            grpCtx.shared().database().checkpointReadUnlock();
        }
        return pageCnt;
    }

    public static Map<Integer, RootPage> findIndexRootPages(CacheGroupContext grpCtx, String cacheName, String treeName, int segments) throws IgniteCheckedException {
        HashMap<Integer, RootPage> rootPages = new HashMap<Integer, RootPage>();
        for (int i = 0; i < segments; ++i) {
            RootPage rootPage = grpCtx.offheap().findRootPageForIndex(CU.cacheId(cacheName), treeName, i);
            if (rootPage == null) continue;
            rootPages.put(i, rootPage);
        }
        return rootPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameIndexRootPages(CacheGroupContext grpCtx, String cacheName, String oldTreeName, String newTreeName, int segments) throws IgniteCheckedException {
        IgniteWriteAheadLogManager wal = grpCtx.shared().wal();
        int cacheId = CU.cacheId(cacheName);
        if (wal != null) {
            wal.log(new IndexRenameRootPageRecord(cacheId, oldTreeName, newTreeName, segments));
        }
        grpCtx.shared().database().checkpointReadLock();
        try {
            for (int i = 0; i < segments; ++i) {
                grpCtx.offheap().renameRootPageForIndex(cacheId, oldTreeName, newTreeName, i);
            }
        }
        finally {
            grpCtx.shared().database().checkpointReadUnlock();
        }
    }

    public static Map<Integer, RootPage> toRootPages(InlineIndexTree[] trees) {
        if (F.isEmpty(trees)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, RootPage> res = new HashMap<Integer, RootPage>();
        for (int i = 0; i < trees.length; ++i) {
            InlineIndexTree tree = trees[i];
            assert (tree != null) : "No tree for segment: " + i;
            res.put(i, new RootPage(new FullPageId(tree.getMetaPageId(), tree.groupId()), tree.created()));
        }
        return res;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String idxName() {
        return this.idxName;
    }

    public boolean needToRename() {
        return this.needToRen;
    }

    public String toString() {
        return S.toString(DurableBackgroundCleanupIndexTreeTaskV2.class, this);
    }

    public static class InlineIndexTreeFactory {
        protected InlineIndexTree create(CacheGroupContext grpCtx, RootPage rootPage, String treeName) throws IgniteCheckedException {
            return new InlineIndexTree(null, grpCtx, treeName, grpCtx.offheap(), grpCtx.offheap().reuseListForIndex(treeName), grpCtx.dataRegion().pageMemory(), PageIoResolver.DEFAULT_PAGE_IO_RESOLVER, rootPage.pageId().pageId(), false, 0, 0, new IndexKeyTypeSettings(), null, null, new NoopRowHandlerFactory(), null);
        }
    }

    public static class NoopRowHandlerFactory
    implements InlineIndexRowHandlerFactory {
        @Override
        public InlineIndexRowHandler create(SortedIndexDefinition sdef, IndexKeyTypeSettings keyTypeSettings) {
            return new InlineIndexRowHandler(){

                @Override
                public IndexKey indexKey(int idx, CacheDataRow row) {
                    return null;
                }

                @Override
                public List<InlineIndexKeyType> inlineIndexKeyTypes() {
                    return Collections.emptyList();
                }

                @Override
                public List<IndexKeyDefinition> indexKeyDefinitions() {
                    return Collections.emptyList();
                }

                @Override
                public IndexKeyTypeSettings indexKeyTypeSettings() {
                    return null;
                }

                @Override
                public int partition(CacheDataRow row) {
                    return 0;
                }

                @Override
                public Object cacheKey(CacheDataRow row) {
                    return null;
                }

                @Override
                public Object cacheValue(CacheDataRow row) {
                    return null;
                }
            };
        }
    }
}

