/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.JdbcDynamicFilteringConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public class JdbcDynamicFilteringSessionProperties
implements SessionPropertiesProvider {
    public static final String DYNAMIC_FILTERING_ENABLED = "dynamic_filtering_enabled";
    public static final String DYNAMIC_FILTERING_WAIT_TIMEOUT = "dynamic_filtering_wait_timeout";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public JdbcDynamicFilteringSessionProperties(JdbcDynamicFilteringConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)DYNAMIC_FILTERING_ENABLED, (String)"Wait for dynamic filters before starting JDBC query", (Boolean)config.isDynamicFilteringEnabled(), (boolean)false), (Object)PropertyMetadataUtil.durationProperty((String)DYNAMIC_FILTERING_WAIT_TIMEOUT, (String)"Duration to wait for completion of dynamic filters", (Duration)config.getDynamicFilteringWaitTimeout(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean dynamicFilteringEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(DYNAMIC_FILTERING_ENABLED, Boolean.class);
    }

    public static Duration getDynamicFilteringWaitTimeout(ConnectorSession session) {
        return (Duration)session.getProperty(DYNAMIC_FILTERING_WAIT_TIMEOUT, Duration.class);
    }
}

