/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.inject.Inject;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import java.util.Objects;

public class ClassLoaderSafeEventListener
implements EventListener {
    private final EventListener delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeEventListener(@ForClassLoaderSafe EventListener delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.queryCreated(queryCreatedEvent);
        }
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.queryCompleted(queryCompletedEvent);
        }
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.splitCompleted(splitCompletedEvent);
        }
    }

    public boolean requiresAnonymizedPlan() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.requiresAnonymizedPlan();
            return bl;
        }
    }
}

