/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.client;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.mxbean.ClientProcessorMXBean;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorClientConnectionDropTask
extends VisorMultiNodeTask<Long, Void, Boolean> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<Long, Boolean> job(Long arg) {
        return new VisorClientConnectionDropJob(arg, this.debug);
    }

    @Override
    protected Void reduce0(List<ComputeJobResult> results) throws IgniteException {
        boolean res = false;
        for (ComputeJobResult jobRes : results) {
            if (jobRes.getException() != null) {
                throw jobRes.getException();
            }
            res |= ((Boolean)jobRes.getData()).booleanValue();
        }
        if (!res) {
            throw new IgniteException("No connection was dropped");
        }
        return null;
    }

    private static class VisorClientConnectionDropJob
    extends VisorJob<Long, Boolean> {
        private static final long serialVersionUID = 0L;

        protected VisorClientConnectionDropJob(@Nullable Long arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Boolean run(@Nullable Long arg) throws IgniteException {
            ClientProcessorMXBean bean = this.ignite.context().clientListener().mxBean();
            if (arg != null) {
                return bean.dropConnection(arg);
            }
            bean.dropAllConnections();
            return true;
        }
    }
}

