/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionMapping;
import org.jetbrains.annotations.Nullable;

class ClientCachePartitionAwarenessGroup {
    @Nullable
    private final ClientCachePartitionMapping mapping;
    private final boolean dfltAffinity;
    private final Map<Integer, CacheConfiguration<?, ?>> cacheCfgs = new HashMap();

    public ClientCachePartitionAwarenessGroup(@Nullable ClientCachePartitionMapping mapping, boolean dfltAffinity) {
        this.mapping = mapping;
        this.dfltAffinity = dfltAffinity;
    }

    public void write(CacheObjectBinaryProcessorImpl proc, BinaryRawWriter writer, ClientProtocolContext cpctx) {
        writer.writeBoolean(this.mapping != null);
        writer.writeInt(this.cacheCfgs.size());
        for (Map.Entry<Integer, CacheConfiguration<?, ?>> entry : this.cacheCfgs.entrySet()) {
            writer.writeInt(entry.getKey());
            if (this.mapping == null) continue;
            CacheConfiguration<?, ?> ccfg = entry.getValue();
            CacheKeyConfiguration[] keyCfgs = ccfg.getKeyConfiguration();
            if (keyCfgs == null) {
                writer.writeInt(0);
                continue;
            }
            writer.writeInt(keyCfgs.length);
            for (CacheKeyConfiguration keyCfg : keyCfgs) {
                int keyTypeId = proc.typeId(keyCfg.getTypeName());
                int affinityKeyFieldId = proc.binaryContext().fieldId(keyTypeId, keyCfg.getAffinityKeyFieldName());
                writer.writeInt(keyTypeId);
                writer.writeInt(affinityKeyFieldId);
            }
        }
        if (this.mapping != null) {
            this.mapping.write(writer);
        }
        if (cpctx.isFeatureSupported(ClientBitmaskFeature.ALL_AFFINITY_MAPPINGS)) {
            writer.writeBoolean(this.dfltAffinity);
        }
    }

    public void addAll(List<DynamicCacheDescriptor> descs) {
        for (DynamicCacheDescriptor desc : descs) {
            this.cacheCfgs.putIfAbsent(desc.cacheId(), desc.cacheConfiguration());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCachePartitionAwarenessGroup group = (ClientCachePartitionAwarenessGroup)o;
        return this.dfltAffinity == group.dfltAffinity && Objects.equals(this.mapping, group.mapping);
    }

    public int hashCode() {
        return Objects.hash(this.mapping, this.dfltAffinity);
    }
}

