/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class GridCacheSharedTtlCleanupManager
extends GridCacheSharedManagerAdapter {
    private static final long CLEANUP_WORKER_SLEEP_INTERVAL = 500L;
    private static final int CLEANUP_WORKER_ENTRIES_PROCESS_LIMIT = 1000;
    private CleanupWorker cleanupWorker;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Integer, GridCacheTtlManager> mgrs = new ConcurrentHashMap<Integer, GridCacheTtlManager>();

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.stopCleanupWorker();
    }

    public void register(GridCacheTtlManager mgr) {
        if (this.mgrs.isEmpty()) {
            this.startCleanupWorker();
        }
        this.mgrs.put(mgr.context().cacheId(), mgr);
    }

    public void unregister(GridCacheTtlManager mgr) {
        this.mgrs.remove(mgr.context().cacheId());
        if (this.mgrs.isEmpty()) {
            this.stopCleanupWorker();
        }
    }

    public boolean eagerTtlEnabled() {
        assert (this.cctx != null) : "Manager is not started";
        this.lock.lock();
        try {
            boolean bl = this.cleanupWorker != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startCleanupWorker() {
        this.lock.lock();
        try {
            if (this.cleanupWorker != null) {
                return;
            }
            this.cleanupWorker = new CleanupWorker();
            new IgniteThread(this.cleanupWorker).start();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopCleanupWorker() {
        this.lock.lock();
        try {
            if (null != this.cleanupWorker) {
                U.cancel(this.cleanupWorker);
                U.join(this.cleanupWorker, this.log);
                this.cleanupWorker = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static /* synthetic */ Map access$000(GridCacheSharedTtlCleanupManager x0) {
        return x0.mgrs;
    }

    private class CleanupWorker
    extends GridWorker {
        CleanupWorker() {
            super(GridCacheSharedTtlCleanupManager.this.cctx.igniteInstanceName(), "ttl-cleanup-worker", GridCacheSharedTtlCleanupManager.this.cctx.logger(GridCacheSharedTtlCleanupManager.class), GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().workersRegistry());
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ GridCacheTtlManager lambda$body$0(AtomicBoolean expiredRemains, Integer id, GridCacheTtlManager m) {
            if (m.expire(1000)) {
                expiredRemains.set(true);
            }
            return m;
        }
    }
}

