/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.BaselineChangedEvent;
import org.apache.ignite.events.ClusterActivationEvent;
import org.apache.ignite.events.ClusterStateChangeEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.DiscoveryLocalJoinData;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.FetchActiveTxOwnerTraceClosure;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheExplicitLockSpan;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.PendingDiscoveryEvent;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.WalStateNodeLeaveExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.FinishPreloadingTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.ForceRebalanceExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandLegacyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemander;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionHistorySuppliersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionsToReloadMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.RebalanceReassignExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.StopCachesOnClientReconnectExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch.ExchangeLatchManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridClientPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.BooleanMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.query.schema.SchemaNodeLeaveExchangeWorkerTask;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanTags;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.GridListSet;
import org.apache.ignite.internal.util.GridPartitionStateMap;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCachePartitionExchangeManager<K, V>
extends GridCacheSharedManagerAdapter<K, V> {
    public static final String FAILED_DUMP_MSG = "Failed to dump debug information: ";
    public static final int DFLT_EXCHANGE_HISTORY_SIZE = 1000;
    public static final int DFLT_EXCHANGE_MERGE_DELAY = 0;
    public static final int DFLT_DIAGNOSTIC_WARN_LIMIT = 10;
    private final int EXCHANGE_HISTORY_SIZE = IgniteSystemProperties.getInteger("IGNITE_EXCHANGE_HISTORY_SIZE", 1000);
    private final long IGNITE_EXCHANGE_MERGE_DELAY = IgniteSystemProperties.getLong("IGNITE_EXCHANGE_MERGE_DELAY", 0L);
    private final int DIAGNOSTIC_WARN_LIMIT = IgniteSystemProperties.getInteger("IGNITE_DIAGNOSTIC_WARN_LIMIT", 10);
    private static final IgniteProductVersion EXCHANGE_PROTOCOL_2_SINCE = IgniteProductVersion.fromString("2.1.4");
    private AtomicReference<ResendTimeoutObject> pendingResend = new AtomicReference();
    private final long partResendTimeout = IgniteSystemProperties.getLong("IGNITE_PRELOAD_RESEND_TIMEOUT", 1500L);
    private final ReadWriteLock busyLock = new ReentrantReadWriteLock();
    private final AtomicLong lastRefresh = new AtomicLong(-1L);
    private final ActionLimiter<IgniteInternalTx> ltrDumpLimiter = new ActionLimiter(1);
    @GridToStringInclude
    private ExchangeWorker exchWorker;
    @GridToStringExclude
    private final ConcurrentMap<Integer, GridClientPartitionTopology> clientTops = new ConcurrentHashMap<Integer, GridClientPartitionTopology>();
    @Nullable
    private volatile GridDhtPartitionsExchangeFuture lastInitializedFut;
    private final AtomicReference<GridDhtPartitionsExchangeFuture> lastFinishedFut = new AtomicReference();
    private final ConcurrentMap<AffinityTopologyVersion, AffinityReadyFuture> readyFuts = new ConcurrentSkipListMap<AffinityTopologyVersion, AffinityReadyFuture>();
    private final ConcurrentNavigableMap<AffinityTopologyVersion, AffinityTopologyVersion> lastAffTopVers = new ConcurrentSkipListMap<AffinityTopologyVersion, AffinityTopologyVersion>();
    private GridFutureAdapter<?> reconnectExchangeFut;
    private ExchangeFutureSet exchFuts = new ExchangeFutureSet(this.EXCHANGE_HISTORY_SIZE);
    private volatile IgniteCheckedException stopErr;
    private long nextLongRunningOpsDumpTime;
    private int longRunningOpsDumpStep;
    private final List<PendingDiscoveryEvent> pendingEvts = new ArrayList<PendingDiscoveryEvent>();
    private final GridFutureAdapter<?> crdInitFut = new GridFutureAdapter();
    private volatile AffinityTopologyVersion exchMergeTestWaitVer;
    private volatile List mergedEvtsForTest;
    private ExchangeLatchManager latchMgr;
    private final List<PartitionsExchangeAware> exchangeAwareComps = new CopyOnWriteArrayList<PartitionsExchangeAware>();
    private volatile HistogramMetricImpl durationHistogram;
    private volatile HistogramMetricImpl blockingDurationHistogram;
    private volatile BooleanMetricImpl rebalanced;
    private final ReentrantLock dumpLongRunningOpsLock = new ReentrantLock();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final DiscoveryEventListener discoLsnr = new DiscoveryEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(DiscoveryEvent evt, DiscoCache cache) {
            if (!GridCachePartitionExchangeManager.this.enterBusy()) {
                return;
            }
            try {
                if (evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof ChangeGlobalStateMessage) {
                    ChangeGlobalStateMessage stateChangeMsg = (ChangeGlobalStateMessage)((DiscoveryCustomEvent)evt).customMessage();
                    if (stateChangeMsg.exchangeActions() == null) {
                        return;
                    }
                    GridCachePartitionExchangeManager.this.onDiscoveryEvent(evt, cache);
                    return;
                }
                if (evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof ChangeGlobalStateFinishMessage) {
                    ChangeGlobalStateFinishMessage stateFinishMsg = (ChangeGlobalStateFinishMessage)((DiscoveryCustomEvent)evt).customMessage();
                    if (stateFinishMsg.clusterActive()) {
                        for (PendingDiscoveryEvent pendingEvt : GridCachePartitionExchangeManager.this.pendingEvts) {
                            if (GridCachePartitionExchangeManager.this.log.isDebugEnabled()) {
                                GridCachePartitionExchangeManager.this.log.debug("Process pending event: " + pendingEvt.event());
                            }
                            GridCachePartitionExchangeManager.this.onDiscoveryEvent(pendingEvt.event(), pendingEvt.discoCache());
                        }
                    } else {
                        for (PendingDiscoveryEvent pendingEvt : GridCachePartitionExchangeManager.this.pendingEvts) {
                            GridCachePartitionExchangeManager.this.processEventInactive(pendingEvt.event(), pendingEvt.discoCache());
                        }
                    }
                    GridCachePartitionExchangeManager.this.pendingEvts.clear();
                    return;
                }
                if (cache.state().transition() && (evt.type() == 11 || evt.type() == 10 || evt.type() == 12)) {
                    if (GridCachePartitionExchangeManager.this.log.isDebugEnabled()) {
                        GridCachePartitionExchangeManager.this.log.debug("Adding pending event: " + evt);
                    }
                    GridCachePartitionExchangeManager.this.pendingEvts.add(new PendingDiscoveryEvent(evt, cache));
                } else if (cache.state().active()) {
                    GridCachePartitionExchangeManager.this.onDiscoveryEvent(evt, cache);
                } else {
                    GridCachePartitionExchangeManager.this.processEventInactive(evt, cache);
                }
                GridCachePartitionExchangeManager.this.notifyNodeFail(evt);
            }
            finally {
                GridCachePartitionExchangeManager.this.leaveBusy();
            }
        }
    };

    private void notifyNodeFail(DiscoveryEvent evt) {
        if (evt.type() == 11 || evt.type() == 12) {
            ClusterNode n = evt.eventNode();
            assert (this.cctx.discovery().node(n.id()) == null);
            for (GridDhtPartitionsExchangeFuture f : this.exchFuts.values()) {
                f.onNodeLeft(n);
            }
        }
    }

    private void processEventInactive(DiscoveryEvent evt, DiscoCache cache) {
        this.cctx.cache().localJoinCachesContext();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignore event, cluster is inactive: " + evt);
        }
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.exchWorker = new ExchangeWorker();
        this.latchMgr = new ExchangeLatchManager(this.cctx.kernalContext());
        this.cctx.gridEvents().addDiscoveryEventListener(this.discoLsnr, 10, 11, 12, 18);
        this.cctx.io().addCacheHandler(GridDhtPartitionsSingleMessage.class, new MessageHandler<GridDhtPartitionsSingleMessage>(){

            @Override
            public void onMessage(final ClusterNode node, final GridDhtPartitionsSingleMessage msg) {
                GridDhtPartitionExchangeId exchangeId = msg.exchangeId();
                if (exchangeId != null) {
                    GridDhtPartitionsExchangeFuture fut = GridCachePartitionExchangeManager.this.exchangeFuture(exchangeId);
                    boolean fastReplied = fut.fastReplyOnSingleMessage(node, msg);
                    if (fastReplied) {
                        if (GridCachePartitionExchangeManager.this.log.isInfoEnabled()) {
                            GridCachePartitionExchangeManager.this.log.info("Fast replied to single message [exchId=" + exchangeId + ", nodeId=" + node.id() + "]");
                        }
                        return;
                    }
                } else {
                    GridDhtPartitionsExchangeFuture cur = GridCachePartitionExchangeManager.this.lastTopologyFuture();
                    if (!cur.isDone() && cur.changedAffinity() && !msg.restoreState()) {
                        cur.listen(new IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>(){

                            @Override
                            public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                                if (fut.error() == null) {
                                    GridCachePartitionExchangeManager.this.processSinglePartitionUpdate(node, msg);
                                }
                            }
                        });
                        return;
                    }
                }
                GridCachePartitionExchangeManager.this.processSinglePartitionUpdate(node, msg);
            }
        });
        this.cctx.io().addCacheHandler(GridDhtPartitionsFullMessage.class, new MessageHandler<GridDhtPartitionsFullMessage>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtPartitionsFullMessage msg) {
                GridDhtPartitionsExchangeFuture currentExchange;
                if (msg.exchangeId() == null && (currentExchange = GridCachePartitionExchangeManager.this.lastTopologyFuture()) != null && currentExchange.addOrMergeDelayedFullMessage(node, msg)) {
                    if (GridCachePartitionExchangeManager.this.log.isInfoEnabled()) {
                        GridCachePartitionExchangeManager.this.log.info("Delay process full message without exchange id (there is exchange in progress) [nodeId=" + node.id() + "]");
                    }
                    return;
                }
                GridCachePartitionExchangeManager.this.processFullPartitionUpdate(node, msg);
            }
        });
        this.cctx.io().addCacheHandler(GridDhtPartitionsSingleRequest.class, new MessageHandler<GridDhtPartitionsSingleRequest>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtPartitionsSingleRequest msg) {
                GridCachePartitionExchangeManager.this.processSinglePartitionRequest(node, msg);
            }
        });
        if (!this.cctx.kernalContext().clientNode()) {
            for (int cnt = 0; cnt < this.cctx.gridConfig().getRebalanceThreadPoolSize(); ++cnt) {
                final int idx = cnt;
                this.cctx.io().addOrderedCacheGroupHandler(this.cctx, GridCachePartitionExchangeManager.rebalanceTopic(cnt), (IgniteBiInClosure<UUID, ? extends GridCacheGroupIdMessage>)new CI2<UUID, GridCacheGroupIdMessage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void apply(UUID id, GridCacheGroupIdMessage m) {
                        if (!GridCachePartitionExchangeManager.this.enterBusy()) {
                            return;
                        }
                        try {
                            CacheGroupContext grp = GridCachePartitionExchangeManager.this.cctx.cache().cacheGroup(m.groupId());
                            if (grp != null) {
                                if (m instanceof GridDhtPartitionSupplyMessage) {
                                    grp.preloader().handleSupplyMessage(id, (GridDhtPartitionSupplyMessage)m);
                                    return;
                                }
                                if (m instanceof GridDhtPartitionDemandMessage) {
                                    grp.preloader().handleDemandMessage(idx, id, (GridDhtPartitionDemandMessage)m);
                                    return;
                                }
                                if (m instanceof GridDhtPartitionDemandLegacyMessage) {
                                    grp.preloader().handleDemandMessage(idx, id, new GridDhtPartitionDemandMessage((GridDhtPartitionDemandLegacyMessage)m));
                                    return;
                                }
                                U.error(GridCachePartitionExchangeManager.this.log, "Unsupported message type: " + m.getClass().getName());
                            }
                            U.warn(GridCachePartitionExchangeManager.this.log, "Cache group with id=" + m.groupId() + " is stopped or absent");
                        }
                        finally {
                            GridCachePartitionExchangeManager.this.leaveBusy();
                        }
                    }
                });
            }
        }
        MetricRegistry mreg = this.cctx.kernalContext().metric().registry("pme");
        mreg.register("Duration", () -> this.currentPMEDuration(false), "Current PME duration in milliseconds.");
        mreg.register("CacheOperationsBlockedDuration", () -> this.currentPMEDuration(true), "Current PME cache operations blocked duration in milliseconds.");
        this.durationHistogram = (HistogramMetricImpl)mreg.findMetric("DurationHistogram");
        this.blockingDurationHistogram = (HistogramMetricImpl)mreg.findMetric("CacheOperationsBlockedDurationHistogram");
        MetricRegistry clusterReg = this.cctx.kernalContext().metric().registry("cluster");
        this.rebalanced = clusterReg.booleanMetric("Rebalanced", "True if the cluster has fully achieved rebalanced state. Note that an inactive cluster always has this metric in False regardless of the real partitions state.");
        this.startLatch.countDown();
    }

    public void onCoordinatorInitialized() {
        this.crdInitFut.onDone();
    }

    public void onLocalJoin(DiscoveryEvent evt, DiscoCache cache) {
        this.discoLsnr.onEvent(evt, cache);
    }

    private void onDiscoveryEvent(DiscoveryEvent evt, DiscoCache cache) {
        ClusterNode loc = this.cctx.localNode();
        assert (evt.type() == 10 || evt.type() == 11 || evt.type() == 12 || evt.type() == 18);
        ClusterNode n = evt.eventNode();
        GridDhtPartitionExchangeId exchId = null;
        GridDhtPartitionsExchangeFuture exchFut = null;
        if (evt.type() != 18) {
            LocalJoinCachesContext locJoinCtx;
            boolean locJoin;
            assert (evt.type() != 10 || n.isLocal() || n.order() > loc.order()) : "Node joined with smaller-than-local order [newOrder=" + n.order() + ", locOrder=" + loc.order() + ", evt=" + evt + ']';
            exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
            ExchangeActions exchActs = null;
            boolean bl = locJoin = evt.type() == 10 && evt.eventNode().isLocal();
            if (locJoin && (locJoinCtx = this.cctx.cache().localJoinCachesContext()) != null) {
                exchActs = new ExchangeActions();
                exchActs.localJoinContext(locJoinCtx);
            }
            if (!n.isClient()) {
                exchActs = this.cctx.kernalContext().state().autoAdjustExchangeActions(exchActs);
            }
            exchFut = this.exchangeFuture(exchId, evt, cache, exchActs, null);
        } else {
            DiscoveryCustomMessage customMsg = ((DiscoveryCustomEvent)evt).customMessage();
            if (customMsg instanceof ChangeGlobalStateMessage) {
                ChangeGlobalStateMessage stateChangeMsg = (ChangeGlobalStateMessage)customMsg;
                ExchangeActions exchActions = stateChangeMsg.exchangeActions();
                if (exchActions != null) {
                    boolean baselineChanging;
                    exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                    exchFut = this.exchangeFuture(exchId, evt, cache, exchActions, null);
                    if (stateChangeMsg.forceChangeBaselineTopology()) {
                        baselineChanging = true;
                    } else {
                        DiscoveryDataClusterState state = this.cctx.kernalContext().state().clusterState();
                        assert (state.transition()) : state;
                        baselineChanging = exchActions.changedBaseline() || state.state() != ClusterState.INACTIVE && !state.previouslyActive() && state.previousBaselineTopology() == null;
                    }
                    exchFut.listen(f -> this.onClusterStateChangeFinish((IgniteInternalFuture<AffinityTopologyVersion>)f, exchActions, baselineChanging));
                }
            } else if (customMsg instanceof DynamicCacheChangeBatch) {
                DynamicCacheChangeBatch batch = (DynamicCacheChangeBatch)customMsg;
                ExchangeActions exchActions = batch.exchangeActions();
                if (exchActions != null) {
                    exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                    exchFut = this.exchangeFuture(exchId, evt, cache, exchActions, null);
                }
            } else if (customMsg instanceof CacheAffinityChangeMessage) {
                CacheAffinityChangeMessage msg = (CacheAffinityChangeMessage)customMsg;
                if (msg.exchangeId() == null) {
                    if (msg.exchangeNeeded()) {
                        exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                        exchFut = this.exchangeFuture(exchId, evt, cache, null, msg);
                    }
                } else if (msg.exchangeId().topologyVersion().topologyVersion() >= this.cctx.discovery().localJoinEvent().topologyVersion()) {
                    this.exchangeFuture(msg.exchangeId(), null, null, null, null).onAffinityChangeMessage(evt.eventNode(), msg);
                }
            } else if (customMsg instanceof DynamicCacheChangeFailureMessage) {
                DynamicCacheChangeFailureMessage msg = (DynamicCacheChangeFailureMessage)customMsg;
                if (msg.exchangeId().topologyVersion().topologyVersion() >= this.affinityTopologyVersion(this.cctx.discovery().localJoinEvent()).topologyVersion()) {
                    this.exchangeFuture(msg.exchangeId(), null, null, null, null).onDynamicCacheChangeFail(evt.eventNode(), msg);
                }
            } else if (customMsg instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)customMsg).needExchange()) {
                exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                exchFut = this.exchangeFuture(exchId, evt, null, null, null);
            } else if (customMsg instanceof WalStateAbstractMessage && ((WalStateAbstractMessage)customMsg).needExchange()) {
                exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                exchFut = this.exchangeFuture(exchId, evt, null, null, null);
            } else {
                CachePartitionExchangeWorkerTask task = this.cctx.cache().exchangeTaskForCustomDiscoveryMessage(customMsg);
                if (task != null) {
                    this.exchWorker.addCustomTask(task);
                }
            }
        }
        if (exchId != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Discovery event (will start exchange): " + exchId);
            }
            exchFut.onEvent(exchId, evt, cache);
            Span span = this.cctx.kernalContext().tracing().create(SpanType.EXCHANGE_FUTURE, evt.span());
            if (exchId != null) {
                GridDhtPartitionExchangeId exchIdf = exchId;
                span.addTag(SpanTags.tag(SpanTags.EVENT_NODE, "id"), () -> evt.eventNode().id().toString());
                span.addTag(SpanTags.tag(SpanTags.EVENT_NODE, "consistent.id"), () -> evt.eventNode().consistentId().toString());
                span.addTag(SpanTags.tag("event", "type"), () -> String.valueOf(evt.type()));
                span.addTag(SpanTags.tag("exchange", "id"), () -> String.valueOf(exchIdf.toString()));
                span.addTag(SpanTags.tag("initial", "topology.version", "major"), () -> String.valueOf(exchIdf.topologyVersion().topologyVersion()));
                span.addTag(SpanTags.tag("initial", "topology.version", "minor"), () -> String.valueOf(exchIdf.topologyVersion().minorTopologyVersion()));
            }
            span.addTag(SpanTags.NODE_ID, () -> this.cctx.localNodeId().toString());
            span.addLog(() -> "Created");
            exchFut.span(span);
            this.addFuture(exchFut);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Do not start exchange for discovery event: " + evt);
        }
        this.notifyNodeFail(evt);
        if (evt.type() == 11 || evt.type() == 12) {
            SecurityContext secCtx = SecurityUtils.remoteSecurityContext(this.cctx.kernalContext());
            this.exchWorker.addCustomTask(new SchemaNodeLeaveExchangeWorkerTask(secCtx, evt.eventNode()));
            this.exchWorker.addCustomTask(new WalStateNodeLeaveExchangeTask(secCtx, evt.eventNode()));
        }
    }

    private void onClusterStateChangeFinish(IgniteInternalFuture<AffinityTopologyVersion> fut, ExchangeActions exchActions, boolean baselineChanging) {
        A.notNull(exchActions, "exchActions");
        GridEventStorageManager evtMngr = this.cctx.kernalContext().event();
        if (exchActions.activate() && evtMngr.isRecordable(140) || exchActions.deactivate() && evtMngr.isRecordable(141) || exchActions.changedClusterState() && evtMngr.isRecordable(144)) {
            ArrayList<EventAdapter> evts = new ArrayList<EventAdapter>(2);
            ClusterNode locNode = this.cctx.kernalContext().discovery().localNode();
            Collection<BaselineNode> bltNodes = this.cctx.kernalContext().cluster().get().currentBaselineTopology();
            boolean collectionUsed = false;
            if (exchActions.activate() && evtMngr.isRecordable(140)) {
                assert (!exchActions.deactivate()) : exchActions;
                collectionUsed = true;
                evts.add(new ClusterActivationEvent(locNode, "Cluster activated.", 140, bltNodes));
            }
            if (exchActions.deactivate() && evtMngr.isRecordable(141)) {
                assert (!exchActions.activate()) : exchActions;
                collectionUsed = true;
                evts.add(new ClusterActivationEvent(locNode, "Cluster deactivated.", 141, bltNodes));
            }
            if (exchActions.changedClusterState() && evtMngr.isRecordable(144)) {
                StateChangeRequest req = exchActions.stateChangeRequest();
                if (collectionUsed && bltNodes != null) {
                    bltNodes = new ArrayList<BaselineNode>(bltNodes);
                }
                evts.add(new ClusterStateChangeEvent(req.prevState(), req.state(), bltNodes, locNode, "Cluster state changed."));
            }
            A.notEmpty(evts, "events " + exchActions);
            this.cctx.kernalContext().pools().getSystemExecutorService().submit(() -> evts.forEach(e -> this.cctx.kernalContext().event().record((Event)e)));
        }
        final GridKernalContext ctx = this.cctx.kernalContext();
        DiscoveryDataClusterState state = ctx.state().clusterState();
        if (baselineChanging) {
            ctx.pools().getStripedExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    if (ctx.event().isRecordable(146)) {
                        ctx.event().record(new BaselineChangedEvent(ctx.discovery().localNode(), "Baseline changed.", 146, ctx.cluster().get().currentBaselineTopology()));
                    }
                }
            });
        }
    }

    void addCustomTask(CachePartitionExchangeWorkerTask task) {
        assert (task != null);
        this.exchWorker.addCustomTask(task);
    }

    public IgniteInternalFuture<?> reconnectExchangeFuture() {
        return this.reconnectExchangeFut;
    }

    private GridDhtPartitionExchangeId initialExchangeId() {
        DiscoveryEvent discoEvt = this.cctx.discovery().localJoinEvent();
        assert (discoEvt != null);
        AffinityTopologyVersion startTopVer = this.affinityTopologyVersion(discoEvt);
        assert (discoEvt.topologyVersion() == startTopVer.topologyVersion());
        return this.exchangeId(this.cctx.localNode().id(), startTopVer, discoEvt);
    }

    public AffinityTopologyVersion onKernalStart(boolean active, boolean reconnect) throws IgniteCheckedException {
        for (ClusterNode n : this.cctx.discovery().remoteNodes()) {
            this.cctx.versions().onReceived(n.id(), n.metrics().getLastDataVersion());
        }
        DiscoveryLocalJoinData locJoin = this.cctx.discovery().localJoin();
        GridDhtPartitionsExchangeFuture fut = null;
        if (reconnect) {
            this.reconnectExchangeFut = new GridFutureAdapter();
        }
        if (active) {
            DiscoveryEvent discoEvt = locJoin.event();
            DiscoCache discoCache = locJoin.discoCache();
            GridDhtPartitionExchangeId exchId = this.initialExchangeId();
            fut = this.exchangeFuture(exchId, reconnect ? null : discoEvt, reconnect ? null : discoCache, null, null);
        } else if (reconnect) {
            this.reconnectExchangeFut.onDone();
        }
        new IgniteThread(this.cctx.igniteInstanceName(), "exchange-worker", this.exchWorker).start();
        if (reconnect) {
            if (fut != null) {
                fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            fut.get();
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                grp.preloader().onInitialExchangeComplete(null);
                            }
                            GridCachePartitionExchangeManager.this.reconnectExchangeFut.onDone();
                        }
                        catch (IgniteCheckedException e) {
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                grp.preloader().onInitialExchangeComplete(e);
                            }
                            GridCachePartitionExchangeManager.this.reconnectExchangeFut.onDone(e);
                        }
                    }
                });
            }
        } else if (fut != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Beginning to wait on local exchange future: " + fut);
            }
            boolean first = true;
            while (true) {
                try {
                    fut.get(this.cctx.preloadExchangeTimeout());
                }
                catch (IgniteFutureTimeoutCheckedException ignored) {
                    if (first) {
                        U.warn(this.log, "Failed to wait for initial partition map exchange. Possible reasons are: " + U.nl() + "  ^-- Transactions in deadlock." + U.nl() + "  ^-- Long running transactions (ignore if this is the case)." + U.nl() + "  ^-- Unreleased explicit locks.");
                        first = false;
                        continue;
                    }
                    U.warn(this.log, "Still waiting for initial partition map exchange [fut=" + fut + ']');
                    continue;
                }
                catch (IgniteNeedReconnectException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (fut.reconnectOnError(e)) {
                        throw new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e);
                    }
                    throw e;
                }
                break;
            }
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (!locJoin.joinTopologyVersion().equals(grp.localStartVersion())) continue;
                grp.preloader().onInitialExchangeComplete(null);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished waiting for initial exchange: " + fut.exchangeId());
            }
            return fut.initialVersion();
        }
        return AffinityTopologyVersion.NONE;
    }

    public static int exchangeProtocolVersion(IgniteProductVersion ver) {
        if (ver.compareToIgnoreTimestamp(EXCHANGE_PROTOCOL_2_SINCE) >= 0) {
            return 2;
        }
        return 1;
    }

    public static Object rebalanceTopic(int idx) {
        return GridTopic.TOPIC_CACHE.topic("Rebalance", (long)idx);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        ResendTimeoutObject resendTimeoutObject;
        this.exchWorker.onKernalStop();
        this.cctx.gridEvents().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
        this.cctx.io().removeHandler(false, 0, GridDhtPartitionsSingleMessage.class);
        this.cctx.io().removeHandler(false, 0, GridDhtPartitionsFullMessage.class);
        this.cctx.io().removeHandler(false, 0, GridDhtPartitionsSingleRequest.class);
        this.stopErr = this.cctx.kernalContext().clientDisconnected() ? new IgniteClientDisconnectedCheckedException(this.cctx.kernalContext().cluster().clientReconnectFuture(), "Client node disconnected: " + this.cctx.igniteInstanceName()) : new NodeStoppingException("Node is stopping: " + this.cctx.igniteInstanceName());
        U.cancel(this.exchWorker);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Before joining on exchange worker: " + this.exchWorker);
        }
        U.join(this.exchWorker, this.log);
        if (this.cctx.kernalContext().clientDisconnected()) {
            this.cctx.affinity().removeGroupHolders();
        }
        ExchangeFutureSet exchFuts0 = this.exchFuts;
        for (CachePartitionExchangeWorkerTask cachePartitionExchangeWorkerTask : this.exchWorker.futQ) {
            if (!(cachePartitionExchangeWorkerTask instanceof GridDhtPartitionsExchangeFuture)) continue;
            ((GridDhtPartitionsExchangeFuture)cachePartitionExchangeWorkerTask).onDone(this.stopErr);
        }
        if (exchFuts0 != null) {
            for (GridDhtPartitionsExchangeFuture gridDhtPartitionsExchangeFuture : this.exchFuts.values()) {
                gridDhtPartitionsExchangeFuture.onDone(this.stopErr);
            }
        }
        for (AffinityReadyFuture affinityReadyFuture : this.readyFuts.values()) {
            affinityReadyFuture.onDone(this.stopErr);
        }
        GridDhtPartitionsExchangeFuture lastFut = this.lastInitializedFut;
        if (lastFut != null) {
            lastFut.onDone(this.stopErr);
        }
        if (!this.cctx.kernalContext().clientNode()) {
            void var4_10;
            boolean bl = false;
            while (var4_10 < this.cctx.gridConfig().getRebalanceThreadPoolSize()) {
                this.cctx.io().removeOrderedHandler(true, GridCachePartitionExchangeManager.rebalanceTopic((int)var4_10));
                ++var4_10;
            }
        }
        if ((resendTimeoutObject = (ResendTimeoutObject)this.pendingResend.getAndSet(null)) != null) {
            this.cctx.time().removeTimeoutObject(resendTimeoutObject);
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.busyLock.writeLock().lock();
        this.exchFuts.clear();
    }

    @Nullable
    public GridDhtPartitionTopology clientTopologyIfExists(int grpId) {
        return (GridDhtPartitionTopology)this.clientTops.get(grpId);
    }

    public GridDhtPartitionTopology clientTopology(int grpId, DiscoCache discoCache) {
        GridClientPartitionTopology top = (GridClientPartitionTopology)this.clientTops.get(grpId);
        if (top != null) {
            return top;
        }
        CacheGroupDescriptor grpDesc = this.cctx.affinity().cacheGroups().get(grpId);
        assert (grpDesc != null) : "grpId=" + grpId;
        CacheConfiguration<?, ?> ccfg = grpDesc.config();
        AffinityFunction aff = ccfg.getAffinity();
        Object affKey = this.cctx.kernalContext().affinity().similaryAffinityKey(aff, ccfg.getNodeFilter(), ccfg.getBackups(), aff.partitions());
        top = new GridClientPartitionTopology(this.cctx, discoCache, grpId, aff.partitions(), affKey, ccfg.getPartitionLossPolicy());
        GridClientPartitionTopology old = this.clientTops.putIfAbsent(grpId, top);
        return old != null ? old : top;
    }

    public Collection<GridClientPartitionTopology> clientTopologies() {
        return this.clientTops.values();
    }

    public GridClientPartitionTopology clearClientTopology(int grpId) {
        return (GridClientPartitionTopology)this.clientTops.remove(grpId);
    }

    public AffinityTopologyVersion readyAffinityVersion() {
        return this.exchFuts.readyTopVer();
    }

    public GridDhtPartitionsExchangeFuture lastTopologyFuture() {
        return this.lastInitializedFut;
    }

    @Nullable
    public GridDhtPartitionsExchangeFuture lastFinishedFuture() {
        return this.lastFinishedFut.get();
    }

    public void lastFinishedFuture(GridDhtPartitionsExchangeFuture fut) {
        GridDhtPartitionsExchangeFuture cur;
        assert (fut != null && fut.isDone()) : fut;
        do {
            cur = this.lastFinishedFut.get();
        } while (fut.topologyVersion() != null && (cur == null || fut.topologyVersion().compareTo(cur.topologyVersion()) > 0) && !this.lastFinishedFut.compareAndSet(cur, fut));
    }

    @NotNull
    public IgniteInternalFuture<AffinityTopologyVersion> affinityReadyFuture(AffinityTopologyVersion ver) {
        GridDhtPartitionsExchangeFuture lastInitializedFut0 = this.lastInitializedFut;
        if (lastInitializedFut0 != null && lastInitializedFut0.initialVersion().compareTo(ver) == 0 && lastInitializedFut0.changedAffinity()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Return lastInitializedFut for topology ready future [ver=" + ver + ", fut=" + lastInitializedFut0 + ']');
            }
            return lastInitializedFut0;
        }
        AffinityTopologyVersion topVer = this.exchFuts.readyTopVer();
        if (topVer.compareTo(ver) >= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Return finished future for topology ready future [ver=" + ver + ", topVer=" + topVer + ']');
            }
            return new GridFinishedFuture<AffinityTopologyVersion>(topVer);
        }
        GridFutureAdapter fut = F.addIfAbsent(this.readyFuts, ver, new AffinityReadyFuture(ver));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created topology ready future [ver=" + ver + ", fut=" + fut + ']');
        }
        if ((topVer = this.exchFuts.readyTopVer()).compareTo(ver) >= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Completing created topology ready future [ver=" + topVer + ", topVer=" + topVer + ", fut=" + fut + ']');
            }
            fut.onDone(topVer);
        } else if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    private boolean enterBusy() {
        if (this.busyLock.readLock().tryLock()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to enter to busy state (exchange manager is stopping): " + this.cctx.localNodeId());
        }
        return false;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    public List<GridDhtPartitionsExchangeFuture> exchangeFutures() {
        return this.exchFuts.values();
    }

    public boolean hasPendingExchange() {
        return this.exchWorker.hasPendingExchange();
    }

    public boolean hasPendingServerExchange() {
        return this.exchWorker.hasPendingServerExchange();
    }

    public AffinityTopologyVersion lastAffinityChangedTopologyVersion(AffinityTopologyVersion topVer) {
        if (topVer.topologyVersion() <= 0L) {
            return topVer;
        }
        AffinityTopologyVersion lastAffTopVer = (AffinityTopologyVersion)this.lastAffTopVers.get(topVer);
        return lastAffTopVer != null ? lastAffTopVer : topVer;
    }

    public boolean lastAffinityChangedTopologyVersion(AffinityTopologyVersion topVer, AffinityTopologyVersion lastAffTopVer) {
        block4: {
            AffinityTopologyVersion old;
            assert (lastAffTopVer.compareTo(topVer) <= 0);
            if (lastAffTopVer.topologyVersion() <= 0L || lastAffTopVer.equals(topVer)) {
                return false;
            }
            do {
                if ((old = this.lastAffTopVers.putIfAbsent(topVer, lastAffTopVer)) == null) {
                    return true;
                }
                if (lastAffTopVer.compareTo(old) >= 0) break block4;
            } while (!this.lastAffTopVers.replace(topVer, old, lastAffTopVer));
            return true;
        }
        return false;
    }

    private AffinityTopologyVersion affinityTopologyVersion(DiscoveryEvent evt) {
        if (evt.type() == 18) {
            return ((DiscoveryCustomEvent)evt).affinityTopologyVersion();
        }
        return new AffinityTopologyVersion(evt.topologyVersion());
    }

    public void forceReassign(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture fut) {
        this.exchWorker.forceReassign(exchId, fut);
    }

    public IgniteInternalFuture<Boolean> forceRebalance(GridDhtPartitionExchangeId exchId) {
        return this.exchWorker.forceRebalance(exchId);
    }

    public void finishPreloading(AffinityTopologyVersion topVer, int grpId, long rebalanceId) {
        this.exchWorker.finishPreloading(topVer, grpId, rebalanceId);
    }

    public IgniteInternalFuture<Void> deferStopCachesOnClientReconnect(Collection<GridCacheAdapter> caches) {
        assert (this.cctx.discovery().localNode().isClient());
        return this.exchWorker.deferStopCachesOnClientReconnect(caches);
    }

    public void scheduleResendPartitions() {
        ResendTimeoutObject update;
        ResendTimeoutObject timeout = this.pendingResend.get();
        if ((timeout == null || timeout.started()) && this.pendingResend.compareAndSet(timeout, update = new ResendTimeoutObject())) {
            this.cctx.time().addTimeoutObject(update);
        }
    }

    public void registerExchangeAwareComponent(PartitionsExchangeAware comp) {
        this.exchangeAwareComps.add(comp);
    }

    public void unregisterExchangeAwareComponent(PartitionsExchangeAware comp) {
        this.exchangeAwareComps.remove(comp);
    }

    public List<PartitionsExchangeAware> exchangeAwareComponents() {
        return U.sealList(this.exchangeAwareComps);
    }

    public void refreshPartitions(@NotNull Collection<CacheGroupContext> grps) {
        if (this.cctx.snapshot().snapshotOperationInProgress()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Schedule resend parititions due to snapshot in progress");
            }
            this.scheduleResendPartitions();
            return;
        }
        if (grps.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skip partitions refresh, there are no cache groups for partition refresh.");
            }
            return;
        }
        ClusterNode oldest = this.cctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
        if (oldest == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skip partitions refresh, there are no server nodes [loc=" + this.cctx.localNodeId() + ']');
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Refreshing partitions [oldest=" + oldest.id() + ", loc=" + this.cctx.localNodeId() + ", cacheGroups= " + grps + ']');
        }
        if (oldest.id().equals(this.cctx.localNodeId())) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                GridDhtPartitionTopology top = grp.topology();
                if (top == null) continue;
                this.cctx.affinity().checkRebalanceState(top, grp.groupId());
            }
            GridDhtPartitionsExchangeFuture lastFut = this.lastInitializedFut;
            AffinityTopologyVersion rmtTopVer = lastFut != null ? (lastFut.isDone() && lastFut.error() == null ? lastFut.topologyVersion() : lastFut.initialVersion()) : AffinityTopologyVersion.NONE;
            Collection<ClusterNode> rmts = this.cctx.discovery().remoteAliveNodesWithCaches(rmtTopVer);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refreshing partitions from oldest node: " + this.cctx.localNodeId());
            }
            this.sendAllPartitions(rmts, rmtTopVer, grps);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refreshing local partitions from non-oldest node: " + this.cctx.localNodeId());
            }
            this.sendLocalPartitions(oldest, null, grps);
        }
    }

    public void refreshPartitions() {
        this.refreshPartitions(this.cctx.cache().cacheGroups());
    }

    private void sendAllPartitions(Collection<ClusterNode> nodes, AffinityTopologyVersion msgTopVer, Collection<CacheGroupContext> grps) {
        long latency;
        long latency2;
        long time = System.currentTimeMillis();
        GridDhtPartitionsFullMessage m = this.createPartitionsFullMessage(true, false, null, null, null, null, grps);
        m.topologyVersion(msgTopVer);
        if (this.log.isInfoEnabled() && ((latency2 = System.currentTimeMillis() - time) > 50L || this.log.isDebugEnabled())) {
            this.log.info("Finished full message creation [msgTopVer=" + msgTopVer + ", groups=" + grps + ", latency=" + latency2 + "ms]");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending all partitions [nodeIds=" + U.nodeIds(nodes) + ", cacheGroups=" + grps + ", msg=" + m + ']');
        }
        time = System.currentTimeMillis();
        HashSet failedNodes = U.newHashSet(nodes.size());
        for (ClusterNode node : nodes) {
            try {
                assert (!node.equals(this.cctx.localNode()));
                this.cctx.io().sendNoRetry(node, m, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignore) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to send partition update to node because it left grid (will ignore) [node=" + node.id() + ", msg=" + m + ']');
            }
            catch (IgniteCheckedException e) {
                failedNodes.add(node);
                U.warn(this.log, "Failed to send partitions full message [node=" + node + ", err=" + e + ']', e);
            }
        }
        if (this.log.isInfoEnabled() && ((latency = System.currentTimeMillis() - time) > 50L || this.log.isDebugEnabled())) {
            this.log.info("Finished sending full message [msgTopVer=" + msgTopVer + ", groups=" + grps + (failedNodes.isEmpty() ? "" : ", skipped=" + U.nodeIds(failedNodes)) + ", latency=" + latency + "ms]");
        }
    }

    public GridDhtPartitionsFullMessage createPartitionsFullMessage(boolean compress, boolean newCntrMap, @Nullable GridDhtPartitionExchangeId exchId, @Nullable GridCacheVersion lastVer, @Nullable IgniteDhtPartitionHistorySuppliersMap partHistSuppliers, @Nullable IgniteDhtPartitionsToReloadMap partsToReload) {
        Collection<CacheGroupContext> grps = this.cctx.cache().cacheGroups();
        return this.createPartitionsFullMessage(compress, newCntrMap, exchId, lastVer, partHistSuppliers, partsToReload, grps);
    }

    public GridDhtPartitionsFullMessage createPartitionsFullMessage(boolean compress, boolean newCntrMap, @Nullable GridDhtPartitionExchangeId exchId, @Nullable GridCacheVersion lastVer, @Nullable IgniteDhtPartitionHistorySuppliersMap partHistSuppliers, @Nullable IgniteDhtPartitionsToReloadMap partsToReload, Collection<CacheGroupContext> grps) {
        Map<Integer, Long> partSizesMap;
        AffinityTopologyVersion ver = exchId != null ? exchId.topologyVersion() : AffinityTopologyVersion.NONE;
        GridDhtPartitionsFullMessage m = new GridDhtPartitionsFullMessage(exchId, lastVer, ver, partHistSuppliers, partsToReload);
        m.compressed(compress);
        HashMap<Object, T2<Integer, GridDhtPartitionFullMap>> dupData = new HashMap<Object, T2<Integer, GridDhtPartitionFullMap>>();
        HashMap<Integer, Map<Integer, Long>> partsSizes = new HashMap<Integer, Map<Integer, Long>>();
        for (CacheGroupContext grp : grps) {
            AffinityTopologyVersion startTopVer;
            if (exchId != null && (startTopVer = grp.localStartVersion()).compareTo(exchId.topologyVersion()) > 0) continue;
            GridAffinityAssignmentCache affCache = grp.affinity();
            GridDhtPartitionFullMap locMap = grp.topology().partitionMap(true);
            if (locMap != null) {
                this.addFullPartitionsMap(m, dupData, compress, grp.groupId(), locMap, affCache.similarAffinityKey());
            }
            if (!(partSizesMap = grp.topology().globalPartSizes()).isEmpty()) {
                partsSizes.put(grp.groupId(), partSizesMap);
            }
            if (exchId == null) continue;
            CachePartitionFullCountersMap cntrsMap = grp.topology().fullUpdateCounters();
            if (newCntrMap) {
                m.addPartitionUpdateCounters(grp.groupId(), cntrsMap);
            } else {
                m.addPartitionUpdateCounters(grp.groupId(), CachePartitionFullCountersMap.toCountersMap(cntrsMap));
            }
            m.addLostPartitions(grp.groupId(), grp.topology().lostPartitions());
        }
        for (GridClientPartitionTopology top : this.cctx.exchange().clientTopologies()) {
            GridDhtPartitionFullMap map = top.partitionMap(true);
            if (map != null) {
                this.addFullPartitionsMap(m, dupData, compress, top.groupId(), map, top.similarAffinityKey());
            }
            if (exchId == null) continue;
            CachePartitionFullCountersMap cntrsMap = top.fullUpdateCounters();
            if (newCntrMap) {
                m.addPartitionUpdateCounters(top.groupId(), cntrsMap);
            } else {
                m.addPartitionUpdateCounters(top.groupId(), CachePartitionFullCountersMap.toCountersMap(cntrsMap));
            }
            partSizesMap = top.globalPartSizes();
            if (!partSizesMap.isEmpty()) {
                partsSizes.put(top.groupId(), partSizesMap);
            }
            m.addLostPartitions(top.groupId(), top.lostPartitions());
        }
        if (!partsSizes.isEmpty()) {
            m.partitionSizes(this.cctx, partsSizes);
        }
        return m;
    }

    private void addFullPartitionsMap(GridDhtPartitionsFullMessage m, Map<Object, T2<Integer, GridDhtPartitionFullMap>> dupData, boolean compress, Integer grpId, GridDhtPartitionFullMap map, Object affKey) {
        assert (map != null);
        Integer dupDataCache = null;
        if (compress && affKey != null && !m.containsGroup(grpId)) {
            T2<Integer, GridDhtPartitionFullMap> state0 = dupData.get(affKey);
            if (state0 != null && ((GridDhtPartitionFullMap)state0.get2()).partitionStateEquals(map)) {
                GridDhtPartitionFullMap map0 = new GridDhtPartitionFullMap(map.nodeId(), map.nodeOrder(), map.updateSequence());
                for (Map.Entry e : map.entrySet()) {
                    map0.put(e.getKey(), ((GridDhtPartitionMap)e.getValue()).emptyCopy());
                }
                map = map0;
                dupDataCache = (Integer)state0.get1();
            } else {
                dupData.put(affKey, new T2<Integer, GridDhtPartitionFullMap>(grpId, map));
            }
        }
        m.addFullPartitionsMap(grpId, map, dupDataCache);
    }

    private void sendLocalPartitions(ClusterNode node, @Nullable GridDhtPartitionExchangeId id, @NotNull Collection<CacheGroupContext> grps) {
        GridDhtPartitionsSingleMessage m = this.createPartitionsSingleMessage(id, this.cctx.kernalContext().clientNode(), false, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0, null, grps);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending local partitions [nodeId=" + node.id() + ", msg=" + m + ']');
        }
        try {
            this.cctx.io().sendNoRetry(node, m, (byte)2);
        }
        catch (ClusterTopologyCheckedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send partition update to node because it left grid (will ignore) [node=" + node.id() + ", msg=" + m + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send local partition map to node [node=" + node + ", exchId=" + id + ']', e);
        }
    }

    public GridDhtPartitionsSingleMessage createPartitionsSingleMessage(@Nullable GridDhtPartitionExchangeId exchangeId, boolean clientOnlyExchange, boolean sndCounters, boolean newCntrMap, ExchangeActions exchActions) {
        Collection<CacheGroupContext> grps = this.cctx.cache().cacheGroups();
        return this.createPartitionsSingleMessage(exchangeId, clientOnlyExchange, sndCounters, newCntrMap, exchActions, grps);
    }

    public GridDhtPartitionsSingleMessage createPartitionsSingleMessage(@Nullable GridDhtPartitionExchangeId exchangeId, boolean clientOnlyExchange, boolean sndCounters, boolean newCntrMap, ExchangeActions exchActions, Collection<CacheGroupContext> grps) {
        CachePartitionPartialCountersMap cntrsMap;
        GridDhtPartitionMap locMap;
        GridDhtPartitionsSingleMessage m = new GridDhtPartitionsSingleMessage(exchangeId, clientOnlyExchange, this.cctx.versions().last(), true);
        HashMap<Object, T2<Integer, GridPartitionStateMap>> dupData = new HashMap<Object, T2<Integer, GridPartitionStateMap>>();
        for (CacheGroupContext grp : grps) {
            if (exchActions != null && exchActions.cacheGroupStopping(grp.groupId())) continue;
            locMap = grp.topology().localPartitionMap();
            this.addPartitionMap(m, dupData, true, grp.groupId(), locMap, grp.affinity().similarAffinityKey());
            if (sndCounters) {
                cntrsMap = grp.topology().localUpdateCounters(true);
                m.addPartitionUpdateCounters(grp.groupId(), newCntrMap ? cntrsMap : CachePartitionPartialCountersMap.toCountersMap(cntrsMap));
            }
            m.addPartitionSizes(grp.groupId(), grp.topology().partitionSizes());
        }
        for (GridClientPartitionTopology top : this.clientTops.values()) {
            if (m.partitions() != null && m.partitions().containsKey(top.groupId())) continue;
            locMap = top.localPartitionMap();
            this.addPartitionMap(m, dupData, true, top.groupId(), locMap, top.similarAffinityKey());
            if (sndCounters) {
                cntrsMap = top.localUpdateCounters(true);
                m.addPartitionUpdateCounters(top.groupId(), newCntrMap ? cntrsMap : CachePartitionPartialCountersMap.toCountersMap(cntrsMap));
            }
            m.addPartitionSizes(top.groupId(), top.partitionSizes());
        }
        return m;
    }

    private void addPartitionMap(GridDhtPartitionsSingleMessage m, Map<Object, T2<Integer, GridPartitionStateMap>> dupData, boolean compress, Integer cacheId, GridDhtPartitionMap map, Object affKey) {
        Integer dupDataCache = null;
        if (compress) {
            T2<Integer, GridPartitionStateMap> state0 = dupData.get(affKey);
            if (state0 != null && ((GridPartitionStateMap)state0.get2()).equals(map.map())) {
                dupDataCache = (Integer)state0.get1();
                map = map.emptyCopy();
            } else {
                dupData.put(affKey, new T2<Integer, GridPartitionStateMap>(cacheId, map.map()));
            }
        }
        m.addLocalPartitionMap(cacheId, map, dupDataCache);
    }

    private GridDhtPartitionExchangeId exchangeId(UUID nodeId, AffinityTopologyVersion topVer, DiscoveryEvent evt) {
        return new GridDhtPartitionExchangeId(nodeId, evt, topVer);
    }

    private GridDhtPartitionsExchangeFuture exchangeFuture(@NotNull GridDhtPartitionExchangeId exchId) {
        return this.exchangeFuture(exchId, null, null, null, null);
    }

    private GridDhtPartitionsExchangeFuture exchangeFuture(@NotNull GridDhtPartitionExchangeId exchId, @Nullable DiscoveryEvent discoEvt, @Nullable DiscoCache cache, @Nullable ExchangeActions exchActions, @Nullable CacheAffinityChangeMessage affChangeMsg) {
        GridDhtPartitionsExchangeFuture fut = new GridDhtPartitionsExchangeFuture(this.cctx, this.busyLock, exchId, exchActions, affChangeMsg);
        GridDhtPartitionsExchangeFuture old = this.exchFuts.addx(fut);
        if (old != null) {
            fut = old;
            if (exchActions != null) {
                fut.exchangeActions(exchActions);
            }
            if (affChangeMsg != null) {
                fut.affinityChangeMessage(affChangeMsg);
            }
        }
        if (discoEvt != null) {
            fut.onEvent(exchId, discoEvt, cache);
        }
        if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    public void onExchangeDone(AffinityTopologyVersion topVer, AffinityTopologyVersion initTopVer, @Nullable Throwable err) {
        assert (topVer != null || err != null);
        assert (initTopVer != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Exchange done [topVer=" + topVer + ", err=" + err + ']');
        }
        if (err == null) {
            this.exchFuts.readyTopVer(topVer);
        }
        this.completeAffReadyFuts(err == null ? topVer : initTopVer, err);
        ExchangeFutureSet exchFuts0 = this.exchFuts;
        if (exchFuts0 != null) {
            int skipped = 0;
            for (GridDhtPartitionsExchangeFuture fut : exchFuts0.values()) {
                if (initTopVer.compareTo(fut.exchangeId().topologyVersion()) < 0) continue;
                if (skipped == 10 || fut.isMerged()) {
                    fut.cleanUp();
                    continue;
                }
                ++skipped;
            }
        }
    }

    private void completeAffReadyFuts(AffinityTopologyVersion topVer, @Nullable Throwable err) {
        for (Map.Entry entry : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry.getKey()).compareTo(topVer) > 0) continue;
            if (err == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Completing created topology ready future [ver=" + topVer + ", fut=" + entry.getValue() + ']');
                }
                ((AffinityReadyFuture)entry.getValue()).onDone(topVer);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing created topology ready future with error [ver=" + entry.getKey() + ", fut=" + entry.getValue() + ']');
            }
            ((AffinityReadyFuture)entry.getValue()).onDone(err);
        }
    }

    private boolean addFuture(GridDhtPartitionsExchangeFuture fut) {
        if (fut.onAdded()) {
            this.exchWorker.addExchangeFuture(fut);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFullPartitionUpdate(ClusterNode node, GridDhtPartitionsFullMessage msg) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (msg.exchangeId() == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received full partition update [node=" + node.id() + ", msg=" + msg + ']');
                }
                boolean updated = false;
                Map<Integer, Map<Integer, Long>> partsSizes = msg.partitionSizes(this.cctx);
                for (Map.Entry<Integer, GridDhtPartitionFullMap> entry : msg.partitions().entrySet()) {
                    Integer grpId = entry.getKey();
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
                    GridDhtPartitionTopology top = grp == null ? (GridDhtPartitionTopology)this.clientTops.get(grpId) : grp.topology();
                    if (top == null) continue;
                    updated |= top.update(null, entry.getValue(), null, msg.partsToReload(this.cctx.localNodeId(), grpId), partsSizes.getOrDefault(grpId, Collections.emptyMap()), msg.topologyVersion(), null, null);
                }
                if (!this.cctx.kernalContext().clientNode() && updated) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Refresh partitions due to topology update");
                    }
                    this.refreshPartitions();
                }
                boolean hasMovingParts = false;
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (!grp.topology().hasMovingPartitions()) continue;
                    hasMovingParts = true;
                    break;
                }
                if (!hasMovingParts) {
                    this.cctx.database().releaseHistoryForPreloading();
                }
            } else {
                this.exchangeFuture(msg.exchangeId(), null, null, null, null).onReceiveFullMessage(node, msg);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSinglePartitionUpdate(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (msg.exchangeId() == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received local partition update [nodeId=" + node.id() + ", parts=" + msg + ']');
                }
                boolean updated = false;
                for (Map.Entry<Integer, GridDhtPartitionMap> entry : msg.partitions().entrySet()) {
                    GridDhtPartitionTopology top;
                    Integer grpId = entry.getKey();
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
                    if (grp != null && !grp.topology().initialized() || (top = grp == null ? (GridDhtPartitionTopology)this.clientTops.get(grpId) : grp.topology()) == null) continue;
                    updated |= top.update(null, entry.getValue(), false);
                    this.cctx.affinity().checkRebalanceState(top, grpId);
                }
                if (updated) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partitions have been scheduled to resend [reason=Single update from " + node.id() + "]");
                    }
                    this.scheduleResendPartitions();
                }
            } else {
                AffinityTopologyVersion readyVer;
                AffinityTopologyVersion initVer;
                GridDhtPartitionsExchangeFuture exchFut = this.exchangeFuture(msg.exchangeId());
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Notifying exchange future about single message: " + exchFut);
                }
                if (msg.client() && (initVer = exchFut.initialVersion()).compareTo(readyVer = this.readyAffinityVersion()) < 0 && !exchFut.isDone()) {
                    U.warn(this.log, "Client node tries to connect but its exchange info is cleaned up from exchange history. Consider increasing 'IGNITE_EXCHANGE_HISTORY_SIZE' property or start clients in smaller batches. Current settings and versions: [IGNITE_EXCHANGE_HISTORY_SIZE=" + this.EXCHANGE_HISTORY_SIZE + ", initVer=" + initVer + ", readyVer=" + readyVer + "].");
                    exchFut.forceClientReconnect(node, msg);
                    return;
                }
                exchFut.onReceiveSingleMessage(node, msg);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSinglePartitionRequest(ClusterNode node, GridDhtPartitionsSingleRequest msg) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            GridDhtPartitionsExchangeFuture exchFut = this.exchangeFuture(msg.exchangeId(), null, null, null, null);
            exchFut.onReceivePartitionRequest(node, msg);
        }
        finally {
            this.leaveBusy();
        }
    }

    public ExchangeLatchManager latch() {
        return this.latchMgr;
    }

    public void dumpDebugInfo(@Nullable GridDhtPartitionsExchangeFuture exchFut) throws Exception {
        ExchangeFutureSet exchFuts;
        IgniteDiagnosticPrepareContext diagCtx;
        AffinityTopologyVersion exchTopVer = exchFut != null ? exchFut.initialVersion() : null;
        U.warn(this.diagnosticLog, "Ready affinity version: " + this.exchFuts.readyTopVer());
        U.warn(this.diagnosticLog, "Last exchange future: " + this.lastInitializedFut);
        this.exchWorker.dumpExchangeDebugInfo();
        if (!this.readyFuts.isEmpty()) {
            int warningsLimit = IgniteSystemProperties.getInteger("IGNITE_DIAGNOSTIC_WARN_LIMIT", 5);
            U.warn(this.diagnosticLog, "First " + warningsLimit + " pending affinity ready futures [total=" + this.readyFuts.size() + ']');
            if (warningsLimit > 0) {
                int cnt = 0;
                for (Object fut : this.readyFuts.values()) {
                    U.warn(this.diagnosticLog, ">>> " + fut);
                    if (++cnt != warningsLimit) continue;
                    break;
                }
            }
        }
        IgniteDiagnosticPrepareContext igniteDiagnosticPrepareContext = diagCtx = this.cctx.kernalContext().cluster().diagnosticEnabled() ? new IgniteDiagnosticPrepareContext(this.cctx.localNodeId()) : null;
        if (diagCtx != null && exchFut != null) {
            exchFut.addDiagnosticRequest(diagCtx);
        }
        if ((exchFuts = this.exchFuts) != null) {
            U.warn(this.diagnosticLog, "Last " + this.DIAGNOSTIC_WARN_LIMIT + " exchange futures (total: " + exchFuts.size() + "):");
            if (this.DIAGNOSTIC_WARN_LIMIT > 0) {
                int cnt = 0;
                for (GridDhtPartitionsExchangeFuture fut : exchFuts.values()) {
                    U.warn(this.diagnosticLog, ">>> " + fut.shortInfo());
                    if (++cnt != this.DIAGNOSTIC_WARN_LIMIT) continue;
                    break;
                }
            }
        }
        U.warn(this.diagnosticLog, "Latch manager state: " + this.latchMgr);
        this.dumpPendingObjects(exchTopVer, diagCtx);
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            GridCachePreloader preloader = grp.preloader();
            if (preloader == null) continue;
            preloader.dumpDebugInfo();
        }
        this.cctx.affinity().dumpDebugInfo();
        StringBuilder pendingMsgs = new StringBuilder();
        this.cctx.io().dumpPendingMessages(pendingMsgs);
        if (pendingMsgs.length() > 0 && this.diagnosticLog.isInfoEnabled()) {
            this.diagnosticLog.info(pendingMsgs.toString());
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_IO_DUMP_ON_TIMEOUT", false)) {
            this.cctx.gridIO().dumpStats();
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) {
            U.dumpThreads(this.diagnosticLog);
        }
        if (diagCtx != null) {
            diagCtx.send(this.cctx.kernalContext(), null);
        }
    }

    public void checkRebalanceState() {
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            GridDhtPartitionTopology top = grp.topology();
            if (top == null) continue;
            this.cctx.affinity().checkRebalanceState(top, grp.groupId());
        }
    }

    private static String longRunningTransactionWarning(IgniteInternalTx tx, long curTime) {
        GridStringBuilder warning = new GridStringBuilder().a(">>> Transaction [startTime=").a(GridCachePartitionExchangeManager.formatTime(tx.startTime())).a(", curTime=").a(GridCachePartitionExchangeManager.formatTime(curTime));
        if (tx instanceof GridNearTxLocal) {
            GridNearTxLocal nearTxLoc = (GridNearTxLocal)tx;
            long sysTimeCurr = nearTxLoc.systemTimeCurrent();
            long userTime = Math.max(curTime - nearTxLoc.startTime() - sysTimeCurr, 0L);
            warning.a(", systemTime=").a(sysTimeCurr).a(", userTime=").a(userTime);
        }
        warning.a(", tx=").a(tx).a("]");
        return warning.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dumpLongRunningOperations0(long timeout) {
        IgniteDiagnosticPrepareContext diagCtx;
        long curTime = U.currentTimeMillis();
        boolean found = false;
        IgniteTxManager tm = this.cctx.tm();
        GridCacheMvccManager mvcc = this.cctx.mvcc();
        IgniteDiagnosticPrepareContext igniteDiagnosticPrepareContext = diagCtx = this.cctx.kernalContext().cluster().diagnosticEnabled() ? new IgniteDiagnosticPrepareContext(this.cctx.localNodeId()) : null;
        if (tm != null) {
            WarningsGroup warnings = new WarningsGroup("First %d long running transactions [total=%d]", this.diagnosticLog, this.DIAGNOSTIC_WARN_LIMIT);
            ActionLimiter<IgniteInternalTx> actionLimiter = this.ltrDumpLimiter;
            synchronized (actionLimiter) {
                for (IgniteInternalTx igniteInternalTx : tm.activeTransactions()) {
                    if (curTime - igniteInternalTx.startTime() <= timeout) continue;
                    found = true;
                    if (warnings.canAddMessage()) {
                        warnings.add(GridCachePartitionExchangeManager.longRunningTransactionWarning(igniteInternalTx, curTime));
                        if (!this.cctx.tm().txOwnerDumpRequestsAllowed() || Optional.ofNullable(this.cctx.kernalContext().config().isClientMode()).orElse(false).booleanValue() || !igniteInternalTx.local() || igniteInternalTx.state() != TransactionState.ACTIVE || !this.ltrDumpLimiter.allowAction(igniteInternalTx)) continue;
                        this.dumpLongRunningTransaction(igniteInternalTx);
                        continue;
                    }
                    warnings.incTotal();
                }
                this.ltrDumpLimiter.trim();
            }
            warnings.printToLog();
        }
        if (mvcc != null) {
            WarningsGroup activeWarnings = new WarningsGroup("First %d long running cache futures [total=%d]", this.diagnosticLog, this.DIAGNOSTIC_WARN_LIMIT);
            for (GridCacheFuture gridCacheFuture : mvcc.activeFutures()) {
                if (curTime - gridCacheFuture.startTime() <= timeout) continue;
                found = true;
                if (activeWarnings.canAddMessage()) {
                    activeWarnings.add(">>> Future [startTime=" + GridCachePartitionExchangeManager.formatTime(gridCacheFuture.startTime()) + ", curTime=" + GridCachePartitionExchangeManager.formatTime(curTime) + ", fut=" + gridCacheFuture + ']');
                } else {
                    activeWarnings.incTotal();
                }
                if (diagCtx == null || !(gridCacheFuture instanceof IgniteDiagnosticAware)) continue;
                ((IgniteDiagnosticAware)((Object)gridCacheFuture)).addDiagnosticRequest(diagCtx);
            }
            activeWarnings.printToLog();
            WarningsGroup atomicWarnings = new WarningsGroup("First %d long running cache futures [total=%d]", this.diagnosticLog, this.DIAGNOSTIC_WARN_LIMIT);
            for (GridCacheFuture gridCacheFuture : mvcc.atomicFutures()) {
                if (curTime - gridCacheFuture.startTime() <= timeout) continue;
                found = true;
                if (atomicWarnings.canAddMessage()) {
                    atomicWarnings.add(">>> Future [startTime=" + GridCachePartitionExchangeManager.formatTime(gridCacheFuture.startTime()) + ", curTime=" + GridCachePartitionExchangeManager.formatTime(curTime) + ", fut=" + gridCacheFuture + ']');
                } else {
                    atomicWarnings.incTotal();
                }
                if (diagCtx == null || !(gridCacheFuture instanceof IgniteDiagnosticAware)) continue;
                ((IgniteDiagnosticAware)((Object)gridCacheFuture)).addDiagnosticRequest(diagCtx);
            }
            atomicWarnings.printToLog();
        }
        if (diagCtx != null && !diagCtx.empty()) {
            try {
                this.cctx.kernalContext().closure().runLocal(new Runnable(){

                    @Override
                    public void run() {
                        diagCtx.send(GridCachePartitionExchangeManager.this.cctx.kernalContext(), null);
                    }
                }, (byte)2);
            }
            catch (IgniteCheckedException e) {
                U.error(this.diagnosticLog, "Failed to submit diagnostic closure: " + e, e);
            }
        }
        return found;
    }

    private void dumpLongRunningTransaction(IgniteInternalTx tx) {
        Collection<UUID> masterNodeIds = tx.masterNodeIds();
        if (masterNodeIds.size() == 1) {
            UUID nearNodeId = masterNodeIds.iterator().next();
            long txOwnerThreadId = tx.threadId();
            IgniteEx ignite = this.cctx.kernalContext().grid();
            ClusterGroup nearNode = ignite.cluster().forNodeId(nearNodeId, new UUID[0]);
            final String txRequestInfo = String.format("[xidVer=%s, nodeId=%s]", tx.xidVersion().toString(), nearNodeId.toString());
            if (IgniteFeatures.allNodesSupports(nearNode.nodes(), IgniteFeatures.TRANSACTION_OWNER_THREAD_DUMP_PROVIDING)) {
                try {
                    ignite.context().closure().callAsync(GridClosureCallMode.BALANCE, new FetchActiveTxOwnerTraceClosure(txOwnerThreadId), TaskExecutionOptions.options(ignite.cluster().forNodeId(nearNodeId, new UUID[0]).nodes())).listen(new IgniteInClosure<IgniteInternalFuture<String>>(){

                        @Override
                        public void apply(IgniteInternalFuture<String> strIgniteFut) {
                            String traceDump = null;
                            try {
                                traceDump = strIgniteFut.get();
                            }
                            catch (ClusterGroupEmptyException e) {
                                U.error(GridCachePartitionExchangeManager.this.diagnosticLog, "Could not get thread dump from transaction owner because near node is out of topology now. " + txRequestInfo);
                            }
                            catch (Exception e) {
                                U.error(GridCachePartitionExchangeManager.this.diagnosticLog, "Could not get thread dump from transaction owner near node " + txRequestInfo, e);
                            }
                            if (traceDump != null) {
                                U.warn(GridCachePartitionExchangeManager.this.diagnosticLog, String.format("Dumping the near node thread that started transaction %s\n%s", txRequestInfo, traceDump));
                            }
                        }
                    });
                }
                catch (Exception e) {
                    U.error(this.diagnosticLog, "Could not send dump request to transaction owner near node " + txRequestInfo, e);
                }
            } else {
                U.warn(this.diagnosticLog, "Could not send dump request to transaction owner near node: node does not support this feature. " + txRequestInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLongRunningOperations(long timeout) {
        try {
            GridDhtPartitionsExchangeFuture lastFut = this.lastInitializedFut;
            if (lastFut != null && !lastFut.isDone()) {
                return;
            }
            if (!this.dumpLongRunningOpsLock.tryLock()) {
                return;
            }
            this.startLatch.await();
            try {
                if (U.currentTimeMillis() < this.nextLongRunningOpsDumpTime) {
                    return;
                }
                if (this.dumpLongRunningOperations0(timeout)) {
                    this.nextLongRunningOpsDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(this.longRunningOpsDumpStep++, timeout);
                    if (IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) {
                        U.warn(this.diagnosticLog, "Found long running cache operations, dump threads.");
                        U.dumpThreads(this.diagnosticLog);
                    }
                    if (IgniteSystemProperties.getBoolean("IGNITE_IO_DUMP_ON_TIMEOUT", false)) {
                        U.warn(this.diagnosticLog, "Found long running cache operations, dump IO statistics.");
                        if (IgniteSystemProperties.getBoolean("IGNITE_IO_DUMP_ON_TIMEOUT", false)) {
                            this.cctx.gridIO().dumpStats();
                        }
                    }
                } else {
                    this.nextLongRunningOpsDumpTime = 0L;
                    this.longRunningOpsDumpStep = 0;
                }
            }
            finally {
                this.dumpLongRunningOpsLock.unlock();
            }
        }
        catch (Exception e) {
            U.error(this.diagnosticLog, FAILED_DUMP_MSG + e, e);
        }
    }

    private static String formatTime(long time) {
        return IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(time));
    }

    private static boolean isExchangeTask(CachePartitionExchangeWorkerTask task) {
        return task instanceof GridDhtPartitionsExchangeFuture || task instanceof RebalanceReassignExchangeTask || task instanceof ForceRebalanceExchangeTask;
    }

    private void dumpPendingObjects(@Nullable AffinityTopologyVersion exchTopVer, @Nullable IgniteDiagnosticPrepareContext diagCtx) {
        GridCacheMvccManager mvcc;
        IgniteTxManager tm = this.cctx.tm();
        if (tm != null) {
            boolean first = true;
            for (IgniteInternalTx tx : tm.activeTransactions()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending transactions:");
                    first = false;
                }
                if (exchTopVer != null) {
                    U.warn(this.diagnosticLog, ">>> [txVer=" + tx.topologyVersionSnapshot() + ", exchWait=" + tm.needWaitTransaction(tx, exchTopVer) + ", tx=" + tx + ']');
                    continue;
                }
                U.warn(this.diagnosticLog, ">>> [txVer=" + tx.topologyVersionSnapshot() + ", tx=" + tx + ']');
            }
        }
        if ((mvcc = this.cctx.mvcc()) != null) {
            boolean first = true;
            for (GridCacheExplicitLockSpan gridCacheExplicitLockSpan : mvcc.activeExplicitLocks()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending explicit locks:");
                    first = false;
                }
                U.warn(this.diagnosticLog, ">>> " + gridCacheExplicitLockSpan);
            }
            first = true;
            for (GridCacheFuture gridCacheFuture : mvcc.activeFutures()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending cache futures:");
                    first = false;
                }
                this.dumpDiagnosticInfo(gridCacheFuture, diagCtx);
            }
            first = true;
            for (GridCacheFuture gridCacheFuture : mvcc.atomicFutures()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending atomic cache futures:");
                    first = false;
                }
                this.dumpDiagnosticInfo(gridCacheFuture, diagCtx);
            }
            first = true;
            for (IgniteInternalFuture igniteInternalFuture : mvcc.dataStreamerFutures()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending data streamer futures:");
                    first = false;
                }
                this.dumpDiagnosticInfo(igniteInternalFuture, diagCtx);
            }
            if (tm != null) {
                first = true;
                for (IgniteInternalFuture igniteInternalFuture : tm.deadlockDetectionFutures()) {
                    if (first) {
                        U.warn(this.diagnosticLog, "Pending transaction deadlock detection futures:");
                        first = false;
                    }
                    this.dumpDiagnosticInfo(igniteInternalFuture, diagCtx);
                }
            }
        }
        int affDumpCnt = 0;
        for (CacheGroupContext cacheGroupContext : this.cctx.cache().cacheGroups()) {
            GridAffinityAssignmentCache aff;
            GridCachePreloader preloader = cacheGroupContext.preloader();
            if (preloader != null) {
                preloader.dumpDebugInfo();
            }
            if ((aff = cacheGroupContext.affinity()) == null || affDumpCnt >= 5 || !aff.dumpDebugInfo()) continue;
            ++affDumpCnt;
        }
        this.cctx.kernalContext().coordinators().dumpDebugInfo(this.diagnosticLog, diagCtx);
    }

    private void dumpDiagnosticInfo(IgniteInternalFuture<?> fut, @Nullable IgniteDiagnosticPrepareContext ctx) {
        U.warn(this.diagnosticLog, ">>> " + fut);
        if (ctx != null && fut instanceof IgniteDiagnosticAware) {
            ((IgniteDiagnosticAware)((Object)fut)).addDiagnosticRequest(ctx);
        }
    }

    public void mergeExchangesTestWaitVersion(AffinityTopologyVersion exchMergeTestWaitVer, @Nullable List mergedEvtsForTest) {
        this.exchMergeTestWaitVer = exchMergeTestWaitVer;
        this.mergedEvtsForTest = mergedEvtsForTest;
    }

    public AffinityTopologyVersion mergeExchangesTestWaitVersion() {
        return this.exchMergeTestWaitVer;
    }

    public boolean mergeExchanges(GridDhtPartitionsExchangeFuture curFut, GridDhtPartitionsFullMessage msg) throws IgniteInterruptedCheckedException {
        AffinityTopologyVersion resVer = msg.resultTopologyVersion();
        if (this.exchWorker.waitForExchangeFuture(resVer)) {
            return true;
        }
        for (CachePartitionExchangeWorkerTask task : this.exchWorker.futQ) {
            GridDhtPartitionsSingleMessage pendingMsg;
            if (!(task instanceof GridDhtPartitionsExchangeFuture)) continue;
            GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)task;
            if (fut.initialVersion().compareTo(resVer) > 0) {
                if (!this.log.isInfoEnabled()) break;
                this.log.info("Merge exchange future on finish stop [curFut=" + curFut.initialVersion() + ", resVer=" + resVer + ", nextFutVer=" + fut.initialVersion() + ']');
                break;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Merge exchange future on finish [curFut=" + curFut.initialVersion() + ", mergedFut=" + fut.initialVersion() + ", evt=" + IgniteUtils.gridEventName(fut.firstEvent().type()) + ", evtNode=" + fut.firstEvent().eventNode().id() + ", evtNodeClient=" + fut.firstEvent().eventNode().isClient() + ']');
            }
            DiscoveryEvent evt = fut.firstEvent();
            curFut.context().events().addEvent(fut.initialVersion(), fut.firstEvent(), fut.firstEventCache());
            if (evt.type() != 10 || (pendingMsg = fut.mergeJoinExchangeOnDone(curFut)) == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Merged join exchange future on finish, will reply to node [curFut=" + curFut.initialVersion() + ", mergedFut=" + fut.initialVersion() + ", evtNode=" + evt.eventNode().id() + ']');
            }
            curFut.waitAndReplyToNode(evt.eventNode().id(), pendingMsg);
        }
        ExchangeDiscoveryEvents evts = curFut.context().events();
        assert (evts.topologyVersion().equals(resVer)) : "Invalid exchange merge result [ver=" + evts.topologyVersion() + ", expVer=" + resVer + ']';
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeExchangesOnCoordinator(GridDhtPartitionsExchangeFuture curFut, @Nullable AffinityTopologyVersion threshold) {
        AffinityTopologyVersion exchMergeTestWaitVer;
        if (this.IGNITE_EXCHANGE_MERGE_DELAY > 0L) {
            try {
                U.sleep(this.IGNITE_EXCHANGE_MERGE_DELAY);
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Failed to wait for exchange merge, thread interrupted: " + e);
                return true;
            }
        }
        if ((exchMergeTestWaitVer = this.exchMergeTestWaitVer) != null) {
            this.waitForTestVersion(exchMergeTestWaitVer, curFut);
        }
        Object object = curFut.mutex();
        synchronized (object) {
            int awaited = 0;
            for (CachePartitionExchangeWorkerTask task : this.exchWorker.futQ) {
                if (task instanceof GridDhtPartitionsExchangeFuture) {
                    GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)task;
                    DiscoveryEvent evt = fut.firstEvent();
                    if (threshold != null && fut.initialVersion().compareTo(threshold) > 0) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, threshold is exceed: " + evt + ", threshold = " + threshold);
                        break;
                    }
                    if (evt.type() == 18) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, custom event found: " + evt);
                        break;
                    }
                    if (!fut.changedAffinity()) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, no-affinity exchange found: " + evt);
                        break;
                    }
                    ClusterNode node = evt.eventNode();
                    if (!curFut.context().supportsMergeExchanges(node)) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, node does not support merge: " + node);
                        break;
                    }
                    if (evt.type() == 10 && this.cctx.cache().hasCachesReceivedFromJoin(node)) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, received caches from node: " + node);
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Merge exchange future [curFut=" + curFut.initialVersion() + ", mergedFut=" + fut.initialVersion() + ", evt=" + IgniteUtils.gridEventName(fut.firstEvent().type()) + ", evtNode=" + fut.firstEvent().eventNode().id() + ", evtNodeClient=" + fut.firstEvent().eventNode().isClient() + ']');
                    }
                    this.addDiscoEvtForTest(fut.firstEvent());
                    curFut.context().events().addEvent(fut.initialVersion(), fut.firstEvent(), fut.firstEventCache());
                    if (evt.type() != 10 || !fut.mergeJoinExchange(curFut)) continue;
                    ++awaited;
                    continue;
                }
                if (task.skipForExchangeMerge()) continue;
                if (!this.log.isInfoEnabled()) break;
                this.log.info("Stop merge, custom task found: " + task);
                break;
            }
            return awaited == 0;
        }
    }

    private void addDiscoEvtForTest(DiscoveryEvent discoEvt) {
        List mergedEvtsForTest = this.mergedEvtsForTest;
        if (mergedEvtsForTest != null) {
            mergedEvtsForTest.add(discoEvt);
        }
    }

    private void waitForTestVersion(AffinityTopologyVersion exchMergeTestWaitVer, GridDhtPartitionsExchangeFuture curFut) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Exchange merge test, waiting for version [exch=" + curFut.initialVersion() + ", waitVer=" + exchMergeTestWaitVer + ']');
        }
        long end = U.currentTimeMillis() + 10000L;
        while (U.currentTimeMillis() < end) {
            boolean found = false;
            for (CachePartitionExchangeWorkerTask task : this.exchWorker.futQ) {
                GridDhtPartitionsExchangeFuture fut;
                if (!(task instanceof GridDhtPartitionsExchangeFuture) || !exchMergeTestWaitVer.equals((fut = (GridDhtPartitionsExchangeFuture)task).initialVersion())) continue;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Exchange merge test, found awaited version: " + exchMergeTestWaitVer);
                }
                found = true;
                break;
            }
            if (found) break;
            try {
                U.sleep(100L);
            }
            catch (IgniteInterruptedCheckedException e) {
                break;
            }
        }
        this.exchMergeTestWaitVer = null;
    }

    public void exchangerUpdateHeartbeat() {
        this.exchWorker.updateHeartbeat();
    }

    public void exchangerBlockingSectionBegin() {
        if (this.currentThreadIsExchanger()) {
            this.exchWorker.blockingSectionBegin();
        }
    }

    public void exchangerBlockingSectionEnd() {
        if (this.currentThreadIsExchanger()) {
            this.exchWorker.blockingSectionEnd();
        }
    }

    private boolean currentThreadIsExchanger() {
        return this.exchWorker != null && Thread.currentThread() == this.exchWorker.runner();
    }

    public boolean affinityChanged(AffinityTopologyVersion from, AffinityTopologyVersion to) {
        if (this.lastAffinityChangedTopologyVersion(to).compareTo(from) >= 0) {
            return false;
        }
        List<GridDhtPartitionsExchangeFuture> history = this.exchFuts.values();
        boolean fromFound = false;
        for (GridDhtPartitionsExchangeFuture fut : history) {
            if (!fromFound) {
                int cmp = fut.initialVersion().compareTo(from);
                if (cmp > 0) {
                    return true;
                }
                if (cmp == 0) {
                    fromFound = true;
                    continue;
                }
                if (!fut.isDone() || fut.topologyVersion().compareTo(from) < 0) continue;
                return true;
            }
            if (fut.changedAffinity()) {
                return true;
            }
            if (fut.initialVersion().compareTo(to) < 0) continue;
            return false;
        }
        return true;
    }

    private long currentPMEDuration(boolean blocked) {
        GridDhtPartitionsExchangeFuture fut = this.lastTopologyFuture();
        return fut == null ? 0L : fut.currentPMEDuration(blocked);
    }

    public HistogramMetricImpl durationHistogram() {
        return this.durationHistogram;
    }

    public HistogramMetricImpl blockingDurationHistogram() {
        return this.blockingDurationHistogram;
    }

    public BooleanMetricImpl clusterRebalancedMetric() {
        return this.rebalanced;
    }

    private static class CacheRebalanceOrderComparator
    implements Comparator<CacheGroupContext> {
        private CacheRebalanceOrderComparator() {
        }

        @Override
        public int compare(CacheGroupContext ctx1, CacheGroupContext ctx2) {
            CacheConfiguration cfg1 = ctx1.config();
            CacheConfiguration cfg2 = ctx2.config();
            if (cfg1.getRebalanceOrder() == cfg2.getRebalanceOrder()) {
                if (cfg1.getRebalanceMode() == cfg2.getRebalanceMode()) {
                    return ctx1.cacheOrGroupName().compareTo(ctx2.cacheOrGroupName());
                }
                switch (cfg1.getRebalanceMode()) {
                    case SYNC: {
                        return -1;
                    }
                    case ASYNC: {
                        return cfg2.getRebalanceMode() == CacheRebalanceMode.SYNC ? 1 : -1;
                    }
                    case NONE: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("Unknown cache rebalance mode [mode=" + (Object)((Object)cfg1.getRebalanceMode()) + ']');
            }
            return cfg1.getRebalanceOrder() < cfg2.getRebalanceOrder() ? -1 : 1;
        }
    }

    private static class ActionLimiter<T> {
        private final int limit;
        private final Map<T, AtomicInteger> actionsCnt = new HashMap<T, AtomicInteger>();
        private final Set<T> activeObjects = new HashSet<T>();

        private ActionLimiter(int limit) {
            this.limit = limit;
        }

        boolean allowAction(T obj) {
            this.activeObjects.add(obj);
            int cnt = this.actionsCnt.computeIfAbsent(obj, o -> new AtomicInteger(0)).incrementAndGet();
            return cnt <= this.limit;
        }

        void trim() {
            this.actionsCnt.keySet().removeIf(key -> !this.activeObjects.contains(key));
            this.activeObjects.clear();
        }
    }

    private static class WarningsGroup {
        private final IgniteLogger log;
        private final int warningsLimit;
        private final String title;
        private final List<String> messages = new ArrayList<String>();
        private int warningsTotal = 0;

        private WarningsGroup(String title, IgniteLogger log, int warningsLimit) {
            this.title = title;
            this.log = log;
            this.warningsLimit = warningsLimit;
        }

        private boolean add(String msg) {
            boolean added = false;
            if (this.canAddMessage()) {
                this.messages.add(msg);
                added = true;
            }
            ++this.warningsTotal;
            return added;
        }

        private boolean canAddMessage() {
            return this.warningsTotal < this.warningsLimit;
        }

        private void incTotal() {
            ++this.warningsTotal;
        }

        private void printToLog() {
            if (this.warningsTotal > 0) {
                U.warn(this.log, String.format(this.title, this.warningsLimit, this.warningsTotal));
                for (String message : this.messages) {
                    U.warn(this.log, message);
                }
            }
        }
    }

    private class AffinityReadyFuture
    extends GridFutureAdapter<AffinityTopologyVersion> {
        @GridToStringInclude
        private AffinityTopologyVersion topVer;

        private AffinityReadyFuture(AffinityTopologyVersion topVer) {
            this.topVer = topVer;
        }

        @Override
        public boolean onDone(AffinityTopologyVersion res, @Nullable Throwable err) {
            assert (res != null || err != null);
            boolean done = super.onDone(res, err);
            if (done) {
                GridCachePartitionExchangeManager.this.readyFuts.remove(this.topVer, this);
            }
            return done;
        }

        @Override
        public String toString() {
            return S.toString(AffinityReadyFuture.class, this, super.toString());
        }
    }

    private abstract class MessageHandler<M>
    implements IgniteBiInClosure<UUID, M> {
        private static final long serialVersionUID = 0L;

        private MessageHandler() {
        }

        @Override
        public void apply(UUID nodeId, M msg) {
            ClusterNode node = GridCachePartitionExchangeManager.this.cctx.node(nodeId);
            if (node == null) {
                if (GridCachePartitionExchangeManager.this.log.isTraceEnabled()) {
                    GridCachePartitionExchangeManager.this.log.trace("Received message from failed node [node=" + nodeId + ", msg=" + msg + ']');
                }
                return;
            }
            if (GridCachePartitionExchangeManager.this.log.isTraceEnabled()) {
                GridCachePartitionExchangeManager.this.log.trace("Received message from node [node=" + nodeId + ", msg=" + msg + ']');
            }
            this.onMessage(node, msg);
        }

        protected abstract void onMessage(ClusterNode var1, M var2);
    }

    private static class ExchangeFutureSet
    extends GridListSet<GridDhtPartitionsExchangeFuture> {
        private static final long serialVersionUID = 0L;
        private final int histSize;
        private final AtomicReference<AffinityTopologyVersion> readyTopVer = new AtomicReference<AffinityTopologyVersion>(AffinityTopologyVersion.NONE);

        private ExchangeFutureSet(int histSize) {
            super((f1, f2) -> {
                AffinityTopologyVersion t1 = f1.exchangeId().topologyVersion();
                AffinityTopologyVersion t2 = f2.exchangeId().topologyVersion();
                assert (t1.topologyVersion() > 0L);
                assert (t2.topologyVersion() > 0L);
                return t2.compareTo(t1);
            }, false);
            this.histSize = histSize;
        }

        @Override
        public synchronized GridDhtPartitionsExchangeFuture addx(GridDhtPartitionsExchangeFuture fut) {
            GridDhtPartitionsExchangeFuture last;
            GridDhtPartitionsExchangeFuture cur = super.addx(fut);
            while (this.size() > this.histSize && (last = (GridDhtPartitionsExchangeFuture)this.last()).isDone() && !Objects.equals(last.initialVersion(), this.readyTopVer())) {
                this.removeLast();
            }
            return cur == null ? fut : cur;
        }

        public AffinityTopologyVersion readyTopVer() {
            return this.readyTopVer.get();
        }

        public boolean readyTopVer(AffinityTopologyVersion readyTopVersion) {
            AffinityTopologyVersion readyVer;
            do {
                if ((readyVer = this.readyTopVer.get()).compareTo(readyTopVersion) < 0) continue;
                return false;
            } while (!this.readyTopVer.compareAndSet(readyVer, readyTopVersion));
            return true;
        }

        @Override
        @Nullable
        public synchronized GridDhtPartitionsExchangeFuture removex(GridDhtPartitionsExchangeFuture val) {
            return super.removex(val);
        }

        @Override
        public synchronized List<GridDhtPartitionsExchangeFuture> values() {
            return super.values();
        }

        @Override
        public synchronized String toString() {
            return S.toString(ExchangeFutureSet.class, this, super.toString());
        }
    }

    private class ResendTimeoutObject
    implements GridTimeoutObject {
        private final IgniteUuid timeoutId = IgniteUuid.randomUuid();
        protected final IgniteLogger log;
        private final long createTime = U.currentTimeMillis();
        private AtomicBoolean started = new AtomicBoolean();

        private ResendTimeoutObject() {
            this.log = GridCachePartitionExchangeManager.this.cctx.logger(this.getClass());
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.timeoutId;
        }

        @Override
        public long endTime() {
            return this.createTime + GridCachePartitionExchangeManager.this.partResendTimeout;
        }

        @Override
        public void onTimeout() {
            GridCachePartitionExchangeManager.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    if (!GridCachePartitionExchangeManager.this.busyLock.readLock().tryLock()) {
                        return;
                    }
                    try {
                        if (ResendTimeoutObject.this.started.compareAndSet(false, true)) {
                            if (ResendTimeoutObject.this.log.isDebugEnabled()) {
                                ResendTimeoutObject.this.log.debug("Refresh partitions due to scheduled timeout");
                            }
                            GridCachePartitionExchangeManager.this.refreshPartitions();
                        }
                    }
                    finally {
                        GridCachePartitionExchangeManager.this.busyLock.readLock().unlock();
                        GridCachePartitionExchangeManager.this.cctx.time().removeTimeoutObject(ResendTimeoutObject.this);
                        GridCachePartitionExchangeManager.this.pendingResend.compareAndSet(ResendTimeoutObject.this, null);
                    }
                }
            });
        }

        public boolean started() {
            return this.started.get();
        }
    }

    private class ExchangeWorker
    extends GridWorker {
        private final LinkedBlockingDeque<CachePartitionExchangeWorkerTask> futQ;
        private AffinityTopologyVersion lastFutVer;
        private boolean crd;
        private boolean stop;
        private boolean reconnectNeeded;

        private ExchangeWorker() {
            super(GridCachePartitionExchangeManager.this.cctx.igniteInstanceName(), "partition-exchanger", GridCachePartitionExchangeManager.this.log, GridCachePartitionExchangeManager.this.cctx.kernalContext().workersRegistry());
            this.futQ = new LinkedBlockingDeque();
        }

        void forceReassign(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture fut) {
            if (!this.hasPendingExchange()) {
                this.futQ.add(new RebalanceReassignExchangeTask(SecurityUtils.remoteSecurityContext(GridCachePartitionExchangeManager.this.cctx.kernalContext()), exchId, fut));
            }
        }

        IgniteInternalFuture<Boolean> forceRebalance(GridDhtPartitionExchangeId exchId) {
            GridCompoundFuture<Boolean, Boolean> fut = new GridCompoundFuture<Boolean, Boolean>(CU.boolReducer());
            this.futQ.add(new ForceRebalanceExchangeTask(SecurityUtils.remoteSecurityContext(GridCachePartitionExchangeManager.this.cctx.kernalContext()), exchId, fut));
            return fut;
        }

        IgniteInternalFuture<Void> deferStopCachesOnClientReconnect(Collection<GridCacheAdapter> caches) {
            StopCachesOnClientReconnectExchangeTask task = new StopCachesOnClientReconnectExchangeTask(SecurityUtils.remoteSecurityContext(GridCachePartitionExchangeManager.this.cctx.kernalContext()), caches);
            this.futQ.add(task);
            return task;
        }

        void finishPreloading(AffinityTopologyVersion topVer, int grpId, long rebalanceId) {
            this.futQ.add(new FinishPreloadingTask(SecurityUtils.remoteSecurityContext(GridCachePartitionExchangeManager.this.cctx.kernalContext()), topVer, grpId, rebalanceId));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addExchangeFuture(GridDhtPartitionsExchangeFuture exchFut) {
            assert (exchFut != null);
            this.futQ.offer(exchFut);
            ExchangeWorker exchangeWorker = this;
            synchronized (exchangeWorker) {
                this.lastFutVer = exchFut.initialVersion();
                this.notifyAll();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added exchange future to exchange worker: " + exchFut);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onKernalStop() {
            ExchangeWorker exchangeWorker = this;
            synchronized (exchangeWorker) {
                this.stop = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForExchangeFuture(AffinityTopologyVersion resVer) throws IgniteInterruptedCheckedException {
            ExchangeWorker exchangeWorker = this;
            synchronized (exchangeWorker) {
                while (!this.stop && this.lastFutVer.compareTo(resVer) < 0) {
                    U.wait(this);
                }
                return this.stop;
            }
        }

        private void removeMergedFutures(AffinityTopologyVersion resVer, GridDhtPartitionsExchangeFuture exchFut) throws IgniteInterruptedCheckedException {
            if (resVer.compareTo(exchFut.initialVersion()) != 0) {
                this.waitForExchangeFuture(resVer);
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    if (!(task instanceof GridDhtPartitionsExchangeFuture)) continue;
                    GridDhtPartitionsExchangeFuture fut0 = (GridDhtPartitionsExchangeFuture)task;
                    if (resVer.compareTo(fut0.initialVersion()) < 0) break;
                    fut0.finishMerged(resVer, exchFut);
                    this.futQ.remove(fut0);
                }
            }
        }

        void addCustomTask(CachePartitionExchangeWorkerTask task) {
            assert (task != null);
            assert (!GridCachePartitionExchangeManager.isExchangeTask(task));
            this.futQ.offer(task);
        }

        void processCustomTask(CachePartitionExchangeWorkerTask task) {
            assert (!GridCachePartitionExchangeManager.isExchangeTask(task));
            try {
                GridCachePartitionExchangeManager.this.cctx.cache().processCustomExchangeTask(task);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to process custom exchange task: " + task, e);
            }
        }

        boolean hasPendingExchange() {
            if (!this.futQ.isEmpty()) {
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    if (!GridCachePartitionExchangeManager.isExchangeTask(task)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean hasPendingServerExchange() {
            if (!this.futQ.isEmpty()) {
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    if (!(task instanceof GridDhtPartitionsExchangeFuture) || !((GridDhtPartitionsExchangeFuture)task).changedAffinity()) continue;
                    return true;
                }
            }
            return false;
        }

        void dumpExchangeDebugInfo() {
            U.warn(this.log, "First " + GridCachePartitionExchangeManager.this.DIAGNOSTIC_WARN_LIMIT + " pending exchange futures [total=" + this.futQ.size() + ']');
            if (GridCachePartitionExchangeManager.this.DIAGNOSTIC_WARN_LIMIT > 0) {
                int cnt = 0;
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    if (!(task instanceof GridDhtPartitionsExchangeFuture)) continue;
                    U.warn(this.log, ">>> " + ((GridDhtPartitionsExchangeFuture)task).shortInfo());
                    if (++cnt != GridCachePartitionExchangeManager.this.DIAGNOSTIC_WARN_LIMIT) continue;
                    break;
                }
            }
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            Throwable err = null;
            try {
                this.body0();
            }
            catch (InterruptedException | IgniteInterruptedCheckedException e) {
                if (!this.stop) {
                    err = e;
                }
            }
            catch (Throwable e) {
                if (!(e == GridCachePartitionExchangeManager.this.stopErr || this.stop && X.hasCause(e, IgniteInterruptedCheckedException.class))) {
                    err = e;
                }
            }
            finally {
                if (err == null && !this.stop && !this.reconnectNeeded) {
                    err = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    GridCachePartitionExchangeManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    GridCachePartitionExchangeManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                } else {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void body0() throws InterruptedException, IgniteCheckedException {
            long timeout = GridCachePartitionExchangeManager.this.cctx.gridConfig().getNetworkTimeout();
            long cnt = 0L;
            while (!this.isCancelled()) {
                this.onIdle();
                ++cnt;
                CachePartitionExchangeWorkerTask task = null;
                try {
                    boolean preloadFinished = true;
                    for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                        if (!(preloadFinished &= grp.preloader() != null && grp.preloader().syncFuture().isDone())) break;
                    }
                    if (!GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() && !this.hasPendingExchange() && preloadFinished) {
                        timeout = GridCachePartitionExchangeManager.this.cctx.gridConfig().getNetworkTimeout();
                    }
                    if (this.log.isTraceEnabled()) {
                        HashSet<GridDhtPartitionsExchangeFuture> unfinished = new HashSet<GridDhtPartitionsExchangeFuture>();
                        for (GridDhtPartitionsExchangeFuture fut : GridCachePartitionExchangeManager.this.exchFuts.values()) {
                            if (fut.isDone()) continue;
                            unfinished.add(fut);
                        }
                        this.log.trace("Before waiting for exchange futures [futs" + unfinished + ", worker=" + this + ']');
                    }
                    if (this.isCancelled()) {
                        Thread.currentThread().interrupt();
                    }
                    this.blockingSectionBegin();
                    task = this.futQ.poll(timeout, TimeUnit.MILLISECONDS);
                    this.blockingSectionEnd();
                    if (task == null) continue;
                    OperationSecurityContext c = SecurityUtils.withRemoteSecurityContext(GridCachePartitionExchangeManager.this.cctx.kernalContext(), task.securityContext());
                    Object object = null;
                    try {
                        GridDhtPartitionExchangeId exchId;
                        if (!GridCachePartitionExchangeManager.isExchangeTask(task)) {
                            this.processCustomTask(task);
                            continue;
                        }
                        GridDhtPartitionsExchangeFuture exchFut = null;
                        AffinityTopologyVersion resVer = null;
                        if (this.isCancelled()) break;
                        if (task instanceof RebalanceReassignExchangeTask) {
                            RebalanceReassignExchangeTask reassignTask = (RebalanceReassignExchangeTask)task;
                            exchId = reassignTask.exchangeId();
                            GridDhtPartitionsExchangeFuture fut = reassignTask.future();
                            assert (fut.changedAffinity()) : "Reassignment request started for exchange future which didn't change affinity [exchId=" + exchId + ", fut=" + fut + ']';
                            if (fut.hasInapplicableNodesForRebalance()) {
                                GridDhtPartitionsExchangeFuture lastFut = (GridDhtPartitionsExchangeFuture)GridCachePartitionExchangeManager.this.lastFinishedFut.get();
                                AffinityTopologyVersion lastAffChangedVer = GridCachePartitionExchangeManager.this.cctx.exchange().lastAffinityChangedTopologyVersion(lastFut.topologyVersion());
                                if (fut.topologyVersion().equals(lastAffChangedVer)) {
                                    exchFut = fut;
                                } else if (lastAffChangedVer.after(exchId.topologyVersion())) {
                                    exchId = lastFut.exchangeId();
                                    exchFut = lastFut;
                                    exchFut.copyInapplicableNodesFrom(fut);
                                }
                            }
                        } else if (task instanceof ForceRebalanceExchangeTask) {
                            timeout = 0L;
                            exchId = ((ForceRebalanceExchangeTask)task).exchangeId();
                        } else {
                            GridDhtPartitionsExchangeFuture lastFut;
                            assert (task instanceof GridDhtPartitionsExchangeFuture) : task;
                            exchFut = (GridDhtPartitionsExchangeFuture)task;
                            exchId = exchFut.exchangeId();
                            GridCachePartitionExchangeManager.this.lastInitializedFut = exchFut;
                            boolean newCrd = false;
                            if (!this.crd) {
                                List<ClusterNode> srvNodes = exchFut.firstEventCache().serverNodes();
                                newCrd = !srvNodes.isEmpty() && srvNodes.get(0).isLocal();
                                this.crd = newCrd;
                            }
                            if (!exchFut.changedAffinity() && (lastFut = (GridDhtPartitionsExchangeFuture)GridCachePartitionExchangeManager.this.lastFinishedFut.get()) != null) {
                                if (!lastFut.changedAffinity()) {
                                    AffinityTopologyVersion lastAffVer = GridCachePartitionExchangeManager.this.cctx.exchange().lastAffinityChangedTopologyVersion(lastFut.topologyVersion());
                                    GridCachePartitionExchangeManager.this.cctx.exchange().lastAffinityChangedTopologyVersion(exchFut.initialVersion(), lastAffVer);
                                } else {
                                    GridCachePartitionExchangeManager.this.cctx.exchange().lastAffinityChangedTopologyVersion(exchFut.initialVersion(), lastFut.topologyVersion());
                                }
                            }
                            exchFut.timeBag().finishGlobalStage("Waiting in exchange queue");
                            exchFut.init(newCrd);
                            int dumpCnt = 0;
                            long waitStartNanos = System.nanoTime();
                            boolean txRolledBack = !GridCachePartitionExchangeManager.this.cctx.localNode().isClient();
                            IgniteConfiguration cfg = GridCachePartitionExchangeManager.this.cctx.gridConfig();
                            long dumpTimeout = 2L * cfg.getNetworkTimeout();
                            long nextDumpTime = 0L;
                            while (true) {
                                long curTimeout = cfg.getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
                                try {
                                    long exchTimeout = curTimeout > 0L && !txRolledBack ? Math.min(curTimeout, dumpTimeout) : dumpTimeout;
                                    this.blockingSectionBegin();
                                    try {
                                        resVer = (AffinityTopologyVersion)exchFut.get(exchTimeout, TimeUnit.MILLISECONDS);
                                    }
                                    finally {
                                        this.blockingSectionEnd();
                                    }
                                    this.onIdle();
                                }
                                catch (IgniteFutureTimeoutCheckedException ignored) {
                                    this.updateHeartbeat();
                                    if (nextDumpTime <= U.currentTimeMillis()) {
                                        U.warn(GridCachePartitionExchangeManager.this.diagnosticLog, "Failed to wait for partition map exchange [topVer=" + exchFut.initialVersion() + ", node=" + GridCachePartitionExchangeManager.this.cctx.localNodeId() + "]. " + (curTimeout <= 0L && !txRolledBack ? "Consider changing TransactionConfiguration.txTimeoutOnPartitionMapExchange to non default value to avoid this message. " : "") + "Dumping pending objects that might be the cause: ");
                                        try {
                                            GridCachePartitionExchangeManager.this.dumpDebugInfo(exchFut);
                                        }
                                        catch (Exception e) {
                                            U.error(GridCachePartitionExchangeManager.this.diagnosticLog, GridCachePartitionExchangeManager.FAILED_DUMP_MSG + e, e);
                                        }
                                        nextDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(dumpCnt++, dumpTimeout);
                                    }
                                    long passedMillis = U.millisSinceNanos(waitStartNanos);
                                    if (txRolledBack || curTimeout <= 0L || passedMillis < curTimeout) continue;
                                    txRolledBack = true;
                                    GridCachePartitionExchangeManager.this.cctx.tm().rollbackOnTopologyChange(exchFut.initialVersion());
                                    continue;
                                }
                                catch (Exception e) {
                                    if (exchFut.reconnectOnError(e)) {
                                        throw new IgniteNeedReconnectException(GridCachePartitionExchangeManager.this.cctx.localNode(), (Throwable)e);
                                    }
                                    throw e;
                                }
                                break;
                            }
                            this.removeMergedFutures(resVer, exchFut);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("After waiting for exchange future [exchFut=" + exchFut + ", worker=" + this + ']');
                            }
                            if (exchFut.exchangeId().nodeId().equals(GridCachePartitionExchangeManager.this.cctx.localNodeId())) {
                                GridCachePartitionExchangeManager.this.lastRefresh.compareAndSet(-1L, U.currentTimeMillis());
                            }
                            boolean changed = false;
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                changed |= grp.topology().afterExchange(exchFut);
                            }
                            if (!GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() && changed) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Refresh partitions due to mapping was changed");
                                }
                                GridCachePartitionExchangeManager.this.refreshPartitions();
                            }
                        }
                        if (this.rebalanceRequired(exchFut)) {
                            NavigableSet assignsSet = GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups().stream().collect(Collectors.toCollection(() -> new TreeSet<CacheGroupContext>(new CacheRebalanceOrderComparator())));
                            GridDhtPartitionDemander.RebalanceFuture next = null;
                            GridCompoundFuture<Boolean, Boolean> rebFut = new GridCompoundFuture<Boolean, Boolean>();
                            GridCompoundFuture<Boolean, Boolean> forcedRebFut = null;
                            if (task instanceof ForceRebalanceExchangeTask) {
                                forcedRebFut = ((ForceRebalanceExchangeTask)task).forcedRebalanceFuture();
                            }
                            for (CacheGroupContext grp : assignsSet.descendingSet()) {
                                GridDhtPartitionDemander.RebalanceFuture cur;
                                boolean disableRebalance = GridCachePartitionExchangeManager.this.cctx.snapshot().partitionsAreFrozen(grp);
                                if (disableRebalance || (cur = grp.preloader().prepare(exchId, exchFut, cnt, next, forcedRebFut, rebFut)) == null) continue;
                                next = cur;
                            }
                            rebFut.markInitialized();
                            if (forcedRebFut != null) {
                                forcedRebFut.markInitialized();
                            }
                            if (next != null) {
                                final GridDhtPartitionDemander.RebalanceFuture finalR = next;
                                final List rebList = assignsSet.stream().map(CacheGroupContext::cacheOrGroupName).collect(Collectors.toList());
                                final long rebId = cnt;
                                final GridDhtPartitionExchangeId finalExchId = exchId;
                                rebFut.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                                    @Override
                                    public void apply(IgniteInternalFuture<Boolean> f) {
                                        U.log(ExchangeWorker.this.log, "Rebalancing scheduled [order=" + rebList + ", top=" + finalR.topologyVersion() + ", rebalanceId=" + rebId + ", evt=" + finalExchId.discoveryEventName() + ", node=" + finalExchId.nodeId() + ']');
                                        finalR.requestPartitions();
                                    }
                                });
                                continue;
                            }
                            resVer = resVer == null ? assignsSet.stream().map(g -> g.topology().readyTopologyVersion()).filter(Objects::nonNull).findFirst().orElse(exchId.topologyVersion()) : resVer;
                            U.log(this.log, "Skipping rebalancing (nothing scheduled) [top=" + resVer + ", force=" + (exchFut == null) + ", evt=" + exchId.discoveryEventName() + ", node=" + exchId.nodeId() + ']');
                            continue;
                        }
                        U.log(this.log, "Skipping rebalancing (no affinity changes) [top=" + resVer == null ? exchId.topologyVersion() : resVer + ", evt=" + exchId.discoveryEventName() + ", evtNode=" + exchId.nodeId() + ", client=" + GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() + ']');
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (c == null) continue;
                        if (object != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable fut) {
                                ((Throwable)object).addSuppressed(fut);
                            }
                            continue;
                        }
                        c.close();
                    }
                }
                catch (IgniteInterruptedCheckedException e) {
                    throw e;
                }
                catch (IgniteClientDisconnectedCheckedException | IgniteNeedReconnectException e) {
                    if (GridCachePartitionExchangeManager.this.cctx.discovery().reconnectSupported()) {
                        U.warn(this.log, "Local node failed to complete partition map exchange due to exception, will try to reconnect to cluster: " + e.getMessage(), e);
                        GridCachePartitionExchangeManager.this.cctx.discovery().reconnect();
                        this.reconnectNeeded = true;
                    } else {
                        U.warn(this.log, "Local node received IgniteClientDisconnectedCheckedException or  IgniteNeedReconnectException exception but doesn't support reconnect, stopping node: " + e.getMessage(), e);
                    }
                    return;
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to wait for completion of partition map exchange (preloading will not start): " + task, e);
                    throw e;
                }
            }
        }

        private boolean rebalanceRequired(GridDhtPartitionsExchangeFuture exchFut) {
            if (GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode()) {
                return false;
            }
            if (exchFut == null) {
                return true;
            }
            return GridCachePartitionExchangeManager.this.lastAffinityChangedTopologyVersion(exchFut.topologyVersion()).equals(exchFut.topologyVersion());
        }
    }
}

