/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class PropertyArgs
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final String NAME = "--name";
    public static final String VAL = "--val";
    private String name;
    private String val;
    private Action action;

    public PropertyArgs() {
    }

    public PropertyArgs(String name, String val, Action action) {
        assert (name != null);
        this.name = name;
        this.val = val;
        this.action = action;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.val;
    }

    public Action action() {
        return this.action;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeString(out, this.val);
        out.writeByte(this.action.ordinal());
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.val = U.readString(in);
        this.action = Action.fromOrdinal(in.readByte());
    }

    public String toString() {
        return this.name + "=" + this.val;
    }

    public static enum Action {
        GET,
        SET;

        private static final Action[] VALS;

        @Nullable
        public static Action fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = Action.values();
        }
    }
}

