/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryArray
implements BinaryObjectEx,
Externalizable,
Comparable<BinaryArray> {
    public static final boolean DFLT_IGNITE_USE_BINARY_ARRAYS = false;
    private static boolean USE_BINARY_ARRAYS = IgniteSystemProperties.getBoolean("IGNITE_USE_BINARY_ARRAYS", false);
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    @GridToStringExclude
    protected BinaryContext ctx;
    protected int compTypeId;
    @Nullable
    protected String compClsName;
    @GridToStringInclude(sensitive=true)
    protected Object[] arr;
    @GridToStringExclude
    protected Object[] deserialized;

    public BinaryArray() {
    }

    public BinaryArray(BinaryContext ctx, int compTypeId, @Nullable String compClsName, Object[] arr) {
        this.ctx = ctx;
        this.compTypeId = compTypeId;
        this.compClsName = compClsName;
        this.arr = arr;
    }

    @Override
    public BinaryType type() throws BinaryObjectException {
        return BinaryUtils.typeProxy(this.ctx, this);
    }

    @Override
    @Nullable
    public BinaryType rawType() throws BinaryObjectException {
        return BinaryUtils.type(this.ctx, this);
    }

    @Override
    public <T> T deserialize() throws BinaryObjectException {
        return this.deserialize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(ClassLoader ldr) throws BinaryObjectException {
        ClassLoader resolveLdr;
        ClassLoader classLoader = resolveLdr = ldr == null ? this.ctx.configuration().getClassLoader() : ldr;
        if (ldr != null) {
            GridBinaryMarshaller.USE_CACHE.set(Boolean.FALSE);
        }
        try {
            Class compType = BinaryUtils.resolveClass(this.ctx, this.compTypeId, this.compClsName, resolveLdr, false);
            if (this.deserialized != null) {
                Object[] objectArray = this.deserialized;
                return (T)objectArray;
            }
            this.deserialized = (Object[])Array.newInstance(compType, this.arr.length);
            for (int i = 0; i < this.arr.length; ++i) {
                Object obj = CacheObjectUtils.unwrapBinaryIfNeeded(null, this.arr[i], false, false, ldr);
                if (obj instanceof BinaryObject) {
                    obj = ((BinaryObject)obj).deserialize(ldr);
                }
                this.deserialized[i] = obj;
            }
            Object[] objectArray = this.deserialized;
            return (T)objectArray;
        }
        finally {
            GridBinaryMarshaller.USE_CACHE.set(Boolean.TRUE);
        }
    }

    public Object[] array() {
        return this.arr;
    }

    public int componentTypeId() {
        return this.compTypeId == 0 ? this.ctx.typeId(this.compClsName) : this.compTypeId;
    }

    public String componentClassName() {
        return this.compClsName;
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return new BinaryArray(this.ctx, this.compTypeId, this.compClsName, (Object[])this.arr.clone());
    }

    @Override
    public int typeId() {
        return 23;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.compTypeId);
        out.writeObject(this.compClsName);
        out.writeObject(this.arr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = GridBinaryMarshaller.threadLocalContext();
        this.compTypeId = in.readInt();
        this.compClsName = (String)in.readObject();
        this.arr = (Object[])in.readObject();
    }

    @Override
    public BinaryObjectBuilder toBuilder() throws BinaryObjectException {
        throw new UnsupportedOperationException("Builder cannot be created for array wrapper.");
    }

    @Override
    public int enumOrdinal() throws BinaryObjectException {
        throw new BinaryObjectException("Object is not enum.");
    }

    @Override
    public String enumName() throws BinaryObjectException {
        throw new BinaryObjectException("Object is not enum.");
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isFlagSet(short flag) {
        return false;
    }

    @Override
    public <F> F field(String fieldName) throws BinaryObjectException {
        return null;
    }

    @Override
    public boolean hasField(String fieldName) {
        return false;
    }

    public int hashCode() {
        int result = 31 * Objects.hash(this.componentTypeId());
        result = 31 * result + IgniteUtils.hashCode(this.arr);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryArray arr = (BinaryArray)o;
        return this.componentTypeId() == arr.componentTypeId() && Arrays.deepEquals(this.arr, arr.arr);
    }

    @Override
    public int compareTo(@NotNull BinaryArray o) {
        if (this.componentTypeId() != o.componentTypeId()) {
            throw new IllegalArgumentException("Can't compare arrays of different types[this=" + this.componentTypeId() + ",that=" + o.componentTypeId() + ']');
        }
        return F.compareArrays(this.arr, o.arr);
    }

    public String toString() {
        return S.toString(BinaryArray.class, this);
    }

    public static boolean useBinaryArrays() {
        return USE_BINARY_ARRAYS;
    }

    public static void initUseBinaryArrays() {
        USE_BINARY_ARRAYS = IgniteSystemProperties.getBoolean("IGNITE_USE_BINARY_ARRAYS", false);
    }
}

