/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.ignite.IgniteMetadata;
import io.trino.plugin.jdbc.DefaultJdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class IgniteJdbcMetadataFactory
extends DefaultJdbcMetadataFactory {
    private final Set<JdbcQueryEventListener> jdbcQueryEventListeners;

    @Inject
    public IgniteJdbcMetadataFactory(JdbcClient jdbcClient, Set<JdbcQueryEventListener> jdbcQueryEventListeners) {
        super(jdbcClient, jdbcQueryEventListeners);
        this.jdbcQueryEventListeners = ImmutableSet.copyOf((Collection)Objects.requireNonNull(jdbcQueryEventListeners, "jdbcQueryEventListeners is null"));
    }

    protected JdbcMetadata create(JdbcClient transactionCachingJdbcClient) {
        return new IgniteMetadata(transactionCachingJdbcClient, this.jdbcQueryEventListeners);
    }
}

