/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.security.AccessControlRules;
import io.trino.plugin.base.security.AnySchemaPermissionsRule;
import io.trino.plugin.base.security.AuthorizationRule;
import io.trino.plugin.base.security.FunctionAccessControlRule;
import io.trino.plugin.base.security.SchemaAccessControlRule;
import io.trino.plugin.base.security.SessionPropertyAccessControlRule;
import io.trino.plugin.base.security.TableAccessControlRule;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class FileBasedAccessControl
implements ConnectorAccessControl {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final String catalogName;
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;
    private final List<FunctionAccessControlRule> functionRules;
    private final List<AuthorizationRule> authorizationRules;
    private final Set<AnySchemaPermissionsRule> anySchemaPermissionsRules;

    public FileBasedAccessControl(CatalogName catalogName, AccessControlRules rules) {
        this.catalogName = catalogName.toString();
        Preconditions.checkArgument((!rules.hasRoleRules() ? 1 : 0) != 0, (Object)"File connector access control does not support role rules");
        this.schemaRules = rules.getSchemaRules();
        this.tableRules = rules.getTableRules();
        this.sessionPropertyRules = rules.getSessionPropertyRules();
        this.functionRules = rules.getFunctionRules();
        this.authorizationRules = rules.getAuthorizationRules();
        ImmutableSet.Builder anySchemaPermissionsRules = ImmutableSet.builder();
        this.schemaRules.stream().map(SchemaAccessControlRule::toAnySchemaPermissionsRule).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableSet.Builder)anySchemaPermissionsRules).add(arg_0));
        this.tableRules.stream().map(TableAccessControlRule::toAnySchemaPermissionsRule).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableSet.Builder)anySchemaPermissionsRules).add(arg_0));
        this.functionRules.stream().map(FunctionAccessControlRule::toAnySchemaPermissionsRule).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableSet.Builder)anySchemaPermissionsRules).add(arg_0));
        this.anySchemaPermissionsRules = anySchemaPermissionsRules.build();
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName, Map<String, Object> properties) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        if (!this.isSchemaOwner(context, schemaName) || !this.isSchemaOwner(context, newSchemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schemaName, (TrinoPrincipal)principal);
        }
        if (!this.checkCanSetAuthorization(context, principal)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schemaName, (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return (Set)schemaNames.stream().filter(schemaName -> this.checkAnySchemaAccess(context, (String)schemaName)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyShowCreateSchema((String)schemaName);
        }
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
        if (!this.checkAnySchemaAccess(context, schemaName)) {
            AccessDeniedException.denyShowTables((String)schemaName);
        }
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return (Set)tableNames.stream().filter(tableName -> this.isSchemaOwner(context, tableName.getSchemaName()) || this.checkAnyTablePermission(context, (SchemaTableName)tableName)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkAnyTablePermission(context, tableName)) {
            AccessDeniedException.denyShowColumns((String)tableName.toString());
        }
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return columns;
        }
        ConnectorIdentity identity = context.getIdentity();
        TableAccessControlRule rule = this.tableRules.stream().filter(tableRule -> tableRule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), tableName)).findFirst().orElse(null);
        if (rule == null || rule.getPrivileges().isEmpty()) {
            return ImmutableSet.of();
        }
        if (rule.getPrivileges().stream().anyMatch(privilege -> TableAccessControlRule.TablePrivilege.SELECT != privilege)) {
            return columns;
        }
        Set<String> restrictedColumns = rule.getRestrictedColumns();
        return (Set)columns.stream().filter(column -> !restrictedColumns.contains(column)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newTableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetTableProperties((String)tableName.toString());
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanSetViewComment(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentView((String)viewName.toString());
        }
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentColumn((String)tableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanAlterColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAlterColumn((String)tableName.toString());
        }
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetTableAuthorization((String)tableName.toString(), (TrinoPrincipal)principal);
        }
        if (!this.checkCanSetAuthorization(context, principal)) {
            AccessDeniedException.denySetTableAuthorization((String)tableName.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return;
        }
        ConnectorIdentity identity = context.getIdentity();
        boolean allowed = this.tableRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), tableName)).map(rule -> rule.canSelectColumns(columnNames)).findFirst().orElse(false);
        if (!allowed) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyTruncateTable((String)tableName.toString());
        }
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.UPDATE)) {
            AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumns);
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetViewAuthorization((String)viewName.toString(), (TrinoPrincipal)principal);
        }
        if (!this.checkCanSetAuthorization(context, principal)) {
            AccessDeniedException.denySetViewAuthorization((String)viewName.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return;
        }
        ConnectorIdentity identity = context.getIdentity();
        TableAccessControlRule rule = this.tableRules.stream().filter(tableRule -> tableRule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), tableName)).findFirst().orElse(null);
        if (rule == null || !rule.canSelectColumns(columnNames)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
        if (!rule.getPrivileges().contains((Object)TableAccessControlRule.TablePrivilege.GRANT_SELECT)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)context.getIdentity());
        }
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        if (!this.checkTablePermission(context, materializedViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateMaterializedView((String)materializedViewName.toString());
        }
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        if (!this.checkTablePermission(context, materializedViewName, TableAccessControlRule.TablePrivilege.UPDATE)) {
            AccessDeniedException.denyRefreshMaterializedView((String)materializedViewName.toString());
        }
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        if (!this.checkTablePermission(context, materializedViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropMaterializedView((String)materializedViewName.toString());
        }
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameMaterializedView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanGrantExecuteFunctionPrivilege(ConnectorSecurityContext context, FunctionKind functionKind, SchemaRoutineName functionName, TrinoPrincipal grantee, boolean grantOption) {
        if (!this.checkFunctionPermission(context, functionKind, functionName, FunctionAccessControlRule::canGrantExecuteFunction)) {
            String granteeAsString = String.format("%s '%s'", grantee.getType().name().toLowerCase(Locale.ENGLISH), grantee.getName());
            AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)functionName.toString(), (Identity)Identity.ofUser((String)context.getIdentity().getUser()), (String)granteeAsString);
        }
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
        if (!this.checkTablePermission(context, materializedViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetMaterializedViewProperties((String)materializedViewName.toString());
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        if (!this.canSetSessionProperty(context, propertyName)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)propertyName);
        }
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyGrantSchemaPrivilege((String)privilege.name(), (String)schemaName);
        }
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyDenySchemaPrivilege((String)privilege.name(), (String)schemaName);
        }
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyRevokeSchemaPrivilege((String)privilege.name(), (String)schemaName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)tableName.toString());
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        AccessDeniedException.denyDenyTablePrivilege((String)privilege.toString(), (String)tableName.toString());
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)tableName.toString());
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyCreateRole((String)role);
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        AccessDeniedException.denyDropRole((String)role);
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role) {
        AccessDeniedException.denySetRole((String)role);
    }

    public void checkCanShowRoleAuthorizationDescriptors(ConnectorSecurityContext context) {
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
    }

    public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
    }

    public void checkCanExecuteFunction(ConnectorSecurityContext context, FunctionKind functionKind, SchemaRoutineName function) {
        if (!this.checkFunctionPermission(context, functionKind, function, FunctionAccessControlRule::canExecuteFunction)) {
            AccessDeniedException.denyExecuteFunction((String)function.toString());
        }
    }

    public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return ImmutableList.of();
        }
        ConnectorIdentity identity = context.getIdentity();
        return (List)this.tableRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), tableName)).map(rule -> rule.getFilter(this.catalogName, tableName.getSchemaName())).findFirst().stream().flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return Optional.empty();
        }
        ConnectorIdentity identity = context.getIdentity();
        List masks = this.tableRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), tableName)).map(rule -> rule.getColumnMask(this.catalogName, tableName.getSchemaName(), columnName)).findFirst().stream().flatMap(Optional::stream).toList();
        if (masks.size() > 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_MASK, String.format("Multiple masks defined for %s.%s", tableName, columnName));
        }
        return masks.stream().findFirst();
    }

    public List<ViewExpression> getColumnMasks(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        throw new UnsupportedOperationException();
    }

    private boolean canSetSessionProperty(ConnectorSecurityContext context, String property) {
        ConnectorIdentity identity = context.getIdentity();
        for (SessionPropertyAccessControlRule rule : this.sessionPropertyRules) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), property);
            if (!allowed.isPresent()) continue;
            return allowed.get();
        }
        return false;
    }

    private boolean checkAnyTablePermission(ConnectorSecurityContext context, SchemaTableName tableName) {
        return this.checkTablePermission(context, tableName, (Set<TableAccessControlRule.TablePrivilege> privileges) -> !privileges.isEmpty());
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, TableAccessControlRule.TablePrivilege requiredPrivilege) {
        return this.checkTablePermission(context, tableName, (Set<TableAccessControlRule.TablePrivilege> privileges) -> privileges.contains((Object)requiredPrivilege));
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, Predicate<Set<TableAccessControlRule.TablePrivilege>> checkPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        ConnectorIdentity identity = context.getIdentity();
        for (TableAccessControlRule rule : this.tableRules) {
            if (!rule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), tableName)) continue;
            return checkPrivileges.test(rule.getPrivileges());
        }
        return false;
    }

    private boolean checkAnySchemaAccess(ConnectorSecurityContext context, String schemaName) {
        ConnectorIdentity identity = context.getIdentity();
        return this.anySchemaPermissionsRules.stream().anyMatch(rule -> rule.match(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), schemaName));
    }

    private boolean isSchemaOwner(ConnectorSecurityContext context, String schemaName) {
        ConnectorIdentity identity = context.getIdentity();
        for (SchemaAccessControlRule rule : this.schemaRules) {
            Optional<Boolean> owner = rule.match(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), schemaName);
            if (!owner.isPresent()) continue;
            return owner.get();
        }
        return false;
    }

    private boolean checkFunctionPermission(ConnectorSecurityContext context, FunctionKind functionKind, SchemaRoutineName functionName, Predicate<FunctionAccessControlRule> executePredicate) {
        ConnectorIdentity identity = context.getIdentity();
        return this.functionRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledSystemRoles(), identity.getGroups(), functionKind, functionName)).findFirst().filter(executePredicate).isPresent();
    }

    private boolean checkCanSetAuthorization(ConnectorSecurityContext context, TrinoPrincipal principal) {
        ConnectorIdentity identity = context.getIdentity();
        Set roles = (Set)identity.getConnectorRole().stream().flatMap(role -> role.getRole().stream()).collect(ImmutableSet.toImmutableSet());
        return this.authorizationRules.stream().flatMap(rule -> rule.match(identity.getUser(), identity.getGroups(), roles, principal).stream()).findFirst().orElse(false);
    }
}

