/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcTransactionManager;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Procedure
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "procedure";
    private final JdbcTransactionManager transactionManager;

    @Inject
    public Procedure(JdbcTransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new ProcedureFunction(this.transactionManager), this.getClass().getClassLoader());
    }

    public static class ProcedureFunction
    extends AbstractConnectorTableFunction {
        private final JdbcTransactionManager transactionManager;

        public ProcedureFunction(JdbcTransactionManager transactionManager) {
            super(Procedure.SCHEMA_NAME, Procedure.NAME, List.of(ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument argument = (ScalarArgument)Iterables.getOnlyElement(arguments.values());
            String procedureQuery = ((Slice)argument.getValue()).toStringUtf8();
            JdbcMetadata metadata = this.transactionManager.getMetadata(transaction);
            JdbcProcedureHandle tableHandle = metadata.getProcedureHandle(session, new JdbcProcedureHandle.ProcedureQuery(procedureQuery));
            List<JdbcColumnHandle> columns = tableHandle.getColumns().orElseThrow(() -> new IllegalStateException("Handle doesn't have columns info"));
            Descriptor returnedType = new Descriptor((List)columns.stream().map(column -> new Descriptor.Field(column.getColumnName(), Optional.of(column.getColumnType()))).collect(ImmutableList.toImmutableList()));
            ProcedureFunctionHandle handle = new ProcedureFunctionHandle(tableHandle);
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class ProcedureFunctionHandle
    implements ConnectorTableFunctionHandle {
        private final JdbcProcedureHandle tableHandle;

        @JsonCreator
        public ProcedureFunctionHandle(@JsonProperty(value="tableHandle") JdbcProcedureHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

