/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.base.MappedRecordSet;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcRecordSet;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;

public class JdbcRecordSetProvider
implements ConnectorRecordSetProvider {
    private final JdbcClient jdbcClient;
    private final ExecutorService executor;

    @Inject
    public JdbcRecordSetProvider(JdbcClient jdbcClient, @ForRecordCursor ExecutorService executor) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        JdbcSplit jdbcSplit = (JdbcSplit)split;
        BaseJdbcConnectorTableHandle jdbcTable = (BaseJdbcConnectorTableHandle)table;
        jdbcTable.getColumns().ifPresent(tableColumns -> Verify.verify((boolean)ImmutableSet.copyOf((Collection)tableColumns).containsAll((Collection)columns)));
        if (jdbcTable instanceof JdbcTableHandle) {
            JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)jdbcTable;
            ImmutableList.Builder handles = ImmutableList.builderWithExpectedSize((int)columns.size());
            for (ColumnHandle columnHandle : columns) {
                handles.add((Object)((JdbcColumnHandle)columnHandle));
            }
            return new JdbcRecordSet(this.jdbcClient, this.executor, session, jdbcSplit, jdbcTableHandle.intersectedWithConstraint((TupleDomain<ColumnHandle>)jdbcSplit.getDynamicFilter().transformKeys(ColumnHandle.class::cast)), (List<JdbcColumnHandle>)handles.build());
        }
        JdbcProcedureHandle procedureHandle = (JdbcProcedureHandle)jdbcTable;
        List<JdbcColumnHandle> sourceColumns = procedureHandle.getColumns().orElseThrow();
        Map columnIndexMap = (Map)IntStream.range(0, sourceColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(sourceColumns::get, UnaryOperator.identity()));
        return new MappedRecordSet((RecordSet)new JdbcRecordSet(this.jdbcClient, this.executor, session, jdbcSplit, procedureHandle, sourceColumns), (List)columns.stream().map(JdbcColumnHandle.class::cast).map(columnIndexMap::get).collect(ImmutableList.toImmutableList()));
    }
}

