/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.noop;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.IgniteSpiNoop;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.jetbrains.annotations.Nullable;

@IgniteSpiNoop
@IgniteSpiMultipleInstancesSupport(value=true)
public class NoopCheckpointSpi
extends IgniteSpiAdapter
implements CheckpointSpi {
    @LoggerResource
    private IgniteLogger log;
    private final AtomicBoolean warnedAboutDisabledCheckpoints = new AtomicBoolean(false);

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
    }

    @Override
    public void spiStop() throws IgniteSpiException {
    }

    @Override
    @Nullable
    public byte[] loadCheckpoint(String key) throws IgniteSpiException {
        this.warnOnceAboutDisabledCheckpoints();
        return null;
    }

    @Override
    public boolean saveCheckpoint(String key, byte[] state, long timeout, boolean overwrite) {
        this.warnOnceAboutDisabledCheckpoints();
        return false;
    }

    @Override
    public boolean removeCheckpoint(String key) {
        this.warnOnceAboutDisabledCheckpoints();
        return false;
    }

    @Override
    public void setCheckpointListener(CheckpointListener lsnr) {
    }

    @Override
    public NoopCheckpointSpi setName(String name) {
        super.setName(name);
        return this;
    }

    private void warnOnceAboutDisabledCheckpoints() {
        if (this.warnedAboutDisabledCheckpoints.compareAndSet(false, true)) {
            U.warn(this.log, "Checkpoints are disabled (to enable configure any GridCheckpointSpi implementation)");
        }
    }

    public String toString() {
        return S.toString(NoopCheckpointSpi.class, this);
    }
}

