/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryManager;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ComputeTaskNoResultCache
public final class PlatformFullTask
extends PlatformAbstractTask {
    private static final long serialVersionUID = 0L;
    private final long topVer;
    private final ClusterGroup grp;
    private final String taskName;

    public PlatformFullTask(PlatformContext ctx, ClusterGroup grp, long taskPtr, long topVer, String taskName) {
        super(ctx, taskPtr);
        this.grp = grp;
        this.topVer = topVer;
        this.taskName = taskName;
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        assert (arg == null);
        this.lock.readLock().lock();
        try {
            assert (!this.done);
            Collection<ClusterNode> nodes = this.grp.nodes();
            PlatformMemoryManager memMgr = this.ctx.memory();
            try (PlatformMemory mem = memMgr.allocate();){
                PlatformOutputStream out = mem.output();
                BinaryRawWriterEx writer = this.ctx.writer(out);
                writer.writeLong(this.taskPtr);
                this.write(writer, nodes, subgrid);
                out.synchronize();
                this.ctx.gateway().computeTaskMap(mem.pointer());
                PlatformInputStream in = mem.input();
                in.synchronize();
                BinaryRawReaderEx reader = this.ctx.reader(in);
                Map<ComputeJob, ClusterNode> map = this.read(reader, nodes);
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void write(BinaryRawWriterEx writer, Collection<ClusterNode> nodes, List<ClusterNode> subgrid) {
        GridDiscoveryManager discoMgr = this.ctx.kernalContext().discovery();
        long curTopVer = discoMgr.topologyVersion();
        if (this.topVer != curTopVer) {
            writer.writeBoolean(true);
            writer.writeLong(curTopVer);
            writer.writeInt(nodes.size());
            writer.writeInt(subgrid.size());
            for (ClusterNode node : nodes) {
                this.ctx.writeNode(writer, node);
                writer.writeBoolean(subgrid.contains(node));
            }
        } else {
            writer.writeBoolean(false);
        }
    }

    private Map<ComputeJob, ClusterNode> read(BinaryRawReaderEx reader, Collection<ClusterNode> nodes) {
        if (reader.readBoolean()) {
            if (!reader.readBoolean()) {
                return null;
            }
            int size = reader.readInt();
            HashMap<ComputeJob, ClusterNode> map = U.newHashMap(size);
            for (int i = 0; i < size; ++i) {
                long ptr = reader.readLong();
                Object nativeJob = reader.readBoolean() ? reader.readObjectDetached() : null;
                PlatformJob job = this.ctx.createJob(this, ptr, nativeJob, this.taskName);
                UUID jobNodeId = reader.readUuid();
                assert (jobNodeId != null);
                ClusterNode jobNode = this.ctx.kernalContext().discovery().node(jobNodeId);
                if (jobNode == null) {
                    for (ClusterNode node : nodes) {
                        if (!node.id().equals(jobNodeId)) continue;
                        jobNode = node;
                        break;
                    }
                    assert (jobNode != null);
                }
                map.put(job, jobNode);
            }
            return map;
        }
        throw new IgniteException(reader.readString());
    }
}

