/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.FixCountRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.FixLeftmostChildRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.FixRemoveId;
import org.apache.ignite.internal.pagemem.wal.record.delta.InsertRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageAddRootRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageCutRootRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRootInlineFlagsCreatedVersionRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.NewRootInitRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RemoveRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.ReplaceRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.SplitExistingPageRecord;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedDataStructureException;
import org.apache.ignite.internal.processors.cache.persistence.DataStructure;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTreeRuntimeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.LongListReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandlerWrapper;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.GridArrays;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridTreePrinter;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public abstract class BPlusTree<L, T extends L>
extends DataStructure
implements IgniteTree<L, T> {
    private static final Object[] EMPTY = new Object[0];
    public static PageHandlerWrapper<Result> testHndWrapper = null;
    public static final ThreadLocal<Boolean> suspendFailureDiagnostic = ThreadLocal.withInitial(() -> false);
    public static final String CONC_DESTROY_MSG = "Tree is being concurrently destroyed: ";
    private static volatile boolean interrupted;
    public static final int IGNITE_BPLUS_TREE_LOCK_RETRIES_DEFAULT = 1000;
    private static final int LOCK_RETRIES;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final float minFill;
    private final float maxFill;
    protected final long metaPageId;
    private boolean canGetRowFromInner;
    private IOVersions<? extends BPlusInnerIO<L>> innerIos;
    private IOVersions<? extends BPlusLeafIO<L>> leafIos;
    private final AtomicLong globalRmvId;
    private volatile TreeMetaData treeMeta;
    private final FailureProcessor failureProcessor;
    private boolean sequentialWriteOptsEnabled;
    private final GridTreePrinter<Long> treePrinter = new GridTreePrinter<Long>(){
        private boolean keys = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        protected List<Long> getChildren(Long pageId) {
            if (pageId == null || pageId == 0L) {
                return null;
            }
            try {
                long page = BPlusTree.this.acquirePage(pageId);
                try {
                    ArrayList<Long> arrayList;
                    BPlusIO io;
                    long pageAddr;
                    block17: {
                        pageAddr = BPlusTree.this.readLock(pageId, page);
                        if (pageAddr == 0L) {
                            List<Long> list = null;
                            return list;
                        }
                        io = BPlusTree.this.io(pageAddr);
                        if (!io.isLeaf()) break block17;
                        List<Long> list = Collections.emptyList();
                        BPlusTree.this.readUnlock(pageId, page, pageAddr);
                        return list;
                    }
                    try {
                        ArrayList<Long> res;
                        int cnt = io.getCount(pageAddr);
                        assert (cnt >= 0) : cnt;
                        if (cnt > 0) {
                            res = new ArrayList<Long>(cnt + 1);
                            for (int i = 0; i < cnt; ++i) {
                                res.add(BPlusTree.inner(io).getLeft(pageAddr, i));
                            }
                            res.add(BPlusTree.inner(io).getRight(pageAddr, cnt - 1));
                        } else {
                            long left = BPlusTree.inner(io).getLeft(pageAddr, 0);
                            res = left == 0L ? Collections.emptyList() : Collections.singletonList(left);
                        }
                        arrayList = res;
                    }
                    catch (Throwable throwable) {
                        BPlusTree.this.readUnlock(pageId, page, pageAddr);
                        throw throwable;
                    }
                    BPlusTree.this.readUnlock(pageId, page, pageAddr);
                    return arrayList;
                }
                finally {
                    BPlusTree.this.releasePage(pageId, page);
                }
            }
            catch (IgniteCheckedException ignored) {
                throw new AssertionError((Object)"Can not acquire page.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        protected String formatTreeNode(Long pageId) {
            if (pageId == null) {
                return ">NPE<";
            }
            if (pageId == 0L) {
                return "<Zero>";
            }
            try {
                long page = BPlusTree.this.acquirePage(pageId);
                try {
                    String string;
                    long pageAddr = BPlusTree.this.readLock(pageId, page);
                    if (pageAddr == 0L) {
                        String string2 = "<Obsolete>";
                        return string2;
                    }
                    try {
                        BPlusIO io = BPlusTree.this.io(pageAddr);
                        string = BPlusTree.this.printPage(io, pageAddr, this.keys);
                    }
                    catch (Throwable throwable) {
                        BPlusTree.this.readUnlock(pageId, page, pageAddr);
                        throw throwable;
                    }
                    BPlusTree.this.readUnlock(pageId, page, pageAddr);
                    return string;
                }
                finally {
                    BPlusTree.this.releasePage(pageId, page);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private final PageHandler<Get, Result> askNeighbor;
    private final PageHandler<Get, Result> search;
    private final PageHandler<Put, Result> replace;
    private final PageHandler<Put, Result> insert;
    private final PageHandler<Remove, Result> rmvFromLeaf;
    private final PageHandler<Remove, Result> rmvRangeFromLeaf;
    private final PageHandler<Remove, Result> lockBackAndRmvFromLeaf;
    private final PageHandler<Remove, Result> lockBackAndTail;
    private final PageHandler<Remove, Result> lockTailForward;
    private final PageHandler<Update, Result> lockTailExact;
    private final PageHandler<Remove, Result> lockTail;
    private final PageHandler<Void, Bool> cutRoot = new CutRoot();
    private final PageHandler<Long, Bool> addRoot = new AddRoot();
    private final PageHandler<Long, Bool> initRoot = new InitRoot();

    protected BPlusTree(String name, int cacheGrpId, String cacheGrpName, PageMemory pageMem, @Nullable IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, IOVersions<? extends BPlusInnerIO<L>> innerIos, IOVersions<? extends BPlusLeafIO<L>> leafIos, byte pageFlag, @Nullable FailureProcessor failureProcessor, PageLockTrackerManager pageLockTrackerManager) throws IgniteCheckedException {
        this(name, cacheGrpId, cacheGrpName, pageMem, wal, globalRmvId, metaPageId, reuseList, pageFlag, failureProcessor, pageLockTrackerManager, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER);
        this.setIos(innerIos, leafIos);
    }

    protected BPlusTree(String name, int cacheGrpId, String grpName, PageMemory pageMem, @Nullable IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, long metaPageId, ReuseList reuseList, byte pageFlag, @Nullable FailureProcessor failureProcessor, PageLockTrackerManager pageLockTrackerManager, PageIoResolver pageIoRslvr) {
        super(name, cacheGrpId, grpName, pageMem, wal, pageLockTrackerManager, pageIoRslvr, pageFlag);
        this.minFill = 0.0f;
        this.maxFill = 0.0f;
        assert (metaPageId != 0L);
        this.metaPageId = metaPageId;
        this.reuseList = reuseList;
        this.globalRmvId = globalRmvId;
        this.failureProcessor = failureProcessor;
        this.askNeighbor = this.wrap(this, new AskNeighbor());
        this.search = this.wrap(this, new Search());
        this.lockTailExact = this.wrap(this, new LockTailExact());
        this.lockTail = this.wrap(this, new LockTail());
        this.lockTailForward = this.wrap(this, new LockTailForward());
        this.lockBackAndTail = this.wrap(this, new LockBackAndTail());
        this.lockBackAndRmvFromLeaf = this.wrap(this, new LockBackAndRmvFromLeaf());
        this.rmvFromLeaf = this.wrap(this, new RemoveFromLeaf());
        this.insert = this.wrap(this, new Insert());
        this.replace = this.wrap(this, new Replace());
        this.rmvRangeFromLeaf = this.wrap(this, new RemoveRangeFromLeaf());
    }

    private PageHandler<?, Result> wrap(BPlusTree<?, ?> tree, PageHandler<?, Result> hnd) {
        if (testHndWrapper == null) {
            return hnd;
        }
        return testHndWrapper.wrap(tree, hnd);
    }

    public void setIos(IOVersions<? extends BPlusInnerIO<L>> innerIos, IOVersions<? extends BPlusLeafIO<L>> leafIos) {
        assert (innerIos != null);
        assert (leafIos != null);
        this.canGetRowFromInner = innerIos.latest().canGetRow();
        this.innerIos = innerIos;
        this.leafIos = leafIos;
    }

    public void enableSequentialWriteMode() {
        this.sequentialWriteOptsEnabled = true;
    }

    protected final void initTree(boolean initNew) throws IgniteCheckedException {
        this.initTree(initNew, 0);
    }

    protected final void initTree(boolean initNew, int inlineSize) throws IgniteCheckedException {
        if (initNew) {
            long rootId = this.allocatePage(null);
            this.init(rootId, this.latestLeafIO());
            Bool res = this.write(this.metaPageId, this.initRoot, BPlusMetaIO.VERSIONS.latest(), Long.valueOf(rootId), inlineSize, Bool.FALSE, this.statisticsHolder());
            assert (res == Bool.TRUE) : res;
            assert (this.treeMeta != null);
        }
    }

    private TreeMetaData treeMeta() throws IgniteCheckedException {
        return this.treeMeta(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMetaData treeMeta(long metaPageAddr) throws IgniteCheckedException {
        TreeMetaData meta0 = this.treeMeta;
        if (meta0 != null) {
            return meta0;
        }
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long pageAddr;
            if (metaPageAddr == 0L) {
                pageAddr = this.readLock(this.metaPageId, metaPage);
                assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong(this.metaPageId) + ']';
            } else {
                pageAddr = metaPageAddr;
            }
            try {
                BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
                int rootLvl = io.getRootLevel(pageAddr);
                long rootId = io.getFirstPageId(pageAddr, rootLvl);
                this.treeMeta = meta0 = new TreeMetaData(rootLvl, rootId);
            }
            finally {
                if (metaPageAddr == 0L) {
                    this.readUnlock(this.metaPageId, metaPage, pageAddr);
                }
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        return meta0;
    }

    private int getRootLevel() throws IgniteCheckedException {
        return this.getRootLevel(0L);
    }

    private int getRootLevel(long metaPageAddr) throws IgniteCheckedException {
        TreeMetaData meta0 = this.treeMeta(metaPageAddr);
        assert (meta0 != null);
        return meta0.rootLvl;
    }

    private long getFirstPageId(long metaId, long metaPage, int lvl) {
        return this.getFirstPageId(metaId, metaPage, lvl, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFirstPageId(long metaId, long metaPage, int lvl, long metaPageAddr) {
        long pageAddr = metaPageAddr != 0L ? metaPageAddr : this.readLock(metaId, metaPage);
        try {
            BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
            if (lvl < 0) {
                lvl = io.getRootLevel(pageAddr);
            }
            if (lvl >= io.getLevelsCount(pageAddr)) {
                long l = 0L;
                return l;
            }
            long l = io.getFirstPageId(pageAddr, lvl);
            return l;
        }
        finally {
            if (metaPageAddr == 0L) {
                this.readUnlock(metaId, metaPage, pageAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCursor<T> findLowerUnbounded(L upper, boolean upIncl, TreeRowClosure<L, T> c, TreeRowFactory<L, T> rowFactory, Object x) throws IgniteCheckedException {
        long firstPageId;
        ForwardCursor cursor = new ForwardCursor(upper, upIncl, c, rowFactory, x);
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            firstPageId = this.getFirstPageId(this.metaPageId, metaPage, 0);
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        try {
            long firstPage = this.acquirePage(firstPageId);
            try {
                long pageAddr = this.readLock(firstPageId, firstPage);
                try {
                    cursor.init(pageAddr, this.io(pageAddr), -1);
                }
                finally {
                    this.readUnlock(firstPageId, firstPage, pageAddr);
                }
            }
            finally {
                this.releasePage(firstPageId, firstPage);
            }
        }
        catch (AssertionError | RuntimeException e) {
            throw new BPlusTreeRuntimeException((Throwable)e, this.grpId, this.metaPageId, firstPageId);
        }
        return cursor;
    }

    protected final void checkDestroyed() throws IgniteCheckedException {
        if (this.destroyed.get()) {
            throw new IgniteCheckedException(CONC_DESTROY_MSG + this.name());
        }
    }

    @Override
    public final GridCursor<T> find(L lower, L upper) throws IgniteCheckedException {
        return this.find(lower, upper, null);
    }

    @Override
    public final GridCursor<T> find(L lower, L upper, Object x) throws IgniteCheckedException {
        return this.find(lower, upper, null, x);
    }

    public GridCursor<T> find(L lower, L upper, TreeRowClosure<L, T> c, Object x) throws IgniteCheckedException {
        return this.find(lower, upper, true, true, c, null, x);
    }

    public GridCursor<T> find(L lower, L upper, boolean lowIncl, boolean upIncl, TreeRowClosure<L, T> c, TreeRowFactory<L, T> rowFactory, Object x) throws IgniteCheckedException {
        this.checkDestroyed();
        ForwardCursor cursor = new ForwardCursor(lower, upper, lowIncl, upIncl, c, rowFactory, x);
        try {
            if (lower == null) {
                GridCursor<T> gridCursor = this.findLowerUnbounded(upper, upIncl, c, rowFactory, x);
                return gridCursor;
            }
            cursor.find();
            ForwardCursor forwardCursor = cursor;
            return forwardCursor;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on bounds: [lower=" + lower + ", upper=" + upper + "]", e);
        }
        catch (AssertionError | RuntimeException e) {
            long[] pageIds = this.pages(lower == null || cursor == null || cursor.getCursor == null, () -> new long[]{cursor.getCursor.pageId});
            throw this.corruptedTreeException("Runtime failure on bounds: [lower=" + lower + ", upper=" + upper + "]", (Throwable)e, this.grpId, pageIds);
        }
        finally {
            this.checkDestroyed();
        }
    }

    public void iterate(L lower, L upper, TreeRowClosure<L, T> c) throws IgniteCheckedException {
        this.checkDestroyed();
        ClosureCursor cursor = new ClosureCursor(lower, upper, c);
        try {
            cursor.iterate();
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on bounds: [lower=" + lower + ", upper=" + upper + "]", e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on bounds: [lower=" + lower + ", upper=" + upper + "]", (Throwable)e, this.grpId, this.pages(cursor.getCursor != null, () -> new long[]{cursor.getCursor.pageId}));
        }
        finally {
            this.checkDestroyed();
        }
    }

    public void visit(L lower, L upper, TreeVisitorClosure<L, T> c) throws IgniteCheckedException {
        this.checkDestroyed();
        try {
            new TreeVisitor(lower, upper, c).visit();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on bounds: [lower=" + lower + ", upper=" + upper + "]", e);
        }
        catch (RuntimeException e) {
            throw new IgniteException("Runtime failure on bounds: [lower=" + lower + ", upper=" + upper + "]", e);
        }
        catch (AssertionError e) {
            throw new AssertionError("Assertion error on bounds: [lower=" + lower + ", upper=" + upper + "]", (Throwable)((Object)e));
        }
        finally {
            this.checkDestroyed();
        }
    }

    @Override
    public T findFirst() throws IgniteCheckedException {
        return this.findFirst(null);
    }

    /*
     * Exception decompiling
     */
    public T findFirst(TreeRowClosure<L, T> filter) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 29[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public T findLast() throws IgniteCheckedException {
        return this.findLast(null);
    }

    public T findLast(TreeRowClosure<L, T> c) throws IgniteCheckedException {
        this.checkDestroyed();
        Get g = null;
        try {
            GetLast gLast;
            if (c == null) {
                g = new GetOne(null, null, null, true);
                this.doFind(g);
                Object l = g.row;
                return (T)l;
            }
            g = gLast = new GetLast(c);
            Object t = gLast.find();
            return t;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on last row lookup", e);
        }
        catch (AssertionError | RuntimeException e) {
            GetLast g0 = g;
            long[] pageIds = this.pages(g == null, () -> new long[]{g0.pageId});
            throw this.corruptedTreeException("Runtime failure on last row lookup", (Throwable)e, this.grpId, pageIds);
        }
        finally {
            this.checkDestroyed();
        }
    }

    public final <R> R findOne(L row, Object x) throws IgniteCheckedException {
        return this.findOne(row, null, x);
    }

    public final <R> R findOne(L row, TreeRowClosure<L, T> c, Object x) throws IgniteCheckedException {
        this.checkDestroyed();
        GetOne g = new GetOne(row, c, x, false);
        try {
            this.doFind(g);
            Object object = g.row;
            return (R)object;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on lookup row: " + row, e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on lookup row: " + row, (Throwable)e, this.grpId, g.pageId);
        }
        finally {
            this.checkDestroyed();
        }
    }

    @Override
    public final T findOne(L row) throws IgniteCheckedException {
        return (T)this.findOne(row, null, null);
    }

    private void doFind(Get g) throws IgniteCheckedException {
        assert (!this.sequentialWriteOptsEnabled);
        block3: while (true) {
            g.init();
            switch (this.findDown(g, g.rootId, 0L, g.rootLvl)) {
                case RETRY: 
                case RETRY_ROOT: {
                    this.checkDestroyed();
                    BPlusTree.checkInterrupted();
                    continue block3;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result findDown(Get g, long pageId, long fwdId, int lvl) throws IgniteCheckedException {
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block12: while (true) {
                g.checkLockRetry();
                g.pageId = pageId;
                g.fwdId = fwdId;
                res = this.read(pageId, page, this.search, g, lvl, Result.RETRY);
                switch (res) {
                    case GO_DOWN: 
                    case GO_DOWN_X: {
                        assert (g.pageId != pageId);
                        assert (g.fwdId != fwdId || fwdId == 0L);
                        res = this.findDown(g, g.pageId, g.fwdId, lvl - 1);
                        switch (res) {
                            case RETRY: {
                                BPlusTree.checkInterrupted();
                                continue block12;
                            }
                        }
                        Result result = res;
                        return result;
                    }
                    case NOT_FOUND: {
                        assert (lvl == 0) : lvl;
                        g.row = null;
                        Result result = res;
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            if (g.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    public static String treeName(String instance, String type) {
        return instance + "##" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String printTree() throws IgniteCheckedException {
        long rootPageId;
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            rootPageId = this.getFirstPageId(this.metaPageId, metaPage, -1);
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        return this.treePrinter.print(rootPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validateTree() throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            int rootLvl = this.getRootLevel();
            if (rootLvl < 0) {
                this.fail("Root level: " + rootLvl);
            }
            this.validateFirstPages(this.metaPageId, metaPage, rootLvl);
            long rootPageId = this.getFirstPageId(this.metaPageId, metaPage, rootLvl);
            this.validateDownPages(rootPageId, 0L, rootLvl);
            this.validateDownKeys(rootPageId, null, rootLvl);
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDownKeys(long pageId, L minRow, int lvl) throws IgniteCheckedException {
        long page = this.acquirePage(pageId);
        try {
            long pageAddr = this.readLock(pageId, page);
            try {
                BPlusIO<L> io = this.io(pageAddr);
                int cnt = io.getCount(pageAddr);
                if (cnt < 0) {
                    this.fail("Negative count: " + cnt);
                }
                if (io.isLeaf()) {
                    for (int i = 0; i < cnt; ++i) {
                        if (minRow != null && this.compare(lvl, io, pageAddr, i, minRow) <= 0) {
                            this.fail("Wrong sort order: " + U.hexLong(pageId) + " , at " + i + " , minRow: " + minRow);
                        }
                        minRow = io.getLookupRow(this, pageAddr, i);
                    }
                    return;
                }
                for (int i = 0; i < cnt; ++i) {
                    long leftId;
                    L leafRow;
                    int cmp;
                    L row = io.getLookupRow(this, pageAddr, i);
                    if (minRow != null && this.compare(lvl, io, pageAddr, i, minRow) <= 0) {
                        this.fail("Min row violated: " + row + " , minRow: " + minRow);
                    }
                    if ((cmp = this.compare(lvl, io, pageAddr, i, leafRow = this.getGreatestRowInSubTree(leftId = BPlusTree.inner(io).getLeft(pageAddr, i)))) < 0 || cmp != 0 && this.canGetRowFromInner) {
                        this.fail("Wrong inner row: " + U.hexLong(pageId) + " , at: " + i + " , leaf:  " + leafRow + " , inner: " + row);
                    }
                    this.validateDownKeys(leftId, minRow, lvl - 1);
                    minRow = row;
                }
                long rightId = BPlusTree.inner(io).getLeft(pageAddr, cnt);
                this.validateDownKeys(rightId, minRow, lvl - 1);
            }
            finally {
                this.readUnlock(pageId, page, pageAddr);
            }
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private L getGreatestRowInSubTree(long pageId) throws IgniteCheckedException {
        long page = this.acquirePage(pageId);
        try {
            int cnt;
            BPlusIO<L> io;
            long pageAddr;
            block9: {
                L l;
                pageAddr = this.readLock(pageId, page);
                try {
                    io = this.io(pageAddr);
                    cnt = io.getCount(pageAddr);
                    if (!io.isLeaf()) break block9;
                    if (cnt <= 0) {
                        this.fail("Invalid leaf count: " + cnt + " " + U.hexLong(pageId));
                    }
                    l = io.getLookupRow(this, pageAddr, cnt - 1);
                }
                catch (Throwable throwable) {
                    this.readUnlock(pageId, page, pageAddr);
                    throw throwable;
                }
                this.readUnlock(pageId, page, pageAddr);
                return l;
            }
            long rightId = BPlusTree.inner(io).getLeft(pageAddr, cnt);
            L l = this.getGreatestRowInSubTree(rightId);
            this.readUnlock(pageId, page, pageAddr);
            return l;
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    private void validateFirstPages(long metaId, long metaPage, int rootLvl) throws IgniteCheckedException {
        for (int lvl = rootLvl; lvl > 0; --lvl) {
            this.validateFirstPage(metaId, metaPage, lvl);
        }
    }

    private void fail(Object msg) {
        AssertionError err = new AssertionError(msg);
        this.processFailure(FailureType.CRITICAL_ERROR, (Throwable)((Object)err));
        throw err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFirstPage(long metaId, long metaPage, int lvl) throws IgniteCheckedException {
        long leftmostChildId;
        if (lvl == 0) {
            this.fail("Leaf level: " + lvl);
        }
        long pageId = this.getFirstPageId(metaId, metaPage, lvl);
        long page = this.acquirePage(pageId);
        try {
            long pageAddr = this.readLock(pageId, page);
            try {
                BPlusIO<L> io = this.io(pageAddr);
                if (io.isLeaf()) {
                    this.fail("Leaf.");
                }
                leftmostChildId = BPlusTree.inner(io).getLeft(pageAddr, 0);
            }
            finally {
                this.readUnlock(pageId, page, pageAddr);
            }
        }
        finally {
            this.releasePage(pageId, page);
        }
        long firstDownPageId = this.getFirstPageId(metaId, metaPage, lvl - 1);
        if (firstDownPageId != leftmostChildId) {
            this.fail(new SB("First: meta ").appendHex(firstDownPageId).a(", child ").appendHex(leftmostChildId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDownPages(long pageId, long fwdId, int lvl) throws IgniteCheckedException {
        block21: {
            long page = this.acquirePage(pageId);
            try {
                long pageAddr = this.readLock(pageId, page);
                try {
                    int cnt;
                    long actualFwdId;
                    BPlusIO<L> io;
                    long realPageId = BPlusIO.getPageId(pageAddr);
                    if (realPageId != pageId) {
                        this.fail(new SB("ABA on page ID: ref ").appendHex(pageId).a(", buf ").appendHex(realPageId));
                    }
                    if ((io = this.io(pageAddr)).isLeaf() != (lvl == 0)) {
                        this.fail("Leaf level mismatch: " + lvl);
                    }
                    if ((actualFwdId = io.getForward(pageAddr)) != fwdId) {
                        this.fail(new SB("Triangle: expected fwd ").appendHex(fwdId).a(", actual fwd ").appendHex(actualFwdId));
                    }
                    if ((cnt = io.getCount(pageAddr)) < 0) {
                        this.fail("Negative count: " + cnt);
                    }
                    if (io.isLeaf()) {
                        if (cnt == 0 && this.getRootLevel() != 0) {
                            this.fail("Empty leaf page.");
                        }
                        break block21;
                    }
                    for (int i = 0; i < cnt; ++i) {
                        this.validateDownPages(BPlusTree.inner(io).getLeft(pageAddr, i), BPlusTree.inner(io).getRight(pageAddr, i), lvl - 1);
                    }
                    if (fwdId != 0L) {
                        long fwdId0 = fwdId;
                        long fwdPage = this.acquirePage(fwdId0);
                        try {
                            long fwdPageAddr = this.readLock(fwdId0, fwdPage);
                            try {
                                if (this.io(fwdPageAddr) != io) {
                                    this.fail("IO on the same level must be the same");
                                }
                                fwdId = BPlusTree.inner(io).getLeft(fwdPageAddr, 0);
                            }
                            finally {
                                this.readUnlock(fwdId0, fwdPage, fwdPageAddr);
                            }
                        }
                        finally {
                            this.releasePage(fwdId0, fwdPage);
                        }
                    }
                    long leftId = BPlusTree.inner(io).getLeft(pageAddr, cnt);
                    this.validateDownPages(leftId, fwdId, lvl - 1);
                }
                finally {
                    this.readUnlock(pageId, page, pageAddr);
                }
            }
            finally {
                this.releasePage(pageId, page);
            }
        }
    }

    private String printPage(BPlusIO<L> io, long pageAddr, boolean keys) throws IgniteCheckedException {
        StringBuilder b = new StringBuilder();
        b.append(BPlusTree.formatPageId(PageIO.getPageId(pageAddr)));
        b.append(" [ ");
        b.append(io.isLeaf() ? "L " : "I ");
        int cnt = io.getCount(pageAddr);
        long fwdId = io.getForward(pageAddr);
        b.append("cnt=").append(cnt).append(' ');
        b.append("fwd=").append(BPlusTree.formatPageId(fwdId)).append(' ');
        if (!io.isLeaf()) {
            b.append("lm=").append(BPlusTree.formatPageId(BPlusTree.inner(io).getLeft(pageAddr, 0))).append(' ');
            if (cnt > 0) {
                b.append("rm=").append(BPlusTree.formatPageId(BPlusTree.inner(io).getRight(pageAddr, cnt - 1))).append(' ');
            }
        }
        if (keys) {
            b.append("keys=").append(this.printPageKeys(io, pageAddr)).append(' ');
        }
        b.append(']');
        return b.toString();
    }

    private String printPageKeys(BPlusIO<L> io, long pageAddr) throws IgniteCheckedException {
        int cnt = io.getCount(pageAddr);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < cnt; ++i) {
            if (i != 0) {
                b.append(',');
            }
            b.append(io.isLeaf() || this.canGetRowFromInner ? this.getRow(io, pageAddr, i) : io.getLookupRow(this, pageAddr, i));
        }
        b.append(']');
        return b.toString();
    }

    private static String formatPageId(long x) {
        return U.hexLong(x);
    }

    private static int fix(int idx) {
        assert (BPlusTree.checkIndex(idx)) : idx;
        if (idx < 0) {
            idx = -idx - 1;
        }
        return idx;
    }

    private static boolean checkIndex(int idx) {
        return idx > -32767 && idx < Short.MAX_VALUE;
    }

    private static void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupted.");
        }
    }

    public static void interruptAll() {
        interrupted = true;
    }

    @Override
    public final T remove(L row) throws IgniteCheckedException {
        return this.doRemove(new Remove((Object)row, true));
    }

    public final boolean removex(L row) throws IgniteCheckedException {
        Boolean res = (Boolean)this.doRemove(new Remove((Object)row, false));
        return res != null ? res : false;
    }

    public List<L> remove(L lower, L upper, int limit) throws IgniteCheckedException {
        assert (this.canGetRowFromInner) : "Not supported";
        assert (limit >= 0) : limit;
        RemoveRange rmvOp = new RemoveRange(lower, upper, true, limit);
        this.doRemove(rmvOp);
        assert (rmvOp.isDone());
        return Collections.unmodifiableList(rmvOp.removedRows);
    }

    @Override
    public void invoke(L row, Object z, IgniteTree.InvokeClosure<T> c) throws IgniteCheckedException {
        this.checkDestroyed();
        Invoke x = new Invoke(row, z, c);
        try {
            block12: {
                Result res;
                block10: while (true) {
                    x.init();
                    res = this.invokeDown(x, x.rootId, 0L, 0L, x.rootLvl);
                    switch (res) {
                        case RETRY: 
                        case RETRY_ROOT: {
                            BPlusTree.checkInterrupted();
                            continue block10;
                        }
                    }
                    if (x.isFinished()) break block12;
                    res = x.tryFinish();
                    if (res != Result.RETRY && res != Result.RETRY_ROOT) break;
                    BPlusTree.checkInterrupted();
                }
                assert (x.isFinished()) : res;
            }
            return;
        }
        catch (UnregisteredBinaryTypeException | UnregisteredClassException | CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on search row: " + row, e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on search row: " + row, (Throwable)e, this.grpId, x.pageId);
        }
        finally {
            x.releaseAll();
            this.checkDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result invokeDown(Invoke x, long pageId, long backId, long fwdId, int lvl) throws IgniteCheckedException {
        assert (lvl >= 0) : lvl;
        if (x.isTail(pageId, lvl)) {
            return Result.FOUND;
        }
        long page = this.acquirePage(pageId);
        try {
            Result res = Result.RETRY;
            block14: while (true) {
                if (res == Result.RETRY) {
                    x.checkLockRetry();
                }
                x.pageId(pageId);
                x.fwdId(fwdId);
                x.backId(backId);
                res = this.read(pageId, page, this.search, x, lvl, Result.RETRY);
                switch (res) {
                    case GO_DOWN_X: {
                        assert (backId != 0L);
                        assert (x.backId == 0L);
                        x.backId(pageId);
                        res = this.askNeighbor(backId, x, true);
                        if (res != Result.FOUND) {
                            Result result = res;
                            return result;
                        }
                        assert (x.backId != pageId);
                    }
                    case GO_DOWN: {
                        res = this.invokeDown(x, x.pageId, x.backId, x.fwdId, lvl - 1);
                        if (res == Result.RETRY_ROOT || x.isFinished()) {
                            Result result = res;
                            return result;
                        }
                        if (res == Result.RETRY) {
                            BPlusTree.checkInterrupted();
                            continue block14;
                        }
                        assert (x.op != null);
                        Result result = res = x.op.finishOrLockTail(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                    case NOT_FOUND: {
                        if (lvl == 0) {
                            x.invokeClosure();
                        }
                        assert (lvl == (x.isPut() ? (int)((Put)x.op).btmLvl : 0)) : "NOT_FOUND on the wrong level  [lvl=" + lvl + ", x=" + x + ", btmLvl=" + (Invoke.access$5800(x) ? (int)((Put)x.op).btmLvl : 0) + ']';
                        Result result = x.onNotFound(pageId, page, fwdId, lvl);
                        return result;
                    }
                    case FOUND: {
                        assert (lvl == 0) : "Invoke found an item in an inner node instead of going down: lvl=" + lvl;
                        x.invokeClosure();
                        Result result = x.onFound(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            x.levelExit();
            if (x.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private T doRemove(Remove r) throws IgniteCheckedException {
        assert (!this.sequentialWriteOptsEnabled);
        Object row = r.row;
        this.checkDestroyed();
        try {
            block15: {
                Result res;
                block10: while (true) {
                    r.init();
                    res = this.removeDown(r, r.rootId, 0L, 0L, r.rootLvl);
                    switch (res) {
                        case RETRY: 
                        case RETRY_ROOT: {
                            BPlusTree.checkInterrupted();
                            continue block10;
                        }
                    }
                    if (r.isFinished()) break block15;
                    res = r.finishTail();
                    if (res != Result.RETRY && res != Result.NOT_FOUND) break;
                    assert (r.checkTailLevel(this.getRootLevel())) : "tail=" + r.tail + ", res=" + (Object)((Object)res);
                    BPlusTree.checkInterrupted();
                }
                assert (res == Result.FOUND) : res;
            }
            assert (r.isFinished());
            Object t = r.rmvd;
            return t;
        }
        catch (CorruptedDataStructureException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Runtime failure on search row: " + row, e);
        }
        catch (AssertionError | RuntimeException e) {
            throw this.corruptedTreeException("Runtime failure on search row: " + row, (Throwable)e, this.grpId, r.pageId);
        }
        finally {
            r.releaseAll();
            this.checkDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result removeDown(Remove r, long pageId, long backId, long fwdId, int lvl) throws IgniteCheckedException {
        assert (lvl >= 0) : lvl;
        if (r.isTail(pageId, lvl)) {
            return Result.FOUND;
        }
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block14: while (true) {
                r.checkLockRetry();
                r.pageId = pageId;
                r.fwdId = fwdId;
                r.backId = backId;
                res = this.read(pageId, page, this.search, r, lvl, Result.RETRY);
                switch (res) {
                    case GO_DOWN_X: {
                        assert (backId != 0L);
                        assert (r.backId == 0L);
                        r.backId = pageId;
                        res = this.askNeighbor(backId, r, true);
                        if (res != Result.FOUND) {
                            Result result = res;
                            return result;
                        }
                        assert (r.backId != pageId);
                    }
                    case GO_DOWN: {
                        res = this.removeDown(r, r.pageId, r.backId, r.fwdId, lvl - 1);
                        if (res == Result.RETRY) {
                            BPlusTree.checkInterrupted();
                            continue block14;
                        }
                        if (res == Result.RETRY_ROOT || r.isFinished()) {
                            Result result = res;
                            return result;
                        }
                        Result result = res = r.finishOrLockTail(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                    case NOT_FOUND: {
                        assert (lvl == 0) : lvl;
                        if (!r.ceil()) {
                            Result result = r.finish(res);
                            return result;
                        }
                    }
                    case FOUND: {
                        Result result = r.tryRemoveFromLeaf(pageId, page, backId, fwdId, lvl);
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            r.page = 0L;
            if (r.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private boolean mayMerge(int cnt, int cap) {
        int minCnt = (int)(this.minFill * (float)cap);
        if (cnt <= minCnt) {
            assert (cnt == 0);
            return true;
        }
        assert (cnt > 0);
        int maxCnt = (int)(this.maxFill * (float)cap);
        if (cnt > maxCnt) {
            return false;
        }
        assert (false);
        return BPlusTree.randomInt(maxCnt - minCnt) >= cnt - minCnt;
    }

    public final int rootLevel() throws IgniteCheckedException {
        this.checkDestroyed();
        return this.getRootLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() throws IgniteCheckedException {
        this.checkDestroyed();
        while (true) {
            TreeMetaData treeMeta = this.treeMeta();
            long rootId = treeMeta.rootId;
            long rootPage = this.acquirePage(rootId);
            try {
                boolean bl;
                long rootAddr = this.readLock(rootId, rootPage);
                if (rootAddr == 0L) {
                    this.checkDestroyed();
                    continue;
                }
                try {
                    BPlusIO<L> io = this.io(rootAddr);
                    bl = io.getCount(rootAddr) == 0;
                }
                catch (Throwable throwable) {
                    this.readUnlock(rootId, rootPage, rootAddr);
                    throw throwable;
                }
                this.readUnlock(rootId, rootPage, rootAddr);
                return bl;
            }
            finally {
                this.releasePage(rootId, rootPage);
                continue;
            }
            break;
        }
    }

    @Override
    public final long size() throws IgniteCheckedException {
        return this.size(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long size(@Nullable TreeRowClosure<L, T> filter) throws IgniteCheckedException {
        this.checkDestroyed();
        while (true) {
            metaPage = this.acquirePage(this.metaPageId);
            try {
                curPageId = this.getFirstPageId(this.metaPageId, metaPage, 0);
            }
            finally {
                this.releasePage(this.metaPageId, metaPage);
            }
            cnt = 0L;
            curPage = this.acquirePage(curPageId);
            try {
                curPageAddr = this.readLock(curPageId, curPage);
                if (curPageAddr == 0L) continue;
                io = this.io(curPageAddr);
                if (!BPlusTree.$assertionsDisabled && !io.isLeaf()) {
                    throw new AssertionError();
                }
                while (true) lbl-1000:
                // 5 sources

                {
                    curPageSize = io.getCount(curPageAddr);
                    if (filter == null) {
                        cnt += (long)curPageSize;
                    } else {
                        for (i = 0; i < curPageSize; ++i) {
                            if (!filter.apply(this, io, curPageAddr, i)) continue;
                            ++cnt;
                        }
                    }
                    nextPageId = io.getForward(curPageAddr);
                    if (nextPageId == 0L) {
                        this.checkDestroyed();
                        var16_12 = cnt;
                        return var16_12;
                    }
                    nextPage = this.acquirePage(nextPageId);
                    try {
                        nextPageAddr = this.readLock(nextPageId, nextPage);
                        if (!BPlusTree.$assertionsDisabled && nextPageAddr == 0L) {
                            throw new AssertionError(nextPageAddr);
                        }
                        try {
                            pa = curPageAddr;
                            curPageAddr = 0L;
                            this.readUnlock(curPageId, curPage, pa);
                            p = curPage;
                            curPage = 0L;
                            this.releasePage(curPageId, p);
                            curPageId = nextPageId;
                            curPage = nextPage;
                            curPageAddr = nextPageAddr;
                            nextPage = 0L;
                            nextPageAddr = 0L;
                        }
                        finally {
                            if (nextPageAddr == 0L) ** GOTO lbl-1000
                            this.readUnlock(nextPageId, nextPage, nextPageAddr);
                        }
                    }
                    finally {
                        if (nextPage == 0L) continue;
                        this.releasePage(nextPageId, nextPage);
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (curPageAddr != 0L) {
                        this.readUnlock(curPageId, curPage, curPageAddr);
                    }
                }
            }
            finally {
                if (curPage == 0L) continue;
                this.releasePage(curPageId, curPage);
                continue;
            }
            break;
        }
    }

    @Override
    public final T put(T row) throws IgniteCheckedException {
        return this.doPut(row, true);
    }

    public boolean putx(T row) throws IgniteCheckedException {
        Boolean res = (Boolean)this.doPut(row, false);
        return res != null ? res : false;
    }

    private T doPut(T row, boolean needOld) throws IgniteCheckedException {
        this.checkDestroyed();
        Put p = new Put(row, needOld);
        try {
            Result res;
            block12: while (true) {
                p.init();
                res = this.putDown(p, p.rootId, 0L, p.rootLvl);
                switch (res) {
                    case RETRY: 
                    case RETRY_ROOT: {
                        BPlusTree.checkInterrupted();
                        continue block12;
                    }
                    case FOUND: {
                        if (!(p.isFinished() || (res = p.finishTail()) != Result.RETRY && res != Result.NOT_FOUND)) {
                            p.releaseTail();
                            assert (p.checkTailLevel(this.getRootLevel())) : "tail=" + p.tail + ", res=" + (Object)((Object)res);
                            BPlusTree.checkInterrupted();
                            continue block12;
                        }
                        Object t = p.oldRow;
                        return t;
                    }
                }
                break;
            }
            try {
                throw new IllegalStateException("Result: " + (Object)((Object)res));
            }
            catch (CorruptedDataStructureException e) {
                throw e;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException("Runtime failure on row: " + row, e);
            }
            catch (AssertionError | RuntimeException e) {
                throw this.corruptedTreeException("Runtime failure on row: " + row, (Throwable)e, this.grpId, p.pageId);
            }
        }
        finally {
            this.checkDestroyed();
        }
    }

    protected void temporaryReleaseLock() {
    }

    private void temporaryReleaseLock(Deque<GridTuple3<Long, Long, Long>> lockedPages) {
        lockedPages.iterator().forEachRemaining(t -> this.writeUnlock((Long)t.get1(), (Long)t.get2(), (Long)t.get3(), true));
        this.temporaryReleaseLock();
        lockedPages.descendingIterator().forEachRemaining(t -> this.writeLock((Long)t.get1(), (Long)t.get2()));
    }

    protected long maxLockHoldTime() {
        return Long.MAX_VALUE;
    }

    public final long destroy() throws IgniteCheckedException {
        return this.destroy(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long destroy(@Nullable IgniteInClosure<L> c, boolean forceDestroy) throws IgniteCheckedException {
        this.close();
        if (!this.markDestroyed() && !forceDestroy) {
            return 0L;
        }
        if (this.reuseList == null) {
            return -1L;
        }
        LongListReuseBag bag = new LongListReuseBag();
        long pagesCnt = 0L;
        AtomicLong lockHoldStartTime = new AtomicLong(U.currentTimeMillis());
        LinkedList<GridTuple3<Long, Long, Long>> lockedPages = new LinkedList<GridTuple3<Long, Long, Long>>();
        long lockMaxTime = this.maxLockHoldTime();
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long metaPageAddr = this.writeLock(this.metaPageId, metaPage);
            lockedPages.push(new GridTuple3<Long, Long, Long>(this.metaPageId, metaPage, metaPageAddr));
            try {
                assert (metaPageAddr != 0L);
                int rootLvl = this.getRootLevel(metaPageAddr);
                if (rootLvl < 0) {
                    this.fail("Root level: " + rootLvl);
                }
                long rootPageId = this.getFirstPageId(this.metaPageId, metaPage, rootLvl, metaPageAddr);
                pagesCnt += this.destroyDownPages(bag, rootPageId, rootLvl, c, lockHoldStartTime, lockMaxTime, lockedPages);
                bag.addFreePage(this.recyclePage(this.metaPageId, metaPage, metaPageAddr, null));
                ++pagesCnt;
            }
            finally {
                this.writeUnlock(this.metaPageId, metaPage, metaPageAddr, true);
                lockedPages.pop();
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
        this.reuseList.addForRecycle(bag);
        assert (bag.isEmpty()) : bag.size();
        return pagesCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long destroyDownPages(LongListReuseBag bag, long pageId, int lvl, @Nullable IgniteInClosure<L> c, AtomicLong lockHoldStartTime, long lockMaxTime, Deque<GridTuple3<Long, Long, Long>> lockedPages) throws IgniteCheckedException {
        if (pageId == 0L) {
            return 0L;
        }
        long pagesCnt = 0L;
        long page = this.acquirePage(pageId);
        try {
            long pageAddr = this.writeLock(pageId, page);
            if (pageAddr == 0L) {
                long l = 0L;
                return l;
            }
            lockedPages.push(new GridTuple3<Long, Long, Long>(pageId, page, pageAddr));
            try {
                int cnt;
                BPlusIO<L> io = this.io(pageAddr);
                if (io.isLeaf() != (lvl == 0)) {
                    this.fail("Leaf level mismatch: " + lvl);
                }
                if ((cnt = io.getCount(pageAddr)) < 0) {
                    this.fail("Negative count: " + cnt);
                }
                if (!io.isLeaf()) {
                    for (int i = 0; i <= cnt; ++i) {
                        long leftId = BPlusTree.inner(io).getLeft(pageAddr, i);
                        BPlusTree.inner(io).setLeft(pageAddr, i, 0L);
                        pagesCnt += this.destroyDownPages(bag, leftId, lvl - 1, c, lockHoldStartTime, lockMaxTime, lockedPages);
                    }
                }
                if (c != null && io.isLeaf()) {
                    io.visit(pageAddr, c);
                }
                bag.addFreePage(this.recyclePage(pageId, page, pageAddr, null));
                ++pagesCnt;
            }
            finally {
                this.writeUnlock(pageId, page, pageAddr, true);
                lockedPages.pop();
            }
            if (U.currentTimeMillis() - lockHoldStartTime.get() > lockMaxTime) {
                this.temporaryReleaseLock(lockedPages);
                lockHoldStartTime.set(U.currentTimeMillis());
            }
        }
        finally {
            this.releasePage(pageId, page);
        }
        if (bag.size() == 128) {
            this.reuseList.addForRecycle(bag);
            assert (bag.isEmpty()) : bag.size();
        }
        return pagesCnt;
    }

    public boolean markDestroyed() {
        return this.destroyed.compareAndSet(false, true);
    }

    public boolean destroyed() {
        return this.destroyed.get();
    }

    protected Iterable<Long> getFirstPageIds(long pageAddr) {
        ArrayList<Long> res = new ArrayList<Long>();
        BPlusMetaIO mio = BPlusMetaIO.VERSIONS.forPage(pageAddr);
        for (int lvl = mio.getRootLevel(pageAddr); lvl >= 0; --lvl) {
            res.add(mio.getFirstPageId(pageAddr, lvl));
        }
        return res;
    }

    private boolean splitPage(long pageId, long page, long pageAddr, BPlusIO io, long fwdId, long fwdBuf, int idx) throws IgniteCheckedException {
        int cnt = io.getCount(pageAddr);
        int mid = this.sequentialWriteOptsEnabled ? (int)((double)cnt * 0.85) : cnt >>> 1;
        boolean res = false;
        if (idx > mid) {
            ++mid;
            res = true;
        }
        io.splitForwardPage(pageAddr, fwdId, fwdBuf, mid, cnt, this.pageSize(), this.metrics);
        io.splitExistingPage(pageAddr, mid, fwdId);
        if (this.needWalDeltaRecord(pageId, page, null)) {
            this.wal.log(new SplitExistingPageRecord(this.grpId, pageId, mid, fwdId));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlockAndClose(long pageId, long page, long pageAddr, Boolean walPlc) {
        try {
            this.writeUnlock(pageId, page, pageAddr, walPlc, true);
        }
        finally {
            this.releasePage(pageId, page);
        }
    }

    private Result askNeighbor(long pageId, Get g, boolean back) throws IgniteCheckedException {
        return this.read(pageId, this.askNeighbor, g, back ? Bool.TRUE.ordinal() : Bool.FALSE.ordinal(), Result.RETRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result putDown(Put p, long pageId, long fwdId, int lvl) throws IgniteCheckedException {
        assert (lvl >= 0) : lvl;
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block12: while (true) {
                p.checkLockRetry();
                p.pageId = pageId;
                p.fwdId = fwdId;
                res = this.read(pageId, page, this.search, p, lvl, Result.RETRY);
                switch (res) {
                    case GO_DOWN: 
                    case GO_DOWN_X: {
                        assert (lvl > 0) : lvl;
                        assert (p.pageId != pageId);
                        assert (p.fwdId != fwdId || fwdId == 0L);
                        res = this.putDown(p, p.pageId, p.fwdId, lvl - 1);
                        if (res == Result.RETRY_ROOT || p.isFinished()) {
                            Result result = res;
                            return result;
                        }
                        if (res == Result.RETRY) {
                            BPlusTree.checkInterrupted();
                            continue block12;
                        }
                        Result result = res = p.finishOrLockTail(pageId, page, 0L, fwdId, lvl);
                        return result;
                    }
                    case FOUND: {
                        assert (lvl == 0) : "This replace can happen only at the bottom level.";
                        Result result = p.tryReplace(pageId, page, fwdId, lvl);
                        return result;
                    }
                    case NOT_FOUND: {
                        assert (lvl == p.btmLvl) : "must insert at the bottom level";
                        Result result = p.tryInsert(pageId, page, fwdId, lvl);
                        return result;
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            if (p.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private void doVisit(TreeVisitor c) throws IgniteCheckedException {
        block3: while (true) {
            c.init();
            switch (this.visitDown(c, c.rootId, 0L, c.rootLvl)) {
                case RETRY: 
                case RETRY_ROOT: {
                    BPlusTree.checkInterrupted();
                    continue block3;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result visitDown(TreeVisitor v, long pageId, long fwdId, int lvl) throws IgniteCheckedException {
        long page = this.acquirePage(pageId);
        try {
            Result res;
            block13: while (true) {
                v.checkLockRetry();
                v.pageId = pageId;
                v.fwdId = fwdId;
                res = this.read(pageId, page, this.search, v, lvl, Result.RETRY);
                switch (res) {
                    case GO_DOWN: 
                    case GO_DOWN_X: {
                        assert (v.pageId != pageId);
                        assert (v.fwdId != fwdId || fwdId == 0L);
                        res = this.visitDown(v, v.pageId, v.fwdId, lvl - 1);
                        switch (res) {
                            case RETRY: {
                                BPlusTree.checkInterrupted();
                                continue block13;
                            }
                        }
                        Result result = res;
                        return result;
                    }
                    case NOT_FOUND: {
                        assert (lvl == 0) : lvl;
                        Result result = v.init(pageId, page, fwdId);
                        return result;
                    }
                    case FOUND: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            Result result = res;
            return result;
        }
        finally {
            if (v.canRelease(pageId, lvl)) {
                this.releasePage(pageId, page);
            }
        }
    }

    private long doAskNeighbor(BPlusIO<L> io, long pageAddr, boolean back) {
        long res;
        if (back) {
            int cnt = io.getCount(pageAddr);
            res = BPlusTree.inner(io).getLeft(pageAddr, cnt);
        } else {
            res = BPlusTree.inner(io).getLeft(pageAddr, 0);
        }
        assert (res != 0L) : "inner page with no route down: " + U.hexLong(PageIO.getPageId(pageAddr));
        return res;
    }

    public String toString() {
        return S.toString(BPlusTree.class, this);
    }

    private int findInsertionPoint(int lvl, BPlusIO<L> io, long buf, int low, int cnt, L row, int shift) throws IgniteCheckedException {
        assert (row != null);
        if (this.sequentialWriteOptsEnabled) {
            assert (io.getForward(buf) == 0L);
            return -cnt - 1;
        }
        int high = cnt - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = this.compare(lvl, io, buf, mid, row);
            if (cmp == 0) {
                cmp = -shift;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private BPlusIO<L> io(long pageAddr) {
        assert (pageAddr != 0L);
        int type = PageIO.getType(pageAddr);
        int ver = PageIO.getVersion(pageAddr);
        if (this.innerIos.getType() == type) {
            return this.innerIos.forVersion(ver);
        }
        if (this.leafIos.getType() == type) {
            return this.leafIos.forVersion(ver);
        }
        throw new IllegalStateException("Unknown page type: " + type + " pageId: " + U.hexLong(PageIO.getPageId(pageAddr)));
    }

    private static <L> BPlusInnerIO<L> inner(BPlusIO<L> io) {
        assert (!io.isLeaf());
        return (BPlusInnerIO)io;
    }

    public final BPlusInnerIO<L> latestInnerIO() {
        return this.innerIos.latest();
    }

    public final BPlusLeafIO<L> latestLeafIO() {
        return this.leafIos.latest();
    }

    protected abstract int compare(BPlusIO<L> var1, long var2, int var4, L var5) throws IgniteCheckedException;

    protected int compare(int lvl, BPlusIO<L> io, long pageAddr, int idx, L row) throws IgniteCheckedException {
        return this.compare(io, pageAddr, idx, row);
    }

    public final T getRow(BPlusIO<L> io, long pageAddr, int idx) throws IgniteCheckedException {
        return this.getRow(io, pageAddr, idx, null);
    }

    public abstract T getRow(BPlusIO<L> var1, long var2, int var4, Object var5) throws IgniteCheckedException;

    protected int getLockRetries() {
        return LOCK_RETRIES;
    }

    protected final long acquirePage(long pageId) throws IgniteCheckedException {
        return this.acquirePage(pageId, this.statisticsHolder());
    }

    protected final <X, R> R read(long pageId, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return this.read(pageId, h, arg, intArg, lockFailed, this.statisticsHolder());
    }

    protected final <X, R> R read(long pageId, long page, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteCheckedException {
        return this.read(pageId, page, h, arg, intArg, lockFailed, this.statisticsHolder());
    }

    protected IoStatisticsHolder statisticsHolder() {
        return IoStatisticsHolderNoOp.INSTANCE;
    }

    private long[] pages(boolean empty, Supplier<long[]> pages) {
        return empty ? GridLongList.EMPTY_ARRAY : pages.get();
    }

    protected CorruptedTreeException corruptedTreeException(String msg, Throwable cause, int grpId, long ... pageIds) {
        CorruptedTreeException e = new CorruptedTreeException(msg, cause, this.grpName, grpId, pageIds);
        this.processFailure(FailureType.CRITICAL_ERROR, e);
        return e;
    }

    protected void processFailure(FailureType failureType, Throwable e) {
        if (this.failureProcessor != null && !suspendFailureDiagnostic.get().booleanValue()) {
            this.failureProcessor.process(new FailureContext(failureType, e));
        }
    }

    public long getMetaPageId() {
        return this.metaPageId;
    }

    protected String lockRetryErrorMessage(String op) {
        return "Maximum number of retries " + this.getLockRetries() + " reached for " + op + " operation (the tree may be corrupted). Increase " + "IGNITE_BPLUS_TREE_LOCK_RETRIES" + " system property if you regularly see this message (current value is " + this.getLockRetries() + "). " + this.getClass().getSimpleName() + " [grpName=" + this.grpName + ", treeName=" + this.name() + ", metaPageId=" + U.hexLong(this.metaPageId) + "].";
    }

    static {
        LOCK_RETRIES = IgniteSystemProperties.getInteger("IGNITE_BPLUS_TREE_LOCK_RETRIES", 1000);
    }

    protected class RemoveRange
    extends Remove {
        private final L upper;
        private final L lower;
        private final List<L> removedRows;
        private int remaining;
        private boolean completed;
        private int highIdx;

        protected RemoveRange(L lower, L upper, boolean needOld, int limit) {
            super(lower, needOld, BPlusTree.this.rmvRangeFromLeaf);
            this.lower = lower;
            this.upper = upper;
            this.remaining = limit <= 0 ? -1 : limit;
            this.removedRows = needOld ? new ArrayList() : null;
        }

        private boolean isDone() {
            return this.completed || this.remaining == 0;
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl != 0) {
                return false;
            }
            assert (!this.completed);
            assert (this.tail == null);
            if (idx == io.getCount(pageAddr) || BPlusTree.this.compare(io, pageAddr, idx, this.upper) > 0) {
                this.completed = true;
            }
            return true;
        }

        @Override
        protected boolean ceil() {
            return !this.completed;
        }

        @Override
        protected void removeDataRowFromLeaf(long pageId, long page, long pageAddr, Boolean walPlc, BPlusIO<L> io, int cnt, int idx) throws IgniteCheckedException {
            assert (io.isLeaf()) : "inner";
            assert (!this.isRemoved()) : "already removed";
            assert (this.remaining > 0 || this.remaining == -1) : this.remaining;
            this.rmvd = Boolean.TRUE;
            if (this.highIdx >= 0 || (this.highIdx = BPlusTree.fix(this.highIdx)) < cnt - 1) {
                this.completed = true;
            }
            assert (idx >= 0 && idx <= this.highIdx && this.highIdx < cnt) : "low=" + idx + ", high=" + this.highIdx + ", cnt=" + cnt;
            for (int i = this.highIdx; i >= idx; --i) {
                if (this.needOld) {
                    this.removedRows.add(BPlusTree.this.getRow(io, pageAddr, i));
                }
                this.doRemove(pageId, page, pageAddr, walPlc, io, cnt - this.highIdx + i, i);
                if (this.remaining == -1) continue;
                --this.remaining;
            }
            if (this.needOld) {
                int off;
                int len = this.highIdx - idx + 1;
                int i = off = this.removedRows.size() - len;
                for (int j = this.removedRows.size() - 1; i < j; ++i, --j) {
                    this.removedRows.set(i, this.removedRows.set(j, this.removedRows.get(i)));
                }
            }
            assert (this.isRemoved());
        }

        @Override
        protected boolean releaseForRetry(Tail<L> t) {
            if (t.lvl <= 1 && this.needReplaceInner != Bool.FALSE) {
                this.row = this.lower;
            }
            return super.releaseForRetry(t);
        }

        @Override
        protected Result finish(Result res) {
            if (this.isDone()) {
                return super.finish(res);
            }
            assert (this.tail == null);
            this.row = this.lower;
            this.needReplaceInner = Bool.FALSE;
            this.needMergeEmptyBranch = Bool.FALSE;
            this.rmvd = null;
            this.lockRetriesCnt = BPlusTree.this.getLockRetries();
            return Result.RETRY;
        }
    }

    public static interface TreeVisitorClosure<L, T extends L> {
        public static final int STOP = 1;
        public static final int CAN_WRITE = 2;
        public static final int DIRTY = 4;

        public int visit(BPlusTree<L, T> var1, BPlusIO<L> var2, long var3, int var5, IgniteWriteAheadLogManager var6) throws IgniteCheckedException;

        public int state();
    }

    public static interface TreeRowFactory<L, T extends L> {
        public T create(BPlusTree<L, T> var1, BPlusIO<L> var2, long var3, int var5) throws IgniteCheckedException;
    }

    public static interface TreeRowClosure<L, T extends L> {
        public boolean apply(BPlusTree<L, T> var1, BPlusIO<L> var2, long var3, int var5) throws IgniteCheckedException;
    }

    static enum Bool {
        FALSE,
        TRUE,
        READY,
        DONE;

    }

    public static enum Result {
        GO_DOWN,
        GO_DOWN_X,
        FOUND,
        NOT_FOUND,
        RETRY,
        RETRY_ROOT;

    }

    private static class TreeMetaData {
        final int rootLvl;
        final long rootId;

        TreeMetaData(int rootLvl, long rootId) {
            this.rootLvl = rootLvl;
            this.rootId = rootId;
        }

        public String toString() {
            return S.toString(TreeMetaData.class, this);
        }
    }

    private abstract class GetPageHandler<G extends Get>
    extends PageHandler<G, Result> {
        private GetPageHandler() {
        }

        @Override
        public Result run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, G g, int lvl, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            assert (PageIO.getPageId(pageAddr) == pageId);
            BPlusIO io = (BPlusIO)iox;
            if (lvl == 0 && ((Get)g).rmvId < io.getRemoveId(pageAddr)) {
                return Result.RETRY_ROOT;
            }
            return this.run0(pageId, page, pageAddr, io, g, lvl);
        }

        protected abstract Result run0(long var1, long var3, long var5, BPlusIO<L> var7, G var8, int var9) throws IgniteCheckedException;

        @Override
        public boolean releaseAfterWrite(int cacheId, long pageId, long page, long pageAddr, G g, int lvl) {
            return ((Get)g).canRelease(pageId, lvl);
        }
    }

    private final class ForwardCursor
    extends AbstractForwardCursor
    implements GridCursor<T> {
        final Object x;
        private T[] rows;
        private int row;
        private final TreeRowClosure<L, T> c;
        private final TreeRowFactory<L, T> rowFactory;

        ForwardCursor(L upperBound, boolean upIncl, TreeRowClosure<L, T> c, TreeRowFactory<L, T> rowFactory, Object x) {
            this(null, upperBound, true, upIncl, c, rowFactory, x);
        }

        ForwardCursor(L lowerBound, L upperBound, boolean lowIncl, boolean upIncl, TreeRowClosure<L, T> c, TreeRowFactory<L, T> rowFactory, Object x) {
            super(lowerBound, upperBound, lowIncl, upIncl);
            this.rows = EMPTY;
            this.row = -1;
            this.c = c;
            this.rowFactory = rowFactory;
            this.x = x;
        }

        @Override
        boolean fillFromBuffer0(long pageAddr, BPlusIO<L> io, int startIdx, int cnt) throws IgniteCheckedException {
            int cnt0;
            if (startIdx == -1) {
                startIdx = this.lowerBound != null ? this.findLowerBound(pageAddr, io, cnt) : 0;
            }
            if (this.upperBound != null && cnt != startIdx) {
                cnt = this.findUpperBound(pageAddr, io, startIdx, cnt);
            }
            if ((cnt0 = cnt - startIdx) == 0) {
                return false;
            }
            if (this.rows == EMPTY) {
                this.rows = new Object[cnt0];
            }
            int resCnt = 0;
            for (int idx = startIdx; idx < cnt; ++idx) {
                if (this.c != null && !this.c.apply(BPlusTree.this, io, pageAddr, idx)) continue;
                this.rows = GridArrays.set(this.rows, resCnt++, this.rowFactory == null ? BPlusTree.this.getRow(io, pageAddr, idx, this.x) : this.rowFactory.create(BPlusTree.this, io, pageAddr, idx));
            }
            if (resCnt == 0) {
                this.rows = EMPTY;
                return false;
            }
            GridArrays.clearTail(this.rows, resCnt);
            return true;
        }

        @Override
        boolean reinitialize0() throws IgniteCheckedException {
            return this.next();
        }

        @Override
        void onNotFound(boolean readDone) {
            if (readDone) {
                this.rows = null;
            } else if (this.rows != EMPTY) {
                assert (this.rows.length > 0);
                this.rows[0] = null;
            }
        }

        @Override
        void init0() {
            this.row = -1;
        }

        @Override
        public boolean next() throws IgniteCheckedException {
            if (this.rows == null) {
                return false;
            }
            if (++this.row < this.rows.length && this.rows[this.row] != null) {
                this.clearLastRow();
                return true;
            }
            Object lastRow = this.clearLastRow();
            this.row = 0;
            return this.nextPage(lastRow);
        }

        private T clearLastRow() {
            if (this.row == 0) {
                return null;
            }
            int last = this.row - 1;
            Object r = this.rows[last];
            assert (r != null);
            this.rows[last] = null;
            return r;
        }

        @Override
        public T get() {
            Object r = this.rows[this.row];
            assert (r != null);
            return r;
        }
    }

    private final class ClosureCursor
    extends AbstractForwardCursor {
        private final TreeRowClosure<L, T> p;
        private L lastRow;

        ClosureCursor(L lowerBound, L upperBound, TreeRowClosure<L, T> p) {
            super(lowerBound, upperBound, true, true);
            assert (lowerBound != null);
            assert (upperBound != null);
            assert (p != null);
            this.p = p;
        }

        @Override
        void init0() {
        }

        @Override
        boolean fillFromBuffer0(long pageAddr, BPlusIO<L> io, int startIdx, int cnt) throws IgniteCheckedException {
            if (startIdx == -1) {
                startIdx = this.findLowerBound(pageAddr, io, cnt);
            }
            if (cnt == startIdx) {
                return false;
            }
            for (int i = startIdx; i < cnt; ++i) {
                boolean stop;
                int cmp = BPlusTree.this.compare(0, io, pageAddr, i, this.upperBound);
                if (cmp > 0) {
                    this.nextPageId = 0L;
                    return false;
                }
                boolean bl = stop = !this.p.apply(BPlusTree.this, io, pageAddr, i);
                if (!stop) continue;
                this.nextPageId = 0L;
                return true;
            }
            if (this.nextPageId != 0L) {
                this.lastRow = io.getLookupRow(BPlusTree.this, pageAddr, cnt - 1);
            }
            return true;
        }

        @Override
        boolean reinitialize0() throws IgniteCheckedException {
            return true;
        }

        @Override
        void onNotFound(boolean readDone) {
            this.nextPageId = 0L;
        }

        private void iterate() throws IgniteCheckedException {
            this.find();
            if (this.nextPageId == 0L) {
                return;
            }
            do {
                Object lastRow0 = this.lastRow;
                this.lastRow = null;
                this.nextPage(lastRow0);
            } while (this.nextPageId != 0L);
        }
    }

    private abstract class AbstractForwardCursor {
        long nextPageId;
        L lowerBound;
        private int lowerShift;
        final L upperBound;
        private final int upperShift;
        public GetCursor getCursor;

        AbstractForwardCursor(L lowerBound, L upperBound, boolean lowIncl, boolean upIncl) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.lowerShift = lowIncl ? -1 : 1;
            this.upperShift = upIncl ? 1 : -1;
        }

        abstract void init0();

        abstract boolean fillFromBuffer0(long var1, BPlusIO<L> var3, int var4, int var5) throws IgniteCheckedException;

        abstract boolean reinitialize0() throws IgniteCheckedException;

        abstract void onNotFound(boolean var1);

        final void init(long pageAddr, BPlusIO<L> io, int startIdx) throws IgniteCheckedException {
            this.nextPageId = 0L;
            this.init0();
            int cnt = io.getCount(pageAddr);
            if (cnt == 0) {
                assert (io.getForward(pageAddr) == 0L);
                this.onNotFound(true);
            } else if (!this.fillFromBuffer(pageAddr, io, startIdx, cnt)) {
                this.onNotFound(false);
            }
        }

        final int findLowerBound(long pageAddr, BPlusIO<L> io, int cnt) throws IgniteCheckedException {
            assert (io.isLeaf());
            int cmp = BPlusTree.this.compare(0, io, pageAddr, 0, this.lowerBound);
            if (cmp < 0 || cmp == 0 && this.lowerShift == 1) {
                int idx = BPlusTree.this.findInsertionPoint(0, io, pageAddr, 0, cnt, this.lowerBound, this.lowerShift);
                assert (idx < 0);
                return BPlusTree.fix(idx);
            }
            return 0;
        }

        final int findUpperBound(long pageAddr, BPlusIO<L> io, int low, int cnt) throws IgniteCheckedException {
            assert (io.isLeaf());
            int cmp = BPlusTree.this.compare(0, io, pageAddr, cnt - 1, this.upperBound);
            if (cmp > 0 || cmp == 0 && this.upperShift == -1) {
                int idx = BPlusTree.this.findInsertionPoint(0, io, pageAddr, low, cnt, this.upperBound, this.upperShift);
                assert (idx < 0);
                cnt = BPlusTree.fix(idx);
                this.nextPageId = 0L;
            }
            return cnt;
        }

        private boolean fillFromBuffer(long pageAddr, BPlusIO<L> io, int startIdx, int cnt) throws IgniteCheckedException {
            assert (io.isLeaf()) : io;
            assert (cnt != 0) : cnt;
            assert (startIdx >= 0 || startIdx == -1) : startIdx;
            assert (cnt >= startIdx);
            BPlusTree.this.checkDestroyed();
            this.nextPageId = io.getForward(pageAddr);
            return this.fillFromBuffer0(pageAddr, io, startIdx, cnt);
        }

        final void find() throws IgniteCheckedException {
            assert (this.lowerBound != null);
            this.getCursor = new GetCursor(this.lowerBound, this.lowerShift, this);
            BPlusTree.this.doFind(this.getCursor);
        }

        private boolean reinitialize() throws IgniteCheckedException {
            this.find();
            return this.reinitialize0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean nextPage(L lastRow) throws IgniteCheckedException {
            BPlusTree.this.checkDestroyed();
            this.updateLowerBound(lastRow);
            while (true) {
                if (this.nextPageId == 0L) {
                    this.onNotFound(true);
                    return false;
                }
                long pageId = this.nextPageId;
                long page = BPlusTree.this.acquirePage(pageId);
                try {
                    long pageAddr = BPlusTree.this.readLock(pageId, page);
                    if (pageAddr == 0L) break;
                    try {
                        BPlusIO io = BPlusTree.this.io(pageAddr);
                        if (!this.fillFromBuffer(pageAddr, io, -1, io.getCount(pageAddr))) continue;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        BPlusTree.this.readUnlock(pageId, page, pageAddr);
                        continue;
                    }
                }
                catch (CorruptedDataStructureException e) {
                    throw e;
                }
                catch (AssertionError | RuntimeException e) {
                    throw BPlusTree.this.corruptedTreeException("Runtime failure on cursor iteration", (Throwable)e, BPlusTree.this.grpId, pageId);
                }
                finally {
                    BPlusTree.this.releasePage(pageId, page);
                    continue;
                }
                break;
            }
            return this.reinitialize();
        }

        private void updateLowerBound(L lower) {
            if (lower != null) {
                this.lowerShift = 1;
                this.lowerBound = lower;
            }
        }
    }

    private static final class Tail<L> {
        static final byte BACK = 0;
        static final byte EXACT = 1;
        static final byte FORWARD = 2;
        private final long pageId;
        private final long page;
        private final long buf;
        private Boolean walPlc;
        private final BPlusIO<L> io;
        private byte type;
        private final int lvl;
        private short idx = (short)Short.MIN_VALUE;
        private Tail<L> sibling;
        private Tail<L> down;

        private Tail(long pageId, long page, long buf, BPlusIO<L> io, byte type, int lvl) {
            assert (type == 0 || type == 1 || type == 2) : type;
            assert (lvl >= 0 && lvl <= 127) : lvl;
            assert (pageId != 0L);
            assert (page != 0L);
            assert (buf != 0L);
            this.pageId = pageId;
            this.page = page;
            this.buf = buf;
            this.io = io;
            this.type = type;
            this.lvl = (byte)lvl;
        }

        private int getCount() {
            return this.io.getCount(this.buf);
        }

        public String toString() {
            return new SB("Tail[").a("pageId=").appendHex(this.pageId).a(", cnt= ").a(this.getCount()).a(", lvl=" + this.lvl).a(", sibling=").a(this.sibling).a("]").toString();
        }

        private Tail<L> getLeftChild() {
            Tail<L> s = this.down.sibling;
            return s.type == 0 ? s : this.down;
        }

        private Tail<L> getRightChild() {
            Tail<L> s = this.down.sibling;
            return s.type == 2 ? s : this.down;
        }
    }

    public class Remove
    extends Update
    implements ReuseBag {
        Bool needReplaceInner;
        Bool needMergeEmptyBranch;
        T rmvd;
        long page;
        Object freePages;
        final boolean needOld;
        final PageHandler<Remove, Result> rmvFromLeafHnd;

        private Remove(L row, boolean needOld) {
            this(row, needOld, this$0.rmvFromLeaf);
        }

        private Remove(L row, boolean needOld, PageHandler<Remove, Result> rmvFromLeaf) {
            super(row);
            this.needReplaceInner = Bool.FALSE;
            this.needMergeEmptyBranch = Bool.FALSE;
            this.needOld = needOld;
            this.rmvFromLeafHnd = rmvFromLeaf;
        }

        @Override
        public long pollFreePage() {
            if (this.freePages == null) {
                return 0L;
            }
            if (this.freePages.getClass() == GridLongList.class) {
                GridLongList list = (GridLongList)this.freePages;
                return list.isEmpty() ? 0L : list.remove();
            }
            long res = (Long)this.freePages;
            this.freePages = null;
            return res;
        }

        @Override
        public void addFreePage(long pageId) {
            assert (pageId != 0L);
            if (this.freePages == null) {
                this.freePages = pageId;
            } else {
                GridLongList list;
                if (this.freePages.getClass() == GridLongList.class) {
                    list = (GridLongList)this.freePages;
                } else {
                    list = new GridLongList(4);
                    list.add((Long)this.freePages);
                    this.freePages = list;
                }
                list.add(pageId);
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.freePages == null) {
                return true;
            }
            if (this.freePages.getClass() == GridLongList.class) {
                GridLongList list = (GridLongList)this.freePages;
                return list.isEmpty();
            }
            return false;
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl == 0) {
                assert (this.tail == null);
                return true;
            }
            return false;
        }

        protected boolean ceil() {
            return false;
        }

        protected Result finish(Result res) {
            assert (this.tail == null);
            this.row = null;
            return res;
        }

        private Tail<L> mergeEmptyBranch() throws IgniteCheckedException {
            assert (this.needMergeEmptyBranch == Bool.TRUE) : this.needMergeEmptyBranch;
            Tail t = this.tail;
            Tail t0 = t.down;
            while (t0.lvl != 0) {
                assert (t0.type == 1) : Tail.access$12400(t0);
                if (t0.getCount() != 0) {
                    t = t0;
                }
                t0 = t0.down;
            }
            int cnt = t.getCount();
            int idx = BPlusTree.fix(this.insertionPoint(t));
            assert (cnt > 0) : cnt;
            if (idx == cnt) {
                --idx;
            }
            if (!this.checkChildren(t, t.getLeftChild(), t.getRightChild(), idx)) {
                return t;
            }
            this.removeDataRowFromLeafTail(t);
            while (t.lvl != 0) {
                boolean res = this.merge(t);
                assert (res) : (Object)((Object)this.needMergeEmptyBranch) + "\n" + this.printTail(true);
                if (this.needMergeEmptyBranch == Bool.TRUE) {
                    this.needMergeEmptyBranch = Bool.READY;
                }
                t = t.down;
            }
            return null;
        }

        private void mergeBottomUp(Tail<L> t) throws IgniteCheckedException {
            assert (this.needMergeEmptyBranch == Bool.FALSE || this.needMergeEmptyBranch == Bool.DONE) : this.needMergeEmptyBranch;
            if (t.down == null || t.down.sibling == null) {
                if (t.lvl == 0 && !this.isRemoved()) {
                    this.removeDataRowFromLeafTail(t);
                }
                return;
            }
            this.mergeBottomUp(t.down);
            this.merge(t);
        }

        private boolean isInnerKeyInTail() throws IgniteCheckedException {
            assert (this.tail.lvl > 0) : Tail.access$8000(this.tail);
            return this.insertionPoint(this.tail) >= 0;
        }

        protected boolean isRemoved() {
            return this.rmvd != null;
        }

        protected boolean releaseForRetry(Tail<L> t) {
            Tail newTail;
            if (t.lvl <= 1) {
                assert (!this.isRemoved()) : "removed";
                this.needReplaceInner = Bool.FALSE;
                this.needMergeEmptyBranch = Bool.FALSE;
                this.releaseTail();
                return true;
            }
            if (t.down != null && (newTail = t.down.down) != null) {
                t.down.down = null;
                this.releaseTail();
                this.tail = newTail;
                return true;
            }
            assert (this.isRemoved());
            assert (this.needReplaceInner != Bool.TRUE && this.needMergeEmptyBranch != Bool.TRUE);
            return false;
        }

        @Override
        protected Result finishTail() throws IgniteCheckedException {
            assert (!this.isFinished());
            assert (this.tail.type == 1 && this.tail.lvl >= 0) : this.tail;
            if (this.tail.lvl == 0) {
                assert (this.tail.sibling != null) : this.tail;
                return Result.NOT_FOUND;
            }
            if (!this.validateTail()) {
                if (this.releaseForRetry(this.tail)) {
                    return Result.RETRY;
                }
            } else {
                if (this.needReplaceInner == Bool.TRUE) {
                    if (!this.isInnerKeyInTail()) {
                        return Result.NOT_FOUND;
                    }
                    this.needReplaceInner = Bool.READY;
                }
                if (this.needMergeEmptyBranch == Bool.TRUE) {
                    if (this.tail.getCount() == 0) {
                        return Result.NOT_FOUND;
                    }
                    Tail t = this.mergeEmptyBranch();
                    if (t != null) {
                        boolean ok = this.releaseForRetry(t);
                        assert (ok);
                        return Result.RETRY;
                    }
                    this.needMergeEmptyBranch = Bool.DONE;
                }
                this.mergeBottomUp(this.tail);
                if (this.needReplaceInner == Bool.READY) {
                    this.replaceInner();
                    this.needReplaceInner = Bool.DONE;
                }
                assert (this.needReplaceInner != Bool.TRUE);
                while (this.tail.getCount() == 0 && this.tail.lvl != 0 && BPlusTree.this.getRootLevel() == this.tail.lvl) {
                    this.cutRoot(this.tail.lvl);
                    this.freePage(this.tail.pageId, this.tail.page, this.tail.buf, this.tail.walPlc, true);
                    this.tail = this.tail.down;
                    assert (this.tail.sibling == null) : this.tail;
                }
                if (this.tail.sibling != null && this.tail.getCount() + this.tail.sibling.getCount() < this.tail.io.getMaxCount(this.tail.buf, BPlusTree.this.pageSize())) {
                    this.doReleaseTail(this.tail.down);
                    this.tail.down = null;
                    return Result.NOT_FOUND;
                }
            }
            assert (this.isRemoved());
            this.releaseTail();
            return this.finish(Result.FOUND);
        }

        private void removeDataRowFromLeafTail(Tail<L> t) throws IgniteCheckedException {
            assert (!this.isRemoved());
            Tail leaf = this.getTail(t, 0);
            this.removeDataRowFromLeaf(leaf.pageId, leaf.page, leaf.buf, leaf.walPlc, leaf.io, leaf.getCount(), this.insertionPoint(leaf));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result removeFromLeaf(long leafId, long leafPage, long backId, long fwdId) throws IgniteCheckedException {
            this.pageId = leafId;
            this.page = leafPage;
            this.backId = backId;
            this.fwdId = fwdId;
            if (backId == 0L) {
                return this.doRemoveFromLeaf();
            }
            long backPage = BPlusTree.this.acquirePage(backId);
            try {
                Result result = (Result)((Object)BPlusTree.this.write(backId, backPage, BPlusTree.this.lockBackAndRmvFromLeaf, this, 0, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
                return result;
            }
            finally {
                if (this.canRelease(backId, 0)) {
                    BPlusTree.this.releasePage(backId, backPage);
                }
            }
        }

        protected Result doRemoveFromLeaf() throws IgniteCheckedException {
            assert (this.page != 0L);
            return (Result)((Object)BPlusTree.this.write(this.pageId, this.page, this.rmvFromLeafHnd, this, 0, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
        }

        private Result doLockTail(int lvl) throws IgniteCheckedException {
            assert (this.page != 0L);
            return (Result)((Object)BPlusTree.this.write(this.pageId, this.page, BPlusTree.this.lockTail, this, lvl, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result lockTail(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteCheckedException {
            assert (this.tail != null);
            this.pageId = pageId;
            this.page = page;
            this.fwdId = fwdId;
            this.backId = backId;
            if (backId == 0L) {
                return this.doLockTail(lvl);
            }
            long backPage = BPlusTree.this.acquirePage(backId);
            try {
                Result result = (Result)((Object)BPlusTree.this.write(backId, backPage, BPlusTree.this.lockBackAndTail, this, lvl, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
                return result;
            }
            finally {
                if (this.canRelease(backId, lvl)) {
                    BPlusTree.this.releasePage(backId, backPage);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Result lockForward(int lvl) throws IgniteCheckedException {
            assert (this.fwdId != 0L) : this.fwdId;
            assert (this.backId == 0L) : this.backId;
            long fwdId = this.fwdId;
            long fwdPage = BPlusTree.this.acquirePage(fwdId);
            try {
                Result result = (Result)((Object)BPlusTree.this.write(fwdId, fwdPage, BPlusTree.this.lockTailForward, this, lvl, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
                return result;
            }
            finally {
                if (this.canRelease(fwdId, lvl)) {
                    BPlusTree.this.releasePage(fwdId, fwdPage);
                }
            }
        }

        protected void removeDataRowFromLeaf(long pageId, long page, long pageAddr, Boolean walPlc, BPlusIO<L> io, int cnt, int idx) throws IgniteCheckedException {
            assert (idx >= 0 && idx < cnt) : idx;
            assert (io.isLeaf()) : "inner";
            assert (!this.isRemoved()) : "already removed";
            this.rmvd = this.needOld ? BPlusTree.this.getRow(io, pageAddr, idx) : Boolean.TRUE;
            this.doRemove(pageId, page, pageAddr, walPlc, io, cnt, idx);
            assert (this.isRemoved());
        }

        protected void doRemove(long pageId, long page, long pageAddr, Boolean walPlc, BPlusIO<L> io, int cnt, int idx) throws IgniteCheckedException {
            assert (cnt > 0) : cnt;
            assert (idx >= 0 && idx < cnt) : idx + " " + cnt;
            io.remove(pageAddr, idx, cnt);
            if (BPlusTree.this.needWalDeltaRecord(pageId, page, walPlc)) {
                BPlusTree.this.wal.log(new RemoveRecord(BPlusTree.this.grpId, pageId, idx, cnt));
            }
        }

        private boolean validateTail() throws IgniteCheckedException {
            int idx;
            Tail s;
            Tail t = this.tail;
            if (t.down == null) {
                assert (this.needMergeEmptyBranch != Bool.TRUE);
                assert (this.needReplaceInner != Bool.TRUE);
                return true;
            }
            Tail left = t.getLeftChild();
            Tail right = t.getRightChild();
            assert (left.pageId != right.pageId);
            int cnt = t.getCount();
            if (cnt != 0) {
                int idx2 = BPlusTree.fix(this.insertionPoint(t));
                if (idx2 == cnt) {
                    --idx2;
                }
                if (this.isChild(t, left, idx2, cnt, false) && this.isChild(t, right, idx2, cnt, true)) {
                    return true;
                }
            }
            if ((s = t.sibling) == null) {
                return false;
            }
            int n = idx = cnt == 0 ? 0 : cnt - 1;
            if (s.type == 2) {
                return this.isChild(t, left, idx, cnt, true) && this.isChild(s, right, 0, 0, false);
            }
            assert (s.type == 0);
            if (!this.isChild(t, right, 0, 0, false)) {
                return false;
            }
            cnt = s.getCount();
            idx = cnt == 0 ? 0 : cnt - 1;
            return this.isChild(s, left, idx, cnt, true);
        }

        private boolean isChild(Tail<L> prnt, Tail<L> child, int idx, int cnt, boolean right) {
            if (right && cnt != 0) {
                ++idx;
            }
            return BPlusTree.inner(prnt.io).getLeft(prnt.buf, idx) == child.pageId;
        }

        private boolean checkChildren(Tail<L> prnt, Tail<L> left, Tail<L> right, int idx) {
            assert (idx >= 0 && idx < prnt.getCount()) : idx;
            return BPlusTree.inner(prnt.io).getLeft(prnt.buf, idx) == left.pageId && BPlusTree.inner(prnt.io).getRight(prnt.buf, idx) == right.pageId;
        }

        private boolean doMerge(Tail<L> prnt, Tail<L> left, Tail<L> right) throws IgniteCheckedException {
            boolean emptyBranch;
            assert (right.io == left.io);
            assert (left.io.getForward(left.buf) == right.pageId);
            int prntCnt = prnt.getCount();
            int prntIdx = BPlusTree.fix(this.insertionPoint(prnt));
            if (prntIdx == prntCnt) {
                --prntIdx;
            }
            if (this.needMergeEmptyBranch == Bool.READY) {
                assert (left.getCount() == 0 || right.getCount() == 0);
            } else if (!this.checkChildren(prnt, left, right, prntIdx)) {
                return false;
            }
            boolean bl = emptyBranch = this.needMergeEmptyBranch == Bool.TRUE || this.needMergeEmptyBranch == Bool.READY;
            if (!left.io.merge(prnt.io, prnt.buf, prntIdx, left.buf, right.buf, emptyBranch, BPlusTree.this.pageSize())) {
                return false;
            }
            prnt.idx = (short)Short.MIN_VALUE;
            left.idx = (short)Short.MIN_VALUE;
            left.walPlc = Boolean.TRUE;
            if (this.needMergeEmptyBranch != Bool.READY) {
                this.doRemove(prnt.pageId, prnt.page, prnt.buf, prnt.walPlc, prnt.io, prntCnt, prntIdx);
            }
            this.freePage(right.pageId, right.page, right.buf, right.walPlc, true);
            return true;
        }

        private void freePage(long pageId, long page, long pageAddr, Boolean walPlc, boolean release) throws IgniteCheckedException {
            long effectivePageId = PageIdUtils.effectivePageId(pageId);
            long recycled = BPlusTree.this.recyclePage(pageId, page, pageAddr, walPlc);
            if (effectivePageId != PageIdUtils.effectivePageId(pageId)) {
                throw new IllegalStateException("Effective page ID must stay the same.");
            }
            if (release) {
                BPlusTree.this.writeUnlockAndClose(pageId, page, pageAddr, walPlc);
            }
            this.addFreePage(recycled);
        }

        private void cutRoot(int lvl) throws IgniteCheckedException {
            Bool res = (Bool)((Object)BPlusTree.this.write(BPlusTree.this.metaPageId, BPlusTree.this.cutRoot, lvl, (Object)Bool.FALSE, BPlusTree.this.statisticsHolder()));
            assert (res == Bool.TRUE) : res;
        }

        private void reuseFreePages() throws IgniteCheckedException {
            if (BPlusTree.this.reuseList != null && this.freePages != null) {
                BPlusTree.this.reuseList.addForRecycle(this);
            }
        }

        private void replaceInner() throws IgniteCheckedException {
            int innerIdx;
            assert (this.needReplaceInner == Bool.READY) : this.needReplaceInner;
            Tail inner = this.tail;
            while (true) {
                assert (inner.type == 1) : Tail.access$12400(inner);
                assert (inner.lvl > 0) : "leaf " + Tail.access$8000(this.tail);
                innerIdx = this.insertionPoint(inner);
                if (innerIdx >= 0) break;
                if (inner.lvl == 1) {
                    return;
                }
                inner = inner.down;
            }
            Tail leaf = this.getTail(inner, 0);
            int leafCnt = leaf.getCount();
            assert (leafCnt > 0) : leafCnt;
            int leafIdx = leafCnt - 1;
            long rmvId = BPlusTree.this.globalRmvId.incrementAndGet();
            inner.io.store(inner.buf, innerIdx, leaf.io, leaf.buf, leafIdx);
            inner.io.setRemoveId(inner.buf, rmvId);
            inner.walPlc = Boolean.TRUE;
            leaf.io.setRemoveId(leaf.buf, rmvId);
            if (BPlusTree.this.needWalDeltaRecord(leaf.pageId, leaf.page, leaf.walPlc)) {
                BPlusTree.this.wal.log(new FixRemoveId(BPlusTree.this.grpId, leaf.pageId, rmvId));
            }
        }

        private boolean merge(Tail<L> prnt) throws IgniteCheckedException {
            Tail right;
            if (prnt.getCount() == 0 && this.needMergeEmptyBranch != Bool.READY) {
                return false;
            }
            Tail left = prnt.getLeftChild();
            if (!this.doMerge(prnt, left, right = prnt.getRightChild())) {
                return false;
            }
            if (left.type == 0) {
                assert (left.sibling == null);
                left.down = right.down;
                left.type = (byte)1;
                prnt.down = left;
            } else {
                assert (left.type == 1) : Tail.access$12400(left);
                assert (left.sibling != null);
                left.sibling = null;
            }
            return true;
        }

        @Override
        boolean isFinished() {
            return this.row == null;
        }

        private void releaseAll() throws IgniteCheckedException {
            this.releaseTail();
            this.reuseFreePages();
        }

        @Override
        protected Result finishOrLockTail(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteCheckedException {
            Result res = this.finishTail();
            if (res == Result.NOT_FOUND) {
                res = this.lockTail(pageId, page, backId, fwdId, lvl);
            }
            return res;
        }

        private Result tryRemoveFromLeaf(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteCheckedException {
            assert (lvl == 0) : lvl;
            Result res = this.removeFromLeaf(pageId, page, backId, fwdId);
            if (res == Result.FOUND && this.tail == null) {
                return this.finish(res);
            }
            return res;
        }
    }

    private abstract class Update
    extends Get {
        Tail<L> tail;

        private Update(L row) {
            super(row, false);
        }

        protected abstract Result finishOrLockTail(long var1, long var3, long var5, long var7, int var9) throws IgniteCheckedException;

        protected abstract Result finishTail() throws IgniteCheckedException;

        protected final void releaseTail() {
            this.doReleaseTail(this.tail);
            this.tail = null;
        }

        protected final boolean checkTailLevel(int rootLvl) {
            return this.tail == null || this.tail.lvl < rootLvl;
        }

        protected final void doReleaseTail(Tail<L> t) {
            while (t != null) {
                BPlusTree.this.writeUnlockAndClose(t.pageId, t.page, t.buf, t.walPlc);
                Tail s = t.sibling;
                if (s != null) {
                    BPlusTree.this.writeUnlockAndClose(s.pageId, s.page, s.buf, s.walPlc);
                }
                t = t.down;
            }
        }

        @Override
        public final boolean canRelease(long pageId, int lvl) {
            return pageId != 0L && !this.isTail(pageId, lvl);
        }

        protected final boolean isTail(long pageId, int lvl) {
            Tail t = this.tail;
            while (t != null) {
                if (t.lvl < lvl) {
                    return false;
                }
                if (t.lvl == lvl) {
                    if (t.pageId == pageId) {
                        return true;
                    }
                    return (t = t.sibling) != null && t.pageId == pageId;
                }
                t = t.down;
            }
            return false;
        }

        protected final Tail<L> addTail(long pageId, long page, long pageAddr, BPlusIO<L> io, int lvl, byte type) {
            Tail t = new Tail(pageId, page, pageAddr, io, type, lvl);
            if (this.tail == null) {
                this.tail = t;
            } else if (this.tail.lvl == lvl) {
                assert (this.tail.sibling == null);
                if (type == 1) {
                    assert (this.tail.type != 1);
                    if (this.tail.down != null) {
                        t.down = this.tail.down;
                        this.tail.down = null;
                    }
                    t.sibling = this.tail;
                    this.tail = t;
                } else {
                    assert (this.tail.type == 1) : Tail.access$12400(this.tail);
                    this.tail.sibling = t;
                }
            } else {
                assert (this.tail.lvl == lvl - 1) : "tail=" + this.tail + ", lvl=" + lvl;
                t.down = this.tail;
                this.tail = t;
            }
            return t;
        }

        protected final Tail<L> getTail(Tail<L> tail, int lvl) {
            assert (tail != null);
            assert (lvl >= 0 && lvl <= tail.lvl) : lvl;
            Tail t = tail;
            while (t.lvl != lvl) {
                t = t.down;
            }
            assert (t.type == 1) : Tail.access$12400(t);
            return t;
        }

        protected final int insertionPoint(Tail<L> tail) throws IgniteCheckedException {
            assert (tail.type == 1) : Tail.access$12400(tail);
            if (tail.idx == Short.MIN_VALUE) {
                int idx = BPlusTree.this.findInsertionPoint(tail.lvl, tail.io, tail.buf, 0, tail.getCount(), this.row, 0);
                assert (BPlusTree.checkIndex(idx)) : idx;
                tail.idx = (short)idx;
            }
            return tail.idx;
        }

        protected final String printTail(boolean keys) throws IgniteCheckedException {
            SB sb = new SB("");
            Tail t = this.tail;
            while (t != null) {
                sb.a(t.lvl).a(": ").a(BPlusTree.this.printPage(t.io, t.buf, keys));
                Tail d = t.down;
                t = t.sibling;
                if (t != null) {
                    sb.a(" -> ").a(t.type == 2 ? "F" : "B").a(' ').a(BPlusTree.this.printPage(t.io, t.buf, keys));
                }
                sb.a('\n');
                t = d;
            }
            return sb.toString();
        }
    }

    public final class Invoke
    extends Get {
        Object x;
        IgniteTree.InvokeClosure<T> clo;
        Bool closureInvoked;
        T foundRow;
        Update op;

        private Invoke(L row, Object x, IgniteTree.InvokeClosure<T> clo) {
            super(row, false);
            this.closureInvoked = Bool.FALSE;
            assert (clo != null);
            this.clo = clo;
            this.x = x;
        }

        @Override
        void pageId(long pageId) {
            this.pageId = pageId;
            if (this.op != null) {
                this.op.pageId = pageId;
            }
        }

        @Override
        void fwdId(long fwdId) {
            this.fwdId = fwdId;
            if (this.op != null) {
                this.op.fwdId = fwdId;
            }
        }

        @Override
        void backId(long backId) {
            this.backId = backId;
            if (this.op != null) {
                this.op.backId = backId;
            }
        }

        @Override
        void restartFromRoot(long rootId, int rootLvl, long rmvId) {
            super.restartFromRoot(rootId, rootLvl, rmvId);
            if (this.op != null) {
                this.op.restartFromRoot(rootId, rootLvl, rmvId);
            }
        }

        @Override
        boolean found(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (this.op != null) {
                return this.op.found(io, pageAddr, idx, lvl);
            }
            if (lvl == 0) {
                if (this.closureInvoked == Bool.FALSE) {
                    this.closureInvoked = Bool.READY;
                    this.foundRow = BPlusTree.this.getRow(io, pageAddr, idx, this.x);
                }
                return true;
            }
            return false;
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (this.op != null) {
                return this.op.notFound(io, pageAddr, idx, lvl);
            }
            if (lvl == 0) {
                if (this.closureInvoked == Bool.FALSE) {
                    this.closureInvoked = Bool.READY;
                }
                return true;
            }
            return false;
        }

        private void invokeClosure() throws IgniteCheckedException {
            if (this.closureInvoked != Bool.READY) {
                return;
            }
            this.closureInvoked = Bool.DONE;
            this.clo.call(this.foundRow);
            switch (this.clo.operationType()) {
                case PUT: {
                    Object newRow = this.clo.newRow();
                    assert (newRow != null);
                    this.op = new Put(newRow, false);
                    break;
                }
                case REMOVE: {
                    assert (this.foundRow != null);
                    this.op = new Remove(this.row, false);
                    break;
                }
                case NOOP: 
                case IN_PLACE: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.op.copyFrom(this);
            this.op.invoke = this;
        }

        @Override
        public boolean canRelease(long pageId, int lvl) {
            if (pageId == 0L) {
                return false;
            }
            if (this.op == null) {
                return true;
            }
            return this.op.canRelease(pageId, lvl);
        }

        private boolean isPut() {
            return this.op != null && this.op.getClass() == Put.class;
        }

        private boolean isRemove() {
            return this.op != null && this.op.getClass() == Remove.class;
        }

        private boolean isTail(long pageId, int lvl) {
            return this.op != null && this.op.isTail(pageId, lvl);
        }

        private void levelExit() {
            if (this.isRemove()) {
                ((Remove)this.op).page = 0L;
            }
        }

        private void releaseAll() throws IgniteCheckedException {
            if (this.isRemove()) {
                ((Remove)this.op).releaseAll();
            }
        }

        private Result onNotFound(long pageId, long page, long fwdId, int lvl) throws IgniteCheckedException {
            if (this.op == null) {
                return Result.NOT_FOUND;
            }
            if (this.isRemove()) {
                assert (lvl == 0);
                return ((Remove)this.op).finish(Result.NOT_FOUND);
            }
            return ((Put)this.op).tryInsert(pageId, page, fwdId, lvl);
        }

        private Result onFound(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteCheckedException {
            if (this.op == null) {
                return Result.FOUND;
            }
            if (this.isRemove()) {
                return ((Remove)this.op).tryRemoveFromLeaf(pageId, page, backId, fwdId, lvl);
            }
            return ((Put)this.op).tryReplace(pageId, page, fwdId, lvl);
        }

        private Result tryFinish() throws IgniteCheckedException {
            assert (this.op != null);
            Result res = this.op.finishTail();
            if (res == Result.NOT_FOUND) {
                res = Result.RETRY;
            }
            if (res == Result.RETRY && this.isPut()) {
                this.op.releaseTail();
            }
            assert (res == Result.FOUND || res == Result.RETRY) : res;
            return res;
        }

        @Override
        boolean isFinished() {
            if (this.closureInvoked != Bool.DONE) {
                return false;
            }
            if (this.op == null) {
                return true;
            }
            return this.op.isFinished();
        }
    }

    public final class Put
    extends Update {
        long rightId;
        T oldRow;
        short btmLvl;
        final boolean needOld;

        private Put(T row, boolean needOld) {
            super(row);
            this.needOld = needOld;
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) {
            assert (this.btmLvl >= 0) : this.btmLvl;
            assert (lvl >= this.btmLvl) : lvl;
            return lvl == this.btmLvl;
        }

        @Override
        protected Result finishOrLockTail(long pageId, long page, long backId, long fwdId, int lvl) throws IgniteCheckedException {
            if (this.btmLvl == lvl) {
                return this.tryInsert(pageId, page, fwdId, lvl);
            }
            Result res = this.finishTail();
            if (res == Result.NOT_FOUND) {
                this.fwdId(fwdId);
                res = (Result)((Object)BPlusTree.this.write(pageId, page, BPlusTree.this.lockTailExact, this, lvl, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
            }
            if (res == Result.RETRY) {
                this.releaseTail();
            }
            return res;
        }

        @Override
        protected Result finishTail() throws IgniteCheckedException {
            if (this.tail.lvl == 0) {
                return Result.NOT_FOUND;
            }
            int idx = this.insertionPoint(this.tail);
            if (idx < 0) {
                idx = BPlusTree.fix(idx);
                BPlusInnerIO io = (BPlusInnerIO)this.tail.io;
                if (io.getLeft(this.tail.buf, idx) != this.tail.down.pageId) {
                    this.releaseTail();
                    return Result.RETRY;
                }
                return Result.NOT_FOUND;
            }
            assert (this.oldRow == null) : "The old row must be set only once.";
            this.replaceRowInPage(this.tail.io, this.tail.pageId, this.tail.page, this.tail.buf, idx);
            while (this.tail.lvl != 0) {
                BPlusTree.this.writeUnlockAndClose(this.tail.pageId, this.tail.page, this.tail.buf, null);
                this.tail = this.tail.down;
            }
            this.oldRow = this.needOld ? BPlusTree.this.getRow(this.tail.io, this.tail.buf, this.tail.idx) : Boolean.TRUE;
            this.replaceRowInPage(this.tail.io, this.tail.pageId, this.tail.page, this.tail.buf, this.tail.idx);
            this.finish();
            return Result.FOUND;
        }

        private void setTailForSplit(long tailId, long tailPage, long tailPageAddr, BPlusIO<L> io, int lvl) {
            assert (tailId != 0L && tailPage != 0L && tailPageAddr != 0L);
            this.releaseTail();
            this.addTail(tailId, tailPage, tailPageAddr, io, lvl, (byte)1);
        }

        private void finish() {
            this.row = null;
            this.rightId = 0L;
            this.releaseTail();
        }

        @Override
        boolean isFinished() {
            return this.row == null;
        }

        private L insert(long pageId, long page, long pageAddr, BPlusIO<L> io, int idx, int lvl) throws IgniteCheckedException {
            int maxCnt = io.getMaxCount(pageAddr, BPlusTree.this.pageSize());
            int cnt = io.getCount(pageAddr);
            if (cnt == maxCnt) {
                return this.insertWithSplit(pageId, page, pageAddr, io, idx, lvl);
            }
            this.insertSimple(pageId, page, pageAddr, io, idx, null);
            return null;
        }

        private void insertSimple(long pageId, long page, long pageAddr, BPlusIO<L> io, int idx, Boolean walPlc) throws IgniteCheckedException {
            boolean needWal = BPlusTree.this.needWalDeltaRecord(pageId, page, walPlc);
            byte[] rowBytes = io.insert(pageAddr, idx, this.row, null, this.rightId, needWal);
            if (needWal) {
                BPlusTree.this.wal.log(new InsertRecord(BPlusTree.this.grpId, pageId, io, idx, rowBytes, this.rightId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private L insertWithSplit(long pageId, long page, long pageAddr, BPlusIO<L> io, int idx, int lvl) throws IgniteCheckedException {
            long fwdId = BPlusTree.this.allocatePage(null);
            long fwdPage = BPlusTree.this.acquirePage(fwdId);
            try {
                Object moveUpRow;
                Boolean fwdPageWalPlc;
                long fwdPageAddr;
                block25: {
                    Object l;
                    boolean hadFwd = io.getForward(pageAddr) != 0L;
                    fwdPageAddr = BPlusTree.this.writeLock(fwdId, fwdPage);
                    assert (fwdPageAddr != 0L);
                    fwdPageWalPlc = Boolean.TRUE;
                    try {
                        boolean midShift = BPlusTree.this.splitPage(pageId, page, pageAddr, io, fwdId, fwdPageAddr, idx);
                        int cnt = io.getCount(pageAddr);
                        if (idx < cnt || idx == cnt && !midShift) {
                            this.insertSimple(pageId, page, pageAddr, io, idx, null);
                            if (idx == cnt && !io.isLeaf()) {
                                BPlusTree.inner(io).setLeft(fwdPageAddr, 0, this.rightId);
                                if (BPlusTree.this.needWalDeltaRecord(fwdId, fwdPage, fwdPageWalPlc)) {
                                    BPlusTree.this.wal.log(new FixLeftmostChildRecord(BPlusTree.this.grpId, fwdId, this.rightId));
                                }
                            }
                        } else {
                            this.insertSimple(fwdId, fwdPage, fwdPageAddr, io, idx - cnt, fwdPageWalPlc);
                        }
                        cnt = io.getCount(pageAddr);
                        moveUpRow = io.getLookupRow(BPlusTree.this, pageAddr, cnt - 1);
                        if (!io.isLeaf()) {
                            io.setCount(pageAddr, cnt - 1);
                            if (BPlusTree.this.needWalDeltaRecord(pageId, page, null)) {
                                BPlusTree.this.wal.log(new FixCountRecord(BPlusTree.this.grpId, pageId, cnt - 1));
                            }
                        }
                        if (hadFwd || lvl != BPlusTree.this.getRootLevel()) break block25;
                        long newRootId = BPlusTree.this.allocatePage(null);
                        long newRootPage = BPlusTree.this.acquirePage(newRootId);
                        try {
                            if (io.isLeaf()) {
                                io = BPlusTree.this.latestInnerIO();
                            }
                            long newRootAddr = BPlusTree.this.writeLock(newRootId, newRootPage);
                            assert (newRootAddr != 0L);
                            Boolean newRootPageWalPlc = Boolean.FALSE;
                            try {
                                boolean needWal = BPlusTree.this.needWalDeltaRecord(newRootId, newRootPage, newRootPageWalPlc);
                                byte[] moveUpRowBytes = BPlusTree.inner(io).initNewRoot(newRootAddr, newRootId, pageId, moveUpRow, null, fwdId, BPlusTree.this.pageSize(), needWal, BPlusTree.this.metrics);
                                if (needWal) {
                                    BPlusTree.this.wal.log(new NewRootInitRecord(BPlusTree.this.grpId, newRootId, newRootId, BPlusTree.inner(io), pageId, moveUpRowBytes, fwdId));
                                }
                            }
                            finally {
                                BPlusTree.this.writeUnlock(newRootId, newRootPage, newRootAddr, newRootPageWalPlc, true);
                            }
                        }
                        finally {
                            BPlusTree.this.releasePage(newRootId, newRootPage);
                        }
                        Bool res = (Bool)((Object)BPlusTree.this.write(BPlusTree.this.metaPageId, BPlusTree.this.addRoot, newRootId, lvl + 1, (Object)Bool.FALSE, BPlusTree.this.statisticsHolder()));
                        assert (res == Bool.TRUE) : res;
                        l = null;
                    }
                    catch (Throwable throwable) {
                        BPlusTree.this.writeUnlock(fwdId, fwdPage, fwdPageAddr, fwdPageWalPlc, true);
                        throw throwable;
                    }
                    BPlusTree.this.writeUnlock(fwdId, fwdPage, fwdPageAddr, fwdPageWalPlc, true);
                    return l;
                }
                Object l = moveUpRow;
                BPlusTree.this.writeUnlock(fwdId, fwdPage, fwdPageAddr, fwdPageWalPlc, true);
                return l;
            }
            finally {
                BPlusTree.this.releasePage(fwdId, fwdPage);
            }
        }

        private Result tryInsert(long pageId, long page, long fwdId, int lvl) throws IgniteCheckedException {
            this.pageId = pageId;
            this.fwdId = fwdId;
            return (Result)((Object)BPlusTree.this.write(pageId, page, BPlusTree.this.insert, this, lvl, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
        }

        public Result tryReplace(long pageId, long page, long fwdId, int lvl) throws IgniteCheckedException {
            this.pageId = pageId;
            this.fwdId = fwdId;
            return (Result)((Object)BPlusTree.this.write(pageId, page, BPlusTree.this.replace, this, lvl, (Object)Result.RETRY, BPlusTree.this.statisticsHolder()));
        }

        public void replaceRowInPage(BPlusIO<L> io, long pageId, long page, long pageAddr, int idx) throws IgniteCheckedException {
            boolean needWal = BPlusTree.this.needWalDeltaRecord(pageId, page, null);
            byte[] newRowBytes = io.store(pageAddr, idx, this.row, null, needWal);
            if (needWal) {
                BPlusTree.this.wal.log(new ReplaceRecord(BPlusTree.this.grpId, pageId, io, newRowBytes, idx));
            }
        }

        @Override
        void checkLockRetry() throws IgniteCheckedException {
            if (this.tail == null) {
                super.checkLockRetry();
            }
        }
    }

    private final class GetLast
    extends Get {
        private final TreeRowClosure<L, T> c;
        private boolean retry;
        private long lastPageId;
        private T row0;

        public GetLast(TreeRowClosure<L, T> c) {
            super(null, true);
            this.retry = true;
            assert (c != null);
            this.c = c;
        }

        @Override
        boolean found(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl != 0) {
                return false;
            }
            for (int i = idx; i >= 0; --i) {
                if (!this.c.apply(BPlusTree.this, io, pageAddr, i)) continue;
                this.retry = false;
                this.row0 = BPlusTree.this.getRow(io, pageAddr, i);
                return true;
            }
            if (this.pageId == this.rootId) {
                this.retry = false;
            }
            if (this.retry) {
                this.findLast = false;
                this.row0 = BPlusTree.this.getRow(io, pageAddr, 0);
                this.shift = -1;
                this.lastPageId = this.pageId;
            }
            return true;
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl != 0) {
                return false;
            }
            if (io.getCount(pageAddr) == 0) {
                this.retry = false;
                return true;
            }
            if (idx == 0 && this.lastPageId == this.pageId) {
                this.retry = false;
                this.row0 = null;
                return true;
            }
            for (int i = idx; i >= 0; --i) {
                if (!this.c.apply(BPlusTree.this, io, pageAddr, i)) continue;
                this.retry = false;
                this.row0 = BPlusTree.this.getRow(io, pageAddr, i);
                break;
            }
            if (this.retry) {
                this.row0 = BPlusTree.this.getRow(io, pageAddr, 0);
                this.lastPageId = this.pageId;
            }
            return true;
        }

        public T find() throws IgniteCheckedException {
            while (this.retry) {
                this.row = this.row0;
                BPlusTree.this.doFind(this);
            }
            return this.row0;
        }
    }

    private final class TreeVisitor
    extends Get {
        long nextPageId;
        L upper;
        TreeVisitorClosure<L, T> p;
        private boolean dirty;
        private boolean writing;

        TreeVisitor(L lower, L upper, TreeVisitorClosure<L, T> p) {
            super(lower, false);
            this.shift = -1;
            this.upper = upper;
            this.p = p;
        }

        @Override
        boolean found(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            throw new IllegalStateException();
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl != 0) {
                return false;
            }
            this.writing = (this.p.state() & 2) != 0;
            if (!this.writing) {
                this.init(pageAddr, io, idx);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result init(long pageId, long page, long fwdId) throws IgniteCheckedException {
            this.pageId = pageId;
            this.fwdId = fwdId;
            if (this.writing) {
                long pageAddr = BPlusTree.this.writeLock(pageId, page);
                if (pageAddr == 0L) {
                    return Result.RETRY;
                }
                try {
                    BPlusIO io = BPlusTree.this.io(pageAddr);
                    if (io.getForward(pageAddr) != fwdId) {
                        Result result = Result.RETRY;
                        return result;
                    }
                    this.init(pageAddr, io, -1);
                }
                finally {
                    this.unlock(pageId, page, pageAddr);
                }
            }
            return Result.NOT_FOUND;
        }

        private void init(long pageAddr, BPlusIO<L> io, int startIdx) throws IgniteCheckedException {
            this.nextPageId = 0L;
            int cnt = io.getCount(pageAddr);
            if (cnt != 0) {
                this.visit(pageAddr, io, startIdx, cnt);
            }
        }

        private void visit(long pageAddr, BPlusIO<L> io, int startIdx, int cnt) throws IgniteCheckedException {
            assert (io.isLeaf()) : io;
            assert (cnt != 0) : cnt;
            assert (startIdx >= -1) : startIdx;
            assert (cnt >= startIdx);
            BPlusTree.this.checkDestroyed();
            this.nextPageId = io.getForward(pageAddr);
            if (startIdx == -1) {
                startIdx = this.findLowerBound(pageAddr, io, cnt);
            }
            if (cnt == startIdx) {
                return;
            }
            cnt = this.findUpperBound(pageAddr, io, startIdx, cnt);
            for (int i = startIdx; i < cnt; ++i) {
                boolean stop;
                int state = this.p.visit(BPlusTree.this, io, pageAddr, i, BPlusTree.this.wal);
                boolean bl = stop = (state & 1) != 0;
                if (this.writing) {
                    boolean bl2 = this.dirty = this.dirty || (state & 4) != 0;
                }
                if (!stop) continue;
                this.nextPageId = 0L;
                return;
            }
            if (this.nextPageId != 0L) {
                this.row = io.getLookupRow(BPlusTree.this, pageAddr, cnt - 1);
                this.shift = 1;
            }
        }

        private int findLowerBound(long pageAddr, BPlusIO<L> io, int cnt) throws IgniteCheckedException {
            assert (io.isLeaf());
            int cmp = BPlusTree.this.compare(0, io, pageAddr, 0, this.row);
            if (cmp < 0 || cmp == 0 && this.shift == 1) {
                int idx = BPlusTree.this.findInsertionPoint(0, io, pageAddr, 0, cnt, this.row, this.shift);
                assert (idx < 0);
                return BPlusTree.fix(idx);
            }
            return 0;
        }

        private int findUpperBound(long pageAddr, BPlusIO<L> io, int low, int cnt) throws IgniteCheckedException {
            assert (io.isLeaf());
            int cmp = BPlusTree.this.compare(0, io, pageAddr, cnt - 1, this.upper);
            if (cmp > 0) {
                int idx = BPlusTree.this.findInsertionPoint(0, io, pageAddr, low, cnt, this.upper, 1);
                assert (idx < 0);
                cnt = BPlusTree.fix(idx);
                this.nextPageId = 0L;
            }
            return cnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nextPage() throws IgniteCheckedException {
            while (true) {
                if (this.nextPageId == 0L) {
                    return;
                }
                long pageId = this.nextPageId;
                long page = BPlusTree.this.acquirePage(pageId);
                try {
                    long pageAddr = this.lock(pageId, page);
                    if (pageAddr == 0L) break;
                    try {
                        BPlusIO io = BPlusTree.this.io(pageAddr);
                        this.visit(pageAddr, io, -1, io.getCount(pageAddr));
                        continue;
                    }
                    finally {
                        this.unlock(pageId, page, pageAddr);
                        continue;
                    }
                }
                finally {
                    BPlusTree.this.releasePage(pageId, page);
                    continue;
                }
                break;
            }
            BPlusTree.this.doVisit(this);
        }

        private void unlock(long pageId, long page, long pageAddr) {
            if (this.writing) {
                BPlusTree.this.writeUnlock(pageId, page, pageAddr, this.dirty);
                this.dirty = false;
            } else {
                BPlusTree.this.readUnlock(pageId, page, pageAddr);
            }
        }

        private long lock(long pageId, long page) {
            this.writing = (this.p.state() & 2) != 0;
            if (this.writing) {
                return BPlusTree.this.writeLock(pageId, page);
            }
            return BPlusTree.this.readLock(pageId, page);
        }

        private void visit() throws IgniteCheckedException {
            BPlusTree.this.doVisit(this);
            while (this.nextPageId != 0L) {
                this.nextPage();
            }
        }
    }

    private final class GetCursor
    extends Get {
        AbstractForwardCursor cursor;

        GetCursor(L lower, int shift, AbstractForwardCursor cursor) {
            super(lower, false);
            assert (shift != 0);
            this.shift = shift;
            this.cursor = cursor;
        }

        @Override
        boolean found(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            throw new IllegalStateException();
        }

        @Override
        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl != 0) {
                return false;
            }
            this.cursor.init(pageAddr, io, idx);
            return true;
        }
    }

    private final class GetOne
    extends Get {
        Object x;
        TreeRowClosure<L, T> c;

        private GetOne(L row, TreeRowClosure<L, T> c, Object x, boolean findLast) {
            super(row, findLast);
            this.x = x;
            this.c = c;
        }

        @Override
        boolean found(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            if (lvl != 0 && !BPlusTree.this.canGetRowFromInner) {
                return false;
            }
            this.row = this.c == null || this.c.apply(BPlusTree.this, io, pageAddr, idx) ? BPlusTree.this.getRow(io, pageAddr, idx, this.x) : null;
            return true;
        }
    }

    public abstract class Get {
        long rmvId;
        int rootLvl;
        long rootId;
        L row;
        long pageId;
        long fwdId;
        long backId;
        int shift;
        Invoke invoke;
        boolean findLast;
        int lockRetriesCnt;

        Get(L row, boolean findLast) {
            this.lockRetriesCnt = BPlusTree.this.getLockRetries();
            assert (findLast ^ row != null);
            this.row = row;
            this.findLast = findLast;
        }

        final void copyFrom(Get g) {
            this.rmvId = g.rmvId;
            this.rootLvl = g.rootLvl;
            this.pageId = g.pageId;
            this.fwdId = g.fwdId;
            this.backId = g.backId;
            this.shift = g.shift;
            this.findLast = g.findLast;
        }

        final void init() throws IgniteCheckedException {
            TreeMetaData meta0 = BPlusTree.this.treeMeta();
            assert (meta0 != null);
            this.restartFromRoot(meta0.rootId, meta0.rootLvl, BPlusTree.this.globalRmvId.get());
        }

        void restartFromRoot(long rootId, int rootLvl, long rmvId) {
            this.rootId = rootId;
            this.rootLvl = rootLvl;
            this.rmvId = rmvId;
        }

        boolean found(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            assert (lvl >= 0);
            return lvl == 0;
        }

        boolean notFound(BPlusIO<L> io, long pageAddr, int idx, int lvl) throws IgniteCheckedException {
            assert (lvl >= 0);
            return lvl == 0;
        }

        public boolean canRelease(long pageId, int lvl) {
            return pageId != 0L;
        }

        void backId(long backId) {
            this.backId = backId;
        }

        void pageId(long pageId) {
            this.pageId = pageId;
        }

        void fwdId(long fwdId) {
            this.fwdId = fwdId;
        }

        boolean isFinished() {
            throw new IllegalStateException();
        }

        void checkLockRetry() throws IgniteCheckedException {
            if (this.lockRetriesCnt == 0) {
                String errMsg = BPlusTree.this.lockRetryErrorMessage(this.getClass().getSimpleName());
                IgniteCheckedException e = new IgniteCheckedException(errMsg);
                BPlusTree.this.processFailure(FailureType.CRITICAL_ERROR, e);
                throw e;
            }
            --this.lockRetriesCnt;
        }

        public L row() {
            return this.row;
        }
    }

    private class InitRoot
    extends PageHandler<Long, Bool> {
        private InitRoot() {
        }

        @Override
        public Bool run(int cacheId, long metaId, long metaPage, long pageAddr, PageIO iox, Boolean walPlc, Long rootId, int inlineSize, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            assert (rootId != null);
            BPlusMetaIO io = (BPlusMetaIO)iox;
            io.initRoot(pageAddr, rootId, BPlusTree.this.pageSize());
            io.setInlineSize(pageAddr, inlineSize);
            io.initFlagsAndVersion(pageAddr, 7L, IgniteVersionUtils.VER);
            if (BPlusTree.this.needWalDeltaRecord(metaId, metaPage, walPlc)) {
                BPlusTree.this.wal.log(new MetaPageInitRootInlineFlagsCreatedVersionRecord(cacheId, metaId, rootId, inlineSize));
            }
            assert (io.getRootLevel(pageAddr) == 0);
            assert (io.getFirstPageId(pageAddr, 0) == rootId.longValue());
            BPlusTree.this.treeMeta = new TreeMetaData(0, rootId);
            return Bool.TRUE;
        }
    }

    private class AddRoot
    extends PageHandler<Long, Bool> {
        private AddRoot() {
        }

        @Override
        public Bool run(int cacheId, long metaId, long metaPage, long pageAddr, PageIO iox, Boolean walPlc, Long rootPageId, int lvl, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            assert (rootPageId != null);
            BPlusMetaIO io = (BPlusMetaIO)iox;
            assert (lvl == io.getLevelsCount(pageAddr));
            io.addRoot(pageAddr, rootPageId, BPlusTree.this.pageSize());
            if (BPlusTree.this.needWalDeltaRecord(metaId, metaPage, walPlc)) {
                BPlusTree.this.wal.log(new MetaPageAddRootRecord(cacheId, metaId, rootPageId));
            }
            assert (io.getRootLevel(pageAddr) == lvl);
            assert (io.getFirstPageId(pageAddr, lvl) == rootPageId.longValue());
            BPlusTree.this.treeMeta = new TreeMetaData(lvl, rootPageId);
            return Bool.TRUE;
        }
    }

    private class CutRoot
    extends PageHandler<Void, Bool> {
        private CutRoot() {
        }

        @Override
        public Bool run(int cacheId, long metaId, long metaPage, long metaAddr, PageIO iox, Boolean walPlc, Void ignore, int lvl, IoStatisticsHolder statHolder) throws IgniteCheckedException {
            BPlusMetaIO io = (BPlusMetaIO)iox;
            assert (lvl == io.getRootLevel(metaAddr));
            io.cutRoot(metaAddr, BPlusTree.this.pageSize());
            if (BPlusTree.this.needWalDeltaRecord(metaId, metaPage, walPlc)) {
                BPlusTree.this.wal.log(new MetaPageCutRootRecord(cacheId, metaId));
            }
            int newLvl = lvl - 1;
            assert (io.getRootLevel(metaAddr) == newLvl);
            BPlusTree.this.treeMeta = new TreeMetaData(newLvl, io.getFirstPageId(metaAddr, newLvl));
            return Bool.TRUE;
        }
    }

    private class LockTail
    extends GetPageHandler<Remove> {
        private LockTail() {
        }

        @Override
        public Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Remove r, int lvl) throws IgniteCheckedException {
            Result res;
            assert (lvl > 0) : lvl;
            if (io.getForward(pageAddr) != r.fwdId) {
                return Result.RETRY;
            }
            if (r.fwdId != 0L && r.backId == 0L && (res = r.lockForward(lvl)) != Result.FOUND) {
                return res;
            }
            r.addTail(pageId, page, pageAddr, io, lvl, (byte)1);
            return Result.FOUND;
        }
    }

    private class LockTailExact
    extends GetPageHandler<Update> {
        private LockTailExact() {
        }

        @Override
        protected Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Update u, int lvl) {
            if (io.getForward(pageAddr) != u.fwdId) {
                return Result.RETRY;
            }
            u.addTail(pageId, page, pageAddr, io, lvl, (byte)1);
            return Result.FOUND;
        }
    }

    private class LockTailForward
    extends GetPageHandler<Remove> {
        private LockTailForward() {
        }

        @Override
        protected Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Remove r, int lvl) throws IgniteCheckedException {
            r.addTail(pageId, page, pageAddr, io, lvl, (byte)2);
            return Result.FOUND;
        }
    }

    private class LockBackAndTail
    extends GetPageHandler<Remove> {
        private LockBackAndTail() {
        }

        @Override
        public Result run0(long backId, long backPage, long backAddr, BPlusIO<L> io, Remove r, int lvl) throws IgniteCheckedException {
            if (io.getForward(backAddr) != r.pageId) {
                return Result.RETRY;
            }
            Result res = r.doLockTail(lvl);
            if (res == Result.FOUND) {
                r.addTail(backId, backPage, backAddr, io, lvl, (byte)0);
            }
            return res;
        }
    }

    private class LockBackAndRmvFromLeaf
    extends GetPageHandler<Remove> {
        private LockBackAndRmvFromLeaf() {
        }

        @Override
        protected Result run0(long backId, long backPage, long backAddr, BPlusIO<L> io, Remove r, int lvl) throws IgniteCheckedException {
            if (io.getForward(backAddr) != r.pageId) {
                return Result.RETRY;
            }
            Result res = r.doRemoveFromLeaf();
            if (res == Result.FOUND && r.tail != null) {
                r.addTail(backId, backPage, backAddr, io, lvl, (byte)0);
            }
            return res;
        }
    }

    private class RemoveRangeFromLeaf
    extends RemoveFromLeaf<RemoveRange> {
        private RemoveRangeFromLeaf() {
        }

        @Override
        public Result run0(long leafId, long leafPage, long leafAddr, BPlusIO<L> io, RemoveRange r, int lvl) throws IgniteCheckedException {
            int highIdx;
            assert (lvl == 0) : lvl;
            if (io.getForward(leafAddr) != r.fwdId) {
                return Result.RETRY;
            }
            int cnt = io.getCount(leafAddr);
            assert (cnt <= Short.MAX_VALUE) : cnt;
            int idx = BPlusTree.this.findInsertionPoint(lvl, io, leafAddr, 0, cnt, r.lower, 0);
            if (idx < 0 && ((idx = BPlusTree.fix(idx)) == cnt || BPlusTree.this.compare(io, leafAddr, idx, r.upper) > 0)) {
                return Result.RETRY;
            }
            r.highIdx = BPlusTree.this.findInsertionPoint(lvl, io, leafAddr, idx, cnt, r.upper, 0);
            int n = highIdx = r.highIdx >= 0 ? r.highIdx : BPlusTree.fix(r.highIdx) - 1;
            if (r.remaining != -1 && highIdx - idx + 1 >= r.remaining) {
                highIdx = idx + r.remaining - 1;
            }
            assert (highIdx >= idx) : "low=" + idx + ", high=" + highIdx;
            r.highIdx = r.highIdx >= 0 ? highIdx : -highIdx - 1;
            Result res = this.doRemoveOrLockTail(idx, cnt, highIdx - idx + 1, leafId, leafPage, leafAddr, io, r);
            if (res == Result.FOUND && r.needReplaceInner == Bool.TRUE) {
                r.row = BPlusTree.this.getRow(io, leafAddr, highIdx);
            }
            return res;
        }
    }

    private class RemoveFromLeaf<R extends Remove>
    extends GetPageHandler<R> {
        private RemoveFromLeaf() {
        }

        @Override
        public Result run0(long leafId, long leafPage, long leafAddr, BPlusIO<L> io, R r, int lvl) throws IgniteCheckedException {
            assert (lvl == 0) : lvl;
            if (io.getForward(leafAddr) != ((Remove)r).fwdId) {
                return Result.RETRY;
            }
            int cnt = io.getCount(leafAddr);
            assert (cnt <= Short.MAX_VALUE) : cnt;
            int idx = BPlusTree.this.findInsertionPoint(lvl, io, leafAddr, 0, cnt, ((Remove)r).row, 0);
            if (idx < 0) {
                return Result.RETRY;
            }
            return this.doRemoveOrLockTail(idx, cnt, 1, leafId, leafPage, leafAddr, io, r);
        }

        protected Result doRemoveOrLockTail(int idx, int cnt, int rmvCnt, long leafId, long leafPage, long leafAddr, BPlusIO<L> io, R r) throws IgniteCheckedException {
            boolean needReplaceInner;
            assert (idx >= 0 && idx < cnt) : idx;
            boolean bl = needReplaceInner = BPlusTree.this.canGetRowFromInner && idx == cnt - rmvCnt && io.getForward(leafAddr) != 0L;
            if (needReplaceInner || (((Remove)r).fwdId != 0L || ((Remove)r).backId != 0L) && BPlusTree.this.mayMerge(cnt - rmvCnt, io.getMaxCount(leafAddr, BPlusTree.this.pageSize()))) {
                if (((Remove)r).fwdId != 0L && ((Remove)r).backId == 0L) {
                    Result res = ((Remove)r).lockForward(0);
                    if (res != Result.FOUND) {
                        assert (((Remove)r).tail == null);
                        return res;
                    }
                    assert (((Remove)r).tail != null);
                }
                assert (((Remove)r).needReplaceInner == Bool.FALSE) : "needReplaceInner";
                assert (((Remove)r).needMergeEmptyBranch == Bool.FALSE) : "needMergeEmptyBranch";
                if (cnt == rmvCnt) {
                    ((Remove)r).needMergeEmptyBranch = Bool.TRUE;
                }
                if (needReplaceInner) {
                    ((Remove)r).needReplaceInner = Bool.TRUE;
                }
                Tail t = ((Update)r).addTail(leafId, leafPage, leafAddr, io, 0, (byte)1);
                t.idx = (short)idx;
                return Result.FOUND;
            }
            ((Remove)r).removeDataRowFromLeaf(leafId, leafPage, leafAddr, null, io, cnt, idx);
            return Result.FOUND;
        }
    }

    public class Insert
    extends GetPageHandler<Put> {
        @Override
        public Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Put p, int lvl) throws IgniteCheckedException {
            assert (p.btmLvl == lvl) : "we must always insert at the bottom level: " + p.btmLvl + " " + lvl;
            if (io.getForward(pageAddr) != p.fwdId) {
                return Result.RETRY;
            }
            int cnt = io.getCount(pageAddr);
            int idx = BPlusTree.this.findInsertionPoint(lvl, io, pageAddr, 0, cnt, p.row, 0);
            if (idx >= 0) {
                throw new IllegalStateException("Duplicate row in index.");
            }
            Object moveUpRow = p.insert(pageId, page, pageAddr, io, idx = BPlusTree.fix(idx), lvl);
            if (moveUpRow != null) {
                p.btmLvl = (short)(p.btmLvl + 1);
                p.row = moveUpRow;
                if (p.invoke != null) {
                    p.invoke.row = moveUpRow;
                }
                p.rightId = io.getForward(pageAddr);
                p.setTailForSplit(pageId, page, pageAddr, io, p.btmLvl - 1);
                assert (p.rightId != 0L);
            } else {
                p.finish();
            }
            return Result.FOUND;
        }
    }

    public class Replace
    extends GetPageHandler<Put> {
        @Override
        public Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Put p, int lvl) throws IgniteCheckedException {
            if (io.getForward(pageAddr) != p.fwdId) {
                return Result.RETRY;
            }
            assert (p.btmLvl == 0) : "split is impossible with replace";
            assert (lvl == 0) : "Replace via page handler is only possible on the leaves level.";
            int cnt = io.getCount(pageAddr);
            int idx = BPlusTree.this.findInsertionPoint(lvl, io, pageAddr, 0, cnt, p.row, 0);
            if (idx < 0) {
                return Result.RETRY;
            }
            assert (p.oldRow == null) : "The old row must be set only once.";
            if (BPlusTree.this.canGetRowFromInner && idx + 1 == cnt && p.fwdId != 0L) {
                Tail tail = p.addTail(pageId, page, pageAddr, io, lvl, (byte)1);
                tail.idx = (short)idx;
                return Result.FOUND;
            }
            p.oldRow = p.needOld ? BPlusTree.this.getRow(io, pageAddr, idx) : Boolean.TRUE;
            p.replaceRowInPage(io, pageId, page, pageAddr, idx);
            p.finish();
            return Result.FOUND;
        }
    }

    public class Search
    extends GetPageHandler<Get> {
        @Override
        public Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Get g, int lvl) throws IgniteCheckedException {
            boolean found;
            if (io.getForward(pageAddr) != g.fwdId) {
                return Result.RETRY;
            }
            boolean needBackIfRouting = g.backId != 0L;
            g.backId(0L);
            int cnt = io.getCount(pageAddr);
            int idx = g.findLast ? (io.isLeaf() ? cnt - 1 : -cnt - 1) : BPlusTree.this.findInsertionPoint(lvl, io, pageAddr, 0, cnt, g.row, g.shift);
            boolean bl = found = idx >= 0;
            if (found) {
                assert (g.getClass() != GetCursor.class);
                if (g.found(io, pageAddr, idx, lvl)) {
                    return Result.FOUND;
                }
            } else if (g.notFound(io, pageAddr, idx = BPlusTree.fix(idx), lvl)) {
                return Result.NOT_FOUND;
            }
            assert (!io.isLeaf()) : io;
            g.pageId(BPlusTree.inner(io).getLeft(pageAddr, idx));
            if (idx < cnt) {
                g.fwdId(BPlusTree.inner(io).getRight(pageAddr, idx));
            } else {
                assert (idx == cnt);
                long fwdId = io.getForward(pageAddr);
                if (fwdId == 0L) {
                    g.fwdId(0L);
                } else {
                    Result res = BPlusTree.this.askNeighbor(fwdId, g, false);
                    if (res != Result.FOUND) {
                        return res;
                    }
                }
                if (cnt != 0) {
                    g.backId(BPlusTree.inner(io).getLeft(pageAddr, cnt - 1));
                } else if (needBackIfRouting) {
                    return Result.GO_DOWN_X;
                }
            }
            return Result.GO_DOWN;
        }
    }

    private class AskNeighbor
    extends GetPageHandler<Get> {
        private AskNeighbor() {
        }

        @Override
        public Result run0(long pageId, long page, long pageAddr, BPlusIO<L> io, Get g, int isBack) {
            assert (!io.isLeaf());
            boolean back = isBack == Bool.TRUE.ordinal();
            long res = BPlusTree.this.doAskNeighbor(io, pageAddr, back);
            if (back) {
                if (io.getForward(pageAddr) != g.backId) {
                    return Result.RETRY;
                }
                g.backId(res);
            } else {
                assert (isBack == Bool.FALSE.ordinal()) : isBack;
                g.fwdId(res);
            }
            return Result.FOUND;
        }
    }
}

