/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.jetbrains.annotations.Nullable;

abstract class SnapshotSender {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Executor exec;
    private volatile boolean closed;
    protected final IgniteLogger log;

    protected SnapshotSender(IgniteLogger log, Executor exec) {
        this.exec = exec;
        this.log = log.getLogger(SnapshotSender.class);
    }

    public Executor executor() {
        return this.exec;
    }

    public final void sendMarshallerMeta(List<Map<Integer, MappedName>> mappings) {
        if (!this.lock.readLock().tryLock()) {
            return;
        }
        try {
            if (this.closed) {
                return;
            }
            if (mappings == null) {
                return;
            }
            this.sendMarshallerMeta0(mappings);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final void sendBinaryMeta(Collection<BinaryType> types) {
        if (!this.lock.readLock().tryLock()) {
            return;
        }
        try {
            if (this.closed) {
                return;
            }
            if (types == null) {
                return;
            }
            this.sendBinaryMeta0(types);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final void sendCacheConfig(File ccfg, String cacheDirName) {
        if (!this.lock.readLock().tryLock()) {
            return;
        }
        try {
            if (this.closed) {
                return;
            }
            this.sendCacheConfig0(ccfg, cacheDirName);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendPart(File part, String cacheDirName, GroupPartitionId pair, Long length) {
        if (!this.lock.readLock().tryLock()) {
            return;
        }
        try {
            if (this.closed) {
                return;
            }
            this.sendPart0(part, cacheDirName, pair, length);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendDelta(File delta, String cacheDirName, GroupPartitionId pair) {
        if (!this.lock.readLock().tryLock()) {
            return;
        }
        try {
            if (this.closed) {
                return;
            }
            this.sendDelta0(delta, cacheDirName, pair);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final void close(@Nullable Throwable th) {
        this.lock.writeLock().lock();
        try {
            this.close0(th);
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract void init(int var1);

    protected abstract void sendPart0(File var1, String var2, GroupPartitionId var3, Long var4);

    protected abstract void sendDelta0(File var1, String var2, GroupPartitionId var3);

    protected void sendMarshallerMeta0(List<Map<Integer, MappedName>> mappings) {
    }

    protected void sendBinaryMeta0(Collection<BinaryType> types) {
    }

    protected void sendCacheConfig0(File ccfg, String cacheDirName) {
    }

    protected void close0(@Nullable Throwable th) {
    }
}

