/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.discovery.ConsistentIdMapper;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotVerificationTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotProcessor;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotVerificationTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.TransactionsHashRecord;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class IncrementalSnapshotVerificationTask
extends AbstractSnapshotVerificationTask {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;

    @Override
    public SnapshotPartitionsVerifyTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap<Object, Map<Object, TransactionsHashRecord>> nodeTxHashMap = new HashMap<Object, Map<Object, TransactionsHashRecord>>();
        ArrayList<List<TransactionsHashRecord>> txHashConflicts = new ArrayList<List<TransactionsHashRecord>>();
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> partHashes = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        HashMap<ClusterNode, Collection<GridCacheVersion>> partiallyCommittedTxs = new HashMap<ClusterNode, Collection<GridCacheVersion>>();
        HashMap<ClusterNode, Exception> errors = new HashMap<ClusterNode, Exception>();
        for (ComputeJobResult nodeRes : results) {
            if (nodeRes.getException() != null) {
                errors.put(nodeRes.getNode(), nodeRes.getException());
                continue;
            }
            IncrementalSnapshotVerificationTaskResult res = (IncrementalSnapshotVerificationTaskResult)nodeRes.getData();
            if (!F.isEmpty(res.exceptions())) {
                errors.put(nodeRes.getNode(), F.first(res.exceptions()));
                continue;
            }
            if (!F.isEmpty(res.partiallyCommittedTxs())) {
                partiallyCommittedTxs.put(nodeRes.getNode(), res.partiallyCommittedTxs());
            }
            for (Map.Entry<PartitionKeyV2, PartitionHashRecordV2> entry : res.partHashRes().entrySet()) {
                partHashes.computeIfAbsent(entry.getKey(), v -> new ArrayList()).add(entry.getValue());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handle VerifyIncrementalSnapshotJob result [node=" + nodeRes.getNode() + ", taskRes=" + res + ']');
            }
            nodeTxHashMap.put(nodeRes.getNode().consistentId(), res.txHashRes());
            Iterator<Map.Entry<Object, TransactionsHashRecord>> resIt = res.txHashRes().entrySet().iterator();
            while (resIt.hasNext()) {
                Map.Entry<Object, TransactionsHashRecord> nodeTxHash = resIt.next();
                Map prevNodeTxHash = (Map)nodeTxHashMap.get(nodeTxHash.getKey());
                if (prevNodeTxHash == null) continue;
                TransactionsHashRecord hash = nodeTxHash.getValue();
                TransactionsHashRecord prevHash = (TransactionsHashRecord)prevNodeTxHash.remove(hash.localConsistentId());
                if (prevHash == null || prevHash.transactionHash() != hash.transactionHash()) {
                    txHashConflicts.add(F.asList(new TransactionsHashRecord[]{hash, prevHash}));
                }
                resIt.remove();
            }
        }
        nodeTxHashMap.values().stream().flatMap(e -> e.values().stream()).forEach(e -> txHashConflicts.add(F.asList(new TransactionsHashRecord[]{e, null})));
        return new SnapshotPartitionsVerifyTaskResult(this.metas, errors.isEmpty() ? new IdleVerifyResultV2(partHashes, txHashConflicts, partiallyCommittedTxs) : new IdleVerifyResultV2(errors));
    }

    @Override
    protected ComputeJob createJob(String name, @Nullable String path, int incIdx, String constId, Collection<String> groups, boolean check) {
        return new VerifyIncrementalSnapshotJob(name, path, incIdx, constId);
    }

    private static class HashHolder {
        private int hash;
        private int verHash;

        private HashHolder() {
        }

        public void increment(int hash, int verHash) {
            this.hash += hash;
            this.verHash += verHash;
        }
    }

    private static class VerifyIncrementalSnapshotJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private final String snpName;
        private final String snpPath;
        private final int incIdx;
        private final String consId;
        private LongAdder procEntriesCnt;

        public VerifyIncrementalSnapshotJob(String snpName, @Nullable String snpPath, int incIdx, String consId) {
            this.snpName = snpName;
            this.snpPath = snpPath;
            this.incIdx = incIdx;
            this.consId = consId;
        }

        @Override
        public IncrementalSnapshotVerificationTaskResult execute() throws IgniteException {
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Verify incremental snapshot procedure has been initiated [snpName=" + this.snpName + ", incrementIndex=" + this.incIdx + ", consId=" + this.consId + ']');
                }
                if (this.incIdx <= 0) {
                    return new IncrementalSnapshotVerificationTaskResult();
                }
                BaselineTopology blt = this.ignite.context().state().clusterState().baselineTopology();
                this.checkBaseline(blt);
                Map<Integer, StoredCacheData> txCaches = this.readTxCachesData();
                final AtomicLong procSegCnt = new AtomicLong();
                IncrementalSnapshotProcessor proc = new IncrementalSnapshotProcessor(this.ignite.context().cache().context(), this.snpName, this.snpPath, this.incIdx, txCaches.keySet()){

                    @Override
                    void totalWalSegments(int segCnt) {
                    }

                    @Override
                    void processedWalSegments(int segCnt) {
                        procSegCnt.set(segCnt);
                    }

                    @Override
                    void initWalEntries(LongAdder entriesCnt) {
                        procEntriesCnt = entriesCnt;
                    }
                };
                short locNodeId = blt.consistentIdMapping().get(this.consId);
                HashSet activeDhtTxs = new HashSet();
                HashMap txPrimParticipatingNodes = new HashMap();
                HashMap nodesTxHash = new HashMap();
                HashSet<GridCacheVersion> partiallyCommittedTxs = new HashSet<GridCacheVersion>();
                HashMap partMap = new HashMap();
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                Function<Short, HashHolder> hashHolderBuilder = k -> new HashHolder();
                BiConsumer<GridCacheVersion, Set> calcTxHash = (xid, participatingNodes) -> {
                    Iterator iterator = participatingNodes.iterator();
                    while (iterator.hasNext()) {
                        short nodeId = (Short)iterator.next();
                        if (nodeId == locNodeId) continue;
                        HashHolder hash = (HashHolder)nodesTxHash.computeIfAbsent(nodeId, hashHolderBuilder);
                        hash.increment(xid.hashCode(), 0);
                    }
                };
                Map<Integer, Integer> cacheGrpId = txCaches.values().stream().collect(Collectors.toMap(StoredCacheData::cacheId, cacheData -> CU.cacheGroupId(cacheData.config().getName(), cacheData.config().getGroupName())));
                LongAdder procTxCnt = new LongAdder();
                proc.process(dataEntry -> {
                    if (dataEntry.op() == GridCacheOperation.READ || !exceptions.isEmpty()) {
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Checking data entry [entry=" + dataEntry + ']');
                    }
                    if (!activeDhtTxs.contains(dataEntry.writeVersion())) {
                        partiallyCommittedTxs.add(dataEntry.nearXidVersion());
                    }
                    StoredCacheData cacheData = (StoredCacheData)txCaches.get(dataEntry.cacheId());
                    PartitionKeyV2 partKey = new PartitionKeyV2((Integer)cacheGrpId.get(dataEntry.cacheId()), dataEntry.partitionId(), CU.cacheOrGroupName(cacheData.config()));
                    HashHolder hash = partMap.computeIfAbsent(partKey, k -> new HashHolder());
                    try {
                        int valHash = dataEntry.key().hashCode();
                        if (dataEntry.value() != null) {
                            valHash += Arrays.hashCode(dataEntry.value().valueBytes(null));
                        }
                        int verHash = dataEntry.writeVersion().hashCode();
                        hash.increment(valHash, verHash);
                    }
                    catch (IgniteCheckedException ex) {
                        exceptions.add(ex);
                    }
                }, txRec -> {
                    if (!exceptions.isEmpty()) {
                        return;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Checking tx record [txRec=" + txRec + ']');
                    }
                    if (txRec.state() == TransactionState.PREPARED) {
                        Set<Short> primParticipatingNodes = txRec.participatingNodes().keySet();
                        if (primParticipatingNodes.contains(locNodeId)) {
                            txPrimParticipatingNodes.put(txRec.nearXidVersion(), primParticipatingNodes);
                            activeDhtTxs.add(txRec.writeVersion());
                        } else {
                            for (Collection<Short> backups : txRec.participatingNodes().values()) {
                                if (!backups.contains(ConsistentIdMapper.ALL_NODES) && !backups.contains(locNodeId)) continue;
                                activeDhtTxs.add(txRec.writeVersion());
                            }
                        }
                    } else if (txRec.state() == TransactionState.COMMITTED) {
                        activeDhtTxs.remove(txRec.writeVersion());
                        Set participatingNodes = (Set)txPrimParticipatingNodes.remove(txRec.nearXidVersion());
                        if (participatingNodes == null) {
                            return;
                        }
                        procTxCnt.increment();
                        calcTxHash.accept(txRec.nearXidVersion(), participatingNodes);
                    } else if (txRec.state() == TransactionState.ROLLED_BACK) {
                        activeDhtTxs.remove(txRec.writeVersion());
                        txPrimParticipatingNodes.remove(txRec.nearXidVersion());
                    }
                });
                for (Map.Entry tx : txPrimParticipatingNodes.entrySet()) {
                    calcTxHash.accept((GridCacheVersion)tx.getKey(), (Set)tx.getValue());
                }
                Map<Object, TransactionsHashRecord> txHashRes = nodesTxHash.entrySet().stream().map(e -> new TransactionsHashRecord(this.consId, blt.compactIdMapping().get(e.getKey()), ((HashHolder)e.getValue()).hash)).collect(Collectors.toMap(TransactionsHashRecord::remoteConsistentId, Function.identity()));
                Map<PartitionKeyV2, PartitionHashRecordV2> partHashRes = partMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new PartitionHashRecordV2((PartitionKeyV2)e.getKey(), false, this.consId, ((HashHolder)e.getValue()).hash, ((HashHolder)e.getValue()).verHash, null, 0L, null)));
                if (this.log.isInfoEnabled()) {
                    this.log.info("Verify incremental snapshot procedure finished [snpName=" + this.snpName + ", incrementIndex=" + this.incIdx + ", consId=" + this.consId + ", txCnt=" + procTxCnt.sum() + ", dataEntries=" + this.procEntriesCnt.sum() + ", walSegments=" + procSegCnt.get() + ']');
                }
                return new IncrementalSnapshotVerificationTaskResult(txHashRes, partHashRes, partiallyCommittedTxs, exceptions);
            }
            catch (IOException | IgniteCheckedException e2) {
                throw new IgniteException(e2);
            }
        }

        private void checkBaseline(BaselineTopology blt) throws IgniteCheckedException, IOException {
            IgniteSnapshotManager snpMgr = this.ignite.context().cache().context().snapshotMgr();
            File snpDir = snpMgr.snapshotLocalDir(this.snpName, this.snpPath);
            SnapshotMetadata meta = snpMgr.readSnapshotMetadata(snpDir, this.ignite.localNode().consistentId().toString());
            if (!F.eqNotOrdered(blt.consistentIds(), meta.baselineNodes())) {
                throw new IgniteCheckedException("Topologies of snapshot and current cluster are different [snp=" + meta.baselineNodes() + ", current=" + blt.consistentIds() + ']');
            }
        }

        private Map<Integer, StoredCacheData> readTxCachesData() throws IgniteCheckedException, IOException {
            File snpDir = this.ignite.context().cache().context().snapshotMgr().snapshotLocalDir(this.snpName, this.snpPath);
            String folderName = this.ignite.context().pdsFolderResolver().resolveFolders().folderName();
            return GridLocalConfigManager.readCachesData(new File(snpDir, IgniteSnapshotManager.databaseRelativePath(folderName)), MarshallerUtils.jdkMarshaller(this.ignite.name()), this.ignite.configuration()).values().stream().filter(data -> data.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL).collect(Collectors.toMap(StoredCacheData::cacheId, Function.identity()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerifyIncrementalSnapshotJob job = (VerifyIncrementalSnapshotJob)o;
            return this.snpName.equals(job.snpName) && Objects.equals(this.incIdx, job.incIdx) && Objects.equals(this.snpPath, job.snpPath) && this.consId.equals(job.consId);
        }

        public int hashCode() {
            return Objects.hash(this.snpName, this.incIdx, this.snpPath, this.consId);
        }
    }
}

