/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IncrementalSnapshotMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final UUID rqId;
    @GridToStringInclude
    private final String snpName;
    @GridToStringInclude
    private final int incIdx;
    @GridToStringInclude
    private final String consId;
    private final String folderName;
    private final WALPointer incSnpRec;

    public IncrementalSnapshotMetadata(UUID rqId, String snpName, int incIdx, String consId, String folderName, WALPointer incSnpRec) {
        this.rqId = rqId;
        this.snpName = snpName;
        this.incIdx = incIdx;
        this.consId = consId;
        this.folderName = folderName;
        this.incSnpRec = incSnpRec;
    }

    public UUID requestId() {
        return this.rqId;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public String consistentId() {
        return this.consId;
    }

    public WALPointer incrementalSnapshotPointer() {
        return this.incSnpRec;
    }

    public int incrementIndex() {
        return this.incIdx;
    }

    public String folderName() {
        return this.folderName;
    }

    public boolean matchBaseSnapshot(SnapshotMetadata meta) {
        return this.snpName.equals(meta.snapshotName()) && this.consId.equals(meta.consistentId());
    }

    public String toString() {
        return S.toString(IncrementalSnapshotMetadata.class, this);
    }
}

