/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IncompleteCacheObject;
import org.apache.ignite.internal.processors.cache.IncompleteObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTreeRuntimeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheDataRowAdapter
implements CacheDataRow {
    @GridToStringExclude
    protected long link;
    @GridToStringInclude
    protected KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;
    @GridToStringInclude
    protected long expireTime = -1L;
    @GridToStringInclude
    protected GridCacheVersion ver;
    protected boolean verReady;
    @GridToStringInclude
    protected int cacheId;

    public CacheDataRowAdapter(long link) {
        this.link = link;
    }

    public CacheDataRowAdapter(KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime) {
        this.key = key;
        this.val = val;
        this.ver = ver;
        this.expireTime = expireTime;
        this.verReady = true;
    }

    public final void initFromLink(CacheGroupContext grp, RowData rowData) throws IgniteCheckedException {
        this.initFromLink(grp, rowData, false);
    }

    public final void initFromLink(CacheGroupContext grp, RowData rowData, boolean skipVer) throws IgniteCheckedException {
        this.initFromLink(grp, grp.shared(), grp.dataRegion().pageMemory(), rowData, skipVer);
    }

    public final void initFromLink(@Nullable CacheGroupContext grp, GridCacheSharedContext<?, ?> sharedCtx, PageMemory pageMem, RowData rowData, boolean skipVer) throws IgniteCheckedException {
        assert (grp != null || pageMem instanceof PageMemoryNoStoreImpl);
        CacheObjectContext coctx = grp != null ? grp.cacheObjectContext() : null;
        boolean readCacheId = grp == null || grp.storeCacheIdInDataPage();
        int grpId = grp != null ? grp.groupId() : 0;
        IoStatisticsHolder statHolder = grp != null ? grp.statisticsHolderData() : IoStatisticsHolderNoOp.INSTANCE;
        this.doInitFromLink(this.link, sharedCtx, coctx, pageMem, grpId, statHolder, readCacheId, rowData, null, skipVer);
    }

    public final void initFromPageBuffer(GridCacheSharedContext<?, ?> sctx, CacheObjectContext coctx, IgniteThrowableFunction<Long, ByteBuffer> reader, ByteBuffer pageBuff, int itemId, boolean readCacheId, RowData rowData, boolean skipVer) throws IgniteCheckedException {
        block2: {
            long nextLink;
            int itemId0 = itemId;
            ByteBuffer buff = pageBuff;
            IncompleteObject<?> incomplete = null;
            while (true) {
                long pageAddr = GridUnsafe.bufferAddress(buff);
                if ((incomplete = this.readIncomplete(incomplete, sctx, coctx, buff.capacity(), buff.capacity(), pageAddr, itemId0, (DataPageIO)PageIO.getPageIO(1, PageIO.getVersion(buff)), rowData, readCacheId, skipVer)) == null || (nextLink = incomplete.getNextLink()) == 0L) break block2;
                buff = reader.apply(PageIdUtils.pageId(nextLink));
                itemId0 = PageIdUtils.itemId(nextLink);
                assert (itemId0 == 0) : "Only one item is possible on the fragmented page: " + PageIdUtils.toDetailString(nextLink);
            }
        }
        assert (this.isReady()) : "Entry must has the 'ready' state, when the init ends";
    }

    public final void initFromDataPage(DataPageIO io, long pageAddr, int itemId, @Nullable CacheGroupContext grp, GridCacheSharedContext<?, ?> sharedCtx, PageMemory pageMem, RowData rowData, boolean skipVer) throws IgniteCheckedException {
        long nextLink;
        assert (grp != null || pageMem instanceof PageMemoryNoStoreImpl);
        CacheObjectContext coctx = grp != null ? grp.cacheObjectContext() : null;
        boolean readCacheId = grp == null || grp.storeCacheIdInDataPage();
        int grpId = grp != null ? grp.groupId() : 0;
        IoStatisticsHolder statHolder = grp != null ? grp.statisticsHolderData() : IoStatisticsHolderNoOp.INSTANCE;
        IncompleteObject<?> incomplete = this.readIncomplete(null, sharedCtx, coctx, pageMem.pageSize(), pageMem.realPageSize(grpId), pageAddr, itemId, io, rowData, readCacheId, skipVer);
        if (incomplete != null && (nextLink = incomplete.getNextLink()) != 0L) {
            this.doInitFromLink(nextLink, sharedCtx, coctx, pageMem, grpId, statHolder, readCacheId, rowData, incomplete, skipVer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitFromLink(long link, GridCacheSharedContext<?, ?> sharedCtx, CacheObjectContext coctx, PageMemory pageMem, int grpId, IoStatisticsHolder statHolder, boolean readCacheId, RowData rowData, @Nullable IncompleteObject<?> incomplete, boolean skipVer) throws IgniteCheckedException {
        assert (link != 0L) : "link";
        assert (this.key == null) : "key";
        long nextLink = link;
        do {
            long pageId = PageIdUtils.pageId(nextLink);
            try {
                long page = pageMem.acquirePage(grpId, pageId, statHolder);
                try {
                    long pageAddr = pageMem.readLock(grpId, pageId, page);
                    assert (pageAddr != 0L) : nextLink;
                    try {
                        DataPageIO io = DataPageIO.VERSIONS.forPage(pageAddr);
                        int itemId = PageIdUtils.itemId(nextLink);
                        incomplete = this.readIncomplete(incomplete, sharedCtx, coctx, pageMem.pageSize(), pageMem.realPageSize(grpId), pageAddr, itemId, io, rowData, readCacheId, skipVer);
                        if (incomplete == null || rowData == RowData.KEY_ONLY && this.key != null) {
                            return;
                        }
                        nextLink = incomplete.getNextLink();
                    }
                    finally {
                        pageMem.readUnlock(grpId, pageId, page);
                    }
                }
                finally {
                    pageMem.releasePage(grpId, pageId, page);
                }
            }
            catch (AssertionError | RuntimeException e) {
                long[] pageIds;
                try {
                    pageIds = this.relatedPageIds(grpId, link, pageId, pageMem, statHolder);
                }
                catch (IgniteCheckedException e0) {
                    pageIds = new long[]{pageId};
                }
                throw new BPlusTreeRuntimeException((Throwable)e, grpId, pageIds);
            }
        } while (nextLink != 0L);
        assert (this.isReady()) : "ready";
    }

    protected IncompleteObject<?> readIncomplete(IncompleteObject<?> incomplete, GridCacheSharedContext<?, ?> sharedCtx, CacheObjectContext coctx, int pageSize, int realPageSize, long pageAddr, int itemId, DataPageIO io, RowData rowData, boolean readCacheId, boolean skipVer) throws IgniteCheckedException {
        DataPagePayload data = io.readPayload(pageAddr, itemId, realPageSize);
        long nextLink = data.nextLink();
        int hdrLen = 0;
        if (incomplete == null) {
            if (nextLink == 0L) {
                this.readFullRow(sharedCtx, coctx, pageAddr + (long)data.offset(), rowData, readCacheId, skipVer);
                return null;
            }
            hdrLen = this.readHeader(sharedCtx, pageAddr, data.offset(), rowData);
            if (rowData == RowData.LINK_WITH_HEADER) {
                return null;
            }
        }
        ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, pageSize);
        int off = data.offset() + hdrLen;
        int payloadSize = data.payloadSize() - hdrLen;
        buf.position(off);
        buf.limit(off + payloadSize);
        boolean keyOnly = rowData == RowData.KEY_ONLY;
        incomplete = this.readFragment(sharedCtx, coctx, buf, keyOnly, readCacheId, incomplete, skipVer);
        if (incomplete != null) {
            incomplete.setNextLink(nextLink);
        }
        return incomplete;
    }

    protected int readHeader(GridCacheSharedContext<?, ?> sharedCtx, long addr, int off, RowData rowData) {
        return 0;
    }

    protected IncompleteObject<?> readFragment(GridCacheSharedContext<?, ?> sharedCtx, CacheObjectContext coctx, ByteBuffer buf, boolean keyOnly, boolean readCacheId, IncompleteObject<?> incomplete, boolean skipVer) throws IgniteCheckedException {
        if (readCacheId && this.cacheId == 0) {
            incomplete = this.readIncompleteCacheId(buf, incomplete);
            if (this.cacheId == 0) {
                assert (incomplete != null);
                return incomplete;
            }
            incomplete = null;
        }
        if (coctx == null) {
            assert (this.cacheId != 0);
            coctx = sharedCtx.cacheContext(this.cacheId).cacheObjectContext();
        }
        if (this.key == null) {
            incomplete = this.readIncompleteKey(coctx, buf, (IncompleteCacheObject)incomplete);
            if (this.key == null) {
                assert (incomplete != null);
                return incomplete;
            }
            if (keyOnly) {
                return null;
            }
            incomplete = null;
        }
        if (this.expireTime == -1L) {
            incomplete = this.readIncompleteExpireTime(buf, incomplete);
            if (this.expireTime == -1L) {
                assert (incomplete != null);
                return incomplete;
            }
            incomplete = null;
        }
        if (this.val == null) {
            incomplete = this.readIncompleteValue(coctx, buf, (IncompleteCacheObject)incomplete);
            if (this.val == null) {
                assert (incomplete != null);
                return incomplete;
            }
            incomplete = null;
        }
        if (!this.verReady) {
            incomplete = this.readIncompleteVersion(buf, incomplete, skipVer);
            assert (skipVer || this.ver != null || incomplete != null);
        }
        return incomplete;
    }

    protected void readFullRow(GridCacheSharedContext<?, ?> sharedCtx, CacheObjectContext coctx, long addr, RowData rowData, boolean readCacheId, boolean skipVer) throws IgniteCheckedException {
        int verLen;
        byte[] bytes;
        byte type;
        int off = 0;
        off += this.readHeader(sharedCtx, addr, off, rowData);
        if (rowData == RowData.LINK_WITH_HEADER) {
            return;
        }
        if (readCacheId) {
            this.cacheId = PageUtils.getInt(addr, off);
            off += 4;
        }
        if (coctx == null) {
            coctx = sharedCtx.cacheContext(this.cacheId).cacheObjectContext();
        }
        int len = PageUtils.getInt(addr, off);
        off += 4;
        if (rowData != RowData.NO_KEY && rowData != RowData.NO_KEY_WITH_HINTS) {
            type = PageUtils.getByte(addr, off);
            bytes = PageUtils.getBytes(addr, ++off, len);
            off += len;
            this.key = coctx.kernalContext().cacheObjects().toKeyCacheObject(coctx, type, bytes);
            if (rowData == RowData.KEY_ONLY) {
                return;
            }
        } else {
            off += len + 1;
        }
        len = PageUtils.getInt(addr, off);
        type = PageUtils.getByte(addr, off += 4);
        bytes = PageUtils.getBytes(addr, ++off, len);
        off += len;
        this.val = coctx.kernalContext().cacheObjects().toCacheObject(coctx, type, bytes);
        if (skipVer) {
            this.ver = null;
            verLen = CacheVersionIO.readSize(addr + (long)off, false);
        } else {
            this.ver = CacheVersionIO.read(addr + (long)off, false);
            verLen = CacheVersionIO.size(this.ver, false);
        }
        this.verReady = true;
        this.expireTime = PageUtils.getLong(addr, off += verLen);
    }

    protected IncompleteObject<?> readIncompleteCacheId(ByteBuffer buf, IncompleteObject<?> incomplete) {
        if (incomplete == null) {
            int size;
            int remaining = buf.remaining();
            if (remaining >= (size = 4)) {
                this.cacheId = buf.getInt();
                assert (this.cacheId != 0);
                return null;
            }
            incomplete = new IncompleteObject(new byte[size]);
            if (remaining == 0) {
                return incomplete;
            }
        }
        incomplete.readData(buf);
        if (incomplete.isReady()) {
            ByteBuffer timeBuf = ByteBuffer.wrap(incomplete.data());
            timeBuf.order(buf.order());
            this.cacheId = timeBuf.getInt();
            assert (this.cacheId != 0);
        }
        return incomplete;
    }

    protected IncompleteCacheObject readIncompleteKey(CacheObjectContext coctx, ByteBuffer buf, IncompleteCacheObject incomplete) throws IgniteCheckedException {
        incomplete = coctx.kernalContext().cacheObjects().toKeyCacheObject(coctx, buf, incomplete);
        if (incomplete.isReady()) {
            this.key = (KeyCacheObject)incomplete.object();
            assert (this.key != null);
        } else assert (!buf.hasRemaining());
        return incomplete;
    }

    protected IncompleteCacheObject readIncompleteValue(CacheObjectContext coctx, ByteBuffer buf, IncompleteCacheObject incomplete) throws IgniteCheckedException {
        incomplete = coctx.kernalContext().cacheObjects().toCacheObject(coctx, buf, incomplete);
        if (incomplete.isReady()) {
            this.val = (CacheObject)incomplete.object();
            assert (this.val != null);
        } else assert (!buf.hasRemaining());
        return incomplete;
    }

    protected IncompleteObject<?> readIncompleteExpireTime(ByteBuffer buf, IncompleteObject<?> incomplete) {
        if (incomplete == null) {
            int size;
            int remaining = buf.remaining();
            if (remaining >= (size = 8)) {
                this.expireTime = buf.getLong();
                assert (this.expireTime >= 0L) : this.expireTime;
                return null;
            }
            incomplete = new IncompleteObject(new byte[size]);
            if (remaining == 0) {
                return incomplete;
            }
        }
        incomplete.readData(buf);
        if (incomplete.isReady()) {
            ByteBuffer timeBuf = ByteBuffer.wrap(incomplete.data());
            timeBuf.order(buf.order());
            this.expireTime = timeBuf.getLong();
            assert (this.expireTime >= 0L);
        }
        return incomplete;
    }

    protected IncompleteObject<?> readIncompleteVersion(ByteBuffer buf, IncompleteObject<?> incomplete, boolean skip) throws IgniteCheckedException {
        if (incomplete == null || incomplete.data() == null) {
            int remaining = buf.remaining();
            if (remaining == 0) {
                return new IncompleteObject();
            }
            int size = CacheVersionIO.readSize(buf, false);
            if (remaining >= size) {
                if (skip) {
                    buf.position(buf.position() + size);
                } else {
                    this.ver = CacheVersionIO.read(buf, false);
                    assert (!buf.hasRemaining()) : buf.remaining();
                    assert (this.ver != null);
                }
                this.verReady = true;
                return null;
            }
            incomplete = new IncompleteObject(new byte[size]);
        }
        incomplete.readData(buf);
        if (incomplete.isReady()) {
            if (!skip) {
                ByteBuffer verBuf = ByteBuffer.wrap(incomplete.data());
                verBuf.order(buf.order());
                this.ver = CacheVersionIO.read(verBuf, false);
                assert (this.ver != null);
            }
            this.verReady = true;
        }
        assert (!buf.hasRemaining());
        return incomplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] relatedPageIds(int grpId, long link, long pageId, PageMemory pageMem, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        GridLongList pageIds = new GridLongList();
        long nextLink = link;
        long nextLinkPageId = PageIdUtils.pageId(nextLink);
        while (nextLinkPageId != pageId) {
            pageIds.add(nextLinkPageId);
            long page = pageMem.acquirePage(grpId, nextLinkPageId, statHolder);
            try {
                long pageAddr = pageMem.readLock(grpId, nextLinkPageId, page);
                try {
                    DataPageIO io = DataPageIO.VERSIONS.forPage(pageAddr);
                    int itemId = PageIdUtils.itemId(nextLink);
                    DataPagePayload data = io.readPayload(pageAddr, itemId, pageMem.realPageSize(grpId));
                    nextLink = data.nextLink();
                    nextLinkPageId = PageIdUtils.pageId(nextLink);
                }
                finally {
                    pageMem.readUnlock(grpId, nextLinkPageId, page);
                }
            }
            finally {
                pageMem.releasePage(grpId, nextLinkPageId, page);
            }
        }
        pageIds.add(pageId);
        return pageIds.array();
    }

    public boolean isReady() {
        return this.verReady && this.val != null && this.key != null;
    }

    @Override
    public KeyCacheObject key() {
        assert (this.key != null) : "Key is not ready: " + this;
        return this.key;
    }

    @Override
    public void key(KeyCacheObject key) {
        assert (key != null);
        this.key = key;
    }

    @Override
    public int cacheId() {
        return this.cacheId;
    }

    @Override
    public CacheObject value() {
        assert (this.val != null) : "Value is not ready: " + this;
        return this.val;
    }

    @Override
    public GridCacheVersion version() {
        assert (this.verReady) : "Version is not ready: " + this;
        return this.ver;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public int partition() {
        return PageIdUtils.partId(PageIdUtils.pageId(this.link));
    }

    @Override
    public long link() {
        return this.link;
    }

    @Override
    public void link(long link) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() throws IgniteCheckedException {
        int len = this.key().valueBytesLength(null);
        return (len += this.value().valueBytesLength(null) + CacheVersionIO.size(this.version(), false) + 8) + (this.cacheId() != 0 ? 4 : 0);
    }

    @Override
    public int headerSize() {
        return 0;
    }

    @Override
    public long mvccCoordinatorVersion() {
        return 0L;
    }

    @Override
    public long mvccCounter() {
        return 0L;
    }

    @Override
    public int mvccOperationCounter() {
        return 0;
    }

    @Override
    public byte mvccTxState() {
        return 0;
    }

    @Override
    public long newMvccCoordinatorVersion() {
        return 0L;
    }

    @Override
    public long newMvccCounter() {
        return 0L;
    }

    @Override
    public int newMvccOperationCounter() {
        return 0;
    }

    @Override
    public byte newMvccTxState() {
        return 0;
    }

    public String toString() {
        return S.toString(CacheDataRowAdapter.class, this, "link", (Object)U.hexLong(this.link));
    }

    public static enum RowData {
        FULL,
        KEY_ONLY,
        NO_KEY,
        LINK_ONLY,
        LINK_WITH_HEADER,
        FULL_WITH_HINTS,
        NO_KEY_WITH_HINTS;

    }
}

