/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DateIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DateTimeIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class DateInlineIndexKeyType
extends NullableInlineIndexKeyType<DateIndexKey> {
    public DateInlineIndexKeyType() {
        super(IndexKeyType.DATE, (short)8);
    }

    @Override
    public boolean isComparableTo(IndexKey key) {
        return key instanceof DateTimeIndexKey;
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        return -Integer.signum(((DateTimeIndexKey)key).compareTo(PageUtils.getLong(pageAddr, off + 1), 0L));
    }

    @Override
    protected int put0(long pageAddr, int off, DateIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putLong(pageAddr, off + 1, key.dateValue());
        return this.keySize + 1;
    }

    @Override
    protected DateIndexKey get0(long pageAddr, int off) {
        long dateVal = PageUtils.getLong(pageAddr, off + 1);
        if (dateVal > 511999999903L) {
            dateVal = 511999999903L;
        } else if (dateVal < -511999999455L) {
            dateVal = -511999999455L;
        }
        return new DateIndexKey(dateVal);
    }

    @Override
    protected int inlineSize0(DateIndexKey key) {
        return this.keySize + 1;
    }
}

