/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.block.BlockSerdeUtil;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.util.SerDeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.StructuralTestUtil;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSerDeUtils {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();

    private static synchronized ObjectInspector getInspector(Type type) {
        return ObjectInspectorFactory.getReflectionObjectInspector((Type)type, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    @Test
    public void testPrimitiveSlice() {
        Block expectedBoolean = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)BooleanType.BOOLEAN, blockBuilder -> BooleanType.BOOLEAN.writeBoolean(blockBuilder, true));
        Block actualBoolean = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, true, TestSerDeUtils.getInspector(Boolean.class));
        this.assertBlockEquals(actualBoolean, expectedBoolean);
        Block expectedByte = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)TinyintType.TINYINT, blockBuilder -> TinyintType.TINYINT.writeLong(blockBuilder, 5L));
        Block actualByte = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)TinyintType.TINYINT, (byte)5, TestSerDeUtils.getInspector(Byte.class));
        this.assertBlockEquals(actualByte, expectedByte);
        Block expectedShort = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)SmallintType.SMALLINT, blockBuilder -> SmallintType.SMALLINT.writeLong(blockBuilder, 2L));
        Block actualShort = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)SmallintType.SMALLINT, (short)2, TestSerDeUtils.getInspector(Short.class));
        this.assertBlockEquals(actualShort, expectedShort);
        Block expectedInt = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)IntegerType.INTEGER, blockBuilder -> IntegerType.INTEGER.writeLong(blockBuilder, 1L));
        Block actualInt = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)IntegerType.INTEGER, 1, TestSerDeUtils.getInspector(Integer.class));
        this.assertBlockEquals(actualInt, expectedInt);
        Block expectedLong = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)BigintType.BIGINT, blockBuilder -> BigintType.BIGINT.writeLong(blockBuilder, 10L));
        Block actualLong = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)BigintType.BIGINT, 10L, TestSerDeUtils.getInspector(Long.class));
        this.assertBlockEquals(actualLong, expectedLong);
        Block expectedFloat = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)RealType.REAL, blockBuilder -> RealType.REAL.writeLong(blockBuilder, (long)Float.floatToIntBits(20.0f)));
        Block actualFloat = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)RealType.REAL, Float.valueOf(20.0f), TestSerDeUtils.getInspector(Float.class));
        this.assertBlockEquals(actualFloat, expectedFloat);
        Block expectedDouble = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)DoubleType.DOUBLE, blockBuilder -> DoubleType.DOUBLE.writeDouble(blockBuilder, 30.12));
        Block actualDouble = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)DoubleType.DOUBLE, 30.12, TestSerDeUtils.getInspector(Double.class));
        this.assertBlockEquals(actualDouble, expectedDouble);
        Block expectedString = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)VarcharType.VARCHAR, blockBuilder -> VarcharType.VARCHAR.writeString(blockBuilder, "value"));
        Block actualString = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)VarcharType.VARCHAR, "value", TestSerDeUtils.getInspector(String.class));
        this.assertBlockEquals(actualString, expectedString);
        int date = Math.toIntExact(LocalDate.of(2008, 10, 28).toEpochDay());
        Block expectedDate = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)DateType.DATE, blockBuilder -> DateType.DATE.writeLong(blockBuilder, (long)date));
        Block actualDate = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)DateType.DATE, Date.ofEpochDay((int)date), TestSerDeUtils.getInspector(Date.class));
        this.assertBlockEquals(actualDate, expectedDate);
        DateTime dateTime = new DateTime(2008, 10, 28, 16, 7, 15, 123);
        Block expectedTimestamp = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)TimestampType.TIMESTAMP_MILLIS, blockBuilder -> TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, dateTime.getMillis() * 1000L));
        Block actualTimestamp = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)TimestampType.TIMESTAMP_MILLIS, Timestamp.ofEpochMilli((long)dateTime.getMillis()), TestSerDeUtils.getInspector(Timestamp.class));
        this.assertBlockEquals(actualTimestamp, expectedTimestamp);
        byte[] byteArray = new byte[]{81, 82, 84, 85};
        Block expectedBinary = TestSerDeUtils.createSingleValue((io.trino.spi.type.Type)VarbinaryType.VARBINARY, blockBuilder -> VarbinaryType.VARBINARY.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])byteArray)));
        Block actualBinary = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)VarbinaryType.VARBINARY, byteArray, TestSerDeUtils.getInspector(byte[].class));
        this.assertBlockEquals(actualBinary, expectedBinary);
    }

    private static Block createSingleValue(io.trino.spi.type.Type type, Consumer<BlockBuilder> outputConsumer) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        outputConsumer.accept(blockBuilder);
        return blockBuilder.build();
    }

    @Test
    public void testListBlock() {
        ArrayList<InnerStruct> array = new ArrayList<InnerStruct>(2);
        array.add(new InnerStruct(8, 9L));
        array.add(new InnerStruct(10, 11L));
        ListHolder listHolder = new ListHolder();
        listHolder.array = array;
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        RowType arrayOfRowType = RowType.anonymous((List)ImmutableList.of((Object)new ArrayType((io.trino.spi.type.Type)rowType)));
        Block actual = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)arrayOfRowType, listHolder, TestSerDeUtils.getInspector(ListHolder.class));
        BlockBuilder blockBuilder = rowType.createBlockBuilder(null, 1024);
        rowType.writeObject(blockBuilder, (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{8, 9L}));
        rowType.writeObject(blockBuilder, (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{10, 11L}));
        Block expected = StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)new ArrayType((io.trino.spi.type.Type)rowType)), (Object[])new Object[]{blockBuilder.build()});
        this.assertBlockEquals(actual, expected);
    }

    @Test
    public void testMapBlock() {
        MapHolder holder = new MapHolder();
        holder.map = new TreeMap<String, InnerStruct>();
        holder.map.put("twelve", new InnerStruct(13, 14L));
        holder.map.put("fifteen", new InnerStruct(16, 17L));
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        RowType rowOfMapOfVarcharRowType = RowType.anonymous((List)ImmutableList.of((Object)HiveTestUtils.mapType((io.trino.spi.type.Type)VarcharType.VARCHAR, (io.trino.spi.type.Type)rowType)));
        Block actual = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)rowOfMapOfVarcharRowType, holder, TestSerDeUtils.getInspector(MapHolder.class));
        Block mapBlock = StructuralTestUtil.mapBlockOf((io.trino.spi.type.Type)VarcharType.VARCHAR, (io.trino.spi.type.Type)rowType, (Object[])new Object[]{Slices.utf8Slice((String)"fifteen"), Slices.utf8Slice((String)"twelve")}, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)rowType.getTypeParameters(), (Object[])new Object[]{16, 17L}), StructuralTestUtil.rowBlockOf((List)rowType.getTypeParameters(), (Object[])new Object[]{13, 14L})});
        Block expected = StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)HiveTestUtils.mapType((io.trino.spi.type.Type)VarcharType.VARCHAR, (io.trino.spi.type.Type)rowType)), (Object[])new Object[]{mapBlock});
        this.assertBlockEquals(actual, expected);
    }

    @Test
    public void testStructBlock() {
        InnerStruct innerStruct = new InnerStruct(13, 14L);
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        Block actual = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)rowType, innerStruct, TestSerDeUtils.getInspector(InnerStruct.class));
        Block expected = StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{13, 14L});
        this.assertBlockEquals(actual, expected);
        OuterStruct outerStruct = new OuterStruct();
        outerStruct.byteVal = 1;
        outerStruct.shortVal = 2;
        outerStruct.intVal = 3;
        outerStruct.longVal = 4L;
        outerStruct.floatVal = Float.valueOf(5.01f);
        outerStruct.doubleVal = 6.001;
        outerStruct.stringVal = "seven";
        outerStruct.byteArray = new byte[]{50};
        InnerStruct is1 = new InnerStruct(2, -5L);
        InnerStruct is2 = new InnerStruct(-10, 0L);
        outerStruct.structArray = new ArrayList<InnerStruct>(2);
        outerStruct.structArray.add(is1);
        outerStruct.structArray.add(is2);
        outerStruct.map = new TreeMap<String, InnerStruct>();
        outerStruct.map.put("twelve", new InnerStruct(0, 5L));
        outerStruct.map.put("fifteen", new InnerStruct(-5, -10L));
        outerStruct.innerStruct = new InnerStruct(18, 19L);
        RowType innerRowType = RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        ArrayType arrayOfInnerRowType = new ArrayType((io.trino.spi.type.Type)innerRowType);
        MapType mapOfInnerRowType = HiveTestUtils.mapType((io.trino.spi.type.Type)VarcharType.createUnboundedVarcharType(), (io.trino.spi.type.Type)innerRowType);
        ImmutableList outerRowParameterTypes = ImmutableList.of((Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)arrayOfInnerRowType, (Object)mapOfInnerRowType, (Object)innerRowType);
        RowType outerRowType = RowType.anonymous((List)outerRowParameterTypes);
        actual = TestSerDeUtils.toBinaryBlock((io.trino.spi.type.Type)outerRowType, outerStruct, TestSerDeUtils.getInspector(OuterStruct.class));
        ImmutableList.Builder outerRowValues = ImmutableList.builder();
        outerRowValues.add((Object)1);
        outerRowValues.add((Object)2);
        outerRowValues.add((Object)3);
        outerRowValues.add((Object)4L);
        outerRowValues.add((Object)Float.valueOf(5.01f));
        outerRowValues.add((Object)6.001);
        outerRowValues.add((Object)"seven");
        outerRowValues.add((Object)new byte[]{50});
        outerRowValues.add((Object)StructuralTestUtil.arrayBlockOf((io.trino.spi.type.Type)innerRowType, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)innerRowType.getTypeParameters(), (Object[])new Object[]{2, -5L}), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{-10, 0L})}));
        outerRowValues.add((Object)StructuralTestUtil.mapBlockOf((io.trino.spi.type.Type)VarcharType.VARCHAR, (io.trino.spi.type.Type)innerRowType, (Object[])new Object[]{Slices.utf8Slice((String)"fifteen"), Slices.utf8Slice((String)"twelve")}, (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)innerRowType.getTypeParameters(), (Object[])new Object[]{-5, -10L}), StructuralTestUtil.rowBlockOf((List)innerRowType.getTypeParameters(), (Object[])new Object[]{0, 5L})}));
        outerRowValues.add((Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT), (Object[])new Object[]{18, 19L}));
        this.assertBlockEquals(actual, StructuralTestUtil.rowBlockOf((List)outerRowParameterTypes, (Object[])outerRowValues.build().toArray()));
    }

    @Test
    public void testReuse() {
        BytesWritable value = new BytesWritable();
        byte[] first = "hello world".getBytes(StandardCharsets.UTF_8);
        value.set(first, 0, first.length);
        byte[] second = "bye".getBytes(StandardCharsets.UTF_8);
        value.set(second, 0, second.length);
        Type type = new TypeToken<Map<BytesWritable, Long>>(){}.getType();
        ObjectInspector inspector = TestSerDeUtils.getInspector(type);
        Block actual = SerDeUtils.getBlockObject((io.trino.spi.type.Type)HiveTestUtils.mapType((io.trino.spi.type.Type)VarcharType.createUnboundedVarcharType(), (io.trino.spi.type.Type)BigintType.BIGINT), ImmutableMap.of((Object)value, (Object)0L), inspector);
        Block expected = StructuralTestUtil.mapBlockOf((io.trino.spi.type.Type)VarcharType.createUnboundedVarcharType(), (io.trino.spi.type.Type)BigintType.BIGINT, (Object)"bye", (Object)0L);
        this.assertBlockEquals(actual, expected);
    }

    private void assertBlockEquals(Block actual, Block expected) {
        Assert.assertEquals((Object)this.blockToSlice(actual), (Object)this.blockToSlice(expected));
    }

    private Slice blockToSlice(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
        BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.blockEncodingSerde, (SliceOutput)sliceOutput, (Block)block);
        return sliceOutput.slice();
    }

    private static Block toBinaryBlock(io.trino.spi.type.Type type, Object object, ObjectInspector inspector) {
        if (inspector.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return TestSerDeUtils.getPrimitiveBlock(type, object, inspector);
        }
        return SerDeUtils.getBlockObject(type, object, inspector);
    }

    private static Block getPrimitiveBlock(io.trino.spi.type.Type type, Object object, ObjectInspector inspector) {
        BlockBuilder builder = type.createBlockBuilder(null, 1);
        SerDeUtils.serializeObject(type, builder, object, inspector);
        return builder.build();
    }

    private static class InnerStruct {
        Integer intVal;
        Long longVal;

        public InnerStruct(Integer intVal, Long longVal) {
            this.intVal = intVal;
            this.longVal = longVal;
        }
    }

    private static class ListHolder {
        List<InnerStruct> array;

        private ListHolder() {
        }
    }

    private static class MapHolder {
        Map<String, InnerStruct> map;

        private MapHolder() {
        }
    }

    private static class OuterStruct {
        Byte byteVal;
        Short shortVal;
        Integer intVal;
        Long longVal;
        Float floatVal;
        Double doubleVal;
        String stringVal;
        byte[] byteArray;
        List<InnerStruct> structArray;
        Map<String, InnerStruct> map;
        InnerStruct innerStruct;

        private OuterStruct() {
        }
    }
}

