/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.type.InternalTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveBucketing {
    @Test
    public void testHashingCompare() {
        TestHiveBucketing.assertBucketEquals("string", (Object)"Trino rocks", 1132136730, -399107423);
        Assert.assertEquals((int)HiveBucketing.getBucketNumber((int)1132136730, (int)4), (int)2);
        Assert.assertEquals((int)HiveBucketing.getBucketNumber((int)-399107423, (int)4), (int)1);
        TestHiveBucketing.assertBucketEquals("boolean", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("boolean", (Object)true, 1, 1);
        TestHiveBucketing.assertBucketEquals("boolean", (Object)false, 0, 0);
        TestHiveBucketing.assertBucketEquals("tinyint", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("tinyint", (Object)5, 5, 5);
        TestHiveBucketing.assertBucketEquals("tinyint", (Object)-128, -128, -128);
        TestHiveBucketing.assertBucketEquals("tinyint", (Object)127, 127, 127);
        TestHiveBucketing.assertBucketEquals("smallint", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("smallint", (Object)300, 300, 2107031704);
        TestHiveBucketing.assertBucketEquals("smallint", (Object)Short.MIN_VALUE, Short.MIN_VALUE, 1342976838);
        TestHiveBucketing.assertBucketEquals("smallint", (Object)Short.MAX_VALUE, Short.MAX_VALUE, -684075052);
        TestHiveBucketing.assertBucketEquals("int", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("int", (Object)300000, 300000, -678663480);
        TestHiveBucketing.assertBucketEquals("int", (Object)Integer.MIN_VALUE, Integer.MIN_VALUE, 1194881028);
        TestHiveBucketing.assertBucketEquals("int", (Object)Integer.MAX_VALUE, Integer.MAX_VALUE, 1133859967);
        TestHiveBucketing.assertBucketEquals("bigint", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("bigint", (Object)300000000000L, -647710651, -888935297);
        TestHiveBucketing.assertBucketEquals("bigint", (Object)Long.MIN_VALUE, Integer.MIN_VALUE, 1728983947);
        TestHiveBucketing.assertBucketEquals("bigint", (Object)Long.MAX_VALUE, Integer.MIN_VALUE, -536577852);
        TestHiveBucketing.assertBucketEquals("float", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(12.34f), 1095069860, -381747602);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(-3.4028235E38f), -8388609, 470252243);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.MIN_VALUE), 1, 1206721797);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.POSITIVE_INFINITY), 2139095040, -292175804);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.NEGATIVE_INFINITY), -8388608, -1433270801);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.NaN), 2143289344, -480354314);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.intBitsToFloat(-4194304)), 2143289344, -480354314);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.intBitsToFloat(2143289344)), 2143289344, -480354314);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.intBitsToFloat(2143294004)), 2143289344, -480354314);
        TestHiveBucketing.assertBucketEquals("float", (Object)Float.valueOf(Float.intBitsToFloat(-4189644)), 2143289344, -480354314);
        TestHiveBucketing.assertBucketEquals("double", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("double", (Object)12.34, 986311098, -2070733568);
        TestHiveBucketing.assertBucketEquals("double", (Object)-1.7976931348623157E308, 0x100000, 14392725);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.MIN_VALUE, 1, -8838199);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.POSITIVE_INFINITY, 0x7FF00000, 1614292060);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.NEGATIVE_INFINITY, -1048576, 141388605);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.NaN, 2146959360, 1138026565);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.longBitsToDouble(-2251799813685248L), 2146959360, 1138026565);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.longBitsToDouble(9221140251894092340L), 2146959360, 1138026565);
        TestHiveBucketing.assertBucketEquals("double", (Object)Double.longBitsToDouble(-2231784960683468L), 2146959360, 1138026565);
        TestHiveBucketing.assertBucketEquals("varchar(15)", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("varchar(15)", (Object)"", 1, -965378730);
        TestHiveBucketing.assertBucketEquals("varchar(15)", (Object)"test string", -189841218, -138301454);
        TestHiveBucketing.assertBucketEquals("varchar(15)", (Object)"\u5f3a\u5927\u7684Trino\u5f15\u64ce", 1899852420, 1784416344);
        TestHiveBucketing.assertBucketEquals("varchar(15)", (Object)"\ud843\udffc\ud843\udffd\ud843\udffe\ud843\udfff", -457487557, -697348811);
        TestHiveBucketing.assertBucketEquals("string", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("string", (Object)"", 0, -965378730);
        TestHiveBucketing.assertBucketEquals("string", (Object)"test string", -318923937, -138301454);
        TestHiveBucketing.assertBucketEquals("string", (Object)"\u5f3a\u5927\u7684Trino\u5f15\u64ce", 1688501507, 1784416344);
        TestHiveBucketing.assertBucketEquals("string", (Object)"\ud843\udffc\ud843\udffd\ud843\udffe\ud843\udfff", -1810797254, -697348811);
        TestHiveBucketing.assertBucketEquals("date", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("date", (Object)Date.valueOf((String)"1970-01-01"), 0, 1362653161);
        TestHiveBucketing.assertBucketEquals("date", (Object)Date.valueOf((String)"2015-11-19"), 16758, 8542395);
        TestHiveBucketing.assertBucketEquals("date", (Object)Date.valueOf((String)"1950-11-19"), -6983, -431619185);
        for (HiveBucketing.BucketingVersion version : HiveBucketing.BucketingVersion.values()) {
            ImmutableList typeInfos = ImmutableList.of((Object)HiveType.HIVE_TIMESTAMP.getTypeInfo());
            Assertions.assertThatThrownBy(() -> TestHiveBucketing.lambda$testHashingCompare$0(version, (List)typeInfos)).hasMessage("Computation of Hive bucket hashCode is not supported for Hive primitive category: TIMESTAMP");
            TimestampType timestampType = TimestampType.createTimestampType((int)3);
            BlockBuilder builder = timestampType.createBlockBuilder(null, 1);
            timestampType.writeLong(builder, 0L);
            Page page = new Page(new Block[]{builder.build()});
            Assertions.assertThatThrownBy(() -> TestHiveBucketing.lambda$testHashingCompare$1(version, (List)typeInfos, page)).hasMessage("Computation of Hive bucket hashCode is not supported for Hive primitive category: TIMESTAMP");
        }
        TestHiveBucketing.assertBucketEquals("array<double>", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("array<boolean>", (Object)ImmutableList.of(), 0, 0);
        TestHiveBucketing.assertBucketEquals("array<smallint>", (Object)ImmutableList.of((Object)5, (Object)8, (Object)13), 5066, -905011156);
        TestHiveBucketing.assertBucketEquals("array<string>", (Object)ImmutableList.of((Object)"test1", (Object)"test2", (Object)"test3", (Object)"test4"), 957612994, 1305539282);
        TestHiveBucketing.assertBucketEquals("array<array<bigint>>", (Object)ImmutableList.of((Object)ImmutableList.of((Object)10L, (Object)20L), (Object)ImmutableList.of((Object)-10L, (Object)-20L), Arrays.asList(new Object[]{null})), 326368, 611324477);
        TestHiveBucketing.assertBucketEquals("map<float,date>", null, 0, 0);
        TestHiveBucketing.assertBucketEquals("map<double,timestamp>", (Object)ImmutableMap.of(), 0, 0);
        TestHiveBucketing.assertBucketEquals("map<string,bigint>", (Object)ImmutableMap.of((Object)"key", (Object)123L, (Object)"key2", (Object)123456789L, (Object)"key3", (Object)-123456L), 127880789, -1910999650);
        TestHiveBucketing.assertBucketEquals("map<array<double>,map<int,string>>", (Object)ImmutableMap.of((Object)ImmutableList.of((Object)12.3, (Object)45.7), (Object)ImmutableMap.of((Object)123, (Object)"test99")), -34001111, -1565874874);
        TestHiveBucketing.assertBucketEquals((List<String>)ImmutableList.of((Object)"float", (Object)"array<smallint>", (Object)"map<string,bigint>"), (List<Object>)ImmutableList.of((Object)Float.valueOf(12.34f), (Object)ImmutableList.of((Object)5, (Object)8, (Object)13), (Object)ImmutableMap.of((Object)"key", (Object)123L)), 95411006, 932898434);
        TestHiveBucketing.assertBucketEquals((List<String>)ImmutableList.of((Object)"double", (Object)"array<smallint>", (Object)"boolean", (Object)"map<string,bigint>", (Object)"tinyint"), Arrays.asList(null, ImmutableList.of((Object)5, (Object)8, (Object)13), null, ImmutableMap.of((Object)"key", (Object)123L), null), 154207826, -1120812524);
    }

    @Test
    public void testBucketFilterFromDiscreteSets() {
        TestHiveBucketing.assertBucketsEqual((List<String>)ImmutableList.of((Object)"int", (Object)"tinyint"), (List<List<Object>>)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)10), (Object)ImmutableList.of((Object)5, (Object)6)), 8, Optional.of(ImmutableSet.of((Object)3, (Object)4, (Object)5)), Optional.of(ImmutableSet.of((Object)0, (Object)1, (Object)5, (Object)6)));
        TestHiveBucketing.assertBucketsEqual((List<String>)ImmutableList.of((Object)"float", (Object)"array<smallint>", (Object)"map<string,bigint>"), (List<List<Object>>)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(12.34f), (Object)Float.valueOf(56.78f)), (Object)ImmutableList.of((Object)ImmutableList.of((Object)5, (Object)8, (Object)13), (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)123L), (Object)ImmutableMap.of((Object)"key2", (Object)456L))), 32, Optional.of(ImmutableSet.of((Object)3, (Object)9, (Object)11, (Object)17, (Object)21, (Object)23, (Object[])new Integer[]{29, 31})), Optional.of(ImmutableSet.of((Object)0, (Object)8, (Object)10, (Object)20, (Object)30)));
        TestHiveBucketing.assertBucketsEqual((List<String>)ImmutableList.of((Object)"double", (Object)"array<smallint>", (Object)"boolean", (Object)"map<string,bigint>", (Object)"tinyint"), (List<List<Object>>)ImmutableList.of((Object)Lists.newArrayList((Object[])new Object[]{null, 12.3}), (Object)Lists.newArrayList((Object[])new Object[]{null, ImmutableList.of((Object)1, (Object)2, (Object)3)}), (Object)Lists.newArrayList((Object[])new Object[]{null, false}), (Object)Lists.newArrayList((Object[])new Object[]{null, ImmutableMap.of((Object)"key", (Object)123L)}), (Object)Lists.newArrayList((Object[])new Object[]{null, (byte)120})), 32, Optional.of(ImmutableSet.of((Object)0, (Object)1, (Object)3, (Object)18, (Object)20, (Object)21, (Object[])new Integer[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31})), Optional.of(ImmutableSet.of((Object)0, (Object)2, (Object)10, (Object)11, (Object)19, (Object)21, (Object[])new Integer[]{24, 29})));
        ArrayList<Integer> intValues = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            intValues.add(i);
        }
        ArrayList<Byte> tinyIntValues = new ArrayList<Byte>(100);
        for (byte i = 0; i < 100; i = (byte)(i + 1)) {
            tinyIntValues.add(i);
        }
        TestHiveBucketing.assertBucketsEqual((List<String>)ImmutableList.of((Object)"int", (Object)"tinyint"), (List<List<Object>>)ImmutableList.of((Object)ImmutableList.copyOf(intValues), (Object)ImmutableList.copyOf(tinyIntValues)), 32, Optional.empty(), Optional.empty());
    }

    private static void assertBucketsEqual(List<String> hiveTypeStrings, List<List<Object>> hiveValues, int bucketCount, Optional<Set<Integer>> expectedBucketsV1, Optional<Set<Integer>> expectedBucketsV2) {
        List hiveTypes = (List)hiveTypeStrings.stream().map(HiveType::valueOf).collect(ImmutableList.toImmutableList());
        List hiveTypeInfos = (List)hiveTypes.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        List trinoTypes = (List)hiveTypes.stream().map(type -> type.getType(InternalTypeManager.TESTING_TYPE_MANAGER)).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder values = ImmutableList.builder();
        for (int i = 0; i < hiveValues.size(); ++i) {
            List<Object> valueList = hiveValues.get(i);
            Type trinoType = (Type)trinoTypes.get(i);
            values.add((Object)((List)valueList.stream().map(value -> new NullableValue(trinoType, HiveTestUtils.toNativeContainerValue(trinoType, value))).collect(ImmutableList.toImmutableList())));
        }
        Assert.assertEquals((Object)HiveBucketing.getHiveBuckets((HiveBucketing.BucketingVersion)HiveBucketing.BucketingVersion.BUCKETING_V1, (int)bucketCount, (List)hiveTypeInfos, (List)values.build()), expectedBucketsV1);
        Assert.assertEquals((Object)HiveBucketing.getHiveBuckets((HiveBucketing.BucketingVersion)HiveBucketing.BucketingVersion.BUCKETING_V2, (int)bucketCount, (List)hiveTypeInfos, (List)values.build()), expectedBucketsV2);
    }

    private static void assertBucketEquals(String hiveTypeString, Object hiveValue, int expectedHashCodeV1, int expectedHashCodeV2) {
        TestHiveBucketing.assertBucketEquals(hiveTypeString, hiveValue, HiveBucketing.BucketingVersion.BUCKETING_V1, expectedHashCodeV1);
        TestHiveBucketing.assertBucketEquals(hiveTypeString, hiveValue, HiveBucketing.BucketingVersion.BUCKETING_V2, expectedHashCodeV2);
    }

    private static void assertBucketEquals(String hiveTypeString, Object hiveValue, HiveBucketing.BucketingVersion bucketingVersion, int expectedHashCode) {
        TestHiveBucketing.assertBucketEquals((List<String>)ImmutableList.of((Object)hiveTypeString), Arrays.asList(hiveValue), bucketingVersion, expectedHashCode);
    }

    private static void assertBucketEquals(List<String> hiveTypeStrings, List<Object> hiveValues, int expectedHashCodeV1, int expectedHashCodeV2) {
        TestHiveBucketing.assertBucketEquals(hiveTypeStrings, hiveValues, HiveBucketing.BucketingVersion.BUCKETING_V1, expectedHashCodeV1);
        TestHiveBucketing.assertBucketEquals(hiveTypeStrings, hiveValues, HiveBucketing.BucketingVersion.BUCKETING_V2, expectedHashCodeV2);
    }

    private static void assertBucketEquals(List<String> hiveTypeStrings, List<Object> hiveValues, HiveBucketing.BucketingVersion bucketingVersion, int expectedHashCode) {
        List hiveTypes = (List)hiveTypeStrings.stream().map(HiveType::valueOf).collect(ImmutableList.toImmutableList());
        List hiveTypeInfos = (List)hiveTypes.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        Assert.assertEquals((int)TestHiveBucketing.computeTrino(bucketingVersion, hiveTypeStrings, hiveValues, hiveTypes, hiveTypeInfos), (int)expectedHashCode);
        Assert.assertEquals((int)TestHiveBucketing.computeHive(bucketingVersion, hiveTypeStrings, hiveValues, hiveTypeInfos), (int)expectedHashCode);
        for (int bucketCount : new int[]{1, 2, 500, 997}) {
            int actual = HiveBucketing.getBucketNumber((int)expectedHashCode, (int)bucketCount);
            int expected = ObjectInspectorUtils.getBucketNumber((int)expectedHashCode, (int)bucketCount);
            Assert.assertEquals((int)actual, (int)expected, (String)("bucketCount " + bucketCount));
        }
    }

    private static int computeHive(HiveBucketing.BucketingVersion bucketingVersion, List<String> hiveTypeStrings, List<Object> hiveValues, List<io.trino.plugin.hive.type.TypeInfo> hiveTypeInfos) {
        ImmutableList.Builder columnBindingsBuilder = ImmutableList.builder();
        for (int i = 0; i < hiveTypeStrings.size(); ++i) {
            Object javaValue = hiveValues.get(i);
            TypeInfo hiveTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)hiveTypeInfos.get(i).getTypeName());
            columnBindingsBuilder.add((Object)Maps.immutableEntry((Object)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)hiveTypeInfo), (Object)javaValue));
        }
        return TestHiveBucketing.getHiveBucketHashCode(bucketingVersion, (List<Map.Entry<ObjectInspector, Object>>)columnBindingsBuilder.build());
    }

    private static int computeTrino(HiveBucketing.BucketingVersion bucketingVersion, List<String> hiveTypeStrings, List<Object> hiveValues, List<HiveType> hiveTypes, List<io.trino.plugin.hive.type.TypeInfo> hiveTypeInfos) {
        ImmutableList.Builder blockListBuilder = ImmutableList.builder();
        Object[] nativeContainerValues = new Object[hiveValues.size()];
        for (int i = 0; i < hiveTypeStrings.size(); ++i) {
            Object hiveValue = hiveValues.get(i);
            Type type = hiveTypes.get(i).getType(InternalTypeManager.TESTING_TYPE_MANAGER);
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 3);
            blockBuilder.appendNull();
            blockBuilder.appendNull();
            TestHiveBucketing.appendToBlockBuilder(type, hiveValue, blockBuilder);
            Block block = blockBuilder.build();
            blockListBuilder.add((Object)block);
            nativeContainerValues[i] = HiveTestUtils.toNativeContainerValue(type, hiveValue);
        }
        ImmutableList blockList = blockListBuilder.build();
        int result1 = bucketingVersion.getBucketHashCode(hiveTypeInfos, new Page((Block[])blockList.toArray((Object[])new Block[blockList.size()])), 2);
        int result2 = bucketingVersion.getBucketHashCode(hiveTypeInfos, nativeContainerValues);
        Assert.assertEquals((int)result1, (int)result2, (String)"overloads of getBucketHashCode produced different result");
        return result1;
    }

    public static int getHiveBucketHashCode(HiveBucketing.BucketingVersion bucketingVersion, List<Map.Entry<ObjectInspector, Object>> columnBindings) {
        ObjectInspector[] objectInspectors = new ObjectInspector[columnBindings.size()];
        Object[] objects = new Object[columnBindings.size()];
        int i = 0;
        for (Map.Entry<ObjectInspector, Object> entry : columnBindings) {
            ObjectInspector objectInspector;
            objectInspectors[i] = entry.getKey();
            if (entry.getValue() != null && (objectInspector = entry.getKey()) instanceof JavaHiveVarcharObjectInspector) {
                JavaHiveVarcharObjectInspector varcharObjectInspector = (JavaHiveVarcharObjectInspector)objectInspector;
                objects[i] = new HiveVarchar((String)entry.getValue(), varcharObjectInspector.getMaxLength());
            } else {
                objects[i] = entry.getValue();
            }
            ++i;
        }
        switch (bucketingVersion) {
            case BUCKETING_V1: {
                int hashCodeOld = ObjectInspectorUtils.getBucketHashCodeOld((Object[])objects, (ObjectInspector[])objectInspectors);
                return hashCodeOld;
            }
            case BUCKETING_V2: {
                return ObjectInspectorUtils.getBucketHashCode((Object[])objects, (ObjectInspector[])objectInspectors);
            }
        }
        throw new IllegalArgumentException("Unsupported bucketing version: " + bucketingVersion);
    }

    private static void appendToBlockBuilder(Type type, Object hiveValue, BlockBuilder blockBuilder) {
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)HiveTestUtils.toNativeContainerValue(type, hiveValue));
    }

    private static /* synthetic */ void lambda$testHashingCompare$1(HiveBucketing.BucketingVersion version, List typeInfos, Page page) throws Throwable {
        version.getBucketHashCode(typeInfos, page, 0);
    }

    private static /* synthetic */ void lambda$testHashingCompare$0(HiveBucketing.BucketingVersion version, List typeInfos) throws Throwable {
        version.getBucketHashCode(typeInfos, new Object[]{0});
    }
}

