/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.util.FileSystemTesting;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveAcidUtils {
    @Test
    public void testParsing() {
        Assert.assertEquals((long)AcidUtils.parseBase((Path)new Path("/tmp/base_000123")), (long)123L);
    }

    @Test
    public void testOriginal() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0_copy_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0_copy_2", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/random", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/abc/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new FileSystemTesting.MockPath(fs, "/tbl/part1"), (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertNull((Object)dir.getBaseDirectory());
        Assert.assertEquals((int)dir.getCurrentDirectories().size(), (int)0);
        Assert.assertEquals((int)dir.getObsolete().size(), (int)0);
        List result = dir.getOriginalFiles();
        Assert.assertEquals((int)result.size(), (int)7);
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(0)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000000_0");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(1)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000000_0_copy_1");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(2)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000000_0_copy_2");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(3)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000001_1");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(4)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000002_0");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(5)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/random");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(6)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/subdir/000000_0");
    }

    @Test
    public void testOriginalDeltas() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/random", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/delta_025_025/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_100/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new FileSystemTesting.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertNull((Object)dir.getBaseDirectory());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)2);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_025_025");
        Assert.assertEquals((String)((FileStatus)obsolete.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_029_029");
        List result = dir.getOriginalFiles();
        Assert.assertEquals((int)result.size(), (int)5);
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(0)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000000_0");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(1)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000001_1");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(2)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/000002_0");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(3)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/random");
        Assert.assertEquals((String)((HadoopShims.HdfsFileStatusWithId)result.get(4)).getFileStatus().getPath().toString(), (String)"mock:/tbl/part1/subdir/000000_0");
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((int)deltas.size(), (int)2);
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assert.assertEquals((String)delt.getPath().toString(), (String)"mock:/tbl/part1/delta_025_030");
        Assert.assertEquals((long)delt.getMinWriteId(), (long)25L);
        Assert.assertEquals((long)delt.getMaxWriteId(), (long)30L);
        delt = (AcidUtils.ParsedDelta)deltas.get(1);
        Assert.assertEquals((String)delt.getPath().toString(), (String)"mock:/tbl/part1/delta_050_100");
        Assert.assertEquals((long)delt.getMinWriteId(), (long)50L);
        Assert.assertEquals((long)delt.getMaxWriteId(), (long)100L);
    }

    @Test
    public void testBaseDeltas() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/_tmp/base_5/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_90_120/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertEquals((String)dir.getBaseDirectory().toString(), (String)"mock:/tbl/part1/base_49");
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)5);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/base_10");
        Assert.assertEquals((String)((FileStatus)obsolete.get(1)).getPath().toString(), (String)"mock:/tbl/part1/base_5");
        Assert.assertEquals((String)((FileStatus)obsolete.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_025_030");
        Assert.assertEquals((String)((FileStatus)obsolete.get(3)).getPath().toString(), (String)"mock:/tbl/part1/delta_025_025");
        Assert.assertEquals((String)((FileStatus)obsolete.get(4)).getPath().toString(), (String)"mock:/tbl/part1/delta_029_029");
        Assert.assertEquals((int)dir.getOriginalFiles().size(), (int)0);
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((int)deltas.size(), (int)1);
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assert.assertEquals((String)delt.getPath().toString(), (String)"mock:/tbl/part1/delta_050_105");
        Assert.assertEquals((long)delt.getMinWriteId(), (long)50L);
        Assert.assertEquals((long)delt.getMaxWriteId(), (long)105L);
    }

    @Test
    public void testObsoleteOriginals() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:150:9223372036854775807:"));
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)3);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/base_5");
        Assert.assertEquals((String)dir.getBaseDirectory().toString(), (String)"mock:/tbl/part1/base_10");
    }

    @Test
    public void testOverlapingDelta() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertEquals((String)dir.getBaseDirectory().toString(), (String)"mock:/tbl/part1/base_50");
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)2);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_052_55");
        Assert.assertEquals((String)((FileStatus)obsolete.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_0060_60");
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)4);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_40_60");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_00061_61");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_000062_62");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString(), (String)"mock:/tbl/part1/delta_0000063_63");
    }

    @Test
    public void testOverlapingDelta2() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63_0/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62_0/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61_0/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_4/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60_7/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_058_58/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertEquals((String)dir.getBaseDirectory().toString(), (String)"mock:/tbl/part1/base_50");
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)5);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_052_55");
        Assert.assertEquals((String)((FileStatus)obsolete.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_058_58");
        Assert.assertEquals((String)((FileStatus)obsolete.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_0060_60_1");
        Assert.assertEquals((String)((FileStatus)obsolete.get(3)).getPath().toString(), (String)"mock:/tbl/part1/delta_0060_60_4");
        Assert.assertEquals((String)((FileStatus)obsolete.get(4)).getPath().toString(), (String)"mock:/tbl/part1/delta_0060_60_7");
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)5);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_40_60");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_00061_61_0");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_000062_62_0");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString(), (String)"mock:/tbl/part1/delta_000062_62_3");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(4)).getPath().toString(), (String)"mock:/tbl/part1/delta_0000063_63_0");
    }

    @Test
    public void deltasWithOpenTxnInRead() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)2);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void deltasWithOpenTxnInRead2() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)2);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidCompactorWriteIdList("tbl:4:9223372036854775807"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)1);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_1_1");
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact2() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidCompactorWriteIdList("tbl:3:9223372036854775807"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)1);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_1_1");
    }

    @Test
    public void testBaseWithDeleteDeltas() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_029_029/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_025_030/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_050_105/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_110_110/bucket_0", 0, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertEquals((String)dir.getBaseDirectory().toString(), (String)"mock:/tbl/part1/base_49");
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)7);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/base_10");
        Assert.assertEquals((String)((FileStatus)obsolete.get(1)).getPath().toString(), (String)"mock:/tbl/part1/base_5");
        Assert.assertEquals((String)((FileStatus)obsolete.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_025_030");
        Assert.assertEquals((String)((FileStatus)obsolete.get(3)).getPath().toString(), (String)"mock:/tbl/part1/delta_025_030");
        Assert.assertEquals((String)((FileStatus)obsolete.get(4)).getPath().toString(), (String)"mock:/tbl/part1/delta_025_025");
        Assert.assertEquals((String)((FileStatus)obsolete.get(5)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_029_029");
        Assert.assertEquals((String)((FileStatus)obsolete.get(6)).getPath().toString(), (String)"mock:/tbl/part1/delta_029_029");
        Assert.assertEquals((int)dir.getOriginalFiles().size(), (int)0);
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((int)deltas.size(), (int)2);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)deltas.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_050_105");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)deltas.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_050_105");
    }

    @Test
    public void testOverlapingDeltaAndDeleteDelta() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_00064_64/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_052_55/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        Assert.assertEquals((String)dir.getBaseDirectory().toString(), (String)"mock:/tbl/part1/base_50");
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)3);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_052_55");
        Assert.assertEquals((String)((FileStatus)obsolete.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_052_55");
        Assert.assertEquals((String)((FileStatus)obsolete.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_0060_60");
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)6);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_40_60");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delta_40_60");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_00061_61");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString(), (String)"mock:/tbl/part1/delta_000062_62");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(4)).getPath().toString(), (String)"mock:/tbl/part1/delta_0000063_63");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(5)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_00064_64");
    }

    @Test
    public void testMinorCompactedDeltaMakesInBetweenDelteDeltaObsolete() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_50_50/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:9223372036854775807:"));
        List obsolete = dir.getObsolete();
        Assert.assertEquals((int)obsolete.size(), (int)1);
        Assert.assertEquals((String)((FileStatus)obsolete.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_50_50");
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)1);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_40_60");
    }

    @Test
    public void deltasAndDeleteDeltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_2/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_7_7/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidCompactorWriteIdList("tbl:4:9223372036854775807:"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)2);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_2_2");
    }

    @Test
    public void deleteDeltasWithOpenTxnInRead() throws Exception {
        Configuration conf = ConfigurationInstantiator.newEmptyConfiguration();
        FileSystemTesting.MockFileSystem fs = new FileSystemTesting.MockFileSystem(conf, new FileSystemTesting.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delete_delta_3_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]), new FileSystemTesting.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, new byte[0], new FileSystemTesting.MockBlock[0]));
        FileSystemTesting.MockPath part = new FileSystemTesting.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidWriteIdList)new ValidReaderWriteIdList("tbl:100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((int)delts.size(), (int)3);
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString(), (String)"mock:/tbl/part1/delta_1_1");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString(), (String)"mock:/tbl/part1/delete_delta_2_5");
        Assert.assertEquals((String)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString(), (String)"mock:/tbl/part1/delta_2_5");
    }

    @Test
    public void testDeleteDeltaSubdirPathGeneration() {
        String deleteDeltaSubdirPath = AcidUtils.deleteDeltaSubdir((long)1L, (long)10L);
        Assert.assertEquals((String)deleteDeltaSubdirPath, (String)"delete_delta_0000001_0000010");
        deleteDeltaSubdirPath = AcidUtils.deleteDeltaSubdir((long)1L, (long)10L, (int)5);
        Assert.assertEquals((String)deleteDeltaSubdirPath, (String)"delete_delta_0000001_0000010_0005");
    }
}

